/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.dsa;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.oiw.OIWObjectIdentifiers;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.jcajce.provider.asymmetric.dsa.SwJCEDSAPrivateKey;
import com.sansec.jcajce.provider.asymmetric.dsa.SwJCEDSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class DSAUtil {
    private static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};

    public static ASN1ObjectIdentifier[] getDsaOids() {
        return dsaOids;
    }

    public static boolean isDsaOid(ASN1ObjectIdentifier algOid) {
        for (int i = 0; i != dsaOids.length; ++i) {
            if (!algOid.equals(dsaOids[i])) continue;
            return true;
        }
        return false;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof SwJCEDSAPublicKey) {
            SwJCEDSAPublicKey swKey = (SwJCEDSAPublicKey)key;
            BigInteger p = swKey.getParams().getP();
            BigInteger q = swKey.getParams().getQ();
            BigInteger g = swKey.getParams().getG();
            DSAParameters dsaParams = new DSAParameters(p, q, g);
            if (swKey.getKeyIndex() > 0) {
                return new DSAPublicKeyParameters(swKey.getKeyIndex(), swKey.getKeyType(), swKey.getBits(), swKey.getY(), dsaParams);
            }
            return new DSAPublicKeyParameters(swKey.getBits(), swKey.getY(), dsaParams);
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey k = (DSAPublicKey)key;
            return new DSAPublicKeyParameters(k.getY(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof SwJCEDSAPrivateKey) {
            SwJCEDSAPrivateKey swKey = (SwJCEDSAPrivateKey)key;
            BigInteger p = swKey.getParams().getP();
            BigInteger q = swKey.getParams().getQ();
            BigInteger g = swKey.getParams().getG();
            DSAParameters dsaParams = new DSAParameters(p, q, g);
            if (swKey.getKeyIndex() > 0) {
                return new DSAPrivateKeyParameters(swKey.getKeyIndex(), swKey.getKeyType(), swKey.getBits(), swKey.getX(), dsaParams);
            }
            return new DSAPrivateKeyParameters(swKey.getBits(), swKey.getX(), dsaParams);
        }
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey k = (DSAPrivateKey)key;
            return new DSAPrivateKeyParameters(k.getX(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA private key.");
    }
}

