/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.dsa;

import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.crypto.params.SwKeyParams;
import com.sansec.jcajce.provider.asymmetric.dsa.JCEDSAPublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;

public class SwJCEDSAPublicKey
extends JCEDSAPublicKey
implements SwKeyParams {
    static final long serialVersionUID = -8145849727580266753L;
    private int keyIndex;
    private int keyType;
    private int bits;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    SwJCEDSAPublicKey(DSAPublicKeyParameters key) {
        super(key);
        this.keyIndex = key.getKeyIndex();
        this.keyType = key.getKeyType();
        this.bits = key.getBits();
    }

    SwJCEDSAPublicKey(DSAPublicKeySpec spec) {
        super(spec);
    }

    SwJCEDSAPublicKey(DSAPublicKey key) {
        super(key);
    }

    SwJCEDSAPublicKey(SubjectPublicKeyInfo info) {
        super(info);
    }

    @Override
    public String getAlgorithm() {
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return super.getEncoded();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        if (this.keyIndex == 0) {
            return "External DSA PublicKey[ Bits = " + this.bits + ", Y = " + this.getY() + " ]";
        }
        return "Internal DSA PublicKey[ KeyIndex = " + this.keyIndex + ", KeyType = " + this.keyType + " , Bits = " + this.bits + " ]";
    }
}

