/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.ec;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.DERNull;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.asn1.x9.X9ECPoint;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.jcajce.provider.asymmetric.util.EC5Util;
import com.sansec.jcajce.provider.asymmetric.util.ECUtil;
import com.sansec.jce.spec.ECNamedCurveSpec;
import com.sansec.math.ec.ECCurve;
import java.math.BigInteger;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

public class ECUtils {
    static X9ECParameters getDomainParametersFromGenSpec(ECGenParameterSpec genSpec) {
        return ECUtils.getDomainParametersFromName(genSpec.getName());
    }

    public static X9ECParameters getDomainParametersFromName(String curveName) {
        X9ECParameters domainParameters;
        try {
            if (curveName.charAt(0) >= '0' && curveName.charAt(0) <= '2') {
                ASN1ObjectIdentifier oidID = new ASN1ObjectIdentifier(curveName);
                domainParameters = ECUtil.getNamedCurveByOid(oidID);
            } else if (curveName.indexOf(32) > 0) {
                curveName = curveName.substring(curveName.indexOf(32) + 1);
                domainParameters = ECUtil.getNamedCurveByName(curveName);
            } else {
                domainParameters = ECUtil.getNamedCurveByName(curveName);
            }
        }
        catch (IllegalArgumentException ex) {
            domainParameters = ECUtil.getNamedCurveByName(curveName);
        }
        return domainParameters;
    }

    public static String getCurveTypeName(int curveType, int bits) {
        String curveString = null;
        switch (curveType) {
            case 524289: {
                curveString = "P-" + bits;
                break;
            }
            case 524290: {
                curveString = "K-" + bits;
                break;
            }
            case 524296: {
                curveString = "K1-" + bits;
                break;
            }
            case 524291: {
                curveString = "B-" + bits;
                break;
            }
            case 524295: {
                curveString = "W-" + bits;
                break;
            }
            default: {
                throw new RuntimeCryptoException("get Curve Type Name error:CurveType=" + curveType + ",Bits=" + bits);
            }
        }
        return curveString;
    }

    public static int getCurveType(String curveName) {
        if (curveName.contains("P")) {
            return 524289;
        }
        if (curveName.contains("K1")) {
            return 524296;
        }
        if (curveName.contains("K")) {
            return 524290;
        }
        if (curveName.contains("B")) {
            return 524291;
        }
        if (curveName.contains("W")) {
            return 524295;
        }
        throw new RuntimeCryptoException("curveType error:CurveType=" + curveName);
    }

    public static int getSwCurveType(String dercurveName) {
        if (dercurveName.equals("prime192v1") || dercurveName.equals("secp224r1") || dercurveName.equals("prime256v1") || dercurveName.equals("secp384r1") || dercurveName.equals("secp521r1")) {
            return 524289;
        }
        if (dercurveName.equals("secp256k1")) {
            return 524296;
        }
        if (dercurveName.equals("sect163k1") || dercurveName.equals("sect233k1") || dercurveName.equals("sect283k1") || dercurveName.equals("sect409k1") || dercurveName.equals("sect571k1")) {
            return 524290;
        }
        if (dercurveName.equals("sect163r2") || dercurveName.equals("sect233r1") || dercurveName.equals("sect283r1") || dercurveName.equals("sect409r1") || dercurveName.equals("sect571r1")) {
            return 524291;
        }
        if (dercurveName.equalsIgnoreCase("W-192")) {
            return 524295;
        }
        throw new RuntimeCryptoException("not support CurveType:CurveType=" + dercurveName);
    }

    public static String getSwCurveTypeFromDer(String dercurveName) {
        if (dercurveName.equals("prime192v1")) {
            return "P-192";
        }
        if (dercurveName.equals("secp224r1")) {
            return "P-224";
        }
        if (dercurveName.equals("prime256v1")) {
            return "P-256";
        }
        if (dercurveName.equals("secp256k1")) {
            return "K1-256";
        }
        if (dercurveName.equals("secp384r1")) {
            return "P-384";
        }
        if (dercurveName.equals("secp521r1")) {
            return "P-521";
        }
        if (dercurveName.equals("sect163k1")) {
            return "K-163";
        }
        if (dercurveName.equals("sect233k1")) {
            return "K-233";
        }
        if (dercurveName.equals("sect283k1")) {
            return "K-283";
        }
        if (dercurveName.equals("sect409k1")) {
            return "K-409";
        }
        if (dercurveName.equals("sect571k1")) {
            return "K-571";
        }
        if (dercurveName.equals("sect163r2")) {
            return "B-163";
        }
        if (dercurveName.equals("sect233r1")) {
            return "B-233";
        }
        if (dercurveName.equals("sect283r1")) {
            return "B-283";
        }
        if (dercurveName.equals("sect409r1")) {
            return "B-409";
        }
        if (dercurveName.equals("sect571r1")) {
            return "B-571";
        }
        if (dercurveName.equals("W-192")) {
            return "W-192";
        }
        throw new RuntimeCryptoException("not support CurveType:CurveType=" + dercurveName);
    }

    public static boolean isSwCurveType(String dercurveName) {
        if ("P-192".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("K1-256".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("P-224".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("P-256".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("P-384".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("P-521".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("K-163".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("K-233".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("K-283".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("K-409".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("K-571".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("B-163".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("B-233".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("B-283".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("B-409".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        if ("B-571".equalsIgnoreCase(dercurveName)) {
            return true;
        }
        return "W-192".equalsIgnoreCase(dercurveName);
    }

    static X962Parameters getDomainParametersFromName(ECParameterSpec ecSpec, boolean withCompression) {
        X962Parameters params;
        if (ecSpec instanceof ECNamedCurveSpec) {
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)ecSpec).getName());
            if (curveOid == null) {
                curveOid = new ASN1ObjectIdentifier(((ECNamedCurveSpec)ecSpec).getName());
            }
            params = new X962Parameters(curveOid);
        } else if (ecSpec == null) {
            params = new X962Parameters(DERNull.INSTANCE);
        } else {
            ECCurve curve = EC5Util.convertCurve(ecSpec.getCurve());
            X9ECParameters ecP = new X9ECParameters(curve, new X9ECPoint(EC5Util.convertPoint(curve, ecSpec.getGenerator()), withCompression), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
            params = new X962Parameters(ecP);
        }
        return params;
    }

    public static int getKeyBits(String curveName) {
        String[] infos = curveName.split("-");
        return Integer.parseInt(infos[1]);
    }
}

