/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.ec;

import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.jcajce.provider.asymmetric.ec.JCEECPublicKey;
import com.sansec.jcajce.provider.config.ProviderConfiguration;
import com.sansec.jce.interfaces.ECPublicKey;
import com.sansec.math.ec.ECPoint;
import com.sansec.util.Strings;
import java.security.spec.ECParameterSpec;

public class SwJCEECPublicKey
extends JCEECPublicKey
implements ECPublicKey {
    static final long serialVersionUID = 2422789860422731812L;
    private transient ECPoint q = super.getQ();
    private int keyIndex;
    private int keyType;
    private int bits;
    private int curveType;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public int getCurveType() {
        return this.curveType;
    }

    public SwJCEECPublicKey(int keyIndex, int keyType, int bits, int curveType, String algorithm, ECPublicKeyParameters params, ECParameterSpec spec, ProviderConfiguration configuration) {
        super(algorithm, params, spec, configuration);
        this.keyIndex = keyIndex;
        this.keyType = keyType;
        this.bits = bits;
        this.curveType = curveType;
    }

    public SwJCEECPublicKey(String algorithm, SubjectPublicKeyInfo info, ProviderConfiguration configuration) {
        super(algorithm, info, configuration);
        this.bits = super.getBits();
        this.curveType = super.getCurveType();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = Strings.lineSeparator();
        if (this.keyIndex == 0) {
            buf.append("External EC PublicKey").append(nl);
            buf.append("Bits:").append(this.bits).append(nl);
            buf.append("CurveType:").append(this.curveType).append(nl);
            buf.append("X:").append(this.q.getAffineXCoord().toBigInteger().toString(16)).append(nl);
            buf.append("Y:").append(this.q.getAffineYCoord().toBigInteger().toString(16)).append(nl);
        } else {
            buf.append("Internal EC PublicKey[ KeyIndex = " + this.keyIndex + ",KeyType = " + this.keyType + " ,Bits = " + this.bits + " ,CurveType= " + this.curveType + "]").append(nl);
        }
        return buf.toString();
    }
}

