/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.edec;

import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.ASN1Set;
import com.sansec.asn1.edec.EdECObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.X25519PrivateKeyParameters;
import com.sansec.crypto.params.X448PrivateKeyParameters;
import com.sansec.crypto.util.PrivateKeyInfoFactory;
import com.sansec.jcajce.interfaces.XDHPrivateKey;
import com.sansec.jcajce.interfaces.XDHPublicKey;
import com.sansec.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import com.sansec.jcajce.provider.asymmetric.edec.Utils;
import com.sansec.util.Arrays;
import com.sansec.util.Properties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCXDHPrivateKey
implements XDHPrivateKey {
    static final long serialVersionUID = 1L;
    transient AsymmetricKeyParameter xdhPrivateKey;
    private final boolean hasPublicKey;
    private final byte[] attributes;

    BCXDHPrivateKey(AsymmetricKeyParameter privKey) {
        this.hasPublicKey = true;
        this.attributes = null;
        this.xdhPrivateKey = privKey;
    }

    BCXDHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.hasPublicKey = keyInfo.hasPublicKey();
        this.attributes = keyInfo.getAttributes() != null ? keyInfo.getAttributes().getEncoded() : null;
        this.populateFromPrivateKeyInfo(keyInfo);
    }

    private void populateFromPrivateKeyInfo(PrivateKeyInfo keyInfo) throws IOException {
        ASN1OctetString keyOcts = keyInfo.getPrivateKey();
        byte[] infoOcts = keyOcts.getOctets();
        if (infoOcts.length != 32 && infoOcts.length != 56) {
            keyOcts = ASN1OctetString.getInstance(keyInfo.parsePrivateKey());
        }
        this.xdhPrivateKey = EdECObjectIdentifiers.id_X448.equals(keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? new X448PrivateKeyParameters(ASN1OctetString.getInstance(keyOcts).getOctets(), 0) : new X25519PrivateKeyParameters(ASN1OctetString.getInstance(keyOcts).getOctets(), 0);
    }

    @Override
    public String getAlgorithm() {
        return this.xdhPrivateKey instanceof X448PrivateKeyParameters ? "X448" : "X25519";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ASN1Set attrSet = ASN1Set.getInstance(this.attributes);
            PrivateKeyInfo privInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.xdhPrivateKey, attrSet);
            if (this.hasPublicKey && !Properties.isOverrideSet("org.bouncycastle.pkcs8.v1_info_only")) {
                return privInfo.getEncoded();
            }
            return new PrivateKeyInfo(privInfo.getPrivateKeyAlgorithm(), privInfo.parsePrivateKey(), attrSet).getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public XDHPublicKey getPublicKey() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return new BCXDHPublicKey(((X448PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey());
        }
        return new BCXDHPublicKey(((X25519PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey());
    }

    AsymmetricKeyParameter engineGetKeyParameters() {
        return this.xdhPrivateKey;
    }

    public String toString() {
        AsymmetricKeyParameter pubKey = this.xdhPrivateKey instanceof X448PrivateKeyParameters ? ((X448PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey() : ((X25519PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey();
        return Utils.keyToString("Private Key", this.getAlgorithm(), pubKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivateKey)) {
            return false;
        }
        PrivateKey other = (PrivateKey)o;
        return Arrays.areEqual(other.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPrivateKeyInfo(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

