/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.rsa;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.generators.RSAHsmKeyPairGenerator;
import com.sansec.crypto.generators.RSAKeyPairGenerator;
import com.sansec.crypto.params.RSAKeyGenerationParameters;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.jcajce.provider.asymmetric.rsa.SwJCERSAPrivateCrtKey;
import com.sansec.jcajce.provider.asymmetric.rsa.SwJCERSAPublicKey;
import com.sansec.jce.provider.SwxaProvider;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
    static final int defaultTests = 112;
    RSAKeyGenerationParameters param;
    RSAKeyPairGenerator engine;

    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public KeyPairGeneratorSpi() {
        super("RSA");
        this.engine = new RSAKeyPairGenerator();
        if (SwxaProvider.isHsm(null, "KeyPairGenerator", "RSA")) {
            this.engine = new RSAHsmKeyPairGenerator();
        }
        this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 112);
        this.engine.init(this.param);
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        if (strength < 1024) {
            this.engine = new RSAKeyPairGenerator();
        }
        this.param = new RSAKeyGenerationParameters(defaultPublicExponent, random, strength, 112);
        this.engine.init(this.param);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
        if (rsaParams.getKeysize() < 1024) {
            this.engine = new RSAKeyPairGenerator();
        }
        this.param = new RSAKeyGenerationParameters(rsaParams.getPublicExponent(), random, rsaParams.getKeysize(), 112);
        this.engine.init(this.param);
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        RSAKeyParameters pub = (RSAKeyParameters)pair.getPublic();
        RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)pair.getPrivate();
        SwJCERSAPublicKey publicKey = new SwJCERSAPublicKey(pub);
        SwJCERSAPrivateCrtKey privateKey = new SwJCERSAPrivateCrtKey(priv);
        return new KeyPair(publicKey, privateKey);
    }
}

