/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.rsa;

import com.sansec.asn1.DERNull;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.RSAPrivateKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.crypto.params.SwKeyParams;
import com.sansec.jcajce.provider.asymmetric.rsa.JCERSAPrivateCrtKey;
import com.sansec.util.KeyIndexUtil;
import com.sansec.util.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;

public class SwJCERSAPrivateCrtKey
extends JCERSAPrivateCrtKey
implements SwKeyParams {
    private static final long serialVersionUID = 2883451835712788964L;
    private int keyIndex;
    private int keyType;
    private int bits;
    private String keyLabel;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public SwJCERSAPrivateCrtKey(RSAPrivateCrtKeyParameters key) {
        super(key);
        this.keyIndex = key.getKeyIndex();
        this.keyType = key.getKeyType();
        this.bits = key.getBits();
        this.keyLabel = key.getKeyLabel();
        this.isSW();
    }

    SwJCERSAPrivateCrtKey(RSAPrivateCrtKeySpec spec) {
        super(spec);
        this.isSW();
    }

    public SwJCERSAPrivateCrtKey(RSAPrivateCrtKey key) {
        super(key);
        this.isSW();
    }

    public SwJCERSAPrivateCrtKey(PrivateKeyInfo info) throws IOException {
        super(info);
        this.isSW();
    }

    private void isSW() {
        BigInteger d = super.getPrivateExponent();
        int dint = d.intValue();
        if (dint >= 0 && dint <= 100 && d.bitLength() < 32) {
            try {
                KeyIndexUtil.KeyIndexStruct struct = KeyIndexUtil.parse2KeyIndex(dint);
                this.keyIndex = struct.keyIndex;
                this.keyType = struct.keyType;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    SwJCERSAPrivateCrtKey(RSAPrivateKeyStructure key) {
        super(key);
        this.isSW();
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKeyStructure(this.getModulus(), this.getPublicExponent(), this.getPrivateExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient()).toASN1Primitive());
            return info.toASN1Primitive().getEncoded("DER");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public BigInteger getPublicExponent() {
        return super.getPublicExponent();
    }

    @Override
    public BigInteger getPrimeP() {
        return super.getPrimeP();
    }

    @Override
    public BigInteger getPrimeQ() {
        return super.getPrimeQ();
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return super.getPrimeExponentP();
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return super.getPrimeExponentQ();
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return super.getCrtCoefficient();
    }

    @Override
    public int hashCode() {
        if (this.keyIndex == 0) {
            return super.hashCode();
        }
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.keyIndex == 0) {
            return super.equals(o);
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwJCERSAPrivateCrtKey)) {
            return false;
        }
        SwJCERSAPrivateCrtKey key = (SwJCERSAPrivateCrtKey)o;
        return this.getModulus().equals(key.getModulus()) && this.getPublicExponent().equals(key.getPublicExponent()) && this.getKeyIndex() == key.getKeyIndex() && this.getKeyLabel() == key.getKeyLabel();
    }

    @Override
    public String toString() {
        if (this.keyIndex == 0) {
            StringBuffer buf = new StringBuffer();
            String nl = Strings.lineSeparator();
            buf.append("External RSA Private CRT Key").append(nl);
            buf.append("bits:").append(this.bits).append(nl);
            buf.append("modulus: ").append(this.getModulus().toString(16)).append(nl);
            buf.append("public exponent: ").append(this.getPublicExponent().toString(16)).append(nl);
            buf.append("private exponent: ").append(this.getPrivateExponent().toString(16)).append(nl);
            buf.append("primeP: ").append(this.getPrimeP().toString(16)).append(nl);
            buf.append("primeQ: ").append(this.getPrimeQ().toString(16)).append(nl);
            buf.append("primeExponentP: ").append(this.getPrimeExponentP().toString(16)).append(nl);
            buf.append("primeExponentQ: ").append(this.getPrimeExponentQ().toString(16)).append(nl);
            buf.append("crtCoefficient: ").append(this.getCrtCoefficient().toString(16)).append(nl);
            return buf.toString();
        }
        if (this.keyIndex > 0) {
            return "Internal RSA PrivateKey[ KeyIndex = " + this.keyIndex + ", KeyType = " + this.keyType + ",Bits=" + this.bits + " ]";
        }
        return "Internal RSA PrivateKey[ KeyLabel = " + this.keyLabel + ", KeyType = " + this.keyType + ",Bits=" + this.bits + " ]";
    }
}

