/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.rsa;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.Digest;
import com.sansec.crypto.digests.RIPEMD128Digest;
import com.sansec.crypto.digests.RIPEMD160Digest;
import com.sansec.crypto.digests.SHA1Digest;
import com.sansec.crypto.digests.SHA224Digest;
import com.sansec.crypto.digests.SHA256Digest;
import com.sansec.crypto.digests.SHA384Digest;
import com.sansec.crypto.digests.SHA512Digest;
import com.sansec.crypto.digests.SHA512tDigest;
import com.sansec.crypto.digests.WhirlpoolDigest;
import com.sansec.crypto.engines.RSABlindedEngine;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.signers.X931Signer;
import com.sansec.jcajce.provider.asymmetric.rsa.RSAUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class X931SignatureSpi
extends SignatureSpi {
    private X931Signer signer;

    protected X931SignatureSpi(Digest digest, AsymmetricBlockCipher cipher) {
        this.signer = new X931Signer(cipher, digest);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.signer.init(true, param);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.signer.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.signer.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] sig = this.signer.generateSignature();
            return sig;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        boolean yes = this.signer.verifySignature(sigBytes);
        return yes;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class WhirlpoolWithRSAEncryption
    extends X931SignatureSpi {
        public WhirlpoolWithRSAEncryption() {
            super(new WhirlpoolDigest(), new RSABlindedEngine());
        }
    }

    public static class SHA512_256WithRSAEncryption
    extends X931SignatureSpi {
        public SHA512_256WithRSAEncryption() {
            super(new SHA512tDigest(256), new RSABlindedEngine());
        }
    }

    public static class SHA512_224WithRSAEncryption
    extends X931SignatureSpi {
        public SHA512_224WithRSAEncryption() {
            super(new SHA512tDigest(224), new RSABlindedEngine());
        }
    }

    public static class SHA512WithRSAEncryption
    extends X931SignatureSpi {
        public SHA512WithRSAEncryption() {
            super(new SHA512Digest(), new RSABlindedEngine());
        }
    }

    public static class SHA384WithRSAEncryption
    extends X931SignatureSpi {
        public SHA384WithRSAEncryption() {
            super(new SHA384Digest(), new RSABlindedEngine());
        }
    }

    public static class SHA256WithRSAEncryption
    extends X931SignatureSpi {
        public SHA256WithRSAEncryption() {
            super(new SHA256Digest(), new RSABlindedEngine());
        }
    }

    public static class SHA224WithRSAEncryption
    extends X931SignatureSpi {
        public SHA224WithRSAEncryption() {
            super(new SHA224Digest(), new RSABlindedEngine());
        }
    }

    public static class SHA1WithRSAEncryption
    extends X931SignatureSpi {
        public SHA1WithRSAEncryption() {
            super(new SHA1Digest(), new RSABlindedEngine());
        }
    }

    public static class RIPEMD160WithRSAEncryption
    extends X931SignatureSpi {
        public RIPEMD160WithRSAEncryption() {
            super(new RIPEMD160Digest(), new RSABlindedEngine());
        }
    }

    public static class RIPEMD128WithRSAEncryption
    extends X931SignatureSpi {
        public RIPEMD128WithRSAEncryption() {
            super(new RIPEMD128Digest(), new RSABlindedEngine());
        }
    }
}

