/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.sm2;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.sansec.asn1.x509.X509ObjectIdentifiers;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.Digest;
import com.sansec.crypto.digests.MD2Digest;
import com.sansec.crypto.digests.MD4Digest;
import com.sansec.crypto.digests.MD5Digest;
import com.sansec.crypto.digests.NullDigest;
import com.sansec.crypto.digests.RIPEMD128Digest;
import com.sansec.crypto.digests.RIPEMD160Digest;
import com.sansec.crypto.digests.RIPEMD256Digest;
import com.sansec.crypto.digests.SHA1Digest;
import com.sansec.crypto.digests.SHA224Digest;
import com.sansec.crypto.digests.SHA256Digest;
import com.sansec.crypto.digests.SHA384Digest;
import com.sansec.crypto.digests.SHA512Digest;
import com.sansec.crypto.digests.SM3Digest;
import com.sansec.crypto.encodings.SM2SignatureEncoding;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PrivateKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PublicKey;
import com.sansec.jcajce.provider.asymmetric.sm2.SM2Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private static final byte[] ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private Digest digest;
    private SM2SignatureEncoding cipher;
    private boolean isSM3WithKey = false;

    protected DigestSignatureSpi(Digest digest, SM2SignatureEncoding cipher) {
        this.digest = digest;
        this.cipher = cipher;
    }

    protected DigestSignatureSpi(ASN1ObjectIdentifier objId, Digest digest, SM2SignatureEncoding cipher) {
        this.digest = digest;
        this.cipher = cipher;
    }

    protected DigestSignatureSpi(ASN1ObjectIdentifier objId, Digest digest, SM2SignatureEncoding cipher, boolean isSM3WithKey) {
        this.digest = digest;
        this.cipher = cipher;
        this.isSM3WithKey = isSM3WithKey;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(publicKey) + ") is not a ECPublicKey instance");
        }
        CipherParameters param = null;
        if (publicKey instanceof JCESM2PublicKey) {
            param = SM2Util.generatePublicKeyParameter((JCESM2PublicKey)publicKey);
        } else if (publicKey instanceof ECPublicKey) {
            param = SM2Util.generateECPublicKeyParameter((ECPublicKey)publicKey);
        } else {
            throw new InvalidKeyException("Invalid sm2 public key");
        }
        this.digest.reset();
        if (this.digest instanceof SM3Digest && this.isSM3WithKey) {
            BigInteger x = null;
            BigInteger y = null;
            if (publicKey instanceof JCESM2PublicKey) {
                x = ((JCESM2PublicKey)publicKey).getW().getAffineX();
                y = ((JCESM2PublicKey)publicKey).getW().getAffineY();
            } else if (publicKey instanceof ECPublicKey) {
                x = ((ECPublicKey)publicKey).getW().getAffineX();
                y = ((ECPublicKey)publicKey).getW().getAffineY();
            } else {
                throw new InvalidKeyException("Invalid sm2 public key");
            }
            if (x == null || y == null) {
                throw new InvalidKeyException("x or y is null");
            }
            ((SM3Digest)this.digest).addId(x, y, ID);
        }
        this.cipher.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(privateKey) + ") is not a ECPrivateKey instance");
        }
        CipherParameters param = null;
        if (privateKey instanceof JCESM2PrivateKey) {
            param = SM2Util.generatePrivateKeyParameter((JCESM2PrivateKey)privateKey);
        } else if (privateKey instanceof ECPrivateKey) {
            param = SM2Util.generateECPrivateKeyParameter((ECPrivateKey)privateKey);
        } else {
            throw new InvalidKeyException("Not a valid SM2 public key");
        }
        this.digest.reset();
        if (this.digest instanceof SM3Digest && this.isSM3WithKey) {
            BigInteger x = null;
            BigInteger y = null;
            if (privateKey instanceof JCESM2PrivateKey) {
                param = SM2Util.generatePrivateKeyParameter((JCESM2PrivateKey)privateKey);
                x = ((JCESM2PrivateKey)privateKey).getX();
                y = ((JCESM2PrivateKey)privateKey).getY();
            } else if (privateKey instanceof ECPrivateKey) {
                try {
                    KeyFactory keyFactory1 = KeyFactory.getInstance("SM2", "SwxaJCE");
                    JCESM2PrivateKey privateKey1 = (JCESM2PrivateKey)keyFactory1.generatePrivate(new PKCS8EncodedKeySpec(privateKey.getEncoded()));
                    param = SM2Util.generatePrivateKeyParameter(privateKey1);
                    x = privateKey1.getX();
                    y = privateKey1.getY();
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Key conversion error:" + e.getMessage());
                }
            } else {
                throw new InvalidKeyException("Not a valid SM2 public key");
            }
            if (x == null || y == null) {
                throw new InvalidKeyException(" X or Y in public key is null");
            }
            ((SM3Digest)this.digest).addId(x, y, ID);
        }
        this.cipher.init(true, param);
    }

    private String getType(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] bytes = hash;
            byte[] sigBytes = this.cipher.sign(bytes, 0, bytes.length);
            return sigBytes;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        boolean flag;
        byte[] hash = null;
        hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            flag = this.cipher.verify(sigBytes, 0, sigBytes.length, hash, 0, hash.length);
        }
        catch (Exception ex) {
            flag = false;
        }
        return flag;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
    }

    @Override
    protected Object engineGetParameter(String param) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static class noneSM2
    extends DigestSignatureSpi {
        public noneSM2() {
            super(null, new NullDigest(), new SM2SignatureEncoding());
        }
    }

    public static class SM3WithoutKeyWithSM2Encryption
    extends DigestSignatureSpi {
        public SM3WithoutKeyWithSM2Encryption() {
            super(null, new SM3Digest(), new SM2SignatureEncoding());
        }
    }

    public static class SM3WithSM2Encryption
    extends DigestSignatureSpi {
        public SM3WithSM2Encryption() {
            super(null, new SM3Digest(), new SM2SignatureEncoding(), true);
        }
    }

    public static class RIPEMD256WithSM2Encryption
    extends DigestSignatureSpi {
        public RIPEMD256WithSM2Encryption() {
            super(TeleTrusTObjectIdentifiers.ripemd256, new RIPEMD256Digest(), new SM2SignatureEncoding());
        }
    }

    public static class RIPEMD128WithSM2Encryption
    extends DigestSignatureSpi {
        public RIPEMD128WithSM2Encryption() {
            super(TeleTrusTObjectIdentifiers.ripemd128, new RIPEMD128Digest(), new SM2SignatureEncoding());
        }
    }

    public static class RIPEMD160WithSM2Encryption
    extends DigestSignatureSpi {
        public RIPEMD160WithSM2Encryption() {
            super(TeleTrusTObjectIdentifiers.ripemd160, new RIPEMD160Digest(), new SM2SignatureEncoding());
        }
    }

    public static class MD5WithSM2Encryption
    extends DigestSignatureSpi {
        public MD5WithSM2Encryption() {
            super(PKCSObjectIdentifiers.md5, new MD5Digest(), new SM2SignatureEncoding());
        }
    }

    public static class MD4WithSM2Encryption
    extends DigestSignatureSpi {
        public MD4WithSM2Encryption() {
            super(PKCSObjectIdentifiers.md4, new MD4Digest(), new SM2SignatureEncoding());
        }
    }

    public static class MD2WithSM2Encryption
    extends DigestSignatureSpi {
        public MD2WithSM2Encryption() {
            super(PKCSObjectIdentifiers.md2, new MD2Digest(), new SM2SignatureEncoding());
        }
    }

    public static class SHA512WithSM2Encryption
    extends DigestSignatureSpi {
        public SHA512WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha512, new SHA512Digest(), new SM2SignatureEncoding());
        }
    }

    public static class SHA384WithSM2Encryption
    extends DigestSignatureSpi {
        public SHA384WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha384, new SHA384Digest(), new SM2SignatureEncoding());
        }
    }

    public static class SHA256WithSM2Encryption
    extends DigestSignatureSpi {
        public SHA256WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha256, new SHA256Digest(), new SM2SignatureEncoding());
        }
    }

    public static class SHA224WithSM2Encryption
    extends DigestSignatureSpi {
        public SHA224WithSM2Encryption() {
            super(NISTObjectIdentifiers.id_sha224, new SHA224Digest(), new SM2SignatureEncoding());
        }
    }

    public static class SHA1WithSM2Encryption
    extends DigestSignatureSpi {
        public SHA1WithSM2Encryption() {
            super(X509ObjectIdentifiers.id_SHA1, new SHA1Digest(), new SM2SignatureEncoding());
        }
    }
}

