/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.sm2;

import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.agreement.SM2KeyExchange;
import com.sansec.crypto.engines.SM2Soft;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.params.ParametersWithID;
import com.sansec.crypto.params.SM2KeyExchangePrivateParameters;
import com.sansec.crypto.params.SM2KeyExchangePublicParameters;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2ParameterSpec;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PrivateKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PublicKey;
import com.sansec.jcajce.provider.asymmetric.sm2.SM2Util;
import com.sansec.jcajce.provider.asymmetric.util.SM2KeyUtil;
import com.sansec.math.ec.ECPoint;
import com.sansec.util.Strings;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class JCESM2KeyAgreement
extends KeyAgreementSpi {
    private byte[] result;
    private SecureRandom random;
    private JCESM2PrivateKey priKey;
    private JCESM2PrivateKey tmpPriKey_a;
    private JCESM2PublicKey tmpPubKey_a;
    private JCESM2PublicKey pubKey_b;
    private JCESM2PublicKey tmpPubKey_b;
    private ISDSCrypto crypto = null;
    private SM2KeyExchange exch = null;
    private int flag = 0;
    private int keyBits = 384;
    private int majorVersion;
    private int minorVersion;
    private byte[] ownId = "1234567812345678".getBytes();
    private byte[] opId = "1234567812345678".getBytes();
    private static final Hashtable<String, Integer> algorithms = new Hashtable();
    private boolean ISHSM = true;

    public JCESM2KeyAgreement() throws CryptoException {
        this.crypto = SwxaDeviceFactory.getInstance();
        this.exch = new SM2KeyExchange();
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.priKey == null) {
            throw new IllegalStateException("JCESM2KeyAgreement not initialised.");
        }
        if (!(key instanceof JCESM2PublicKey)) {
            throw new InvalidKeyException("JCESM2KeyAgreement doPhase requires DHPublicKey");
        }
        if (lastPhase) {
            if (this.pubKey_b == null) {
                throw new IllegalStateException("JCESM2KeyAgreement must be called one more time before this");
            }
            this.tmpPubKey_b = (JCESM2PublicKey)key;
            try {
                if (this.ISHSM) {
                    SM2refPublicKey refTmpPubKey_a = SM2KeyUtil.convert((SM2KeyParameters)SM2Util.generatePublicKeyParameter(this.tmpPubKey_a));
                    SM2refPrivateKey refTmpPriKey_a = SM2KeyUtil.convert((SM2PrivateKeyParameters)SM2Util.generatePrivateKeyParameter(this.tmpPriKey_a));
                    SM2refPublicKey refPubKey_b = SM2KeyUtil.convert((SM2KeyParameters)SM2Util.generatePublicKeyParameter(this.pubKey_b));
                    SM2refPublicKey refTmpPubKey_b = SM2KeyUtil.convert((SM2KeyParameters)SM2Util.generatePublicKeyParameter(this.tmpPubKey_b));
                    this.result = this.crypto.keyAgreement_SM2(this.flag, this.priKey.getKeyIndex(), refTmpPubKey_a, refTmpPriKey_a, refPubKey_b, refTmpPubKey_b, this.keyBits, this.ownId, this.opId);
                }
                ECDomainParameters params = SM2Soft.getEcc_bc_spec();
                BigInteger d = this.priKey.getS();
                BigInteger tmpD = this.tmpPriKey_a.getS();
                ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(d, params);
                ECPrivateKeyParameters tmpecPrivateKeyParameters = new ECPrivateKeyParameters(tmpD, params);
                ECPoint Q = SM2Soft.getSm2Curve().createPoint(this.pubKey_b.getW().getAffineX(), this.pubKey_b.getW().getAffineY());
                ECPoint tmpQ = SM2Soft.getSm2Curve().createPoint(this.tmpPubKey_b.getW().getAffineX(), this.tmpPubKey_b.getW().getAffineY());
                ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(Q, params);
                ECPublicKeyParameters tmpecPublicKeyParameters = new ECPublicKeyParameters(tmpQ, params);
                this.exch.init(new ParametersWithID(new SM2KeyExchangePrivateParameters(this.flag == 0, ecPrivateKeyParameters, tmpecPrivateKeyParameters), this.ownId));
                this.result = this.exch.calculateKey(this.keyBits, new ParametersWithID(new SM2KeyExchangePublicParameters(ecPublicKeyParameters, tmpecPublicKeyParameters), this.opId));
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("SM2 algorithm key agreement error", e);
            }
        } else {
            this.pubKey_b = (JCESM2PublicKey)key;
        }
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.priKey == null || this.result == null) {
            throw new IllegalStateException("JCESM2KeyAgreement not initialised.");
        }
        this.priKey = null;
        this.tmpPriKey_a = null;
        this.tmpPubKey_a = null;
        this.tmpPubKey_b = null;
        this.pubKey_b = null;
        return this.result;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (this.priKey == null || this.result == null) {
            throw new IllegalStateException("JCESM2KeyAgreement not initialised.");
        }
        if (sharedSecret.length - offset < this.result.length) {
            throw new ShortBufferException("JCESM2KeyAgreement - buffer too short");
        }
        System.arraycopy(this.result, 0, sharedSecret, offset, this.result.length);
        this.priKey = null;
        this.tmpPubKey_a = null;
        this.tmpPubKey_b = null;
        this.pubKey_b = null;
        this.tmpPriKey_a = null;
        return this.result.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) {
        if (this.priKey == null || this.result == null) {
            throw new IllegalStateException("JCESM2KeyAgreement not initialised.");
        }
        String algKey = Strings.toUpperCase(algorithm);
        this.priKey = null;
        this.tmpPubKey_a = null;
        this.tmpPubKey_b = null;
        this.pubKey_b = null;
        this.tmpPriKey_a = null;
        return new SecretKeySpec(this.result, algorithm);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] tmpBuf;
        if (!(params instanceof SM2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("JCESM2KeyAgreement requires SM2ParameterSpec");
        }
        SM2ParameterSpec paSpec = (SM2ParameterSpec)params;
        this.flag = paSpec.getFlag();
        this.keyBits = paSpec.getKeyBits();
        this.majorVersion = paSpec.getMajorVersion();
        this.minorVersion = paSpec.getMinorVersion();
        KeyPair keyPair = paSpec.getKeyPair();
        if (!(keyPair.getPrivate() instanceof JCESM2PrivateKey) || !(keyPair.getPublic() instanceof JCESM2PublicKey)) {
            throw new InvalidKeyException("tmp KeyPair in params is not SM2 keyPair");
        }
        this.tmpPubKey_a = (JCESM2PublicKey)keyPair.getPublic();
        this.tmpPriKey_a = (JCESM2PrivateKey)keyPair.getPrivate();
        if (paSpec.getOwnId() != null) {
            tmpBuf = new byte[paSpec.getOwnId().length];
            System.arraycopy(paSpec.getOwnId(), 0, tmpBuf, 0, tmpBuf.length);
            this.ownId = tmpBuf;
        }
        if (paSpec.getOpId() != null) {
            tmpBuf = new byte[paSpec.getOpId().length];
            System.arraycopy(paSpec.getOpId(), 0, tmpBuf, 0, tmpBuf.length);
            this.opId = tmpBuf;
        }
        this.engineInit(key, random);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof JCESM2PrivateKey)) {
            throw new InvalidKeyException("JCESM2KeyAgreement requires JCESM2PrivateKey");
        }
        this.random = random;
        this.priKey = (JCESM2PrivateKey)key;
        if (this.priKey.getKeyIndex() < 1) {
            this.ISHSM = false;
        } else if (this.priKey.getKeyType() != 2) {
            throw new InvalidKeyException("JCESM2KeyAgreement requires  SM2 encrypt privateKey");
        }
    }

    static {
        Integer i64 = new Integer(64);
        Integer i192 = new Integer(192);
        Integer i128 = new Integer(128);
        algorithms.put("DES", i64);
        algorithms.put("DESEDE", i192);
        algorithms.put("BLOWFISH", i128);
    }
}

