/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.sm2;

import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.SM2PrivateKeyStructure;
import com.sansec.asn1.pkcs.SM2PublicKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.crypto.params.SwKeyParams;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PriKey;
import com.sansec.util.KeyIndexUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;

public class JCESM2PrivateKey
extends JCESM2PriKey
implements ECPrivateKey,
SwKeyParams {
    static final long serialVersionUID = -8145849727580266753L;
    private static BigInteger MAX_KEY_INDEX = new BigInteger("100");
    private int keyIndex;
    private int keyType;
    private int bits;
    private BigInteger s;
    private BigInteger x;
    private BigInteger y;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    private void setS(BigInteger s) {
        if (s.compareTo(MAX_KEY_INDEX) <= 0 && s.signum() >= 0) {
            try {
                KeyIndexUtil.KeyIndexStruct struct = KeyIndexUtil.parse2KeyIndex(s.intValue());
                this.keyIndex = struct.keyIndex;
                this.keyType = struct.keyType;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.s = s;
    }

    JCESM2PrivateKey(SM2PrivateKeyParameters prikey, SM2KeyParameters pubkey) {
        this.keyIndex = prikey.getKeyIndex();
        this.keyType = prikey.getKeyType();
        this.bits = prikey.getBits();
        this.s = prikey.getD();
        this.x = pubkey.getX();
        this.y = pubkey.getY();
    }

    public JCESM2PrivateKey(ECPrivateKeySpec spec) {
        this.setS(spec.getS());
    }

    public JCESM2PrivateKey(SM2PrivateKeyStructure sm2PrivateKey) {
        this.setS(sm2PrivateKey.getKey());
        DERBitString publicKeyData = sm2PrivateKey.getPublicKey();
        if (publicKeyData != null) {
            SM2PublicKeyStructure sm2PublicKey = new SM2PublicKeyStructure(publicKeyData);
            this.x = sm2PublicKey.getQ().getAffineX();
            this.y = sm2PublicKey.getQ().getAffineY();
        }
    }

    public JCESM2PrivateKey(PrivateKeyInfo info) {
        try {
            SM2PrivateKeyStructure structure = new SM2PrivateKeyStructure((ASN1Sequence)info.parsePrivateKey());
            this.setS(structure.getKey());
            DERBitString publicKeyData = structure.getPublicKey();
            if (publicKeyData != null) {
                SM2PublicKeyStructure sm2PublicKey = new SM2PublicKeyStructure(publicKeyData);
                this.x = sm2PublicKey.getQ().getAffineX();
                this.y = sm2PublicKey.getQ().getAffineY();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid info structure in SM2 public key");
        }
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        DERBitString pubkey = null;
        if (this.x != null && this.y != null) {
            pubkey = new DERBitString(new SM2PublicKeyStructure(new ECPoint(this.x, this.y)).getPublicKey());
        }
        SM2PrivateKeyStructure sm2PrivateKey = new SM2PrivateKeyStructure(this.s, pubkey, GBObjectIdentifiers.sm2);
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.ecPublicKey, GBObjectIdentifiers.sm2), sm2PrivateKey.toASN1Primitive());
            return info.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.getS().hashCode() ^ this.getKeyIndex();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JCESM2PrivateKey)) {
            return false;
        }
        JCESM2PrivateKey key = (JCESM2PrivateKey)o;
        return key.getS().equals(this.s) && this.getKeyIndex() == key.getKeyIndex() && this.getKeyType() == key.getKeyType();
    }

    public String toString() {
        String str = "";
        if (this.keyIndex == 0) {
            StringBuffer buf = new StringBuffer();
            String nl = System.getProperty("line.separator");
            buf.append("External SM2 Private Key").append(nl);
            buf.append("Bits:").append(this.bits).append(nl);
            buf.append("S: ").append(this.s.toString(16)).append(nl);
            str = buf.toString();
        } else {
            str = "Internal SM2 PrivateKey[ KeyIndex = " + this.keyIndex + ", KeyType = " + this.keyType + ",Bits= " + this.bits + " ]";
        }
        return str;
    }

    @Override
    public BigInteger getS() {
        return this.s;
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public ECPoint getW() {
        return new ECPoint(this.x, this.y);
    }

    @Override
    public ECParameterSpec getParams() {
        return null;
    }
}

