/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.sm2;

import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.SM2PublicKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SwKeyParams;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;

public class JCESM2PublicKey
implements ECPublicKey,
SwKeyParams {
    static final long serialVersionUID = -8145849727580266753L;
    private int keyIndex;
    private int keyType;
    private int bits;
    private BigInteger x;
    private BigInteger y;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    JCESM2PublicKey(SM2KeyParameters key) {
        this.keyIndex = key.getKeyIndex();
        this.keyType = key.getKeyType();
        this.bits = key.getBits();
        this.x = key.getX();
        this.y = key.getY();
    }

    public JCESM2PublicKey(ECPublicKeySpec spec) {
        this.x = spec.getW().getAffineX();
        this.y = spec.getW().getAffineY();
    }

    public JCESM2PublicKey(SubjectPublicKeyInfo info) {
        try {
            SM2PublicKeyStructure sm2PublicKey = new SM2PublicKeyStructure(info.getPublicKeyData());
            this.x = sm2PublicKey.getQ().getAffineX();
            this.y = sm2PublicKey.getQ().getAffineY();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid info structure in SM2 public key");
        }
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        ECPoint w = new ECPoint(this.x, this.y);
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.ecPublicKey, GBObjectIdentifiers.sm2), new SM2PublicKeyStructure(w).getPublicKey());
        try {
            return info.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.getW().hashCode() ^ this.getKeyIndex();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JCESM2PublicKey)) {
            return false;
        }
        JCESM2PublicKey key = (JCESM2PublicKey)o;
        ECPoint w = new ECPoint(this.x, this.y);
        return key.getW().getAffineX().equals(w.getAffineX()) && key.getW().getAffineY().equals(w.getAffineY()) && this.getKeyIndex() == key.getKeyIndex() && this.getKeyType() == key.getKeyType();
    }

    public String toString() {
        ECPoint w = new ECPoint(this.x, this.y);
        String str = "";
        if (this.keyIndex == 0) {
            StringBuffer buf = new StringBuffer();
            String nl = System.getProperty("line.separator");
            buf.append("External SM2 Public Key").append(nl);
            buf.append("Bits:").append(this.bits).append(nl);
            buf.append("AffineX: ").append(w.getAffineX().toString(16)).append(nl);
            buf.append("AffineY: ").append(w.getAffineY().toString(16)).append(nl);
            str = buf.toString();
        } else {
            str = "Internal SM2 PublicKey[ KeyIndex = " + this.keyIndex + ", KeyType = " + this.keyType + ",Bits=" + this.bits + " ]";
        }
        return str;
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.x, this.y);
    }

    @Override
    public ECParameterSpec getParams() {
        return null;
    }
}

