/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.util;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.anssi.ANSSINamedCurves;
import com.sansec.asn1.cryptopro.ECGOST3410NamedCurves;
import com.sansec.asn1.nist.NISTNamedCurves;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.sec.SECNamedCurves;
import com.sansec.asn1.teletrust.TeleTrusTNamedCurves;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x9.ECNamedCurveTable;
import com.sansec.asn1.x9.X962NamedCurves;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.crypto.ec.CustomNamedCurves;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECNamedDomainParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.jcajce.provider.asymmetric.ec.JCEECPublicKey;
import com.sansec.jcajce.provider.asymmetric.util.EC5Util;
import com.sansec.jcajce.provider.config.ProviderConfiguration;
import com.sansec.jce.interfaces.ECPrivateKey;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.spec.ECNamedCurveParameterSpec;
import com.sansec.jce.spec.ECParameterSpec;
import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import com.sansec.math.ec.FixedPointCombMultiplier;
import com.sansec.util.Arrays;
import com.sansec.util.Fingerprint;
import com.sansec.util.Strings;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Map;

public class ECUtil {
    static int[] convertMidTerms(int[] k) {
        int[] res = new int[3];
        if (k.length == 1) {
            res[0] = k[0];
        } else {
            if (k.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (k[0] < k[1] && k[0] < k[2]) {
                res[0] = k[0];
                if (k[1] < k[2]) {
                    res[1] = k[1];
                    res[2] = k[2];
                } else {
                    res[1] = k[2];
                    res[2] = k[1];
                }
            } else if (k[1] < k[2]) {
                res[0] = k[1];
                if (k[0] < k[2]) {
                    res[1] = k[0];
                    res[2] = k[2];
                } else {
                    res[1] = k[2];
                    res[2] = k[0];
                }
            } else {
                res[0] = k[2];
                if (k[0] < k[1]) {
                    res[1] = k[0];
                    res[2] = k[1];
                } else {
                    res[1] = k[1];
                    res[2] = k[0];
                }
            }
        }
        return res;
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration configuration, ECParameterSpec params) {
        ECDomainParameters domainParameters;
        if (params instanceof ECNamedCurveParameterSpec) {
            ECNamedCurveParameterSpec nParams = (ECNamedCurveParameterSpec)params;
            ASN1ObjectIdentifier nameOid = ECUtil.getNamedCurveOid(nParams.getName());
            domainParameters = new ECNamedDomainParameters(nameOid, nParams.getCurve(), nParams.getG(), nParams.getN(), nParams.getH(), nParams.getSeed());
        } else if (params == null) {
            ECParameterSpec iSpec = configuration.getEcImplicitlyCa();
            domainParameters = new ECDomainParameters(iSpec.getCurve(), iSpec.getG(), iSpec.getN(), iSpec.getH(), iSpec.getSeed());
        } else {
            domainParameters = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH(), params.getSeed());
        }
        return domainParameters;
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration configuration, X962Parameters params) {
        ECDomainParameters domainParameters;
        if (params.isNamedCurve()) {
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(params.getParameters());
            X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
            if (ecP == null) {
                Map extraCurves = configuration.getAdditionalECParameters();
                ecP = (X9ECParameters)extraCurves.get(oid);
            }
            domainParameters = new ECNamedDomainParameters(oid, ecP);
        } else if (params.isImplicitlyCA()) {
            ECParameterSpec iSpec = configuration.getEcImplicitlyCa();
            domainParameters = new ECDomainParameters(iSpec.getCurve(), iSpec.getG(), iSpec.getN(), iSpec.getH(), iSpec.getSeed());
        } else {
            X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
            domainParameters = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        }
        return domainParameters;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof com.sansec.jce.interfaces.ECPublicKey) {
            com.sansec.jce.interfaces.ECPublicKey k = (com.sansec.jce.interfaces.ECPublicKey)key;
            ECParameterSpec s = k.getParameters();
            if (s == null) {
                s = SwxaProvider.CONFIGURATION.getEcImplicitlyCa();
                return new ECPublicKeyParameters(((JCEECPublicKey)k).engineGetQ(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
            }
            return new ECPublicKeyParameters(k.getKeyIndex(), k.getKeyType(), k.getBits(), k.getCurveType(), k.getQ(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey pubKey = (ECPublicKey)key;
            ECParameterSpec s = EC5Util.convertSpec(pubKey.getParams());
            return new ECPublicKeyParameters(EC5Util.convertPoint(pubKey.getParams(), pubKey.getW()), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        }
        try {
            byte[] bytes = key.getEncoded();
            if (bytes == null) {
                throw new InvalidKeyException("no encoding for EC public key");
            }
            PublicKey publicKey = SwxaProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(bytes));
            if (publicKey instanceof ECPublicKey) {
                return ECUtil.generatePublicKeyParameter(publicKey);
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException("cannot identify EC public key: " + e.toString());
        }
        throw new InvalidKeyException("cannot identify EC public key.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            ECParameterSpec s = k.getParameters();
            if (s == null) {
                s = SwxaProvider.CONFIGURATION.getEcImplicitlyCa();
            }
            ECPrivateKeyParameters parameters = new ECPrivateKeyParameters(k.getKeyIndex(), k.getKeyType(), k.getBits(), k.getCurveType(), k.getD(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
            return parameters;
        }
        if (key instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey privKey = (java.security.interfaces.ECPrivateKey)key;
            ECParameterSpec s = EC5Util.convertSpec(privKey.getParams());
            return new ECPrivateKeyParameters(privKey.getS(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        }
        try {
            byte[] bytes = key.getEncoded();
            if (bytes == null) {
                throw new InvalidKeyException("no encoding for EC private key");
            }
            PrivateKey privateKey = SwxaProvider.getPrivateKey(PrivateKeyInfo.getInstance(bytes));
            if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
                return ECUtil.generatePrivateKeyParameter(privateKey);
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException("cannot identify EC private key: " + e.toString());
        }
        throw new InvalidKeyException("can't identify EC private key.");
    }

    public static int getOrderBitLength(ProviderConfiguration configuration, BigInteger order, BigInteger privateValue) {
        if (order == null) {
            ECParameterSpec implicitCA = configuration.getEcImplicitlyCa();
            if (implicitCA == null) {
                return privateValue.bitLength();
            }
            return implicitCA.getN().bitLength();
        }
        return order.bitLength();
    }

    public static String privateKeyToString(String algorithm, BigInteger d, ECParameterSpec spec) {
        StringBuffer buf = new StringBuffer();
        String nl = Strings.lineSeparator();
        ECPoint q = new FixedPointCombMultiplier().multiply(spec.getG(), d).normalize();
        buf.append(algorithm);
        buf.append(" Private Key [").append(ECUtil.generateKeyFingerprint(q, spec)).append("]").append(nl);
        buf.append("            X: ").append(q.getAffineXCoord().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(q.getAffineYCoord().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }

    public static String generateKeyFingerprint(ECPoint publicPoint, ECParameterSpec spec) {
        ECCurve curve = spec.getCurve();
        ECPoint g = spec.getG();
        if (curve != null) {
            return new Fingerprint(Arrays.concatenate(publicPoint.getEncoded(false), curve.getA().getEncoded(), curve.getB().getEncoded(), g.getEncoded(false))).toString();
        }
        return new Fingerprint(publicPoint.getEncoded(false)).toString();
    }

    public static int getOrderBitLength(BigInteger order, BigInteger privateValue) {
        if (order == null) {
            ECParameterSpec implicitCA = SwxaProvider.CONFIGURATION.getEcImplicitlyCa();
            if (implicitCA == null) {
                return privateValue.bitLength();
            }
            return implicitCA.getN().bitLength();
        }
        return order.bitLength();
    }

    public static ASN1ObjectIdentifier getNamedCurveOid(String curveName) {
        String name = curveName.indexOf(32) > 0 ? curveName.substring(curveName.indexOf(32) + 1) : curveName;
        try {
            if (name.charAt(0) >= '0' && name.charAt(0) <= '2') {
                return new ASN1ObjectIdentifier(name);
            }
            return ECUtil.lookupOidByName(name);
        }
        catch (IllegalArgumentException ex) {
            return ECUtil.lookupOidByName(name);
        }
    }

    private static ASN1ObjectIdentifier lookupOidByName(String name) {
        ASN1ObjectIdentifier oid = X962NamedCurves.getOID(name);
        if (oid == null) {
            oid = SECNamedCurves.getOID(name);
            if (oid == null) {
                oid = NISTNamedCurves.getOID(name);
            }
            if (oid == null) {
                oid = TeleTrusTNamedCurves.getOID(name);
            }
            if (oid == null) {
                oid = ECGOST3410NamedCurves.getOID(name);
            }
            if (oid == null) {
                oid = ANSSINamedCurves.getOID(name);
            }
        }
        return oid;
    }

    public static ASN1ObjectIdentifier getNamedCurveOid(ECParameterSpec ecParameterSpec) {
        Enumeration names = ECNamedCurveTable.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            X9ECParameters params = ECNamedCurveTable.getByName(name);
            if (!params.getN().equals(ecParameterSpec.getN()) || !params.getH().equals(ecParameterSpec.getH()) || !params.getCurve().equals(ecParameterSpec.getCurve()) || !params.getG().equals(ecParameterSpec.getG())) continue;
            return ECNamedCurveTable.getOID(name);
        }
        return null;
    }

    public static X9ECParameters getNamedCurveByOid(ASN1ObjectIdentifier oid) {
        X9ECParameters params = CustomNamedCurves.getByOID(oid);
        if (params == null) {
            params = X962NamedCurves.getByOID(oid);
            if (params == null) {
                params = SECNamedCurves.getByOID(oid);
            }
            if (params == null) {
                params = NISTNamedCurves.getByOID(oid);
            }
            if (params == null) {
                params = TeleTrusTNamedCurves.getByOID(oid);
            }
        }
        return params;
    }

    public static X9ECParameters getNamedCurveByName(String curveName) {
        X9ECParameters params = CustomNamedCurves.getByName(curveName);
        if (params == null) {
            params = X962NamedCurves.getByName(curveName);
            if (params == null) {
                params = SECNamedCurves.getByName(curveName);
            }
            if (params == null) {
                params = NISTNamedCurves.getByName(curveName);
            }
            if (params == null) {
                params = TeleTrusTNamedCurves.getByName(curveName);
            }
        }
        return params;
    }

    public static String getCurveName(ASN1ObjectIdentifier oid) {
        String name = X962NamedCurves.getName(oid);
        if (name == null) {
            name = SECNamedCurves.getName(oid);
            if (name == null) {
                name = NISTNamedCurves.getName(oid);
            }
            if (name == null) {
                name = TeleTrusTNamedCurves.getName(oid);
            }
            if (name == null) {
                name = ECGOST3410NamedCurves.getName(oid);
            }
        }
        return name;
    }

    public static String getNameFrom(final AlgorithmParameterSpec paramSpec) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method m = paramSpec.getClass().getMethod("getName", new Class[0]);
                    return m.invoke((Object)paramSpec, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }
}

