/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.digest;

import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.crypto.CipherKeyGenerator;
import com.sansec.crypto.digests.MD4Digest;
import com.sansec.crypto.macs.HMac;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.digest.DigestAlgorithmProvider;
import com.sansec.jcajce.provider.digest.JCEMessageDigest;
import com.sansec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.sansec.jcajce.provider.symmetric.util.BaseMac;

public class MD4 {
    private MD4() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD4.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD4", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
            this.addHMACAlgorithm(provider, "MD4", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class Digest
    extends JCEMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD4Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD4Digest((MD4Digest)this.digest);
            return d;
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD4", 128, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD4Digest()));
        }
    }
}

