/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.digest;

import com.sansec.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.sansec.crypto.CipherKeyGenerator;
import com.sansec.crypto.digests.RIPEMD256Digest;
import com.sansec.crypto.macs.HMac;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.digest.DigestAlgorithmProvider;
import com.sansec.jcajce.provider.digest.JCEMessageDigest;
import com.sansec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.sansec.jcajce.provider.symmetric.util.BaseMac;

public class RIPEMD256 {
    private RIPEMD256() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD256.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.RIPEMD256", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd256, "RIPEMD256");
            this.addHMACAlgorithm(provider, "RIPEMD256", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD256", 256, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new RIPEMD256Digest()));
        }
    }

    public static class Digest
    extends JCEMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD256Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new RIPEMD256Digest((RIPEMD256Digest)this.digest);
            return d;
        }
    }
}

