/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.keystore.jks;

import com.sansec.jcajce.provider.keystore.jks.AlgorithmId;
import com.sansec.jcajce.provider.keystore.jks.ECParameters;
import com.sansec.jcajce.provider.keystore.jks.X509Key;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPublicKeyImpl
extends X509Key
implements ECPublicKey {
    private static final long serialVersionUID = -2462037275160462289L;
    private ECPoint w;
    private ECParameterSpec params;

    public ECPublicKeyImpl(ECPoint w, ECParameterSpec params) throws InvalidKeyException {
        this.w = w;
        this.params = params;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(params));
        this.key = ECParameters.encodePoint(w, params.getCurve());
    }

    public ECPublicKeyImpl(byte[] encoded) throws InvalidKeyException {
        this.decode(encoded);
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public byte[] getEncodedPublicValue() {
        return (byte[])this.key.clone();
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            AlgorithmParameters algParams = this.algid.getParameters();
            this.params = algParams.getParameterSpec(ECParameterSpec.class);
            this.w = ECParameters.decodePoint(this.key, this.params.getCurve());
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid EC key", e);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidKeyException("Invalid EC key", e);
        }
    }

    @Override
    public String toString() {
        return "Sun EC public key, " + this.params.getCurve().getField().getFieldSize() + " bits\n  public x coord: " + this.w.getAffineX() + "\n  public y coord: " + this.w.getAffineY() + "\n  parameters: " + this.params;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }
}

