/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.keystore.label;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.jcajce.provider.asymmetric.rsa.SwJCERSAPrivateCrtKey;
import com.sansec.jcajce.provider.asymmetric.rsa.SwJCERSAPublicKey;
import com.sansec.jcajce.provider.symmetric.HsmSecretKeySpec;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.KeyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;

public class SwLabelKeyStore
extends KeyStoreSpi {
    private ISDSCrypto device = null;

    public SwLabelKeyStore() {
        try {
            this.device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return new Certificate[0];
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    @Override
    public Enumeration<String> engineAliases() {
        return null;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return false;
    }

    @Override
    public int engineSize() {
        return 0;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public synchronized void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (alias == null || "".equals(alias)) {
            throw new RuntimeCryptoException("alias is null or blank space.");
        }
        if (!(entry instanceof RSAKeyPairEntry) && !(entry instanceof SecretKeyEntry)) {
            throw new RuntimeCryptoException("Entry should be RSAKeyPairEntry or SecretKeyEntry");
        }
        if (alias.startsWith("RSA_")) {
            String keyLabel = alias.substring(4);
            if (!this.checkLabel(keyLabel)) {
                throw new RuntimeCryptoException("label is error.3-31 alphabetic or numeric.");
            }
            if (!(entry instanceof RSAKeyPairEntry)) {
                throw new RuntimeCryptoException("Entry should be RSAKeyPairEntry ");
            }
            RSAKeyPairEntry rsaKeyPairEntry = (RSAKeyPairEntry)entry;
            PublicKey publicKey = rsaKeyPairEntry.getPubKey();
            PrivateKey privateKey = rsaKeyPairEntry.getPrivKey();
            IRSArefPublicKey refPublicKey = null;
            IRSArefPrivateKey refPrivateKey = null;
            if (privateKey == null && publicKey == null) {
                throw new RuntimeCryptoException("PublicKey and PrivateKey of RSAKeyPairEntry cannt  both be null.");
            }
            if (publicKey != null) {
                refPublicKey = KeyUtil.transRSAPubKeyDER2GM(publicKey.getEncoded());
            }
            if (privateKey != null) {
                refPrivateKey = KeyUtil.transRSAPriKeyDER2GM(privateKey.getEncoded());
            }
            try {
                this.device.rsaImportKeyPair(keyLabel, refPublicKey, refPrivateKey);
            }
            catch (CryptoException e) {
                throw new RuntimeCryptoException("RSA key pair import error" + e.getMessage());
            }
        } else if (alias.startsWith("SYM_")) {
            String keyLabel = alias.substring(4);
            if (!this.checkLabel(keyLabel)) {
                throw new RuntimeCryptoException("label is error.3-31 alphabetic or numeric.");
            }
            if (!(entry instanceof SecretKeyEntry)) {
                throw new RuntimeCryptoException("Entry should be SecretKeyEntry");
            }
            SecretKeyEntry secretKeyEntry = (SecretKeyEntry)entry;
            SecretKey secretKey = secretKeyEntry.getSecretKey();
            if (secretKey == null) {
                throw new RuntimeCryptoException("SecretKey of SecretKeyEntry cannt be null.");
            }
            try {
                this.device.importKey(keyLabel, secretKey.getEncoded());
            }
            catch (CryptoException e) {
                throw new RuntimeCryptoException("Secret key pair import error" + e.getMessage());
            }
        } else {
            throw new RuntimeCryptoException("alias is not start with 'RSA_' or 'SYM_'");
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (alias == null || "".equals(alias)) {
            throw new RuntimeCryptoException("alias is null or blank space.");
        }
        if (alias.startsWith("RSA_")) {
            String label = alias.substring(4);
            if (!this.checkLabel(label)) {
                throw new RuntimeCryptoException("label is error.3-31 alphabetic or numeric.");
            }
            try {
                this.device.rsaDeleteKeyPair(label);
            }
            catch (CryptoException e) {
                throw new RuntimeCryptoException("Delete internal label RSA key pair error", e);
            }
        } else if (alias.startsWith("SYM_")) {
            String label = alias.substring(4);
            if (!this.checkLabel(label)) {
                throw new RuntimeCryptoException("label is error.3-31 alphabetic or numeric.");
            }
            try {
                this.device.deleteKey(label);
            }
            catch (CryptoException e) {
                throw new RuntimeCryptoException("Delete internal label key error", e);
            }
        } else {
            throw new RuntimeCryptoException("alias is not start with 'RSA_' or 'SYM_'");
        }
    }

    @Override
    public synchronized KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) {
        KeyStore.Entry entry = null;
        if (alias == null || "".equals(alias)) {
            throw new RuntimeCryptoException("alias is null or blank space.");
        }
        if (alias.startsWith("RSA_")) {
            IRSArefPublicKey publicKey;
            String label = alias.substring(4);
            if (!this.checkLabel(label)) {
                throw new RuntimeCryptoException("label is error.3-31 alphabetic or numeric.");
            }
            BigInteger e = null;
            BigInteger n = null;
            try {
                publicKey = this.device.getRSAPublicKey(label);
                e = BigIntegerUitl.toPositiveInteger(publicKey.getE());
                n = BigIntegerUitl.toPositiveInteger(publicKey.getM());
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Get internal RSA public key error", ex);
            }
            BigInteger d = new BigInteger("0");
            byte[] p1Value = new byte[]{102, 102, 51, 53, 54, 51, 54, 53, 52, 99, 102, 51, 56, 54, 51, 48, 51, 98, 102, 57, 57, 50, 101, 51, 54, 100, 50, 52, 55, 99, 52, 50, 54, 97, 52, 57, 53, 56, 50, 98, 99, 101, 49, 49, 55, 54, 101, 102, 48, 49, 52, 49, 101, 48, 55, 99, 97, 53, 99, 101, 98, 101, 51, 54, 102, 49, 98, 102, 100, 49, 55, 49, 54, 56, 100, 57, 51, 98, 101, 98, 101, 52, 102, 55, 57, 51, 102, 49, 51, 56, 52, 50, 54, 102, 50, 53, 50, 55, 49, 49, 49, 49, 98, 98, 98, 100, 101, 52, 49, 98, 50, 54, 97, 101, 53, 98, 48, 101, 48, 56, 97, 100, 51, 52, 101, 50, 57, 100};
            byte[] p2Value = new byte[]{50, 101, 102, 99, 51, 101, 100, 101, 102, 53, 56, 101, 52, 50, 55, 54, 51, 52, 54, 53, 55, 56, 54, 97, 52, 50, 52, 57, 99, 57, 101, 100, 55, 52, 101, 100, 102, 55, 49, 50, 49, 99, 98, 55, 54, 49, 57, 56, 99, 56, 52, 48, 102, 53, 99, 52, 55, 102, 54, 48, 99, 101, 53, 101, 52, 50, 48, 101, 102, 49, 97, 57, 57, 101, 54, 99, 97, 53, 101, 97, 97, 54, 52, 51, 48, 53, 57, 100, 101, 99, 51, 50, 100, 98, 50, 51, 49, 50, 50, 53, 101, 53, 56, 97, 97, 102, 101, 97, 97, 102, 48, 48, 57, 55, 50, 100, 100, 98, 98, 101, 101, 48, 55, 57, 57, 101, 100, 57};
            byte[] q1Value = new byte[]{53, 54, 55, 55, 55, 48, 98, 51, 49, 102, 51, 99, 97, 53, 52, 52, 57, 56, 99, 101, 48, 101, 52, 102, 49, 53, 48, 97, 57, 55, 98, 50, 102, 53, 49, 101, 99, 54, 53, 101, 50, 99, 57, 49, 52, 48, 102, 98, 57, 48, 51, 50, 100, 102, 97, 48, 102, 49, 52, 50, 50, 51, 57, 54, 53, 100, 51, 52, 57, 57, 51, 100, 102, 99, 99, 99, 100, 101, 101, 52, 101, 98, 50, 101, 97, 97, 52, 54, 54, 52, 55, 101, 49, 97, 48, 100, 100, 55, 54, 57, 100, 54, 50, 56, 50, 100, 52, 54, 100, 102, 102, 48, 52, 99, 97, 52, 99, 97, 99, 52, 56, 50, 101, 102, 102, 101, 55, 49};
            byte[] q2Value = new byte[]{50, 97, 53, 54, 49, 57, 49, 98, 57, 57, 52, 100, 97, 99, 98, 56, 97, 50, 55, 53, 99, 50, 101, 53, 57, 52, 100, 49, 52, 102, 49, 99, 100, 97, 53, 101, 51, 57, 53, 53, 51, 50, 52, 102, 50, 100, 56, 102, 99, 100, 99, 97, 55, 97, 98, 53, 100, 48, 57, 51, 49, 48, 56, 57, 54, 49, 101, 55, 102, 98, 101, 51, 48, 52, 101, 52, 52, 101, 98, 56, 102, 56, 51, 56, 98, 50, 52, 55, 102, 51, 55, 97, 97, 102, 54, 102, 51, 52, 51, 49, 54, 57, 57, 55, 52, 101, 54, 97, 56, 98, 49, 50, 55, 55, 98, 54, 98, 51, 56, 54, 55, 102, 50, 55, 52, 52, 100, 57};
            byte[] coefValue = new byte[]{55, 53, 48, 54, 48, 50, 51, 52, 49, 53, 49, 57, 101, 98, 55, 55, 101, 52, 51, 49, 49, 99, 57, 101, 57, 49, 97, 51, 49, 99, 53, 54, 55, 55, 100, 51, 98, 54, 101, 56, 56, 100, 56, 98, 101, 53, 57, 52, 52, 51, 54, 98, 49, 49, 48, 53, 55, 51, 97, 102, 99, 56, 97, 53, 101, 52, 101, 52, 57, 53, 55, 52, 57, 53, 97, 100, 56, 56, 54, 50, 52, 57, 53, 56, 102, 102, 55, 51, 50, 102, 57, 55, 102, 48, 100, 55, 49, 97, 51, 55, 99, 100, 54, 52, 97, 98, 98, 102, 50, 54, 48, 102, 102, 57, 57, 48, 55, 97, 48, 99, 54, 56, 99, 48, 50, 55, 102, 52};
            BigInteger p1 = new BigInteger(p1Value);
            BigInteger p2 = new BigInteger(p2Value);
            BigInteger q1 = new BigInteger(q1Value);
            BigInteger q2 = new BigInteger(q2Value);
            BigInteger coef = new BigInteger(coefValue);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(new RSAKeyParameters(0, label, 0, publicKey.getBits(), false, n, e), new RSAPrivateCrtKeyParameters(0, label, 0, publicKey.getBits(), n, e, d, p1, p2, q1, q2, coef));
            RSAKeyParameters pub = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
            SwJCERSAPublicKey swJCERSAPublicKey = new SwJCERSAPublicKey(pub);
            SwJCERSAPrivateCrtKey swJCERSAPrivateCrtKey = new SwJCERSAPrivateCrtKey(priv);
            entry = new RSAKeyPairEntry(swJCERSAPublicKey, swJCERSAPrivateCrtKey);
        } else if (alias.startsWith("SYM_")) {
            String keyLabel = alias.substring(4);
            if (!this.checkLabel(keyLabel)) {
                throw new RuntimeCryptoException("label is error.3-31 alphabetic or numeric.");
            }
            byte[] key = new byte[16];
            entry = new SecretKeyEntry(new HsmSecretKeySpec(keyLabel, key, "swxaLabel"));
        } else {
            throw new RuntimeCryptoException("alias is not start with 'RSA_' or 'SYM_'");
        }
        return entry;
    }

    private boolean checkLabel(String label) {
        boolean flag = label.matches("^[a-zA-Z0-9_$]+$");
        if (label.length() >= 32 || label.length() <= 2) {
            flag = false;
        }
        return flag;
    }

    public static final class SecretKeyEntry
    implements KeyStore.Entry {
        private final SecretKey sKey;

        public SecretKeyEntry(SecretKey secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("invalid null input");
            }
            this.sKey = secretKey;
            String alg = this.sKey.getAlgorithm();
            int keyLen = this.sKey.getEncoded().length;
            if (alg.equalsIgnoreCase("SM4") || alg.equalsIgnoreCase("SM1")) {
                if (keyLen != 16) {
                    throw new RuntimeCryptoException("invalid key input,alg=" + alg + " keyLen = " + keyLen);
                }
            } else if (alg.equalsIgnoreCase("3DES") || alg.equalsIgnoreCase("DESede")) {
                if (keyLen != 16 && keyLen != 24) {
                    throw new RuntimeCryptoException("invalid key input,alg=" + alg + " keyLen = " + keyLen);
                }
            } else if (alg.equalsIgnoreCase("AES")) {
                if (keyLen != 16 && keyLen != 24 && keyLen != 32) {
                    throw new RuntimeCryptoException("invalid key input,alg=" + alg + " keyLen = " + keyLen);
                }
            } else if (!alg.equalsIgnoreCase("swxaLabel")) {
                throw new RuntimeCryptoException("invalid alg ,alg=" + alg);
            }
        }

        public SecretKey getSecretKey() {
            return this.sKey;
        }

        public String toString() {
            return "Swxa label Secret key entry with label " + ((HsmSecretKeySpec)this.sKey).getKeyLabel();
        }
    }

    public static final class RSAKeyPairEntry
    implements KeyStore.Entry {
        private final PrivateKey privKey;
        private final PublicKey pubKey;

        public RSAKeyPairEntry(PublicKey publicKey, PrivateKey privateKey) {
            if (publicKey == null) {
                throw new NullPointerException("invalid null input,publicKey can not be null.");
            }
            this.pubKey = publicKey;
            this.privKey = privateKey;
        }

        public PrivateKey getPrivKey() {
            return this.privKey;
        }

        public PublicKey getPubKey() {
            return this.pubKey;
        }

        public String toString() {
            return "Swxa label RSA key pair.";
        }
    }
}

