/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.symmetric;

import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.crypto.BlockCipher;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.DESedeEngine;
import com.sansec.crypto.engines.HsmNoneEngine;
import com.sansec.crypto.modes.CBCBlockCipher;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.symmetric.HsmSecretKeySpec;
import com.sansec.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import com.sansec.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.sansec.util.Strings;
import com.sansec.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class HsmBlockCipher
extends BaseBlockCipher {
    private static final Class gcmSpecClass = HsmBlockCipher.lookup("javax.crypto.spec.GCMParameterSpec");
    private int blockSize;
    private int ivBlockSize;
    private byte[] key = null;
    private int keyIndex = 0;
    private String keyLabel = null;
    private String padd = "PKCS5Padding";
    private String mode = "ECB";
    private int opmode;
    private byte[] iv = null;
    private byte[] ivRemain = null;
    private int macSize = 0;
    private AlgorithmParameters ivParameters = null;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private ByteArrayOutputStream assoBuffer = new ByteArrayOutputStream();
    private String algName;
    private BlockCipher blockCipher = null;

    public HsmBlockCipher(BlockCipher blockCipher, String algName, int blockSize) {
        super(blockCipher);
        this.blockCipher = blockCipher;
        this.algName = algName;
        this.blockSize = blockSize;
        this.ivBlockSize = blockSize;
        this.iv = new byte[blockSize];
    }

    public HsmBlockCipher(BlockCipher blockCipher, String algName, int blockSize, String padd, String mode) {
        this(blockCipher, algName, blockSize);
        this.padd = padd;
        this.mode = mode;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] buf = new byte[this.engineGetOutputSize(inputLen)];
        try {
            int len = this.engineDoFinal(input, inputOffset, inputLen, buf, 0);
            byte[] out = new byte[len];
            System.arraycopy(buf, 0, out, 0, len);
            return out;
        }
        catch (ShortBufferException e) {
            return null;
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.buf.write(input, inputOffset, inputLen);
        }
        if (this.buf.size() == 0) {
            throw new BadPaddingException("the cipher data size is 0");
        }
        byte[] out = this.process(true);
        System.arraycopy(out, 0, output, outputOffset, out.length);
        if (this.iv.length > 0) {
            System.arraycopy(this.ivRemain, 0, this.iv, 0, this.iv.length);
        }
        return out.length;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (this.opmode == 1) {
            if (this.mode.equalsIgnoreCase("GCM")) {
                return this.buf.size() + inputLen + this.macSize;
            }
            if (this.padd.equalsIgnoreCase("NoPadding")) {
                return this.buf.size() + inputLen;
            }
            return ((this.buf.size() + inputLen) / this.blockSize + 1) * this.blockSize;
        }
        if (this.opmode == 2) {
            if (this.padd.equalsIgnoreCase("NoPadding")) {
                return this.buf.size() + inputLen;
            }
            return this.buf.size() + inputLen;
        }
        return this.buf.size() + inputLen + this.blockSize;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.ivParameters;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameters)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
    }

    protected void resetKey() {
        this.keyLabel = null;
        this.keyIndex = 0;
        this.key = null;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.resetKey();
        if (key == null) {
            throw new InvalidKeyException("Key is null.");
        }
        if (key instanceof HsmSecretKeySpec) {
            HsmSecretKeySpec sw = (HsmSecretKeySpec)key;
            if (sw.getKeyIndex() != 0) {
                this.keyIndex = sw.getKeyIndex();
            } else if (sw.getKeyLabel() != null) {
                this.keyLabel = sw.getKeyLabel();
            } else {
                this.key = key.getEncoded();
            }
        } else if (key.getEncoded().length % 8 == 0) {
            this.key = key.getEncoded();
        } else {
            throw new InvalidKeyException("key size invalid; key: " + Hex.toHexString(key.getEncoded()));
        }
        if (params != null && params instanceof IvParameterSpec) {
            this.iv = ((IvParameterSpec)params).getIV();
        } else {
            Arrays.fill(this.iv, (byte)0);
        }
        if (this.iv.length != this.ivBlockSize && !this.mode.equalsIgnoreCase("GCM")) {
            throw new InvalidAlgorithmParameterException("IV size is not blockSize");
        }
        if (this.iv.length > 0) {
            this.ivRemain = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, this.ivRemain, 0, this.iv.length);
        }
        if (this.mode.equalsIgnoreCase("GCM")) {
            if (gcmSpecClass != null && gcmSpecClass.isInstance(params)) {
                try {
                    Method tLen = gcmSpecClass.getDeclaredMethod("getTLen", new Class[0]);
                    Method iv = gcmSpecClass.getDeclaredMethod("getIV", new Class[0]);
                    int macSizeBits = (Integer)tLen.invoke((Object)params, new Object[0]);
                    if (macSizeBits < 32 || macSizeBits > 128 || macSizeBits % 8 != 0) {
                        throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
                    }
                    this.macSize = macSizeBits / 8;
                    this.iv = (byte[])iv.invoke((Object)params, new Object[0]);
                }
                catch (Exception e) {
                    throw new InvalidAlgorithmParameterException("Error: HsmBlockCipher...engineInit...Cannot process GCMParameterSpec.");
                }
            } else if (params instanceof IvParameterSpec) {
                IvParameterSpec param = (IvParameterSpec)params;
                this.iv = param.getIV();
                this.macSize = 16;
            } else {
                throw new IllegalArgumentException("invalid parameters passed to GCM");
            }
            if (this.iv == null || this.iv.length < 1) {
                throw new IllegalArgumentException("IV must be at least 1 byte");
            }
        } else if (params != null && params instanceof IvParameterSpec) {
            this.iv = ((IvParameterSpec)params).getIV();
        } else {
            Arrays.fill(this.iv, (byte)0);
        }
        this.buf.reset();
        this.assoBuffer.reset();
        this.opmode = opmode;
        if (this.padd.equals("NoPadding") && (opmode == 3 || opmode == 4)) {
            this.padd = "PKCS7Padding";
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(IvParameterSpec.class);
                this.ivParameters = params;
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameters get IvParameterSpec error:" + e.getMessage());
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeName = Strings.toUpperCase(mode);
        if (modeName.equalsIgnoreCase("ECB")) {
            this.mode = "ECB";
        } else if (modeName.equalsIgnoreCase("CBC")) {
            this.mode = "CBC";
        } else if (modeName.equalsIgnoreCase("CTR")) {
            this.mode = "CTR";
        } else if (modeName.equalsIgnoreCase("GCM")) {
            this.mode = "GCM";
        } else if (modeName.equalsIgnoreCase("CFB")) {
            this.mode = "CFB";
        } else if (modeName.equalsIgnoreCase("OFB")) {
            this.mode = "OFB";
        } else {
            throw new NoSuchAlgorithmException("can't support mode " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        if (paddingName.equalsIgnoreCase("NOPADDING")) {
            this.padd = "NoPadding";
        } else if (paddingName.equalsIgnoreCase("PKCS5PADDING")) {
            this.padd = "PKCS5Padding";
        } else if (paddingName.equalsIgnoreCase("PKCS7PADDING")) {
            this.padd = "PKCS7Padding";
        } else {
            throw new NoSuchPaddingException("Padding " + padding + " unknown.");
        }
        if (!paddingName.equals("NOPADDING") && "GCM".equals(this.mode)) {
            throw new NoSuchPaddingException("Only NoPadding can be used with GCM modes.");
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] input, int offset, int length) {
        this.assoBuffer.write(input, offset, length);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer bytebuffer) {
        super.engineUpdateAAD(bytebuffer);
        int offset = bytebuffer.arrayOffset() + bytebuffer.position();
        int length = bytebuffer.limit() - bytebuffer.position();
        this.engineUpdateAAD(bytebuffer.array(), offset, length);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.buf.write(input, inputOffset, inputLen);
        try {
            return this.process(false);
        }
        catch (BadPaddingException e) {
            throw new RuntimeCryptoException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeCryptoException(e);
        }
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int bLen = 0;
        byte[] b = this.engineUpdate(input, inputOffset, inputLen);
        if (b != null) {
            bLen = b.length;
            System.arraycopy(b, 0, output, outputOffset, bLen);
        }
        return bLen;
    }

    private byte[] padding(byte[] input) throws IllegalBlockSizeException {
        int inputLen = input.length;
        byte[] outputData = null;
        if (("PKCS5Padding".equalsIgnoreCase(this.padd) || "PKCS7Padding".equalsIgnoreCase(this.padd)) && (this.opmode == 1 || this.opmode == 3)) {
            int padData = (inputLen / this.blockSize + 1) * this.blockSize - inputLen;
            outputData = new byte[inputLen + padData];
            for (int i = inputLen; i < outputData.length; ++i) {
                outputData[i] = (byte)padData;
            }
            System.arraycopy(input, 0, outputData, 0, inputLen);
            input = null;
        } else {
            if (inputLen % this.blockSize != 0) {
                throw new IllegalBlockSizeException("Data length [" + inputLen + "] Block length[" + this.blockSize + "]");
            }
            outputData = input;
        }
        return outputData;
    }

    private byte[] Unpadding(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
        int inputLen = input.length;
        byte[] output = null;
        int outputLen = 0;
        if (("PKCS5Padding".equalsIgnoreCase(this.padd) || "PKCS7Padding".equalsIgnoreCase(this.padd)) && (this.opmode == 2 || this.opmode == 4)) {
            if (inputLen % this.blockSize != 0) {
                throw new IllegalBlockSizeException("Data length[" + inputLen + "]Block length[" + this.blockSize + "]");
            }
            byte padData = input[inputLen - 1];
            if (padData > this.blockSize || padData < 0) {
                throw new BadPaddingException("Wrong padding format, the last one [" + padData + "]Block length[" + this.blockSize + "]");
            }
            outputLen = inputLen - padData;
        } else {
            outputLen = inputLen;
        }
        output = new byte[outputLen];
        System.arraycopy(input, 0, output, 0, outputLen);
        Arrays.fill(input, (byte)0);
        input = null;
        return output;
    }

    private int getAlgId() {
        int algId = 0;
        if ("ECB".equalsIgnoreCase(this.mode)) {
            if ("3DES".equalsIgnoreCase(this.algName)) {
                algId = 2049;
            } else if ("AES".equalsIgnoreCase(this.algName)) {
                algId = 1025;
            } else if ("SM1".equalsIgnoreCase(this.algName)) {
                algId = 257;
            } else if ("SM4".equalsIgnoreCase(this.algName)) {
                algId = 8193;
            } else if ("SSF33".equalsIgnoreCase(this.algName)) {
                algId = 513;
            } else if ("SM7".equalsIgnoreCase(this.algName)) {
                algId = 32769;
            }
        } else if ("CBC".equalsIgnoreCase(this.mode)) {
            if ("3DES".equalsIgnoreCase(this.algName)) {
                algId = 2050;
            } else if ("AES".equalsIgnoreCase(this.algName)) {
                algId = 1026;
            } else if ("SM1".equalsIgnoreCase(this.algName)) {
                algId = 258;
            } else if ("SM4".equalsIgnoreCase(this.algName)) {
                algId = 8194;
            } else if ("SSF33".equalsIgnoreCase(this.algName)) {
                algId = 514;
            } else if ("SM7".equalsIgnoreCase(this.algName)) {
                algId = 32770;
            }
        } else if ("CFB".equalsIgnoreCase(this.mode)) {
            if ("3DES".equalsIgnoreCase(this.algName)) {
                algId = 2052;
            } else if ("AES".equalsIgnoreCase(this.algName)) {
                algId = 1028;
            } else if ("SM7".equalsIgnoreCase(this.algName)) {
                algId = 32772;
            }
        } else if ("OFB".equalsIgnoreCase(this.mode)) {
            if ("3DES".equalsIgnoreCase(this.algName)) {
                algId = 2056;
            } else if ("AES".equalsIgnoreCase(this.algName)) {
                algId = 1032;
            } else if ("SM7".equalsIgnoreCase(this.algName)) {
                algId = 32776;
            }
        } else if ("CTR".equalsIgnoreCase(this.mode)) {
            if ("SM1".equalsIgnoreCase(this.algName)) {
                algId = 288;
            } else if ("SM4".equalsIgnoreCase(this.algName)) {
                algId = 8224;
            } else if ("AES".equalsIgnoreCase(this.algName)) {
                algId = 1056;
            } else if ("SM7".equalsIgnoreCase(this.algName)) {
                algId = 32800;
            }
        } else if ("GCM".equalsIgnoreCase(this.mode)) {
            if ("AES".equalsIgnoreCase(this.algName)) {
                algId = 1088;
            } else if ("SM4".equalsIgnoreCase(this.algName)) {
                algId = 8256;
            }
        } else if ("CCM".equalsIgnoreCase(this.mode) && "SM4".equalsIgnoreCase(this.algName)) {
            algId = 1184;
        }
        return algId;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] process(boolean isFinal) throws BadPaddingException, IllegalBlockSizeException {
        input = this.buf.toByteArray();
        algId = this.getAlgId();
        if (algId == 0) {
            throw new RuntimeCryptoException("Not support algName=" + this.algName);
        }
        if (algId == 1088 || algId == 1184 || algId == 8256) {
            if (!isFinal) {
                return null;
            }
            addBuf = this.assoBuffer.toByteArray();
            crypto = null;
            try {
                crypto = SwxaDeviceFactory.getInstance();
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e.getMessage());
            }
            out = null;
            if (this.opmode == 1 || this.opmode == 3) {
                try {
                    if (this.keyIndex != 0) {
                        out = crypto.encrypt_add(algId, this.keyIndex, this.iv, input, addBuf);
                    }
                    if (this.keyLabel != null) {
                        out = crypto.encrypt_add(algId, this.keyLabel, this.iv, input, addBuf);
                    }
                    out = crypto.encrypt_add(algId, this.key, this.iv, input, addBuf);
                }
                catch (Exception ex) {
                    throw new RuntimeCryptoException(ex.getMessage());
                }
            } else if (this.opmode == 2 || this.opmode == 4) {
                try {
                    out = this.keyIndex != 0 ? crypto.decrypt_add(algId, this.keyIndex, this.iv, input, addBuf) : (this.keyLabel != null ? crypto.decrypt_add(algId, this.keyLabel, this.iv, input, addBuf) : crypto.decrypt_add(algId, this.key, this.iv, input, addBuf));
                }
                catch (Exception ex) {
                    throw new RuntimeCryptoException(ex.getMessage());
                }
            }
            this.assoBuffer.reset();
            this.buf.reset();
            return out;
        }
        if (isFinal) {
            if (this.opmode == 1 || this.opmode == 3) {
                input = this.padding(input);
            }
            this.buf.reset();
        } else if (this.padd.equalsIgnoreCase("NoPadding")) {
            if (input.length < this.blockSize) {
                return null;
            }
            tmpLen = (input.length / this.blockSize - 1) * this.blockSize;
            if (tmpLen == 0) {
                return null;
            }
            tmp = new byte[tmpLen];
            System.arraycopy(input, 0, tmp, 0, tmpLen);
            this.buf.reset();
            this.buf.write(input, tmpLen, input.length - tmpLen);
            input = tmp;
        } else {
            if (input.length <= this.blockSize * 2) {
                return null;
            }
            tmpLen = (input.length / this.blockSize - 1) * this.blockSize;
            tmp = new byte[tmpLen];
            System.arraycopy(input, 0, tmp, 0, tmpLen);
            this.buf.reset();
            this.buf.write(input, tmpLen, input.length - tmpLen);
            input = tmp;
        }
        crypto = null;
        try {
            crypto = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Error getting device instance of HSM", e);
        }
        out = null;
        if (this.opmode == 1 || this.opmode == 3) {
            try {
                out = this.keyIndex != 0 ? crypto.encrypt(algId, this.keyIndex, this.iv, input) : (this.keyLabel != null ? crypto.encrypt(algId, this.keyLabel, this.iv, input) : crypto.encrypt(algId, this.key, this.iv, input));
                if (!"CBC".equalsIgnoreCase(this.mode) && !"CFB".equalsIgnoreCase(this.mode) && !"OFB".equalsIgnoreCase(this.mode)) ** GOTO lbl85
                System.arraycopy(out, out.length - this.iv.length, this.iv, 0, this.iv.length);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Symmetric encryption error," + ex.getMessage());
            }
        } else if (this.opmode == 2 || this.opmode == 4) {
            try {
                out = this.keyIndex != 0 ? crypto.decrypt(algId, this.keyIndex, this.iv, input) : (this.keyLabel != null ? crypto.decrypt(algId, this.keyLabel, this.iv, input) : crypto.decrypt(algId, this.key, this.iv, input));
                if ("CBC".equalsIgnoreCase(this.mode) || "CFB".equalsIgnoreCase(this.mode) || "OFB".equalsIgnoreCase(this.mode)) {
                    System.arraycopy(input, input.length - this.iv.length, this.iv, 0, this.iv.length);
                }
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Symmetric encryption error, " + ex.getMessage());
            }
        }
lbl85:
        // 5 sources

        if (isFinal && (this.opmode == 2 || this.opmode == 4)) {
            out = this.Unpadding(out);
        }
        return out;
    }

    public int getIvBlockSize() {
        return this.ivBlockSize;
    }

    public void setIvBlockSize(int ivBlockSize) {
        this.ivBlockSize = ivBlockSize;
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = HsmBlockCipher.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithmHsm("Cipher.AES", PREFIX + "$AES");
            provider.addAlgorithmHsm("Cipher.AES128", PREFIX + "$AES");
            provider.addAlgorithmHsm("Cipher.AESCBC", PREFIX + "$AESCBC");
            provider.addAlgorithmHsm("Cipher.AESCFB", PREFIX + "$AESCFB");
            provider.addAlgorithmHsm("Cipher.AESOFB", PREFIX + "$AESOFB");
            provider.addAlgorithmHsm("Cipher.AESGCM", PREFIX + "$AESGCM");
            provider.addAlgorithmHsm("Cipher.AESCTR", PREFIX + "$AESCTR");
            provider.addAlgorithmHsm("Cipher", NISTObjectIdentifiers.id_aes128_ECB, PREFIX + "$AES");
            provider.addAlgorithmHsm("Cipher", NISTObjectIdentifiers.id_aes192_ECB, PREFIX + "$AES");
            provider.addAlgorithmHsm("Cipher", NISTObjectIdentifiers.id_aes256_ECB, PREFIX + "$AES");
            provider.addAlgorithmHsm("Cipher", NISTObjectIdentifiers.id_aes128_CBC, PREFIX + "$AESCBC");
            provider.addAlgorithmHsm("Cipher", NISTObjectIdentifiers.id_aes192_CBC, PREFIX + "$AESCBC");
            provider.addAlgorithmHsm("Cipher", NISTObjectIdentifiers.id_aes256_CBC, PREFIX + "$AESCBC");
            provider.addAlgorithmHsm("Cipher.SM1", PREFIX + "$SM1");
            provider.addAlgorithmHsm("Cipher", GBObjectIdentifiers.sm1, PREFIX + "$SM1");
            provider.addAlgorithmHsm("Cipher.SM1CBC", PREFIX + "$SM1CBC");
            provider.addAlgorithmHsm("Cipher.SM1CTR", PREFIX + "$SM1CTR");
            provider.addAlgorithmHsm("AlgorithmParameters.SM1", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameters$IVAlgorithmParameters");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameters." + GBObjectIdentifiers.sm1, "SM1");
            provider.addAlgorithmHsm("AlgorithmParameterGenerator.SM1", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameterGenerator$SM1");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameterGenerator." + GBObjectIdentifiers.sm1, "SM1");
            provider.addAlgorithmHsm("Cipher.SM4", PREFIX + "$SM4");
            provider.addAlgorithmHsm("Cipher", GBObjectIdentifiers.sm4, PREFIX + "$SM4");
            provider.addAlgorithmHsm("Cipher.SM4CBC", PREFIX + "$SM4CBC");
            provider.addAlgorithmHsm("Cipher.SM4CTR", PREFIX + "$SM4CTR");
            provider.addAlgorithmHsm("Cipher.SM4CCM", PREFIX + "$SM4CCM");
            provider.addAlgorithmHsm("Cipher.SM4GCM", PREFIX + "$SM4GCM");
            provider.addAlgorithmHsm("AlgorithmParameters.SM4", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameters$IVAlgorithmParameters");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameters." + GBObjectIdentifiers.sm4, "SM4");
            provider.addAlgorithmHsm("AlgorithmParameterGenerator.SM4", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameterGenerator$SM4");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameterGenerator." + GBObjectIdentifiers.sm4, "SM4");
            provider.addAlgorithmHsm("Cipher.SM7", PREFIX + "$SM7");
            provider.addAlgorithmHsm("Cipher", GBObjectIdentifiers.sm7, PREFIX + "$SM7");
            provider.addAlgorithmHsm("Cipher.SM7CBC", PREFIX + "$SM7CBC");
            provider.addAlgorithmHsm("Cipher.SM7CTR", PREFIX + "$SMCTR");
            provider.addAlgorithmHsm("AlgorithmParameters.SM7", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameters$IVAlgorithmParameters");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameters." + GBObjectIdentifiers.sm7, "SM7");
            provider.addAlgorithmHsm("AlgorithmParameterGenerator.SM7", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameterGenerator$SM7");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameterGenerator." + GBObjectIdentifiers.sm7, "SM7");
            provider.addAlgorithmHsm("Cipher.SSF33", PREFIX + "$SSF33");
            provider.addAlgorithmHsm("Alg.Alias.Cipher." + GBObjectIdentifiers.ssf33, "SSF33");
            provider.addAlgorithmHsm("Cipher.SSF33CBC", PREFIX + "$SSF33CBC");
            provider.addAlgorithmHsm("AlgorithmParameters.SSF33", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameters$IVAlgorithmParameters");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameters." + GBObjectIdentifiers.ssf33, "SSF33");
            provider.addAlgorithmHsm("AlgorithmParameterGenerator.SSF33", "com.sansec.jcajce.provider.symmetric.HsmAlgorithmParameterGenerator$SSF33");
            provider.addAlgorithmHsm("Alg.Alias.AlgorithmParameterGenerator." + GBObjectIdentifiers.ssf33, "SSF33");
            provider.addAlgorithmHsm("Cipher.DESEDE", PREFIX + "$DESede");
            provider.addAlgorithmHsm("Cipher.DESEDE3", PREFIX + "$DESede");
            provider.addAlgorithmHsm("Cipher.DES3", PREFIX + "$DESede");
            provider.addAlgorithmHsm("Cipher.3DES", PREFIX + "$DESede");
            provider.addAlgorithmHsm("Cipher." + PKCSObjectIdentifiers.des_EDE3_CBC, PREFIX + "$DESedeCBC");
            provider.addAlgorithmHsm("Cipher.3DES/CBC/", PREFIX + "$DESedeCBC");
            provider.addAlgorithmHsm("Cipher.3DESCBC", PREFIX + "$DESedeCBC");
            provider.addAlgorithmHsm("Cipher.3DESCFB", PREFIX + "$DESedeCFB");
            provider.addAlgorithmHsm("Cipher.3DESOFB", PREFIX + "$DESedeOFB");
            provider.addAlgorithmHsm("Cipher.DESede/CBC/", PREFIX + "$DESedeCBC");
            provider.addAlgorithmHsm("Cipher.DESedeCBC", PREFIX + "$DESedeCBC");
            provider.addAlgorithmHsm("Cipher.DESedeCFB", PREFIX + "$DESedeCFB");
            provider.addAlgorithmHsm("Cipher.DESedeOFB", PREFIX + "$DESedeOFB");
            provider.addAlgorithmHsm("Cipher.DESEDE/CBC/", PREFIX + "$DESedeCBC");
            provider.addAlgorithmHsm("Cipher.DESEDECBC", PREFIX + "$DESedeCBC");
            provider.addAlgorithmHsm("Cipher.DESEDECFB", PREFIX + "$DESedeCFB");
            provider.addAlgorithmHsm("Cipher.DESEDEOFB", PREFIX + "$DESedeOFB");
        }
    }

    public static class SM7CTR
    extends HsmBlockCipher {
        public SM7CTR() {
            super((BlockCipher)new HsmNoneEngine(), "SM7", 1, "NoPadding", "CTR");
            this.setIvBlockSize(16);
        }
    }

    public static class SM4CCM
    extends HsmBlockCipher {
        public SM4CCM() {
            super((BlockCipher)new HsmNoneEngine(), "SM4", 16, "PKCS5Padding", "CCM");
            this.setIvBlockSize(16);
        }
    }

    public static class SM4CTR
    extends HsmBlockCipher {
        public SM4CTR() {
            super((BlockCipher)new HsmNoneEngine(), "SM4", 1, "NoPadding", "CTR");
            this.setIvBlockSize(16);
        }
    }

    public static class SM1CTR
    extends HsmBlockCipher {
        public SM1CTR() {
            super((BlockCipher)new HsmNoneEngine(), "SM1", 1, "NoPadding", "CTR");
            this.setIvBlockSize(16);
        }
    }

    public static class DESedeOFB
    extends HsmBlockCipher {
        public DESedeOFB() {
            super((BlockCipher)new CBCBlockCipher(new DESedeEngine()), "3DES", 8, "PKCS5Padding", "OFB");
        }
    }

    public static class DESedeCFB
    extends HsmBlockCipher {
        public DESedeCFB() {
            super((BlockCipher)new CBCBlockCipher(new DESedeEngine()), "3DES", 8, "PKCS5Padding", "CFB");
        }
    }

    public static class DESedeCBC
    extends HsmBlockCipher {
        public DESedeCBC() {
            super((BlockCipher)new CBCBlockCipher(new DESedeEngine()), "3DES", 8, "PKCS5Padding", "CBC");
        }
    }

    public static class AESCTR
    extends HsmBlockCipher {
        public AESCTR() {
            super((BlockCipher)new HsmNoneEngine(), "AES", 1, "NoPadding", "CTR");
            this.setIvBlockSize(16);
        }
    }

    public static class SM4GCM
    extends HsmBlockCipher {
        public SM4GCM() {
            super((BlockCipher)new HsmNoneEngine(), "SM4", 16, "PKCS5Padding", "GCM");
            this.setIvBlockSize(16);
        }
    }

    public static class AESGCM
    extends HsmBlockCipher {
        public AESGCM() {
            super((BlockCipher)new HsmNoneEngine(), "AES", 16, "PKCS5Padding", "GCM");
            this.setIvBlockSize(16);
        }
    }

    public static class AESOFB
    extends HsmBlockCipher {
        public AESOFB() {
            super((BlockCipher)new CBCBlockCipher(new HsmNoneEngine()), "AES", 16, "PKCS5Padding", "OFB");
        }
    }

    public static class AESCFB
    extends HsmBlockCipher {
        public AESCFB() {
            super((BlockCipher)new CBCBlockCipher(new HsmNoneEngine()), "AES", 16, "PKCS5Padding", "CFB");
        }
    }

    public static class AESCBC
    extends HsmBlockCipher {
        public AESCBC() {
            super((BlockCipher)new CBCBlockCipher(new HsmNoneEngine()), "AES", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class SSF33CBC
    extends HsmBlockCipher {
        public SSF33CBC() {
            super((BlockCipher)new HsmNoneEngine(), "SSF33", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class SM7CBC
    extends HsmBlockCipher {
        public SM7CBC() {
            super((BlockCipher)new HsmNoneEngine(), "SM7", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class SM4CBC
    extends HsmBlockCipher {
        public SM4CBC() {
            super((BlockCipher)new HsmNoneEngine(), "SM4", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class SM1CBC
    extends HsmBlockCipher {
        public SM1CBC() {
            super((BlockCipher)new HsmNoneEngine(), "SM1", 16, "PKCS5Padding", "CBC");
        }
    }

    public static class DESede
    extends HsmBlockCipher {
        public DESede() {
            super(new DESedeEngine(), "3DES", 8);
        }
    }

    public static class AES
    extends HsmBlockCipher {
        public AES() {
            super(new HsmNoneEngine(), "AES", 16);
        }
    }

    public static class SSF33
    extends HsmBlockCipher {
        public SSF33() {
            super(new HsmNoneEngine(), "SSF33", 16);
        }
    }

    public static class SM7
    extends HsmBlockCipher {
        public SM7() {
            super(new HsmNoneEngine(), "SM7", 16);
        }
    }

    public static class SM4
    extends HsmBlockCipher {
        public SM4() {
            super(new HsmNoneEngine(), "SM4", 16);
        }
    }

    public static class SM1
    extends HsmBlockCipher {
        public SM1() {
            super(new HsmNoneEngine(), "SM1", 16);
        }
    }
}

