/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.symmetric.util;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.Mac;
import com.sansec.crypto.macs.HsmMac;
import com.sansec.crypto.params.KeyParameter;
import com.sansec.crypto.params.ParametersWithIV;
import com.sansec.crypto.params.SkeinParameters;
import com.sansec.jcajce.PKCS12Key;
import com.sansec.jcajce.provider.symmetric.HsmSecretKeySpec;
import com.sansec.jcajce.provider.symmetric.util.JCEPBEKey;
import com.sansec.jcajce.provider.symmetric.util.PBE;
import com.sansec.jcajce.spec.SkeinParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class BaseMac
extends MacSpi
implements PBE {
    private Mac macEngine;
    private Mac hsmMacEngine;
    private int scheme = 2;
    private int pbeHash = 1;
    private int keySize = 160;

    protected BaseMac(Mac macEngine) {
        this.macEngine = macEngine;
    }

    protected BaseMac(Mac macEngine, int scheme, int pbeHash, int keySize) {
        this.macEngine = macEngine;
        this.scheme = scheme;
        this.pbeHash = pbeHash;
        this.keySize = keySize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        SecretKey k;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof HsmSecretKeySpec) {
            HsmSecretKeySpec spec = (HsmSecretKeySpec)key;
            if (spec.getKeyIndex() > 0 && params != null) {
                throw new InvalidAlgorithmParameterException("Internal mac does not support algorithmParameterSpec");
            }
            if (spec.getKeyIndex() > 0) {
                this.hsmMacEngine = new HsmMac(this.macEngine.getAlgorithmName(), spec);
                return;
            }
            if (spec.getKeyIndex() == 0) {
                this.hsmMacEngine = new HsmMac(this.macEngine.getAlgorithmName(), spec);
                return;
            }
        }
        if (key instanceof PKCS12Key) {
            PBEParameterSpec pbeSpec;
            try {
                k = (SecretKey)key;
            }
            catch (Exception e) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            try {
                pbeSpec = (PBEParameterSpec)params;
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("PKCS12 requires a PBEParameterSpec");
            }
            if (k instanceof PBEKey && pbeSpec == null) {
                pbeSpec = new PBEParameterSpec(((PBEKey)k).getSalt(), ((PBEKey)k).getIterationCount());
            }
            int digest = 1;
            int keySize = 160;
            if (this.macEngine.getAlgorithmName().startsWith("GOST")) {
                digest = 6;
                keySize = 256;
            } else if (this.macEngine.getAlgorithmName().startsWith("SHA256")) {
                digest = 4;
                keySize = 256;
            }
            param = PBE.Util.makePBEMacParameters(k, 2, digest, keySize, pbeSpec);
        } else if (key instanceof JCEPBEKey) {
            k = (JCEPBEKey)key;
            if (((JCEPBEKey)k).getParam() != null) {
                param = ((JCEPBEKey)k).getParam();
            } else {
                if (!(params instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                param = PBE.Util.makePBEMacParameters((JCEPBEKey)k, params);
            }
        } else if (params instanceof IvParameterSpec) {
            param = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)params).getIV());
        } else if (params instanceof SkeinParameterSpec) {
            param = new SkeinParameters.Builder(BaseMac.copyMap(((SkeinParameterSpec)params).getParameters())).setKey(key.getEncoded()).build();
        } else {
            if (params != null) throw new InvalidAlgorithmParameterException("unknown parameter type.");
            param = new KeyParameter(key.getEncoded());
        }
        this.macEngine.init(param);
    }

    @Override
    protected int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    @Override
    protected void engineReset() {
        if (this.hsmMacEngine != null) {
            this.hsmMacEngine.reset();
        } else {
            this.macEngine.reset();
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.hsmMacEngine != null) {
            this.hsmMacEngine.update(input);
        } else {
            this.macEngine.update(input);
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (this.hsmMacEngine != null) {
            this.hsmMacEngine.update(input, offset, len);
        } else {
            this.macEngine.update(input, offset, len);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] out = new byte[this.engineGetMacLength()];
        if (this.hsmMacEngine != null) {
            this.hsmMacEngine.doFinal(out, 0);
        } else {
            this.macEngine.doFinal(out, 0);
        }
        return out;
    }

    private static Hashtable copyMap(Map paramsMap) {
        Hashtable newTable = new Hashtable();
        for (Object key : paramsMap.keySet()) {
            newTable.put(key, paramsMap.get(key));
        }
        return newTable;
    }
}

