/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jsses.provider;

import com.sansec.jsses.provider.TlsPrfGenerator;
import com.sansec.jsses.provider.spec.TlsKeyMaterialParameterSpec;
import com.sansec.jsses.provider.spec.TlsKeyMaterialSpec;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private TlsKeyMaterialParameterSpec spec;
    private int protocolVersion;

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsKeyMaterialParameterSpec)params;
        if (!"RAW".equals(this.spec.getMasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if ((this.protocolVersion < 768 || this.protocolVersion > 770) && this.protocolVersion != 256) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, and TLS 1.1 supported");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        try {
            return this.engineGenerateKey0();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }

    private SecretKey engineGenerateKey0() throws GeneralSecurityException {
        String algorithm = this.spec.getCipherAlgorithm();
        if ("SM1".equals(algorithm) || "GBTlsMasterSecret".equals(algorithm) || "SM4".equals(algorithm)) {
            return this.engineGenerateKeyGB();
        }
        return this.engineGenerateKeyStd();
    }

    private SecretKey engineGenerateKeyGB() throws GeneralSecurityException {
        byte[] masterSecret = this.spec.getMasterSecret().getEncoded();
        byte[] clientRandom = this.spec.getClientRandom();
        byte[] serverRandom = this.spec.getServerRandom();
        SecretKeySpec clientMacKey = null;
        SecretKeySpec serverMacKey = null;
        SecretKeySpec clientCipherKey = null;
        IvParameterSpec clientIv = null;
        SecretKeySpec serverCipherKey = null;
        IvParameterSpec serverIv = null;
        int macLength = this.spec.getMacKeyLength();
        int expandedKeyLength = this.spec.getExpandedCipherKeyLength();
        boolean isExportable = expandedKeyLength != 0;
        int keyLength = this.spec.getCipherKeyLength();
        int ivLength = this.spec.getIvLength();
        int keyBlockLen = macLength + keyLength + (isExportable ? 0 : ivLength);
        byte[] keyBlock = new byte[keyBlockLen <<= 1];
        MessageDigest sha = MessageDigest.getInstance("SHA1");
        MessageDigest sm3 = MessageDigest.getInstance("SM3");
        if (this.protocolVersion >= 769 || this.protocolVersion == 256) {
            byte[] seed = TlsPrfGenerator.concat(serverRandom, clientRandom);
            keyBlock = TlsPrfGenerator.doGbPRF(masterSecret, TlsPrfGenerator.LABEL_KEY_EXPANSION, seed, keyBlockLen, sha, sm3);
        } else {
            keyBlock = new byte[keyBlockLen];
            byte[] tmp = new byte[20];
            int i = 0;
            for (int remaining = keyBlockLen; remaining > 0; remaining -= 16) {
                sha.update(TlsPrfGenerator.SSL3_CONST[i]);
                sha.update(masterSecret);
                sha.update(serverRandom);
                sha.update(clientRandom);
                sha.digest(tmp, 0, 20);
                sm3.reset();
                sm3.update(masterSecret);
                sm3.update(tmp);
                if (remaining >= 16) {
                    sm3.digest(keyBlock, i << 4, 16);
                    sm3.reset();
                } else {
                    sm3.digest(tmp, 0, 16);
                    sm3.reset();
                    System.arraycopy(tmp, 0, keyBlock, i << 4, remaining);
                }
                ++i;
            }
        }
        int ofs = 0;
        byte[] tmp = new byte[macLength];
        System.arraycopy(keyBlock, ofs, tmp, 0, macLength);
        clientMacKey = new SecretKeySpec(tmp, "Mac");
        System.arraycopy(keyBlock, ofs += macLength, tmp, 0, macLength);
        ofs += macLength;
        serverMacKey = new SecretKeySpec(tmp, "Mac");
        if (keyLength == 0) {
            return new TlsKeyMaterialSpec(clientMacKey, serverMacKey);
        }
        String alg = this.spec.getCipherAlgorithm();
        byte[] clientKeyBytes = new byte[keyLength];
        System.arraycopy(keyBlock, ofs, clientKeyBytes, 0, keyLength);
        byte[] serverKeyBytes = new byte[keyLength];
        System.arraycopy(keyBlock, ofs += keyLength, serverKeyBytes, 0, keyLength);
        ofs += keyLength;
        if (!isExportable) {
            clientCipherKey = new SecretKeySpec(clientKeyBytes, alg);
            serverCipherKey = new SecretKeySpec(serverKeyBytes, alg);
            if (ivLength != 0) {
                tmp = new byte[ivLength];
                System.arraycopy(keyBlock, ofs, tmp, 0, ivLength);
                clientIv = new IvParameterSpec(tmp);
                System.arraycopy(keyBlock, ofs += ivLength, tmp, 0, ivLength);
                ofs += ivLength;
                serverIv = new IvParameterSpec(tmp);
            }
        } else if (this.protocolVersion >= 769 || this.protocolVersion == 256) {
            byte[] seed = TlsPrfGenerator.concat(clientRandom, serverRandom);
            tmp = TlsPrfGenerator.doGbPRF(clientKeyBytes, TlsPrfGenerator.LABEL_CLIENT_WRITE_KEY, seed, expandedKeyLength, sha, sm3);
            clientCipherKey = new SecretKeySpec(tmp, alg);
            tmp = TlsPrfGenerator.doGbPRF(serverKeyBytes, TlsPrfGenerator.LABEL_SERVER_WRITE_KEY, seed, expandedKeyLength, sha, sm3);
            serverCipherKey = new SecretKeySpec(tmp, alg);
            if (ivLength != 0) {
                tmp = new byte[ivLength];
                byte[] block = TlsPrfGenerator.doGbPRF(null, TlsPrfGenerator.LABEL_IV_BLOCK, seed, ivLength << 1, sha, sm3);
                System.arraycopy(block, 0, tmp, 0, ivLength);
                clientIv = new IvParameterSpec(tmp);
                System.arraycopy(block, ivLength, tmp, 0, ivLength);
                serverIv = new IvParameterSpec(tmp);
            }
        } else {
            tmp = new byte[expandedKeyLength];
            sm3.update(clientKeyBytes);
            sm3.update(clientRandom);
            sm3.update(serverRandom);
            System.arraycopy(sm3.digest(), 0, tmp, 0, expandedKeyLength);
            sm3.reset();
            clientCipherKey = new SecretKeySpec(tmp, alg);
            sm3.update(serverKeyBytes);
            sm3.update(serverRandom);
            sm3.update(clientRandom);
            System.arraycopy(sm3.digest(), 0, tmp, 0, expandedKeyLength);
            sm3.reset();
            serverCipherKey = new SecretKeySpec(tmp, alg);
            if (ivLength != 0) {
                tmp = new byte[ivLength];
                sm3.update(clientRandom);
                sm3.update(serverRandom);
                System.arraycopy(sm3.digest(), 0, tmp, 0, ivLength);
                sm3.reset();
                clientIv = new IvParameterSpec(tmp);
                sm3.update(serverRandom);
                sm3.update(clientRandom);
                System.arraycopy(sm3.digest(), 0, tmp, 0, ivLength);
                sm3.reset();
                serverIv = new IvParameterSpec(tmp);
            }
        }
        return new TlsKeyMaterialSpec(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
    }

    private SecretKey engineGenerateKeyStd() throws GeneralSecurityException {
        byte[] masterSecret = this.spec.getMasterSecret().getEncoded();
        byte[] clientRandom = this.spec.getClientRandom();
        byte[] serverRandom = this.spec.getServerRandom();
        SecretKeySpec clientMacKey = null;
        SecretKeySpec serverMacKey = null;
        SecretKeySpec clientCipherKey = null;
        IvParameterSpec clientIv = null;
        SecretKeySpec serverCipherKey = null;
        IvParameterSpec serverIv = null;
        int macLength = this.spec.getMacKeyLength();
        int expandedKeyLength = this.spec.getExpandedCipherKeyLength();
        boolean isExportable = expandedKeyLength != 0;
        int keyLength = this.spec.getCipherKeyLength();
        int ivLength = this.spec.getIvLength();
        int keyBlockLen = macLength + keyLength + (isExportable ? 0 : ivLength);
        byte[] keyBlock = new byte[keyBlockLen <<= 1];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        MessageDigest sha = MessageDigest.getInstance("SHA1");
        if (this.protocolVersion >= 769) {
            byte[] seed = TlsPrfGenerator.concat(serverRandom, clientRandom);
            keyBlock = TlsPrfGenerator.doPRF(masterSecret, TlsPrfGenerator.LABEL_KEY_EXPANSION, seed, keyBlockLen, md5, sha);
        } else {
            keyBlock = new byte[keyBlockLen];
            byte[] tmp = new byte[20];
            int i = 0;
            for (int remaining = keyBlockLen; remaining > 0; remaining -= 16) {
                sha.update(TlsPrfGenerator.SSL3_CONST[i]);
                sha.update(masterSecret);
                sha.update(serverRandom);
                sha.update(clientRandom);
                sha.digest(tmp, 0, 20);
                md5.update(masterSecret);
                md5.update(tmp);
                if (remaining >= 16) {
                    md5.digest(keyBlock, i << 4, 16);
                } else {
                    md5.digest(tmp, 0, 16);
                    System.arraycopy(tmp, 0, keyBlock, i << 4, remaining);
                }
                ++i;
            }
        }
        int ofs = 0;
        byte[] tmp = new byte[macLength];
        System.arraycopy(keyBlock, ofs, tmp, 0, macLength);
        clientMacKey = new SecretKeySpec(tmp, "Mac");
        System.arraycopy(keyBlock, ofs += macLength, tmp, 0, macLength);
        ofs += macLength;
        serverMacKey = new SecretKeySpec(tmp, "Mac");
        if (keyLength == 0) {
            return new TlsKeyMaterialSpec(clientMacKey, serverMacKey);
        }
        String alg = this.spec.getCipherAlgorithm();
        byte[] clientKeyBytes = new byte[keyLength];
        System.arraycopy(keyBlock, ofs, clientKeyBytes, 0, keyLength);
        byte[] serverKeyBytes = new byte[keyLength];
        System.arraycopy(keyBlock, ofs += keyLength, serverKeyBytes, 0, keyLength);
        ofs += keyLength;
        if (!isExportable) {
            clientCipherKey = new SecretKeySpec(clientKeyBytes, alg);
            serverCipherKey = new SecretKeySpec(serverKeyBytes, alg);
            if (ivLength != 0) {
                tmp = new byte[ivLength];
                System.arraycopy(keyBlock, ofs, tmp, 0, ivLength);
                clientIv = new IvParameterSpec(tmp);
                System.arraycopy(keyBlock, ofs += ivLength, tmp, 0, ivLength);
                ofs += ivLength;
                serverIv = new IvParameterSpec(tmp);
            }
        } else if (this.protocolVersion >= 769) {
            byte[] seed = TlsPrfGenerator.concat(clientRandom, serverRandom);
            tmp = TlsPrfGenerator.doPRF(clientKeyBytes, TlsPrfGenerator.LABEL_CLIENT_WRITE_KEY, seed, expandedKeyLength, md5, sha);
            clientCipherKey = new SecretKeySpec(tmp, alg);
            tmp = TlsPrfGenerator.doPRF(serverKeyBytes, TlsPrfGenerator.LABEL_SERVER_WRITE_KEY, seed, expandedKeyLength, md5, sha);
            serverCipherKey = new SecretKeySpec(tmp, alg);
            if (ivLength != 0) {
                tmp = new byte[ivLength];
                byte[] block = TlsPrfGenerator.doPRF(null, TlsPrfGenerator.LABEL_IV_BLOCK, seed, ivLength << 1, md5, sha);
                System.arraycopy(block, 0, tmp, 0, ivLength);
                clientIv = new IvParameterSpec(tmp);
                System.arraycopy(block, ivLength, tmp, 0, ivLength);
                serverIv = new IvParameterSpec(tmp);
            }
        } else {
            tmp = new byte[expandedKeyLength];
            md5.update(clientKeyBytes);
            md5.update(clientRandom);
            md5.update(serverRandom);
            System.arraycopy(md5.digest(), 0, tmp, 0, expandedKeyLength);
            clientCipherKey = new SecretKeySpec(tmp, alg);
            md5.update(serverKeyBytes);
            md5.update(serverRandom);
            md5.update(clientRandom);
            System.arraycopy(md5.digest(), 0, tmp, 0, expandedKeyLength);
            serverCipherKey = new SecretKeySpec(tmp, alg);
            if (ivLength != 0) {
                tmp = new byte[ivLength];
                md5.update(clientRandom);
                md5.update(serverRandom);
                System.arraycopy(md5.digest(), 0, tmp, 0, ivLength);
                clientIv = new IvParameterSpec(tmp);
                md5.update(serverRandom);
                md5.update(clientRandom);
                System.arraycopy(md5.digest(), 0, tmp, 0, ivLength);
                serverIv = new IvParameterSpec(tmp);
            }
        }
        return new TlsKeyMaterialSpec(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
    }
}

