/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.math.ec.endo;

import com.sansec.math.ec.ECConstants;
import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import com.sansec.math.ec.PreCompCallback;
import com.sansec.math.ec.PreCompInfo;
import com.sansec.math.ec.endo.ECEndomorphism;
import com.sansec.math.ec.endo.EndoPreCompInfo;
import com.sansec.math.ec.endo.ScalarSplitParameters;
import java.math.BigInteger;

public abstract class EndoUtil {
    public static final String PRECOMP_NAME = "bc_endo";

    public static BigInteger[] decomposeScalar(ScalarSplitParameters p, BigInteger k) {
        int bits = p.getBits();
        BigInteger b1 = EndoUtil.calculateB(k, p.getG1(), bits);
        BigInteger b2 = EndoUtil.calculateB(k, p.getG2(), bits);
        BigInteger a = k.subtract(b1.multiply(p.getV1A()).add(b2.multiply(p.getV2A())));
        BigInteger b = b1.multiply(p.getV1B()).add(b2.multiply(p.getV2B())).negate();
        return new BigInteger[]{a, b};
    }

    public static ECPoint mapPoint(final ECEndomorphism endomorphism, final ECPoint p) {
        ECCurve c = p.getCurve();
        EndoPreCompInfo precomp = (EndoPreCompInfo)c.precompute(p, PRECOMP_NAME, new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo existing) {
                EndoPreCompInfo existingEndo;
                EndoPreCompInfo endoPreCompInfo = existingEndo = existing instanceof EndoPreCompInfo ? (EndoPreCompInfo)existing : null;
                if (this.checkExisting(existingEndo, endomorphism)) {
                    return existingEndo;
                }
                ECPoint mappedPoint = endomorphism.getPointMap().map(p);
                EndoPreCompInfo result = new EndoPreCompInfo();
                result.setEndomorphism(endomorphism);
                result.setMappedPoint(mappedPoint);
                return result;
            }

            private boolean checkExisting(EndoPreCompInfo existingEndo, ECEndomorphism endomorphism2) {
                return null != existingEndo && existingEndo.getEndomorphism() == endomorphism2 && existingEndo.getMappedPoint() != null;
            }
        });
        return precomp.getMappedPoint();
    }

    private static BigInteger calculateB(BigInteger k, BigInteger g, int t) {
        boolean negative = g.signum() < 0;
        BigInteger b = k.multiply(g.abs());
        boolean extra = b.testBit(t - 1);
        b = b.shiftRight(t);
        if (extra) {
            b = b.add(ECConstants.ONE);
        }
        return negative ? b.negate() : b;
    }
}

