/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.pqc.jcajce.provider.gmss;

import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.crypto.CipherParameters;
import com.sansec.pqc.asn1.GMSSPublicKey;
import com.sansec.pqc.asn1.PQCObjectIdentifiers;
import com.sansec.pqc.asn1.ParSet;
import com.sansec.pqc.crypto.gmss.GMSSParameters;
import com.sansec.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.sansec.pqc.jcajce.provider.util.KeyUtil;
import com.sansec.util.encoders.Hex;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyBytes;
    private GMSSParameters gmssParameterSet;
    private GMSSParameters gmssParams;

    public BCGMSSPublicKey(byte[] pub, GMSSParameters gmssParameterSet) {
        this.gmssParameterSet = gmssParameterSet;
        this.publicKeyBytes = pub;
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters params) {
        this(params.getPublicKey(), params.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public GMSSParameters getParameterSet() {
        return this.gmssParameterSet;
    }

    public String toString() {
        String out = null;
        try {
            out = "GMSS public key : " + new String(Hex.encode(this.publicKeyBytes), "utf-8") + "\n" + "Height of Trees: \n";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.gmssParameterSet.getHeightOfTrees().length; ++i) {
            out = out + "Layer " + i + " : " + this.gmssParameterSet.getHeightOfTrees()[i] + " WinternitzParameter: " + this.gmssParameterSet.getWinternitzParameter()[i] + " K: " + this.gmssParameterSet.getK()[i] + "\n";
        }
        return out;
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, new ParSet(this.gmssParameterSet.getNumOfLayers(), this.gmssParameterSet.getHeightOfTrees(), this.gmssParameterSet.getWinternitzParameter(), this.gmssParameterSet.getK()).toASN1Primitive()), new GMSSPublicKey(this.publicKeyBytes));
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

