/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.pqc.jcajce.provider.mceliece;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import com.sansec.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import com.sansec.pqc.crypto.mceliece.McElieceCCA2Parameters;
import com.sansec.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.sansec.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.sansec.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import com.sansec.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import com.sansec.pqc.jcajce.spec.McElieceCCA2KeyGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceCCA2KeyPairGeneratorSpi
extends KeyPairGenerator {
    private McElieceCCA2KeyPairGenerator kpg;

    public McElieceCCA2KeyPairGeneratorSpi() {
        super("McEliece-CCA2");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceCCA2KeyPairGenerator();
        super.initialize(params);
        McElieceCCA2KeyGenParameterSpec ecc = (McElieceCCA2KeyGenParameterSpec)params;
        McElieceCCA2KeyGenerationParameters mccca2KGParams = new McElieceCCA2KeyGenerationParameters(new SecureRandom(), new McElieceCCA2Parameters(ecc.getM(), ecc.getT(), ecc.getDigest()));
        this.kpg.init(mccca2KGParams);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        this.kpg = new McElieceCCA2KeyPairGenerator();
        McElieceCCA2KeyGenerationParameters mccca2KGParams = new McElieceCCA2KeyGenerationParameters(random, new McElieceCCA2Parameters());
        this.kpg.init(mccca2KGParams);
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair generateKeyPair = this.kpg.generateKeyPair();
        McElieceCCA2PrivateKeyParameters sk = (McElieceCCA2PrivateKeyParameters)generateKeyPair.getPrivate();
        McElieceCCA2PublicKeyParameters pk = (McElieceCCA2PublicKeyParameters)generateKeyPair.getPublic();
        return new KeyPair(new BCMcElieceCCA2PublicKey(pk), new BCMcElieceCCA2PrivateKey(sk));
    }
}

