/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.pqc.jcajce.provider.newhope;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.pqc.crypto.newhope.NHKeyPairGenerator;
import com.sansec.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.sansec.pqc.crypto.newhope.NHPublicKeyParameters;
import com.sansec.pqc.jcajce.provider.newhope.BCNHPrivateKey;
import com.sansec.pqc.jcajce.provider.newhope.BCNHPublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class NHKeyPairGeneratorSpi
extends KeyPairGenerator {
    NHKeyPairGenerator engine = new NHKeyPairGenerator();
    SecureRandom random = new SecureRandom();
    boolean initialised = false;

    public NHKeyPairGeneratorSpi() {
        super("NH");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        this.engine.init(new KeyGenerationParameters(random, 1024));
        this.initialised = true;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.engine.init(new KeyGenerationParameters(random, 1024));
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.engine.init(new KeyGenerationParameters(this.random, 1024));
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        NHPublicKeyParameters pub = (NHPublicKeyParameters)pair.getPublic();
        NHPrivateKeyParameters priv = (NHPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCNHPublicKey(pub), new BCNHPrivateKey(priv));
    }
}

