/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.pqc.jcajce.provider.sphincs;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.CipherParameters;
import com.sansec.pqc.asn1.PQCObjectIdentifiers;
import com.sansec.pqc.asn1.SPHINCS256KeyParams;
import com.sansec.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.sansec.pqc.jcajce.interfaces.SPHINCSKey;
import com.sansec.util.Arrays;
import java.io.IOException;
import java.security.PublicKey;

public class BCSphincs256PublicKey
implements PublicKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private final ASN1ObjectIdentifier treeDigest;
    private final SPHINCSPublicKeyParameters params;

    public BCSphincs256PublicKey(ASN1ObjectIdentifier treeDigest, SPHINCSPublicKeyParameters params) {
        this.treeDigest = treeDigest;
        this.params = params;
    }

    public BCSphincs256PublicKey(SubjectPublicKeyInfo keyInfo) {
        this.treeDigest = SPHINCS256KeyParams.getInstance(keyInfo.getAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = new SPHINCSPublicKeyParameters(keyInfo.getPublicKeyData().getBytes());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BCSphincs256PublicKey)) {
            return false;
        }
        BCSphincs256PublicKey otherKey = (BCSphincs256PublicKey)o;
        return this.treeDigest.equals(otherKey.treeDigest) && Arrays.areEqual(this.params.getKeyData(), otherKey.params.getKeyData());
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
            SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(algorithmIdentifier, this.params.getKeyData());
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }
}

