/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.pqc.jcajce.provider.sphincs;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.Digest;
import com.sansec.crypto.digests.SHA3Digest;
import com.sansec.crypto.digests.SHA512Digest;
import com.sansec.crypto.digests.SHA512tDigest;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.pqc.crypto.sphincs.SPHINCS256Signer;
import com.sansec.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import com.sansec.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class SphincsSignatureSpi
extends SignatureSpi {
    private Digest digest;
    private SPHINCS256Signer signer;
    private SecureRandom random;

    protected SphincsSignatureSpi(Digest digest, SPHINCS256Signer signer) {
        this.digest = digest;
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCSphincs256PublicKey)) {
            throw new InvalidKeyException("unknown public key passed to SPHINCS-256");
        }
        CipherParameters param = ((BCSphincs256PublicKey)publicKey).getKeyParams();
        this.digest.reset();
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters param;
        if (privateKey instanceof BCSphincs256PrivateKey) {
            param = ((BCSphincs256PrivateKey)privateKey).getKeyParams();
            if (this.random != null) {
                param = new ParametersWithRandom(param, this.random);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to SPHINCS-256");
        }
        this.digest.reset();
        this.signer.init(true, param);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] sig = this.signer.generateSignature(hash);
            return sig;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return this.signer.verifySignature(hash, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class withSha3_512
    extends SphincsSignatureSpi {
        public withSha3_512() {
            super(new SHA3Digest(512), new SPHINCS256Signer(new SHA3Digest(256), new SHA3Digest(512)));
        }
    }

    public static class withSha512
    extends SphincsSignatureSpi {
        public withSha512() {
            super(new SHA512Digest(), new SPHINCS256Signer(new SHA512tDigest(256), new SHA512Digest()));
        }
    }
}

