/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.util;

import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DERNull;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.RSAPrivateKeyStructure;
import com.sansec.asn1.pkcs.SM2PrivateKeyStructure;
import com.sansec.asn1.pkcs.SM2PublicKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.RSAPublicKeyStructure;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyLite;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PrivateKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PublicKey;
import com.sansec.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyUtil {
    public static PublicKey getRSAPublicKey(byte[] n, byte[] e) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        BigInteger bN = new BigInteger(1, n);
        BigInteger bE = new BigInteger(1, e);
        RSAPublicKeyStructure structure = new RSAPublicKeyStructure(bN, bE);
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), structure);
        byte[] encodedKey = info.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SwxaJCE");
        PublicKey key = keyFactory.generatePublic(keySpec);
        return key;
    }

    public static SM2refPublicKey sm2PubKeyDER2GM(byte[] derData) throws Exception {
        JCESM2PublicKey derPublicKey = null;
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(derData);
            KeyFactory factory = KeyFactory.getInstance("SM2", "SwxaJCE");
            derPublicKey = (JCESM2PublicKey)factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new Exception("\u4e0d\u662f\u6709\u6548\u7684DER\u7f16\u7801SM2\u516c\u94a5,\u8bf7\u68c0\u67e5");
        }
        byte[] x = BigIntegers.asUnsignedByteArray(derPublicKey.getW().getAffineX());
        byte[] y = BigIntegers.asUnsignedByteArray(derPublicKey.getW().getAffineY());
        SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
        return publicKey;
    }

    public static SM2refPrivateKey sm2PriKeyDER2GM(byte[] derData) throws Exception {
        JCESM2PrivateKey derPrivateCrtKey = null;
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(derData);
            KeyFactory factory = KeyFactory.getInstance("SM2", "SwxaJCE");
            derPrivateCrtKey = (JCESM2PrivateKey)factory.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new Exception("\u4e0d\u662f\u6709\u6548\u7684DER\u7f16\u7801SM2\u79c1\u94a5,\u8bf7\u68c0\u67e5");
        }
        byte[] d = BigIntegers.asUnsignedByteArray(derPrivateCrtKey.getS());
        SM2refPrivateKey privateKey = new SM2refPrivateKey(d);
        return privateKey;
    }

    public static PrivateKey getRSAPrivateKey(byte[] n, byte[] e, byte[] d, byte[] p, byte[] q, byte[] dp, byte[] dq, byte[] coef) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        BigInteger bN = new BigInteger(1, n);
        BigInteger bE = new BigInteger(1, e);
        BigInteger bD = new BigInteger(1, d);
        BigInteger bP = new BigInteger(1, p);
        BigInteger bQ = new BigInteger(1, q);
        BigInteger bP1 = new BigInteger(1, dp);
        BigInteger bQ1 = new BigInteger(1, dq);
        BigInteger bCoef = new BigInteger(1, coef);
        RSAPrivateKeyStructure structure = new RSAPrivateKeyStructure(bN, bE, bD, bP, bQ, bP1, bQ1, bCoef);
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), structure);
        byte[] encodedKey = info.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SwxaJCE");
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        return key;
    }

    public static PublicKey getSM2PubicKey(byte[] x, byte[] y) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        BigInteger bX = new BigInteger(1, x);
        BigInteger bY = new BigInteger(1, y);
        SM2PublicKeyStructure structure = new SM2PublicKeyStructure(new ECPoint(bX, bY));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.ecPublicKey, GBObjectIdentifiers.sm2), structure.getPublicKey());
        byte[] encodedKey = info.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance("SM2", "SwxaJCE");
        PublicKey key = keyFactory.generatePublic(keySpec);
        return key;
    }

    public static PrivateKey getSM2PrivateKey(byte[] x, byte[] y, byte[] d) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        DERBitString pubkey = null;
        if (x != null && x.length > 0 && y != null && y.length > 0) {
            BigInteger bX = new BigInteger(1, x);
            BigInteger bY = new BigInteger(1, y);
            pubkey = new DERBitString(new SM2PublicKeyStructure(new ECPoint(bX, bY)).getPublicKey());
        }
        BigInteger bD = new BigInteger(1, d);
        SM2PrivateKeyStructure structure = new SM2PrivateKeyStructure(bD, pubkey, null);
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.ecPublicKey, GBObjectIdentifiers.sm2), structure);
        byte[] encodedKey = info.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance("SM2", "SwxaJCE");
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        return key;
    }

    public static IRSArefPublicKey transRSAPubKeyDER2GM(byte[] data) {
        RSAPublicKey derPublicKey = null;
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(data);
            KeyFactory factory = KeyFactory.getInstance("RSA", "SwxaJCE");
            derPublicKey = (RSAPublicKey)factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("The public key is not correct format of RSA X509 DER," + e.getMessage());
        }
        Object publicKey = null;
        byte[] n = BigIntegers.asUnsignedByteArray(derPublicKey.getModulus());
        byte[] e = derPublicKey.getPublicExponent().toByteArray();
        int bits = derPublicKey.getModulus().bitLength();
        publicKey = bits > 2048 ? new RSArefPublicKeyEx(bits, n, e) : new RSArefPublicKeyLite(bits, n, e);
        return publicKey;
    }

    public static IRSArefPrivateKey transRSAPriKeyDER2GM(byte[] data) {
        RSAPrivateCrtKey derPrivateCrtKey = null;
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(data);
            KeyFactory factory = KeyFactory.getInstance("RSA", "SwxaJCE");
            derPrivateCrtKey = (RSAPrivateCrtKey)factory.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("The private key is not correct format of RSA  PKCS8 DER," + e.getMessage());
        }
        Object privateKey = null;
        byte[] n = BigIntegers.asUnsignedByteArray(derPrivateCrtKey.getModulus());
        byte[] e = derPrivateCrtKey.getPublicExponent().toByteArray();
        byte[] d = derPrivateCrtKey.getPrivateExponent().toByteArray();
        byte[] p1 = derPrivateCrtKey.getPrimeP().toByteArray();
        byte[] p2 = derPrivateCrtKey.getPrimeQ().toByteArray();
        byte[] q1 = derPrivateCrtKey.getPrimeExponentP().toByteArray();
        byte[] q2 = derPrivateCrtKey.getPrimeExponentQ().toByteArray();
        byte[] coef = derPrivateCrtKey.getCrtCoefficient().toByteArray();
        privateKey = derPrivateCrtKey.getModulus().bitLength() > 2048 ? new RSArefPrivateKeyEx(n, e, d, p1, p2, q1, q2, coef) : new RSArefPrivateKeyLite(n, e, d, p1, p2, q1, q2, coef);
        return privateKey;
    }
}

