/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.api.ISDSCryptoFactory;
import com.sansec.devicev4.log.CryptoLogger;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwxaDeviceFactory {
    private static Logger logger = CryptoLogger.logger;
    private static volatile ISDSCrypto instance = null;
    private static volatile String DEVICE_FACTORY_NAME = "com.sansec.devicev4.crypto_hsm.SDSCryptoFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance() throws CryptoException {
        if (instance != null) return instance;
        Class<SwxaDeviceFactory> clazz = SwxaDeviceFactory.class;
        synchronized (SwxaDeviceFactory.class) {
            if (instance != null) return instance;
            instance = SwxaDeviceFactory.getCryptoFactory(DEVICE_FACTORY_NAME).getInstance();
            if (!logger.isLoggable(Level.FINE)) return instance;
            logger.info("deviceFactoryName=" + DEVICE_FACTORY_NAME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance(String deviceFactoryName) throws CryptoException {
        if (instance != null) return instance;
        Class<SwxaDeviceFactory> clazz = SwxaDeviceFactory.class;
        synchronized (SwxaDeviceFactory.class) {
            if (instance != null) return instance;
            if (logger.isLoggable(Level.FINE)) {
                logger.info("deviceFactoryName=" + deviceFactoryName);
            }
            instance = SwxaDeviceFactory.getCryptoFactory(deviceFactoryName).getInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance(String deviceFactoryName, String userConfigFile) throws CryptoException {
        if (instance != null) return instance;
        Class<SwxaDeviceFactory> clazz = SwxaDeviceFactory.class;
        synchronized (SwxaDeviceFactory.class) {
            if (instance != null) return instance;
            if (deviceFactoryName == null || deviceFactoryName.length() == 0) {
                deviceFactoryName = DEVICE_FACTORY_NAME;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.info("deviceFactoryName=" + deviceFactoryName);
                logger.info("userConfigFile=" + userConfigFile);
            }
            instance = SwxaDeviceFactory.getCryptoFactory(deviceFactoryName).getInstance(userConfigFile);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance(InputStream iniInputStream) throws CryptoException {
        if (iniInputStream == null) {
            throw new CryptoException("iniInputStream cannot be null.");
        }
        if (instance != null) return instance;
        Class<SwxaDeviceFactory> clazz = SwxaDeviceFactory.class;
        synchronized (SwxaDeviceFactory.class) {
            if (instance != null) return instance;
            instance = SwxaDeviceFactory.getCryptoFactory(DEVICE_FACTORY_NAME).getInstance(iniInputStream);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance(String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (instance != null) return instance;
        Class<SwxaDeviceFactory> clazz = SwxaDeviceFactory.class;
        synchronized (SwxaDeviceFactory.class) {
            if (instance != null) return instance;
            instance = SwxaDeviceFactory.getCryptoFactory(DEVICE_FACTORY_NAME).getInstance(loginPass, keyStorePass, trustStorePass);
            if (!logger.isLoggable(Level.FINE)) return instance;
            logger.info("deviceFactoryName=" + DEVICE_FACTORY_NAME);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance(String deviceFactoryName, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (instance != null) return instance;
        Class<SwxaDeviceFactory> clazz = SwxaDeviceFactory.class;
        synchronized (SwxaDeviceFactory.class) {
            if (instance != null) return instance;
            if (logger.isLoggable(Level.FINE)) {
                logger.info("deviceFactoryName=" + deviceFactoryName);
            }
            instance = SwxaDeviceFactory.getCryptoFactory(deviceFactoryName).getInstance(loginPass, keyStorePass, trustStorePass);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance(String deviceFactoryName, String userConfigFile, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (instance != null) return instance;
        Class<SwxaDeviceFactory> clazz = SwxaDeviceFactory.class;
        synchronized (SwxaDeviceFactory.class) {
            if (instance != null) return instance;
            if (deviceFactoryName == null || deviceFactoryName.length() == 0) {
                deviceFactoryName = DEVICE_FACTORY_NAME;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.info("deviceFactoryName=" + deviceFactoryName);
                logger.info("userConfigFile=" + userConfigFile);
            }
            instance = SwxaDeviceFactory.getCryptoFactory(deviceFactoryName).getInstance(userConfigFile, loginPass, keyStorePass, trustStorePass);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    private static ISDSCryptoFactory getCryptoFactory(String deviceFactoryName) throws CryptoException {
        Class<?> class1 = null;
        try {
            class1 = Class.forName(deviceFactoryName);
        }
        catch (ClassNotFoundException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Reflex class railed:cannot find[" + deviceFactoryName + "]class" + e.getMessage());
            }
            throw new CryptoException("Reflex class railed:cannot find[" + deviceFactoryName + "]class" + e.getMessage());
        }
        Object object = null;
        try {
            object = class1.newInstance();
        }
        catch (InstantiationException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Instantiate factory failed:[" + deviceFactoryName + "]" + e.getMessage());
            }
            throw new CryptoException("Instantiate factory failed:[" + deviceFactoryName + "]" + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Instantiate factory failed:[" + deviceFactoryName + "]" + e.getMessage());
            }
            throw new CryptoException("Instantiate factory failed:[" + deviceFactoryName + "]" + e.getMessage(), e);
        }
        ISDSCryptoFactory cryptoFactory = object;
        return cryptoFactory;
    }
}

