/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.api.ISDSCryptoFactory;
import com.sansec.devicev4.crypto_hsm.config.ConfigFile;
import com.sansec.devicev4.crypto_hsm.config.ConfigFileException;
import com.sansec.devicev4.crypto_hsm.sds.CMDCrypto;
import com.sansec.devicev4.crypto_hsm.sds.LIBCrypto;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.log.CryptoLogger;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDSCryptoFactory
implements ISDSCryptoFactory {
    private Logger logger = CryptoLogger.logger;
    private static volatile ISDSCrypto instance = null;
    private static ConfigFile configFile = null;

    private static String getVersion() {
        return "\n  ____    _    _   _ ____  _____ ____    ____                  _                   \n / ___|  / \\  | \\ | / ___|| ____/ ___|  / ___|_ __ _   _ _ __ | |_ ___           \n \\___ \\ / _ \\ |  \\| \\___ \\|  _|| |     | |   | '__| | | | '_ \\| __/ _ \\    \n  ___) / ___ \\| |\\  |___) | |__| |___  | |___| |  | |_| | |_) | || (_) |         \n |____/_/   \\_|_| \\_|____/|_____\\____|  \\____|_|   \\__, | .__/ \\__\\___/     \n                                                   |___/|_|                        \n Version:        <v5.3.3.RELEASE>  Release-5.3.3.1\n";
    }

    @Override
    public ISDSCrypto getInstance() throws CryptoException {
        return this.getInstance(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISDSCrypto getInstance(String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (instance != null) return instance;
        Class<SDSCryptoFactory> clazz = SDSCryptoFactory.class;
        synchronized (SDSCryptoFactory.class) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(SDSCryptoFactory.getVersion());
            }
            if (instance != null) return instance;
            String path = ConfigFile.findCoinfigFilePath();
            if (path == null) {
                if (!this.logger.isLoggable(Level.SEVERE)) throw new CryptoException("swsds.ini cannot find in default path(Jar):" + path);
                this.logger.severe("swsds.ini cannot find in default path(Jar):" + path);
                throw new CryptoException("swsds.ini cannot find in default path(Jar):" + path);
            }
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning("swsds.ini default path=" + path);
            }
            instance = this.newInstance(path, loginPass, keyStorePass, trustStorePass);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public ISDSCrypto getInstance(String userConfigFile) throws CryptoException {
        return this.getInstance(userConfigFile, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISDSCrypto getInstance(InputStream iniInputStream) throws CryptoException {
        if (instance != null) return instance;
        Class<SDSCryptoFactory> clazz = SDSCryptoFactory.class;
        synchronized (SDSCryptoFactory.class) {
            if (instance != null) return instance;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(SDSCryptoFactory.getVersion());
                this.logger.info("ini info from InputStream.");
            }
            configFile = ConfigFile.getInstance();
            try {
                configFile.loadConfig(iniInputStream);
            }
            catch (ConfigFileException ex) {
                if (!this.logger.isLoggable(Level.SEVERE)) throw new CryptoException(ex.getMessage());
                this.logger.severe(ex.getMessage());
                throw new CryptoException(ex.getMessage());
            }
            try {
                switch (configFile.getDeviceType()) {
                    case 1: {
                        HSMPool pool = HSMPool.getPool();
                        pool.initialize(configFile, null, null, null);
                        instance = new CMDCrypto();
                        break;
                    }
                    case 2: {
                        instance = new LIBCrypto(configFile.getDeviceType());
                        break;
                    }
                    default: {
                        throw new CryptoException("Illegal Device Type.");
                    }
                }
            }
            catch (Exception ex) {
                SDSCryptoFactory.releaseInstance();
                if (this.logger.isLoggable(Level.SEVERE)) {
                    this.logger.severe("Device initialization failed:" + ex.toString());
                }
                ex.printStackTrace();
                throw new CryptoException("Device initialization failed:" + ex.getMessage());
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISDSCrypto getInstance(String userConfigFile, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (instance != null) return instance;
        Class<SDSCryptoFactory> clazz = SDSCryptoFactory.class;
        synchronized (SDSCryptoFactory.class) {
            String path;
            if (instance != null) return instance;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(SDSCryptoFactory.getVersion());
            }
            if ((path = userConfigFile) == null) {
                if (!this.logger.isLoggable(Level.SEVERE)) throw new CryptoException("swsds.ini can not be null");
                this.logger.severe("swsds.ini can not be null");
                throw new CryptoException("swsds.ini can not be null");
            }
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning("swsds.ini path=" + path);
            }
            instance = this.newInstance(path, loginPass, keyStorePass, trustStorePass);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    public static void releaseInstance() {
        ConfigFile.releaseInstance();
        HSMPool.release();
        instance = null;
    }

    private ISDSCrypto newInstance(String path, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        ISDSCrypto instance = null;
        configFile = ConfigFile.getInstance();
        try {
            configFile.loadConfig(path);
        }
        catch (ConfigFileException ex) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.severe(path + ex.getMessage());
            }
            throw new CryptoException(ex.getMessage());
        }
        try {
            switch (configFile.getDeviceType()) {
                case 1: {
                    HSMPool pool = HSMPool.getPool();
                    pool.initialize(configFile, loginPass, keyStorePass, trustStorePass);
                    instance = new CMDCrypto();
                    break;
                }
                case 2: {
                    instance = new LIBCrypto(configFile.getDeviceType());
                    break;
                }
                default: {
                    throw new CryptoException("Illegal Device Type.");
                }
            }
        }
        catch (Exception ex) {
            SDSCryptoFactory.releaseInstance();
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.severe("Device initialization failed:" + ex.toString());
            }
            ex.printStackTrace();
            throw new CryptoException("Device initialization failed:" + ex.getMessage());
        }
        return instance;
    }
}

