/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.changhongecdsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ECCrefCurveParam
extends Structure
implements IKeyPair {
    public byte[] p = new byte[32];
    public byte[] a = new byte[32];
    public byte[] b = new byte[32];
    public byte[] gx = new byte[32];
    public byte[] gy = new byte[32];
    public byte[] n = new byte[32];
    public int len;

    public ECCrefCurveParam() {
    }

    public ECCrefCurveParam(byte[] p, byte[] a, byte[] b, byte[] gx, byte[] gy, byte[] n, int len) {
        this.p = p;
        this.a = a;
        this.b = b;
        this.gx = gx;
        this.gy = gy;
        this.n = n;
        this.len = len;
    }

    public byte[] getP() {
        return this.p;
    }

    public byte[] getA() {
        return this.a;
    }

    public byte[] getB() {
        return this.b;
    }

    public byte[] getGx() {
        return this.gx;
    }

    public byte[] getGy() {
        return this.gy;
    }

    public byte[] getN() {
        return this.n;
    }

    public int getLen() {
        return this.len;
    }

    @Override
    public void decode(byte[] bytes) throws CryptoException {
        int pos = 0;
        System.arraycopy(bytes, pos, this.p, 0, 32);
        System.arraycopy(bytes, pos += this.p.length, this.a, 0, 32);
        System.arraycopy(bytes, pos += this.a.length, this.b, 0, 32);
        System.arraycopy(bytes, pos += this.b.length, this.gx, 0, 32);
        System.arraycopy(bytes, pos += this.gx.length, this.gy, 0, 32);
        System.arraycopy(bytes, pos += this.gy.length, this.n, 0, 32);
        byte[] lenByte = new byte[4];
        System.arraycopy(bytes, pos += this.n.length, lenByte, 0, 4);
        this.len = BytesUtil.bytes2int(lenByte);
        if ((pos += 4) != bytes.length) {
            throw new CryptoException("inputData length != ECCrefCurveParam length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(this.p);
            buf.write(this.a);
            buf.write(this.b);
            buf.write(this.gx);
            buf.write(this.gy);
            buf.write(this.n);
            buf.write(BytesUtil.int2bytes(this.len));
        }
        catch (IOException e) {
            throw new CryptoException("ECCrefCurveParam encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("p: ").append(BytesUtil.bytes2hex(this.p)).append(nl);
        buf.append("a: ").append(BytesUtil.bytes2hex(this.a)).append(nl);
        buf.append("b: ").append(BytesUtil.bytes2hex(this.b)).append(nl);
        buf.append("gx: ").append(BytesUtil.bytes2hex(this.gx)).append(nl);
        buf.append("gy: ").append(BytesUtil.bytes2hex(this.gy)).append(nl);
        buf.append("n: ").append(BytesUtil.bytes2hex(this.n)).append(nl);
        buf.append("len: ").append(this.len).append(nl);
        return buf.toString();
    }

    protected List getFieldOrder() {
        return Arrays.asList("p", "a", "b", "gx", "gy", "n", "len");
    }

    public static class ByValue
    extends ECCrefCurveParam
    implements Structure.ByValue {
    }

    public static class ByReference
    extends ECCrefCurveParam
    implements Structure.ByReference {
    }
}

