/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.sm2;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SM2refCipher
extends Structure
implements IKeyPair {
    public int cLength;
    public byte[] x = new byte[32];
    public byte[] y = new byte[32];
    public byte[] C = new byte[136];
    public byte[] M = new byte[32];

    public SM2refCipher() {
    }

    public SM2refCipher(byte[] x, byte[] y, byte[] c, byte[] m) {
        this.cLength = c.length;
        this.x = x;
        this.y = y;
        this.M = m;
        System.arraycopy(c, 0, this.C, 0, c.length);
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getC() {
        return this.C;
    }

    public byte[] getM() {
        return this.M;
    }

    public int getCLength() {
        return this.cLength;
    }

    @Override
    public void decode(byte[] cipher) throws CryptoException {
        this.cLength = BytesUtil.bytes2int(cipher);
        int pos = 4;
        System.arraycopy(cipher, pos, this.x, 0, 32);
        System.arraycopy(cipher, pos += this.x.length, this.y, 0, 32);
        System.arraycopy(cipher, pos += this.y.length, this.C, 0, 136);
        System.arraycopy(cipher, pos += this.C.length, this.M, 0, 32);
        if ((pos += this.M.length) != cipher.length) {
            throw new CryptoException("inputData length != SM2Cipher length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.cLength));
            buf.write(this.x);
            buf.write(this.y);
            buf.write(this.C);
            buf.write(this.M);
        }
        catch (IOException e) {
            throw new CryptoException("SM2refCipher encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 236;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("cLength: ").append(this.cLength).append(nl);
        buf.append("      x: ").append(BytesUtil.bytes2hex(this.x)).append(nl);
        buf.append("      y: ").append(BytesUtil.bytes2hex(this.y)).append(nl);
        buf.append("      C: ").append(BytesUtil.bytes2hex(this.C)).append(nl);
        buf.append("      M: ").append(BytesUtil.bytes2hex(this.M)).append(nl);
        return buf.toString();
    }

    protected List getFieldOrder() {
        return Arrays.asList("cLength", "x", "y", "C", "M");
    }

    public static class ByValue
    extends SM2refCipher
    implements Structure.ByValue {
    }

    public static class ByReference
    extends SM2refCipher
    implements Structure.ByReference {
    }
}

