/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.cryptoDevice;

import com.sheca.cryptoDevice.shecaCryptoDevice;
import com.sheca.cryptoDevice.shecaDatechStd;
import com.sheca.safeengine.javasafeengine;
import com.sheca.safeengine.shcaSM2PrivateKey;
import com.sheca.safeengine.shcaSM2PublicKey;
import com.sheca.safeengine.shecaCsrUtils;
import com.sheca.safeengine.shecaEnvelopeStructure;
import com.sheca.safeengine.shecaOcspBuilder;
import com.sheca.safeengine.shecaTimeStampBuilder;
import com.sheca.safeengine.shecaUtils;
import com.sheca.safeengine.shecaX509v2CRLBuilder;
import com.sheca.safeengine.shecaX509v3CertBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.Store;
import org.json.JSONObject;

public class shecaLocalStd
extends javasafeengine
implements shecaCryptoDevice {
    private static shecaLocalStd a = null;
    public static final String K_NAME_PRIKEY = "prikey";
    public static final String K_NAME_PUBKEY = "pubkey";
    public static final String K_NAME_CERT = "cert";
    private static Logger b = null;

    public shecaLocalStd() {
        if (b == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                b = Logger.getLogger(shecaDatechStd.class);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                b = null;
                classNotFoundException.printStackTrace();
            }
        }
    }

    public static shecaLocalStd getInstance() {
        if (a == null) {
            a = new shecaLocalStd();
        }
        return a;
    }

    public int calcDeviceSM2signIndexFromGmSM2Index(int n) {
        return 0;
    }

    public int calcDeviceSM2encryptIndexFromGmSM2Index(int n) {
        return 0;
    }

    public int calcRSAsignIndexFromCryptoDevice(int n) {
        return 0;
    }

    public int calcRSAencryptIndexFromCryptoDevice(int n) {
        return 0;
    }

    public int calcSM2signIndexFromCryptoDevice(int n) {
        return 0;
    }

    public int calcSM2encryptIndexFromCryptoDevice(int n) {
        return 0;
    }

    public int calcECCsignIndexFromCryptoDevice(int n) {
        return 0;
    }

    public int calcECCencryptIndexFromCryptoDevice(int n) {
        return 0;
    }

    public static Map exportRSAKeyPair(KeyPair serializable) {
        byte[] byArray = ((KeyPair)serializable).getPrivate().getEncoded();
        byte[] byArray2 = ((KeyPair)serializable).getPublic().getEncoded();
        serializable = new HashMap<String, String>();
        serializable.put(K_NAME_PRIKEY, javasafeengine.hex2b64(byArray));
        serializable.put(K_NAME_PUBKEY, javasafeengine.hex2b64(byArray2));
        return serializable;
    }

    public byte[] generatePFX(KeyPair keyPair, byte[] object, String string) {
        byte[] byArray;
        block13: {
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                try {
                    KeyStore keyStore = KeyStore.getInstance("PKCS12");
                    keyStore.load(null, string.toCharArray());
                    object = shecaLocalStd.getCertificateFromBuffer(object);
                    Certificate[] certificateArray = new Certificate[1];
                    Certificate[] certificateArray2 = certificateArray;
                    certificateArray[0] = object;
                    keyStore.setKeyEntry("", keyPair.getPrivate(), string.toCharArray(), certificateArray2);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    keyStore.store(byteArrayOutputStream, string.toCharArray());
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {
                            object = iOException;
                            iOException.printStackTrace();
                        }
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {
                        object = iOException;
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    public byte[] generatePFX(Map object, byte[] byArray, String string) {
        byte[] byArray2 = null;
        X509Certificate x509Certificate = (X509Certificate)shecaLocalStd.getCertificateFromBuffer(byArray);
        object = !"SM3withSM2".equalsIgnoreCase(x509Certificate.getSigAlgName()) ? this.getRSAKeyPairFromKeyMap((Map)object) : this.getSM2KeyPairFromKeyMap((Map)object);
        if (object != null) {
            byArray2 = this.generatePFX((KeyPair)object, byArray, string);
        }
        return byArray2;
    }

    public Map exportSM2KeyPairFromPFX(byte[] object, String string) {
        try {
            object = new PKCS12PfxPdu(object);
            shecaUtils.logger_info(b, javasafeengine.hex2b64(object.getEncoded()));
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return null;
    }

    public Map exportRSAKeyPairFromPFX(byte[] object, String object2) {
        HashMap<String, String> hashMap = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            object = new ByteArrayInputStream((byte[])object);
            keyStore.load((InputStream)object, ((String)object2).toCharArray());
            ((ByteArrayInputStream)object).close();
            object = keyStore.aliases();
            object = object.nextElement();
            object2 = (PrivateKey)keyStore.getKey((String)object, ((String)object2).toCharArray());
            Object object3 = keyStore.getCertificate((String)object).getPublicKey();
            object2 = object2.getEncoded();
            object3 = object3.getEncoded();
            hashMap = new HashMap<String, String>();
            hashMap.put(K_NAME_PRIKEY, javasafeengine.hex2b64((byte[])object2));
            hashMap.put(K_NAME_PUBKEY, javasafeengine.hex2b64((byte[])object3));
            hashMap.put(K_NAME_CERT, javasafeengine.hex2b64(keyStore.getCertificate((String)object).getEncoded()));
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static Map exportSM2KeyPair(KeyPair serializable) {
        byte[] byArray = shecaLocalStd.getSM2PrivateKeyBuffer((KeyPair)serializable);
        byte[] byArray2 = shecaLocalStd.getSM2PublicKeyBuffer((KeyPair)serializable);
        serializable = new HashMap<String, String>();
        serializable.put(K_NAME_PRIKEY, javasafeengine.hex2b64(byArray));
        serializable.put(K_NAME_PUBKEY, javasafeengine.hex2b64(byArray2));
        return serializable;
    }

    public static Map exportKeyWithSM2KeyPair(KeyPair object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object2 = (BCECPrivateKey)((KeyPair)object).getPrivate();
        object = (BCECPublicKey)((KeyPair)object).getPublic();
        object2 = object2.getD().toByteArray();
        object = object.getQ().getEncoded(false);
        hashMap.put(K_NAME_PRIKEY, object2);
        hashMap.put(K_NAME_PUBKEY, object);
        return hashMap;
    }

    public KeyPair getRSAKeyPairFromKeyMap(Map object) {
        Object object2 = (String)object.get(K_NAME_PRIKEY);
        object = (String)object.get(K_NAME_PUBKEY);
        object2 = this.getRSAPrivateKey(javasafeengine.b64tohex((String)object2));
        object = shecaLocalStd.getRSAPublicKey(javasafeengine.b64tohex((String)object));
        return new KeyPair((PublicKey)object, (PrivateKey)object2);
    }

    public KeyPair getSM2KeyPairFromKeyMap(Map object) {
        Object object2 = (String)object.get(K_NAME_PRIKEY);
        object = (String)object.get(K_NAME_PUBKEY);
        object2 = this.getSM2PrivateKey(javasafeengine.b64tohex((String)object2));
        object = shecaLocalStd.getSM2PublicKey(javasafeengine.b64tohex((String)object));
        return new KeyPair((PublicKey)object, (PrivateKey)object2);
    }

    private static JcaContentSignerBuilder a(PublicKey publicKey) {
        if (publicKey.getAlgorithm().equals("EC") || publicKey.getAlgorithm().equals("ECC")) {
            publicKey = new JcaContentSignerBuilder("SM3withSM2");
            publicKey.setProvider("BC");
            return publicKey;
        }
        throw new Exception("Unsupported PublicKey Algorithm:" + publicKey.getAlgorithm());
    }

    public KeyPair genRSAKeyPairFromCryptoDevice(int n, int n2) {
        if (n == 0) {
            return this.generateRSAKeyPair(n2);
        }
        return null;
    }

    public KeyPair genSM2KeyPairFromCryptoDevice(int n) {
        if (n == 0) {
            return this.generateSM2KeyPair();
        }
        return null;
    }

    public KeyPair genECCKeyPairFromCryptoDevice(int n, int n2) {
        if (n == 0) {
            return this.generateECCKeyPair(n2);
        }
        return null;
    }

    public byte[] genRandomBytesByDevice(int n, int n2) {
        if (n == 0) {
            return this.genRandomBytes(n2);
        }
        return null;
    }

    public byte[] doSymEncryptByDevice(byte[] byArray, int n, byte[] byArray2) {
        return this.doSymEncrypt(n, byArray, byArray2, 0);
    }

    public byte[] doSymDecryptByDevice(byte[] byArray, int n, byte[] byArray2) {
        return this.doSymDecrypt(n, byArray, byArray2, 0);
    }

    public byte[] doRSADecryptWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        return this.decryptByPrivateKey(keyPair.getPrivate(), byArray);
    }

    public byte[] doSM2DecryptWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        byArray = shecaUtils.toAsn1DecodeWithSM2Cipher(byArray);
        return this.sm2Decrypt(byArray, keyPair.getPrivate());
    }

    public byte[] encodePKCS7EnveloperByDevice(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = null;
        if (257 != n) {
            byArray3 = 1025 == n ? this.encodeEnveloper(byArray2, n, byArray) : javasafeengine.genPKCS7enveloperWithCert(byArray, byArray2, n);
        }
        return byArray3;
    }

    public byte[] decodePKCS7EnveloperWithDeviceKeyPair(KeyPair object, byte[] object2) {
        byte[] byArray = null;
        try {
            if (((KeyPair)object).getPublic().getAlgorithm().equalsIgnoreCase("RSA") || ((KeyPair)object).getPublic().getAlgorithm().indexOf("ECDSA") > 0) {
                CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(object2);
                object2 = cMSEnvelopedData;
                Iterator iterator = cMSEnvelopedData.getRecipientInfos().iterator();
                if (iterator.hasNext()) {
                    iterator = (RecipientInformation)iterator.next();
                    byArray = iterator.getContent((Recipient)new JceKeyTransEnvelopedRecipient(((KeyPair)object).getPrivate()).setProvider("SwxaJCE"));
                }
            } else {
                shecaEnvelopeStructure shecaEnvelopeStructure2 = this.parseEnveloper((byte[])object2);
                object2 = shecaEnvelopeStructure2;
                if (shecaEnvelopeStructure2.retCode == 0 && object2.asymAlgoID == 131328) {
                    byte[] byArray2 = object2.symkeyCipher;
                    if (object2.symkeyCipher != null) {
                        byArray2 = shecaUtils.toAsn1DecodeWithSM2Cipher(byArray2);
                        byte[] byArray3 = this.sm2Decrypt(byArray2, ((KeyPair)object).getPrivate());
                        object = byArray3;
                        if (byArray3 != null) {
                            byArray = this.doSymDecrypt(object2.symAlgoID, object2.cipherText, (byte[])object, 0);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] doSM2SM2signWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            JcaContentSignerBuilder jcaContentSignerBuilder = shecaLocalStd.a(keyPair.getPublic());
            keyPair = jcaContentSignerBuilder.build(keyPair.getPrivate());
            jcaContentSignerBuilder = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            jcaContentSignerBuilder.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build((ContentSigner)keyPair, (X509CertificateHolder)object));
            keyPair = new CMSProcessableByteArray(byArray);
            keyPair = jcaContentSignerBuilder.generate((CMSTypedData)keyPair, false);
            keyPair = new DEROctetString((ASN1Encodable)keyPair.toASN1Structure().toASN1Primitive());
            byArray2 = keyPair.getOctets();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSAPKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, int n, boolean bl) {
        byte[] byArray2 = null;
        try {
            String string = javasafeengine.getAlgNameWithAlgID(n);
            serializable = new JcaContentSignerBuilder(string).setProvider("BC").build(serializable.getPrivate());
            string = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            string.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            string.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = string.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSM2PKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, boolean bl) {
        byte[] byArray2 = null;
        try {
            JcaContentSignerBuilder jcaContentSignerBuilder = shecaLocalStd.a(serializable.getPublic());
            serializable = jcaContentSignerBuilder.build(serializable.getPrivate());
            jcaContentSignerBuilder = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            jcaContentSignerBuilder.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            jcaContentSignerBuilder.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = jcaContentSignerBuilder.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doECCPKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, int n, boolean bl) {
        byte[] byArray2 = null;
        try {
            String string = javasafeengine.getAlgNameWithAlgID(n);
            serializable = new JcaContentSignerBuilder(string).setProvider("BC").build(serializable.getPrivate());
            string = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            string.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            string.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = string.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSASignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n) {
        return shecaLocalStd.b(keyPair.getPrivate(), byArray, javasafeengine.getAlgNameWithAlgID(n));
    }

    public byte[] doSM2SignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        return this.signWithSM2PrivateKey(keyPair.getPrivate(), byArray);
    }

    public byte[] generateRSACertWithDeviceKeyPair(KeyPair serializable, byte[] object, int n, String string) {
        byte[] byArray = null;
        try {
            PrivateKey privateKey = serializable.getPrivate();
            PublicKey publicKey = serializable.getPublic();
            serializable = object == null ? serializable.getPublic() : shecaLocalStd.getRSAPublicKey(object);
            serializable = shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, publicKey, (PublicKey)serializable);
            object = javasafeengine.getAlgNameWithAlgID(n);
            object = new JcaContentSignerBuilder((String)object).setProvider("BC").build(privateKey);
            serializable = serializable.build((ContentSigner)object);
            byArray = serializable.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CertWithDeviceKeyPair(KeyPair keyPair, byte[] object, String string) {
        byte[] byArray = null;
        try {
            Object object2;
            Object object3;
            if (object == null) {
                object3 = shecaLocalStd.getSM2PublicKey(keyPair.getPublic());
                object2 = shecaUtils.toAsn1EncodeWithSM2Pubkey(object3);
                shcaSM2PublicKey shcaSM2PublicKey2 = new shcaSM2PublicKey((byte[])object2);
                object = shcaSM2PublicKey2;
                object = shcaSM2PublicKey2;
            } else {
                object3 = shecaUtils.toAsn1EncodeWithSM2Pubkey(object);
                shcaSM2PublicKey shcaSM2PublicKey3 = new shcaSM2PublicKey((byte[])object3);
                object2 = shcaSM2PublicKey3;
                object = shcaSM2PublicKey3;
            }
            object3 = keyPair.getPrivate();
            object2 = keyPair.getPublic();
            object = shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, (PublicKey)object2, (PublicKey)object);
            keyPair = shecaLocalStd.a((PublicKey)object2);
            keyPair = keyPair.build((PrivateKey)object3);
            keyPair = object.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateECCCertWithDeviceKeyPair(KeyPair serializable, byte[] object, int n, String string) {
        byte[] byArray = null;
        try {
            PrivateKey privateKey = ((KeyPair)serializable).getPrivate();
            PublicKey publicKey = ((KeyPair)serializable).getPublic();
            serializable = object == null ? ((KeyPair)serializable).getPublic() : shecaLocalStd.getECCPublicKey(object);
            serializable = shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, publicKey, (PublicKey)serializable);
            object = javasafeengine.getAlgNameWithAlgID(n);
            JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder((String)object);
            object = jcaContentSignerBuilder;
            jcaContentSignerBuilder.setProvider("BC");
            object = object.build(privateKey);
            serializable = serializable.build((ContentSigner)object);
            byArray = serializable.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    private static byte[] a(PrivateKey serializable, byte[] byArray, String object) {
        byte[] byArray2 = null;
        try {
            Provider provider = Security.getProvider("BC");
            object = Signature.getInstance((String)object, provider);
            ((Signature)object).initSign((PrivateKey)serializable);
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    private static byte[] b(PrivateKey serializable, byte[] byArray, String object) {
        byte[] byArray2 = null;
        try {
            Provider provider = Security.getProvider("BC");
            object = Signature.getInstance((String)object, provider);
            ((Signature)object).initSign((PrivateKey)serializable);
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] signWithRSAPrivateKey(byte[] byArray, byte[] byArray2, String string) {
        return shecaLocalStd.b(this.getRSAPrivateKey(byArray), byArray2, string);
    }

    public byte[] signWithSM2PrivateKey(PrivateKey privateKey, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            SM2ParameterSpec sM2ParameterSpec = new SM2ParameterSpec("1234567812345678".getBytes());
            Signature signature = Signature.getInstance("SM3withSM2", "BC");
            signature.setParameter((AlgorithmParameterSpec)sM2ParameterSpec);
            signature.initSign(privateKey, new SecureRandom());
            signature.update(byArray, 0, byArray.length);
            byArray2 = signature.sign();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSASignWithDeviceKeyPairByStream(KeyPair object, InputStream inputStream, int n) {
        byte[] byArray = null;
        try {
            int n2;
            Provider provider = Security.getProvider("BC");
            Signature signature = Signature.getInstance(shecaLocalStd.getAlgNameWithAlgID(n), provider);
            signature.initSign(((KeyPair)object).getPrivate());
            object = new byte[0x100000];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                signature.update((byte[])object, 0, n2);
            }
            byArray = signature.sign();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] doSM2SignWithDeviceKeyPairByStream(KeyPair object, InputStream inputStream) {
        byte[] byArray = null;
        try {
            int n;
            SM2ParameterSpec sM2ParameterSpec = new SM2ParameterSpec("1234567812345678".getBytes());
            Signature signature = Signature.getInstance("SM3withSM2", "BC");
            signature.setParameter((AlgorithmParameterSpec)sM2ParameterSpec);
            signature.initSign(((KeyPair)object).getPrivate(), new SecureRandom());
            object = new byte[0x100000];
            while ((n = inputStream.read((byte[])object)) != -1) {
                signature.update((byte[])object, 0, n);
            }
            byArray = signature.sign();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSACsrWithDeviceKeyPair(KeyPair object, int n, String object2) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            object2 = new X500Principal((String)object2);
            object2 = shecaCsrUtils2.makeCertReqInfo((X500Principal)object2, ((KeyPair)object).getPublic());
            byte[] byArray2 = object2.getEncoded();
            String string = javasafeengine.getAlgNameWithAlgID(n);
            byte[] byArray3 = shecaLocalStd.b(((KeyPair)object).getPrivate(), byArray2, string);
            object = byArray3;
            if (byArray3 != null) {
                object = new DERBitString((byte[])object);
                AlgorithmIdentifier algorithmIdentifier = shecaCsrUtils2.makeCertReqAlgo(n);
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)object2, algorithmIdentifier, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CsrWithDeviceKeyPair(KeyPair object, String string) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            Object object2 = javasafeengine.getSM2PublicKey(((KeyPair)object).getPublic());
            object2 = shecaUtils.toAsn1EncodeWithSM2Pubkey(object2);
            string = shecaCsrUtils2.makeSM2CertReqInfo(string, (byte[])object2);
            object2 = string.getEncoded();
            byte[] byArray2 = this.signWithSM2PrivateKey(((KeyPair)object).getPrivate(), (byte[])object2);
            object = byArray2;
            if (byArray2 != null) {
                object = shecaCsrUtils2.makeSM2CertReqSign((byte[])object);
                object2 = shecaCsrUtils2.makeSM2CertReqAlgo();
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)string, (AlgorithmIdentifier)object2, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateECCCsrWithDeviceKeyPair(KeyPair object, int n, String object2) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            object2 = new X500Principal((String)object2);
            object2 = shecaCsrUtils2.makeCertReqInfo((X500Principal)object2, ((KeyPair)object).getPublic());
            byte[] byArray2 = object2.getEncoded();
            String string = javasafeengine.getAlgNameWithAlgID(n);
            byte[] byArray3 = shecaLocalStd.a(((KeyPair)object).getPrivate(), byArray2, string);
            object = byArray3;
            if (byArray3 != null) {
                object = new DERBitString((byte[])object);
                AlgorithmIdentifier algorithmIdentifier = shecaCsrUtils2.makeCertReqAlgo(n);
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)object2, algorithmIdentifier, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSACrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, int n, String string) {
        byte[] byArray = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)shecaLocalStd.getCertificateFromBuffer(object);
            object = x509Certificate;
            object = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            keyPair = new JcaContentSignerBuilder(string2).setProvider("BC").build(keyPair.getPrivate());
            keyPair = object.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, String string) {
        byte[] byArray = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)shecaLocalStd.getCertificateFromBuffer(object);
            object = x509Certificate;
            object = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            string = shecaLocalStd.a(keyPair.getPublic());
            keyPair = string.build(keyPair.getPrivate());
            keyPair = object.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateECCCrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, int n, String string) {
        byte[] byArray = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)shecaLocalStd.getCertificateFromBuffer(object);
            object = x509Certificate;
            object = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            keyPair = new JcaContentSignerBuilder(string2).setProvider("BC").build(keyPair.getPrivate());
            keyPair = object.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSAocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] object2, int n, String string) {
        byte[] byArray = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, object2);
                object2 = javasafeengine.getAlgNameWithAlgID(n);
                keyPair = new JcaContentSignerBuilder((String)object2).setProvider("BC").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2ocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] object2, String string) {
        byte[] byArray = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, object2);
                JcaContentSignerBuilder jcaContentSignerBuilder = shecaLocalStd.a(keyPair.getPublic());
                object2 = jcaContentSignerBuilder;
                keyPair = jcaContentSignerBuilder.build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateECCocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] object2, int n, String string) {
        byte[] byArray = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, object2);
                object2 = javasafeengine.getAlgNameWithAlgID(n);
                keyPair = new JcaContentSignerBuilder((String)object2).setProvider("BC").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSACrlWithDeviceKeyPairByPreviousCrlPath(KeyPair serializable, byte[] byArray, int n, String string, String string2) {
        byte[] byArray2 = null;
        try {
            String string3 = javasafeengine.getAlgNameWithAlgID(n);
            string3 = new JcaContentSignerBuilder(string3).setProvider("BC").build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer(byArray);
            serializable = shecaX509v2CRLBuilder.genX509v2CRLBuilderByFullSizeCrl(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                serializable = serializable.build((ContentSigner)string3);
                byArray2 = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] generateRSACrlWithDeviceKeyPairByHistoryCrlFolder(KeyPair serializable, byte[] object, int n, String string, String string2) {
        byte[] byArray = null;
        try {
            String string3 = javasafeengine.getAlgNameWithAlgID(n);
            string3 = new JcaContentSignerBuilder(string3).setProvider("BC").build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
            shecaX509v2CRLBuilder shecaX509v2CRLBuilder2 = new shecaX509v2CRLBuilder();
            object = shecaX509v2CRLBuilder2;
            serializable = shecaX509v2CRLBuilder2.genX509v2CRLBuilderByCrlList(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                serializable = serializable.build((ContentSigner)string3);
                byArray = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CrlWithDeviceKeyPairByPreviousCrlPath(KeyPair serializable, byte[] byArray, String string, String string2) {
        byte[] byArray2 = null;
        try {
            JcaContentSignerBuilder jcaContentSignerBuilder = shecaLocalStd.a(serializable.getPublic());
            jcaContentSignerBuilder = jcaContentSignerBuilder.build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer(byArray);
            serializable = shecaX509v2CRLBuilder.genX509v2CRLBuilderByFullSizeCrl(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                shecaUtils.logger_info(b, "build crl by datech.");
                serializable = serializable.build((ContentSigner)jcaContentSignerBuilder);
                byArray2 = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] generateSM2CrlWithDeviceKeyPairByHistoryCrlFolder(KeyPair serializable, byte[] object, String string, String string2) {
        byte[] byArray = null;
        try {
            JcaContentSignerBuilder jcaContentSignerBuilder = shecaLocalStd.a(serializable.getPublic());
            jcaContentSignerBuilder = jcaContentSignerBuilder.build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer((byte[])object);
            object = new shecaX509v2CRLBuilder();
            shecaUtils.logger_info(b, "genX509v2CRLBuilderByCrlList start in local device.");
            serializable = ((shecaX509v2CRLBuilder)object).genX509v2CRLBuilderByCrlList(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                shecaUtils.logger_info(b, "build crl by local device.");
                serializable = serializable.build((ContentSigner)jcaContentSignerBuilder);
                byArray = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] decodeRSAEnveloperBySHECAStandard(KeyPair object, byte[] object2, int n) {
        byte[] byArray = null;
        shecaEnvelopeStructure shecaEnvelopeStructure2 = this.parseEnveloperBySHECAStandard((KeyPair)object, (byte[])object2, n);
        object2 = shecaEnvelopeStructure2;
        if (shecaEnvelopeStructure2.retCode == 0) {
            byte[] byArray2 = this.decryptByPrivateKey(((KeyPair)object).getPrivate(), object2.symkeyCipher);
            object = byArray2;
            if (byArray2 != null) {
                byArray = this.doSymDecrypt(object2.symAlgoID, object2.cipherText, (byte[])object, 0);
            }
        }
        return byArray;
    }

    public byte[] decodeRSAEnveloperBySHECAStandard(PrivateKey object, int n, byte[] byArray, int n2) {
        byte[] byArray2 = null;
        shecaEnvelopeStructure shecaEnvelopeStructure2 = this.parseEnveloperBySHECAStandard(n, byArray, n2);
        if (shecaEnvelopeStructure2.retCode == 0) {
            byte[] byArray3 = this.decryptByPrivateKey((PrivateKey)object, shecaEnvelopeStructure2.symkeyCipher);
            object = byArray3;
            if (byArray3 != null) {
                byArray2 = this.doSymDecrypt(shecaEnvelopeStructure2.symAlgoID, shecaEnvelopeStructure2.cipherText, (byte[])object, 0);
            }
        }
        return byArray2;
    }

    public byte[] decodeRSAEnveloperBySHECAStandard(String object, int n, byte[] byArray, int n2) {
        byte[] byArray2 = null;
        System.out.println("decodeRSAEnveloperBySHECAStandard start...");
        shecaEnvelopeStructure shecaEnvelopeStructure2 = this.parseEnveloperBySHECAStandard(n, byArray, n2);
        if (shecaEnvelopeStructure2.retCode == 0) {
            System.out.println("parseEnveloperBySHECAStandard completed.");
            byte[] byArray3 = javasafeengine.b64tohex((String)object);
            object = byArray3;
            if (byArray3 == null) {
                System.out.println("param prikeyB64 is error.");
            }
            shecaLocalStd shecaLocalStd2 = this;
            byte[] byArray4 = shecaLocalStd2.decryptByPrivateKeyWithSunJCE(shecaLocalStd2.getRSAPrivateKey((byte[])object), shecaEnvelopeStructure2.symkeyCipher);
            object = byArray4;
            if (byArray4 != null) {
                System.out.println("decryptByPrivateKey completed.");
                byArray2 = this.doSymDecrypt(shecaEnvelopeStructure2.symAlgoID, shecaEnvelopeStructure2.cipherText, (byte[])object, 0);
                if (byArray2 == null) {
                    System.out.println("doSymDecrypt error.");
                }
            } else {
                System.out.println("decryptByPrivateKey error.");
            }
        } else {
            System.out.println("param parseEnveloperBySHECAStandard is error.");
        }
        return byArray2;
    }

    public byte[] genrateRSAtimeStampResWithDeviceKeyPair(KeyPair object, byte[] byArray, byte[] byArray2, Date date, int n, String string) {
        String string2 = javasafeengine.getAlgNameWithAlgID(n);
        try {
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build());
            object = new JcaContentSignerBuilder(string2).setProvider("BC").build(((KeyPair)object).getPrivate());
            object = shecaTimeStampBuilder.getShecaRsaTsTokenGenerator(jcaSignerInfoGeneratorBuilder, (ContentSigner)object, byArray2, string);
            object = shecaTimeStampBuilder.buildShecaRsaTsResp((TimeStampTokenGenerator)object, byArray, string, date);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            object = shecaTimeStampBuilder.genShecaRejectedTimeStamp(exception);
        }
        return object;
    }

    public byte[] genrateSM2timeStampResWithDeviceKeyPair(KeyPair object, byte[] byArray, byte[] byArray2, Date date, String string) {
        try {
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build());
            JcaContentSignerBuilder jcaContentSignerBuilder = shecaLocalStd.a(((KeyPair)object).getPublic());
            object = jcaContentSignerBuilder.build(((KeyPair)object).getPrivate());
            object = shecaTimeStampBuilder.getShecaRsaTsTokenGenerator(jcaSignerInfoGeneratorBuilder, (ContentSigner)object, byArray2, string);
            object = shecaTimeStampBuilder.buildShecaRsaTsResp((TimeStampTokenGenerator)object, byArray, string, date);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            object = shecaTimeStampBuilder.genShecaRejectedTimeStamp(exception);
        }
        return object;
    }

    public byte[] doECCSignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n) {
        String string = javasafeengine.getAlgNameWithAlgID(n);
        return shecaLocalStd.a(keyPair.getPrivate(), byArray, string);
    }

    public byte[] genrateECCtimeStampResWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, byte[] byArray2, Date date, int n, String string) {
        return null;
    }

    public byte[] genSM2EncEnvelopedKeyBlobWithCert(byte[] object, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            Object object2 = new shcaSM2PrivateKey(byArray, 0);
            byArray = ((shcaSM2PrivateKey)object2).getD_Bytes();
            object2 = ((shcaSM2PrivateKey)object2).getPublicKeyBytes();
            byte[] byArray3 = this.genRandomBytes(16);
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.156.10197.1.104.1"));
            aSN1EncodableVector2.add((ASN1Encodable)DERNull.INSTANCE);
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            X509Certificate x509Certificate = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
            object = x509Certificate;
            object = x509Certificate.getPublicKey();
            aSN1EncodableVector.add((ASN1Encodable)shecaUtils.toAns1WithSM2Cipher(javasafeengine.sm2Encrypt(byArray3, (PublicKey)object)));
            object = javasafeengine.doSymmetricAlgoWithAlgName("SM4/ECB/NoPadding", true, byArray3, byArray);
            aSN1EncodableVector.add((ASN1Encodable)new DERBitString((byte[])object2));
            aSN1EncodableVector.add((ASN1Encodable)new DERBitString(object));
            byArray2 = new DERSequence(aSN1EncodableVector).getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] genRSAEncEnvelopedKeyBlobWithCert(byte[] byArray, String object, byte[] object2, byte[] byArray2) {
        byArray = null;
        object = ((String)object).toUpperCase().indexOf("CBC") > 0 ? this.genRandomBytes(8) : null;
        byte[] byArray3 = this.genRandomBytes(24);
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])object2);
            object2 = aSN1Sequence;
            if (aSN1Sequence.size() > 2) {
                ASN1OctetString aSN1OctetString = (ASN1OctetString)object2.getObjectAt(2);
                object2 = aSN1OctetString;
                object2 = aSN1OctetString.getOctets();
                if (object2 != null) {
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    Object object3 = new ASN1EncodableVector();
                    object3.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.3.7"));
                    if (object != null) {
                        object3.add((ASN1Encodable)new DEROctetString((byte[])object));
                    } else {
                        object3.add((ASN1Encodable)DERNull.INSTANCE);
                    }
                    aSN1EncodableVector.add((ASN1Encodable)new DERSequence(object3));
                    object3 = javasafeengine.encryptByPublicKey(shecaLocalStd.getRSAPublicKey(byArray2), byArray3);
                    aSN1EncodableVector.add((ASN1Encodable)new DERBitString((byte[])object3));
                    aSN1EncodableVector.add((ASN1Encodable)ASN1Sequence.fromByteArray((byte[])byArray2));
                    object = shecaLocalStd.doSymmetricAlgoWithAlgName("DESede/CBC/PKCS5Padding", (byte[])object, true, byArray3, object2);
                    aSN1EncodableVector.add((ASN1Encodable)new DERBitString((byte[])object));
                    byArray = new DERSequence(aSN1EncodableVector).getEncoded();
                }
            }
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }
}

