/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.cryptoDevice;

import com.sheca.cryptoDevice.shecaCryptoDevice;
import com.sheca.safeengine.javasafeengine;
import com.sheca.safeengine.shcaSM2PublicKey;
import com.sheca.safeengine.shecaCsrUtils;
import com.sheca.safeengine.shecaEnvelopeStructure;
import com.sheca.safeengine.shecaOcspBuilder;
import com.sheca.safeengine.shecaTimeStampBuilder;
import com.sheca.safeengine.shecaUtils;
import com.sheca.safeengine.shecaX509v2CRLBuilder;
import com.sheca.safeengine.shecaX509v3CertBuilder;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.Store;
import org.json.JSONObject;

public class shecaSwxaStd
extends javasafeengine
implements shecaCryptoDevice {
    private static Logger a = null;
    private static shecaSwxaStd b = null;

    public shecaSwxaStd() {
        if (a == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                a = Logger.getLogger(shecaSwxaStd.class);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                a = null;
                classNotFoundException.printStackTrace();
            }
        }
    }

    public static shecaSwxaStd getInstance() {
        if (b == null) {
            b = new shecaSwxaStd();
        }
        return b;
    }

    public byte[] genRandomBytesByDevice(int n, int n2) {
        byte[] byArray = null;
        int n3 = 0;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("RND", "SwxaJCE");
            if (n2 > 1024) {
                byArray = new byte[n2];
                while (n3 < n2) {
                    byte[] byArray2 = secureRandom.generateSeed(1024);
                    System.arraycopy(byArray2, 0, byArray, n3, 1024);
                    n3 += 1024;
                }
            } else {
                byArray = secureRandom.generateSeed(n2);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] doSymEncryptByDevice(byte[] byArray, int n, byte[] object) {
        byte[] byArray2 = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("RND", "SwxaJCE");
            if (257 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SM1");
                Cipher cipher = Cipher.getInstance("SM1/ECB/PKCS5Padding", "SwxaJCE");
                object = cipher;
                cipher.init(1, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else if (513 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SSF33");
                Cipher cipher = Cipher.getInstance("SSF33/ECB/PKCS5Padding", "SwxaJCE");
                object = cipher;
                cipher.init(1, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else {
                byArray2 = this.doSymEncrypt(n, byArray, (byte[])object, 0);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSymDecryptByDevice(byte[] byArray, int n, byte[] object) {
        byte[] byArray2 = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("RND", "SwxaJCE");
            if (257 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SM1");
                Cipher cipher = Cipher.getInstance("SM1/ECB/PKCS5Padding", "SwxaJCE");
                object = cipher;
                cipher.init(2, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else if (513 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SSF33");
                Cipher cipher = Cipher.getInstance("SSF33/ECB/PKCS5Padding", "SwxaJCE");
                object = cipher;
                cipher.init(2, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else {
                byArray2 = this.doSymDecrypt(n, byArray, (byte[])object, 0);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public int calcDeviceSM2signIndexFromGmSM2Index(int n) {
        return 0;
    }

    public int calcDeviceSM2encryptIndexFromGmSM2Index(int n) {
        return 0;
    }

    public int calcRSAsignIndexFromCryptoDevice(int n) {
        return (n << 1) - 1;
    }

    public int calcRSAencryptIndexFromCryptoDevice(int n) {
        return n << 1;
    }

    public int calcSM2signIndexFromCryptoDevice(int n) {
        return this.calcRSAsignIndexFromCryptoDevice(n);
    }

    public int calcSM2encryptIndexFromCryptoDevice(int n) {
        return this.calcRSAencryptIndexFromCryptoDevice(n);
    }

    public int calcECCsignIndexFromCryptoDevice(int n) {
        return this.calcRSAsignIndexFromCryptoDevice(n);
    }

    public int calcECCencryptIndexFromCryptoDevice(int n) {
        return this.calcRSAencryptIndexFromCryptoDevice(n);
    }

    public KeyPair genRSAKeyPairFromCryptoDevice(String string, int n) {
        return null;
    }

    public KeyPair genRSAKeyPairFromCryptoDevice(int n, int n2) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "SwxaJCE");
            keyPairGenerator.initialize(n << 16);
            keyPair = keyPairGenerator.genKeyPair();
        }
        catch (Exception exception) {
            shecaLastErrorCode = -1;
            exception.printStackTrace();
        }
        return keyPair;
    }

    public KeyPair genSM2KeyPairFromCryptoDevice(int n) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("SM2", "SwxaJCE");
            keyPairGenerator.initialize(n << 16);
            keyPair = keyPairGenerator.genKeyPair();
        }
        catch (Exception exception) {
            shecaLastErrorCode = -1;
            exception.printStackTrace();
        }
        return keyPair;
    }

    public KeyPair genECCKeyPairFromCryptoDevice(int n, int n2) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "SwxaJCE");
            keyPairGenerator.initialize(n << 16);
            keyPair = keyPairGenerator.genKeyPair();
        }
        catch (Exception exception) {
            shecaLastErrorCode = -1;
            exception.printStackTrace();
        }
        return keyPair;
    }

    public byte[] generateRSACsrWithDeviceKeyPair(KeyPair object, int n, String object2) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            object2 = new X500Principal((String)object2);
            object2 = shecaCsrUtils2.makeCertReqInfo((X500Principal)object2, ((KeyPair)object).getPublic());
            byte[] byArray2 = object2.getEncoded();
            byte[] byArray3 = this.doRSASignWithDeviceKeyPair((KeyPair)object, byArray2, n);
            object = byArray3;
            if (byArray3 != null) {
                object = new DERBitString((byte[])object);
                AlgorithmIdentifier algorithmIdentifier = shecaCsrUtils2.makeCertReqAlgo(n);
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)object2, algorithmIdentifier, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CsrWithDeviceKeyPair(KeyPair object, String string) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            Object object2 = ((KeyPair)object).getPublic().getEncoded();
            string = shecaCsrUtils2.makeSM2CertReqInfo(string, (byte[])object2);
            object2 = string.getEncoded();
            byte[] byArray2 = this.doSM2SignWithDeviceKeyPair((KeyPair)object, (byte[])object2);
            object = byArray2;
            if (byArray2 != null) {
                object = shecaCsrUtils2.makeSM2CertReqSign((byte[])object);
                object2 = shecaCsrUtils2.makeSM2CertReqAlgo();
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)string, (AlgorithmIdentifier)object2, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateECCCsrWithDeviceKeyPair(KeyPair object, int n, String object2) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            object2 = new X500Principal((String)object2);
            object2 = shecaCsrUtils2.makeCertReqInfo((X500Principal)object2, ((KeyPair)object).getPublic());
            byte[] byArray2 = object2.getEncoded();
            byte[] byArray3 = this.doECCSignWithDeviceKeyPair((KeyPair)object, byArray2, n);
            object = byArray3;
            if (byArray3 != null) {
                object = new DERBitString((byte[])object);
                AlgorithmIdentifier algorithmIdentifier = shecaCsrUtils2.makeCertReqAlgo(n);
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)object2, algorithmIdentifier, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSACertWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n, String string) {
        byte[] byArray2 = null;
        try {
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            string2 = new JcaContentSignerBuilder(string2).setProvider("SwxaJCE").build(keyPair.getPrivate());
            keyPair = byArray != null ? shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, keyPair.getPublic(), shecaSwxaStd.getRSAPublicKey(byArray)) : shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, null, keyPair.getPublic());
            keyPair = keyPair.build((ContentSigner)string2);
            byArray2 = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] generateSM2CertWithDeviceKeyPair(KeyPair keyPair, byte[] object, String string) {
        byte[] byArray = null;
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SM3withSM2").setProvider("SwxaJCE").build(keyPair.getPrivate());
            if (object != null) {
                object = shecaUtils.toAsn1EncodeWithSM2Pubkey(object);
                shcaSM2PublicKey shcaSM2PublicKey2 = new shcaSM2PublicKey((byte[])object);
                object = shcaSM2PublicKey2;
                object = shcaSM2PublicKey2;
                keyPair = shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, keyPair.getPublic(), (PublicKey)object);
            } else {
                object = keyPair.getPublic();
                keyPair = shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, null, (PublicKey)object);
            }
            X509CertificateHolder x509CertificateHolder = keyPair.build(contentSigner);
            object = x509CertificateHolder;
            byArray = x509CertificateHolder.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateECCCertWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n, String string) {
        byte[] byArray2 = null;
        try {
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            string2 = new JcaContentSignerBuilder(string2).setProvider("SwxaJCE").build(keyPair.getPrivate());
            keyPair = byArray != null ? shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, keyPair.getPublic(), shecaSwxaStd.getECCPublicKey(byArray)) : shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, null, keyPair.getPublic());
            keyPair = keyPair.build((ContentSigner)string2);
            byArray2 = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSADecryptWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "SwxaJCE");
            cipher.init(2, keyPair.getPrivate());
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSM2DecryptWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("SM2", "SwxaJCE");
            cipher.init(2, keyPair.getPrivate());
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    private static byte[] a(byte[] object, byte[] object2, int n) {
        byte[] byArray = null;
        object2 = new CMSProcessableByteArray(object2);
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        object = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
        cMSEnvelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator((X509Certificate)object).setProvider("SwxaJCE"));
        if (8 != n) {
            shecaUtils.logger_info(a, "algo:" + n + " is not support.");
            return null;
        }
        object = CMSAlgorithm.AES128_CBC;
        try {
            object = cMSEnvelopedDataGenerator.generate((CMSTypedData)object2, new JceCMSContentEncryptorBuilder((ASN1ObjectIdentifier)object).setProvider("SwxaJCE").build());
            DEROctetString dEROctetString = new DEROctetString((ASN1Encodable)object.toASN1Structure().toASN1Primitive());
            object = dEROctetString;
            byArray = dEROctetString.getOctets();
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] encodePKCS7EnveloperByDevice(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = null;
        if (shecaSwxaStd.getPublicKeyWithCert(byArray).getAlgorithm().equalsIgnoreCase("RSA") && n != 1025) {
            byArray3 = shecaSwxaStd.a(byArray, byArray2, n);
        } else if (shecaSwxaStd.getPublicKeyWithCert(byArray).getAlgorithm().equalsIgnoreCase("EC") && n == 1025) {
            byArray3 = this.encodeEnveloper(byArray2, 1025, byArray);
        } else if (shecaSwxaStd.getPublicKeyWithCert(byArray).getAlgorithm().indexOf("ECDSA") > 0 && n != 1025) {
            byArray3 = shecaSwxaStd.a(byArray, byArray2, n);
        }
        return byArray3;
    }

    public byte[] decodePKCS7EnveloperWithDeviceKeyPair(KeyPair keyPair, byte[] object) {
        byte[] byArray = null;
        try {
            if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("RSA") || keyPair.getPublic().getAlgorithm().indexOf("ECDSA") > 0) {
                CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData((byte[])object);
                object = cMSEnvelopedData;
                Iterator iterator = cMSEnvelopedData.getRecipientInfos().iterator();
                object = iterator;
                if (iterator.hasNext()) {
                    object = (RecipientInformation)object.next();
                    byArray = object.getContent((Recipient)new JceKeyTransEnvelopedRecipient(keyPair.getPrivate()).setProvider("SwxaJCE"));
                }
            } else {
                shecaEnvelopeStructure shecaEnvelopeStructure2 = this.parseEnveloper((byte[])object);
                object = shecaEnvelopeStructure2;
                if (shecaEnvelopeStructure2.retCode == 0 && ((shecaEnvelopeStructure)object).asymAlgoID == 131328) {
                    byArray = this.doSymDecryptByDevice(((shecaEnvelopeStructure)object).cipherText, ((shecaEnvelopeStructure)object).symAlgoID, this.doSM2DecryptWithDeviceKeyPair(keyPair, ((shecaEnvelopeStructure)object).symkeyCipher));
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    private static String a(int n) {
        String string = "";
        if (n == 65538) {
            string = "SHA1WithRSA";
        } else if (n == 65540) {
            string = "SHA256WithRSA";
        } else if (n == 65541) {
            string = "SHA384WithRSA";
        } else if (n == 65542) {
            string = "SHA512WithRSA";
        } else if (n == 524290) {
            string = "SHA224WITHECDSA";
        } else if (n == 524292) {
            string = "SHA256WITHECDSA";
        } else if (n == 524293) {
            string = "SHA384WITHECDSA";
        } else if (n == 524294) {
            string = "SHA512WITHECDSA";
        }
        return string;
    }

    public byte[] doRSASignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n) {
        byte[] byArray2 = null;
        Object object = shecaSwxaStd.a(n);
        try {
            object = Signature.getInstance((String)object, "SwxaJCE");
            ((Signature)object).initSign(keyPair.getPrivate());
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSM2SignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Signature signature = Signature.getInstance("SM3withSM2", "SwxaJCE");
            signature.initSign(keyPair.getPrivate());
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doECCSignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n) {
        byte[] byArray2 = null;
        Object object = shecaSwxaStd.a(n);
        try {
            object = Signature.getInstance((String)object, "SwxaJCE");
            ((Signature)object).initSign(keyPair.getPrivate());
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSAPKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, int n, boolean bl) {
        byte[] byArray2 = null;
        try {
            String string = javasafeengine.getAlgNameWithAlgID(n);
            serializable = new JcaContentSignerBuilder(string).setProvider("SwxaJCE").build(serializable.getPrivate());
            string = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            string.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("SwxaJCE").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            string.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = string.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSM2PKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, boolean bl) {
        byte[] byArray2 = null;
        try {
            serializable = new JcaContentSignerBuilder("SM3withSM2").setProvider("SwxaJCE").build(((KeyPair)serializable).getPrivate());
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("SwxaJCE").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            cMSSignedDataGenerator.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = cMSSignedDataGenerator.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doECCPKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, int n, boolean bl) {
        byte[] byArray2 = null;
        try {
            String string = javasafeengine.getAlgNameWithAlgID(n);
            serializable = new JcaContentSignerBuilder(string).setProvider("SwxaJCE").build(serializable.getPrivate());
            string = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            string.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("SwxaJCE").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            string.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = string.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSASignWithDeviceKeyPairByStream(KeyPair keyPair, InputStream inputStream, int n) {
        return null;
    }

    public byte[] doSM2SignWithDeviceKeyPairByStream(KeyPair keyPair, InputStream inputStream) {
        return null;
    }

    public byte[] generateRSACrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, int n, String string) {
        byte[] byArray = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)shecaSwxaStd.getCertificateFromBuffer(object);
            object = x509Certificate;
            object = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            keyPair = new JcaContentSignerBuilder(string2).setProvider("SwxaJCE").build(keyPair.getPrivate());
            keyPair = object.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSACrlWithDeviceKeyPairByPreviousCrlPath(KeyPair keyPair, byte[] byArray, int n, String string, String string2) {
        return null;
    }

    public byte[] generateRSACrlWithDeviceKeyPairByHistoryCrlFolder(KeyPair keyPair, byte[] byArray, int n, String string, String string2) {
        return null;
    }

    public byte[] generateSM2CrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, String string) {
        byte[] byArray = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)shecaSwxaStd.getCertificateFromBuffer(object);
            object = x509Certificate;
            object = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            keyPair = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(keyPair.getPrivate());
            keyPair = object.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CrlWithDeviceKeyPairByPreviousCrlPath(KeyPair keyPair, byte[] byArray, String string, String string2) {
        return null;
    }

    public byte[] generateECCCrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, int n, String string) {
        byte[] byArray = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)shecaSwxaStd.getCertificateFromBuffer(object);
            object = x509Certificate;
            object = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            keyPair = new JcaContentSignerBuilder(string2).setProvider("SwxaJCE").build(keyPair.getPrivate());
            keyPair = object.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CrlWithDeviceKeyPairByHistoryCrlFolder(KeyPair keyPair, byte[] byArray, String string, String string2) {
        return null;
    }

    public byte[] generateRSAocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] object2, int n, String string) {
        byte[] byArray = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, object2);
                object2 = javasafeengine.getAlgNameWithAlgID(n);
                keyPair = new JcaContentSignerBuilder((String)object2).setProvider("SwxaJCE").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2ocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, byArray);
                keyPair = new JcaContentSignerBuilder("SM3withSM2").setProvider("SwxaJCE").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray2 = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] generateECCocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] object2, int n, String string) {
        byte[] byArray = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, object2);
                object2 = javasafeengine.getAlgNameWithAlgID(n);
                keyPair = new JcaContentSignerBuilder((String)object2).setProvider("SwxaJCE").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, null, new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] genrateRSAtimeStampResWithDeviceKeyPair(KeyPair object, byte[] byArray, byte[] byArray2, Date date, int n, String string) {
        String string2 = javasafeengine.getAlgNameWithAlgID(n);
        try {
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("SwxaJCE").build());
            object = new JcaContentSignerBuilder(string2).setProvider("SwxaJCE").build(((KeyPair)object).getPrivate());
            object = shecaTimeStampBuilder.getShecaRsaTsTokenGenerator(jcaSignerInfoGeneratorBuilder, (ContentSigner)object, byArray2, string);
            object = shecaTimeStampBuilder.buildShecaRsaTsResp((TimeStampTokenGenerator)object, byArray, string, date);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            object = shecaTimeStampBuilder.genShecaRejectedTimeStamp(exception);
        }
        return object;
    }

    public byte[] decodeRSAEnveloperBySHECAStandard(KeyPair keyPair, byte[] byArray, int n) {
        return null;
    }

    public byte[] genrateSM2timeStampResWithDeviceKeyPair(KeyPair object, byte[] byArray, byte[] byArray2, Date date, String string) {
        try {
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("SwxaJCE").build());
            object = new JcaContentSignerBuilder("SM3withSM2").setProvider("SwxaJCE").build(((KeyPair)object).getPrivate());
            object = shecaTimeStampBuilder.getShecaRsaTsTokenGenerator(jcaSignerInfoGeneratorBuilder, (ContentSigner)object, byArray2, string);
            object = shecaTimeStampBuilder.buildShecaRsaTsResp((TimeStampTokenGenerator)object, byArray, string, date);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            object = shecaTimeStampBuilder.genShecaRejectedTimeStamp(exception);
        }
        return object;
    }

    public byte[] genrateECCtimeStampResWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, byte[] byArray2, Date date, int n, String string) {
        return null;
    }
}

