/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.javasafeengine;
import com.sheca.safeengine.shecaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.SingleResponse;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.Req;
import org.json.JSONArray;
import org.json.JSONObject;

public final class shcaOcsp {
    private static Logger a = null;
    public static final String K_SHECA_CertID_HashAlgo = "hashAlgo";
    public static final String K_SHECA_CertID_SerialNumber = "SN";
    public static final String K_SHECA_CertID_SHA1_ISSUER_DN = "DN_HASH";
    public static final String K_SHECA_CertID_SHA1_ISSUER_PK = "PK_HASH";
    public static final String K_SHECA_OCSP_RES_KEY_resCode = "resCode";
    public static final String K_SHECA_OCSP_RES_KEY_certCode = "certCode";
    public static final String K_SHECA_OCSP_RES_KEY_thisUpdate = "thisUpdate";

    private shcaOcsp() {
        if (a == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                a = Logger.getLogger(shcaOcsp.class);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                a = null;
                classNotFoundException.printStackTrace();
            }
        }
    }

    private static byte[] a(X509Certificate object, int n) {
        byte[] byArray = null;
        try {
            if (n == 4) {
                byArray = ((X509Certificate)object).getIssuerX500Principal().getEncoded();
            } else if (n == 20) {
                object = new ByteArrayInputStream(((java.security.cert.Certificate)object).getEncoded());
                object = new ASN1InputStream((InputStream)object);
                object = (ASN1Sequence)object.readObject();
                object = new X509CertificateStructure((ASN1Sequence)object);
                object = object.getSubjectPublicKeyInfo();
                byArray = object.getPublicKeyData().getBytes();
            }
        }
        catch (Exception exception) {
            System.out.println("SHCA_OCSP_GetCertDetail error:" + exception.toString());
        }
        return byArray;
    }

    private static byte[] a(X509Certificate object, X509Certificate object2) {
        Object[] objectArray = shcaOcsp.a((X509Certificate)object, 4);
        objectArray = javasafeengine.digestMessage(objectArray, "SHA1");
        byte[] byArray = shcaOcsp.a((X509Certificate)object2, 20);
        object2 = byArray;
        object2 = javasafeengine.digestMessage(byArray, "SHA1");
        DERSequence dERSequence = new ASN1Encodable[2];
        DERSequence dERSequence2 = dERSequence;
        dERSequence[0] = new DERObjectIdentifier("1.3.14.3.2.26");
        dERSequence2[1] = new DERNull();
        dERSequence2 = new DERSequence((ASN1Encodable[])dERSequence2);
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[4];
        ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
        aSN1EncodableArray[0] = AlgorithmIdentifier.getInstance((Object)dERSequence2);
        aSN1EncodableArray2[1] = new DEROctetString(objectArray);
        aSN1EncodableArray2[2] = new DEROctetString((byte[])object2);
        aSN1EncodableArray2[3] = new DERInteger(((X509Certificate)object).getSerialNumber());
        object = new DERSequence(aSN1EncodableArray2);
        object = new DERSequence((ASN1Encodable)object.toASN1Primitive());
        object = new DERSequence((ASN1Encodable)object.toASN1Primitive());
        byte[] byArray2 = new byte[5];
        object2 = byArray2;
        byArray2[0] = -96;
        object2[1] = 3;
        object2[2] = 2;
        object2[3] = true;
        object2[4] = 2;
        object2 = ASN1Primitive.fromByteArray((byte[])object2);
        ASN1Encodable[] aSN1EncodableArray3 = new ASN1Encodable[2];
        objectArray = aSN1EncodableArray3;
        aSN1EncodableArray3[0] = object2;
        objectArray[1] = (byte)object;
        object = new DERSequence((ASN1Encodable[])objectArray);
        object = new DERSequence((ASN1Encodable)object.toASN1Primitive());
        byte[] byArray3 = object.getEncoded("UTF-8");
        object = byArray3;
        return byArray3;
    }

    public static byte[] genOcspRequest(byte[] object, byte[] object2) {
        object = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
        object2 = (X509Certificate)javasafeengine.getCertificateFromBuffer(object2);
        return shcaOcsp.a((X509Certificate)object, (X509Certificate)object2);
    }

    private static byte[] a(String object, byte[] byArray) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            byte[] byArray2 = null;
            object = URI.create((String)object);
            object = ((URI)object).toURL();
            object = (HttpURLConnection)((URL)object).openConnection();
            ((URLConnection)object).setConnectTimeout(6000);
            ((URLConnection)object).setReadTimeout(6000);
            ((URLConnection)object).setDoOutput(true);
            ((URLConnection)object).setDoInput(true);
            ((HttpURLConnection)object).setRequestMethod("POST");
            ((URLConnection)object).setRequestProperty("Content-type", "application/ocsp-request");
            ((URLConnection)object).setRequestProperty("Content-length", String.valueOf(byArray.length));
            outputStream = ((URLConnection)object).getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            if (((HttpURLConnection)object).getResponseCode() == 200) {
                inputStream = ((URLConnection)object).getInputStream();
                int n = ((URLConnection)object).getContentLength();
                byArray2 = new byte[n > 2048 ? 2048 : n];
                int n2 = 0;
                while (n2 < n) {
                    int n3 = inputStream.read(byArray2, n2, byArray2.length - n2);
                    if (n3 < 0) break;
                    if ((n2 += n3) < byArray2.length || n2 >= n) continue;
                    byArray2 = Arrays.copyOf(byArray2, n2 << 1);
                }
                byArray2 = Arrays.copyOf(byArray2, n2);
                inputStream.close();
                outputStream.close();
            } else {
                shecaUtils.logger_error(a, "HttpURLConnection error.");
            }
            inputStream.close();
            outputStream.close();
            return byArray2;
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
            return null;
        }
    }

    private static String a(X509Certificate object) {
        Object object2 = null;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1");
        byte[] byArray = object.getExtensionValue("1.3.6.1.5.5.7.1.1");
        object = byArray;
        if (byArray != null) {
            object = (DEROctetString)ASN1Primitive.fromByteArray((byte[])object);
            object = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])object.getOctets());
            int n = 0;
            while (n < object.size()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier2;
                ASN1Sequence aSN1Sequence = (ASN1Sequence)object.getObjectAt(n);
                if (aSN1Sequence.size() > 1 && aSN1ObjectIdentifier.equals((Object)(aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)))) {
                    object2 = (ASN1TaggedObject)aSN1Sequence.getObjectAt(1);
                    object2 = (ASN1OctetString)object2.getObject();
                    object2 = new String(object2.getOctets());
                }
                ++n;
            }
        } else {
            shecaUtils.logger_error(a, "getExtensionValue is null.");
        }
        return object2;
    }

    public static String getOcspUrlWithCert(X509Certificate x509Certificate) {
        return shcaOcsp.a(x509Certificate);
    }

    public static String getOcspUrlWithCert(byte[] object) {
        X509Certificate x509Certificate = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
        object = x509Certificate;
        return shcaOcsp.a(x509Certificate);
    }

    private static String b(X509Certificate object) {
        Object object2 = null;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.2");
        byte[] byArray = object.getExtensionValue("1.3.6.1.5.5.7.1.1");
        object = byArray;
        if (byArray != null) {
            object = (DEROctetString)ASN1Primitive.fromByteArray((byte[])object);
            object = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])object.getOctets());
            int n = 0;
            while (n < object.size()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier2;
                ASN1Sequence aSN1Sequence = (ASN1Sequence)object.getObjectAt(n);
                if (aSN1Sequence.size() > 1 && aSN1ObjectIdentifier.equals((Object)(aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)))) {
                    object2 = (ASN1TaggedObject)aSN1Sequence.getObjectAt(1);
                    object2 = (ASN1OctetString)object2.getObject();
                    object2 = new String(object2.getOctets());
                }
                ++n;
            }
        } else {
            shecaUtils.logger_error(a, "getExtensionValue is null.");
        }
        return object2;
    }

    public static String getIssuerCertUrlWithCert(X509Certificate x509Certificate) {
        return shcaOcsp.b(x509Certificate);
    }

    public static String getIssuerCertUrlWithCert(byte[] object) {
        X509Certificate x509Certificate = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
        object = x509Certificate;
        return shcaOcsp.b(x509Certificate);
    }

    public static String getJSONStringFromOCSPrequest(byte[] object) {
        String string = null;
        try {
            OCSPReq oCSPReq = new OCSPReq(object);
            object = oCSPReq;
            Req[] reqArray = oCSPReq.getRequestList();
            object = reqArray;
            if (reqArray.length > 0) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(K_SHECA_CertID_HashAlgo, (Object)object[0].getCertID().getHashAlgOID().getId());
                jSONObject.put(K_SHECA_CertID_SerialNumber, (Object)shecaUtils.hex2ascii(object[0].getCertID().getSerialNumber().toByteArray()));
                jSONObject.put(K_SHECA_CertID_SHA1_ISSUER_DN, (Object)javasafeengine.hex2b64(object[0].getCertID().getIssuerNameHash()));
                jSONObject.put(K_SHECA_CertID_SHA1_ISSUER_PK, (Object)javasafeengine.hex2b64(object[0].getCertID().getIssuerKeyHash()));
                string = jSONObject.toString();
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String parseWtihOCSPrequest(byte[] object) {
        String string = null;
        try {
            OCSPReq oCSPReq = new OCSPReq(object);
            object = oCSPReq;
            object = oCSPReq.getRequestList();
            JSONArray jSONArray = new JSONArray();
            int n = 0;
            while (n < ((byte[])object).length) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(K_SHECA_CertID_HashAlgo, (Object)object[n].getCertID().getHashAlgOID().getId());
                jSONObject.put(K_SHECA_CertID_SerialNumber, (Object)shecaUtils.hex2ascii(object[n].getCertID().getSerialNumber().toByteArray()));
                jSONObject.put(K_SHECA_CertID_SHA1_ISSUER_DN, (Object)javasafeengine.hex2b64(object[n].getCertID().getIssuerNameHash()));
                jSONObject.put(K_SHECA_CertID_SHA1_ISSUER_PK, (Object)javasafeengine.hex2b64(object[n].getCertID().getIssuerKeyHash()));
                jSONArray.put((Object)jSONObject);
                ++n;
            }
            string = jSONArray.toString();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String getSubjectDNsha1FromCert(byte[] object) {
        String string = null;
        try {
            Certificate certificate = javasafeengine.getX509FromBufferWithBC(object);
            object = certificate;
            if (certificate != null) {
                string = javasafeengine.hex2b64(javasafeengine.digestMessage(object.getSubject().getEncoded(), "SHA1"));
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String getIssuerDNsha1FromCert(byte[] object) {
        String string = null;
        try {
            Certificate certificate = javasafeengine.getX509FromBufferWithBC(object);
            object = certificate;
            if (certificate != null) {
                string = javasafeengine.hex2b64(javasafeengine.digestMessage(object.getIssuer().getEncoded(), "SHA1"));
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String getPubkeySHA1FromBuffer(byte[] object) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)object);
        object = subjectPublicKeyInfo;
        String string = javasafeengine.hex2b64(javasafeengine.digestMessage(subjectPublicKeyInfo.getPublicKeyData().getOctets(), "SHA1"));
        object = string;
        return string;
    }

    public static byte[] generateExceptionsOCSPresponse(int n) {
        byte[] byArray = null;
        try {
            if (n != 0) {
                OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
                OCSPResp oCSPResp = oCSPRespBuilder.build(n, null);
                byArray = oCSPResp.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static String getJSONofOCSPresponse(byte[] object) {
        JSONObject jSONObject = new JSONObject();
        OCSPResponse oCSPResponse = OCSPResponse.getInstance((Object)object);
        object = oCSPResponse;
        if (oCSPResponse.getResponseStatus().getValue().longValue() == 0L) {
            jSONObject.put(K_SHECA_OCSP_RES_KEY_resCode, 0);
            BasicOCSPResponse basicOCSPResponse = BasicOCSPResponse.getInstance((Object)object.getResponseBytes().getResponse().getOctets());
            object = basicOCSPResponse;
            if (basicOCSPResponse.getTbsResponseData().getResponses().size() > 0) {
                object = object.getTbsResponseData().getResponses().getObjectAt(0).toASN1Primitive().getEncoded();
                object = SingleResponse.getInstance((Object)object);
                jSONObject.put(K_SHECA_OCSP_RES_KEY_thisUpdate, (Object)object.getThisUpdate().getTimeString());
                if (object.getCertStatus().getTagNo() == 0) {
                    jSONObject.put(K_SHECA_OCSP_RES_KEY_certCode, 0);
                } else if (object.getCertStatus().getTagNo() == 1) {
                    jSONObject.put(K_SHECA_OCSP_RES_KEY_certCode, -2113666975);
                } else {
                    jSONObject.put(K_SHECA_OCSP_RES_KEY_certCode, -2113667042);
                }
            } else {
                jSONObject.put(K_SHECA_OCSP_RES_KEY_certCode, -2113667042);
            }
        } else {
            jSONObject.put(K_SHECA_OCSP_RES_KEY_resCode, object.getResponseStatus().getValue().longValue());
        }
        String string = jSONObject.toString();
        object = string;
        return string;
    }

    public static int check(X509Certificate object, X509Certificate x509Certificate) {
        int n;
        String string = shcaOcsp.a((X509Certificate)object);
        if (string != null) {
            byte[] byArray = shcaOcsp.a((X509Certificate)object, x509Certificate);
            object = byArray;
            if (byArray != null) {
                shecaUtils.logger_info(a, "OCSP_REQ:" + javasafeengine.hex2b64((byte[])object));
                byte[] byArray2 = shcaOcsp.a(string, (byte[])object);
                object = byArray2;
                if (byArray2 != null) {
                    shecaUtils.logger_info(a, "OCSP_RES:" + javasafeengine.hex2b64((byte[])object));
                    object = OCSPResponse.getInstance((Object)object);
                    if (object.getResponseStatus().getValue().longValue() == 0L) {
                        if ((object = BasicOCSPResponse.getInstance((Object)object.getResponseBytes().getResponse().getOctets())).getTbsResponseData().getResponses().size() > 0) {
                            byte[] byArray3 = object.getTbsResponseData().getResponses().getObjectAt(0).toASN1Primitive().getEncoded();
                            object = byArray3;
                            object = SingleResponse.getInstance((Object)byArray3);
                            n = object.getCertStatus().getTagNo() == 0 ? 0 : (object.getCertStatus().getTagNo() == 1 ? -2113666975 : -2113667042);
                        } else {
                            n = -2113667042;
                        }
                    } else {
                        n = -2113667042;
                    }
                } else {
                    n = -2113667046;
                }
            } else {
                n = -2113667045;
            }
        } else {
            n = -2113667057;
        }
        return n;
    }
}

