/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.javasafeengine;
import com.sheca.safeengine.shecaUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.json.JSONObject;

public class shecaX509v2CRLBuilder {
    public static final String K_SHECA_CRL_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final String K_JSON_KEY_thisUpdateDate = "thisUpdateDate";
    public static final String K_JSON_KEY_nextUpdateDate = "nextUpdateDate";
    public static final String K_JSON_KEY_serialnumber = "cRLNumber";
    public static final String K_JSON_KEY_CRLlist = "CRLlist";
    public static final String K_JSON_KEY_certSN = "certSN";
    public static final String K_JSON_KEY_revocationDate = "revocationDate";
    public static final String K_JSON_KEY_reason = "reason";
    public static final int K_SHECA_THREAD_MAX = 100;

    public static X509v2CRLBuilder genX509v2CRLBuilder(byte[] object, String string) {
        X509Certificate x509Certificate = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
        object = x509Certificate;
        return shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
    }

    public static X509v2CRLBuilder genX509v2CRLBuilder(X509Certificate serializable, String object) {
        X509v2CRLBuilder x509v2CRLBuilder = null;
        try {
            object = new JSONObject((String)object);
            Date date = shecaUtils.genDateFromStringWithFormat(object.getString(K_JSON_KEY_thisUpdateDate), K_SHECA_CRL_DATE_FORMAT);
            x509v2CRLBuilder = new X509v2CRLBuilder(new X500Name(serializable.getSubjectDN().getName()), date);
            date = new ASN1ObjectIdentifier("2.5.29.20");
            Object object2 = shecaUtils.ascii2hex(object.getString(K_JSON_KEY_serialnumber));
            object2 = new ASN1Integer(object2);
            x509v2CRLBuilder.addExtension((ASN1ObjectIdentifier)date, false, (ASN1Encodable)object2);
            x509v2CRLBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(serializable.getPublicKey()));
            serializable = shecaUtils.genDateFromStringWithFormat(object.getString(K_JSON_KEY_nextUpdateDate), K_SHECA_CRL_DATE_FORMAT);
            x509v2CRLBuilder.setNextUpdate((Date)serializable);
            if (object.has(K_JSON_KEY_CRLlist)) {
                serializable = object.getJSONArray(K_JSON_KEY_CRLlist);
                int n = 0;
                while (n < serializable.length()) {
                    date = serializable.getJSONObject(n);
                    object2 = date.getString(K_JSON_KEY_revocationDate);
                    Object object3 = shecaUtils.ascii2hex(date.getString(K_JSON_KEY_certSN));
                    object3 = new BigInteger((byte[])object3);
                    x509v2CRLBuilder.addCRLEntry((BigInteger)object3, shecaUtils.genDateFromStringWithFormat((String)object2, K_SHECA_CRL_DATE_FORMAT), date.getInt(K_JSON_KEY_reason));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return x509v2CRLBuilder;
    }

    public static X509v2CRLBuilder genX509v2CRLBuilderByFullSizeCrl(String object, X509Certificate x509Certificate, String string) {
        X509v2CRLBuilder x509v2CRLBuilder = null;
        try {
            x509v2CRLBuilder = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            object = new FileInputStream((String)object);
            x509Certificate = new X509CRLHolder((InputStream)object);
            x509v2CRLBuilder.addCRL((X509CRLHolder)x509Certificate);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return x509v2CRLBuilder;
    }

    public X509v2CRLBuilder genX509v2CRLBuilderByCrlList(String object, X509Certificate x509Certificate, String string) {
        X509v2CRLBuilder x509v2CRLBuilder = null;
        try {
            x509v2CRLBuilder = shecaX509v2CRLBuilder.genX509v2CRLBuilder(x509Certificate, string);
            object = new File((String)object);
            if (((File)object).exists()) {
                object = ((File)object).listFiles();
                File[] fileArray = object;
                int n = ((File[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    object = fileArray[n2];
                    if (((File)object).isFile()) {
                        object = new FileInputStream(((File)object).getAbsolutePath());
                        X509CRLHolder x509CRLHolder = new X509CRLHolder((InputStream)object);
                        x509v2CRLBuilder.addCRL(x509CRLHolder);
                        ((FileInputStream)object).close();
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return x509v2CRLBuilder;
    }

    public static X509CRL getX509CRLFromBuffer(byte[] object) {
        X509CRL x509CRL = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            object = new ByteArrayInputStream((byte[])object);
            x509CRL = (X509CRL)certificateFactory.generateCRL((InputStream)object);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return x509CRL;
    }

    public static byte[] rebuildX509CRLWithSignData(byte[] object, X509CRL x509CRL) {
        byte[] byArray = null;
        try {
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[3];
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])x509CRL.getTBSCertList());
            ASN1Encodable[] aSN1EncodableArray2 = new ASN1Encodable[2];
            ASN1Encodable[] aSN1EncodableArray3 = aSN1EncodableArray2;
            aSN1EncodableArray2[0] = new ASN1ObjectIdentifier(x509CRL.getSigAlgOID());
            aSN1EncodableArray3[1] = x509CRL.getSigAlgParams() != null ? new DEROctetString(x509CRL.getSigAlgParams()) : DERNull.INSTANCE;
            x509CRL = new DERSequence(aSN1EncodableArray3);
            object = new DERBitString(object);
            aSN1EncodableArray[0] = aSN1Primitive;
            aSN1EncodableArray[1] = x509CRL;
            aSN1EncodableArray[2] = (ASN1Encodable)object;
            byArray = new DERSequence(aSN1EncodableArray).getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }
}

