/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.shuiyou.taxCal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.custom.shuiyou.incomeTax.TaxPersonReportExFacadeFactory;
import com.kingdee.eas.custom.shuiyou.incomeTax.TaxSpeAddDedReportExFacadeFactory;
import com.kingdee.eas.custom.shuiyou.task.TaskCatalogEnum;
import com.kingdee.eas.custom.shuiyou.taxCal.AbstractTaxCalFacadeControllerBean;
import com.kingdee.eas.custom.shuiyou.uitls.SYUtilsFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.TaxCalBasicVO;
import com.kingdee.shr.compensation.taxCal.util.TaxItemUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxCalFacadeControllerBean
extends AbstractTaxCalFacadeControllerBean {
    private static Logger logger = Logger.getLogger(TaxCalFacadeControllerBean.class);
    private static final long serialVersionUID = 1L;
    private Map<String, String> taskMap;
    private Map<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
    private List<String> sumTaxList;
    private List<String> allTaxItemList;
    private static final int FIXED_PARA_COUNT = 15;
    private String userId;
    private boolean isDelete = false;
    private boolean isFbSubmit;

    @Override
    protected String _submitInitData(Context ctx, String initIds, String relayTaskID, TaxCalTaskCatalogEnum taskCatalog) throws BOSException {
        if (!StringUtils.isEmpty((String)initIds) && !"''".equals(initIds)) {
            this.isFbSubmit = taskCatalog == TaxCalTaskCatalogEnum.FB_UPLOAD;
            this.initUserID(ctx, relayTaskID);
            String taskId = this.createTask(ctx, initIds, taskCatalog);
            this.initTaxItem(ctx);
            if (!this.isFbSubmit) {
                this.updateTaxCalInitData(ctx, initIds);
            }
            return taskId;
        }
        return null;
    }

    private void initUserID(Context ctx, String relayTaskId) {
        this.userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        if (("00000000-0000-0000-0000-00000000000013B7DE7F".equals(this.userId) || "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(this.userId)) && !StringUtils.isEmpty((String)relayTaskId)) {
            String getCreatorSQL = " select top 1 FCreatorID from T_HR_STAXCALTASK where fid = '" + relayTaskId + "'";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getCreatorSQL);
                if (rowSet.next()) {
                    this.userId = rowSet.getString("FCreatorID");
                }
            }
            catch (Exception var5) {
                var5.printStackTrace();
            }
        }
    }

    private void updateAcceptId(Context ctx, String initIds) throws BOSException {
        String str = " update T_HR_STAXCALINITDETAIL detail set FAcceptId = ( select FAcceptId from T_HR_STaxPersonRecordEntry entry  where detail.FTaxUnitId = entry.FTaxUnitId and detail.FPersonId = entry.FPersonId)  where fid in (" + initIds + ") ";
        DbUtil.execute((Context)ctx, (String)str);
    }

    private String createTask(Context ctx, String initIds, TaxCalTaskCatalogEnum catalog) throws BOSException {
        this.taskMap = new HashMap<String, String>();
        String str = " SELECT t.fTaxUnitId, t.fPeriodBegin,  t.fIncomeItemId,  e.FAcceptId,  e.fid entryId, e.FSubmitStatus,  t.fid initId  from T_HR_STaxCalInitDetail t  left join T_HR_STaxPersonRecordEntry e  on t.fPersonId = e.fPersonId and t.fTaxUnitId = e.fTaxUnitId  where t.fid IN (" + initIds + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        if (rowSet.size() < 1) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label31", (Locale)ctx.getLocale()));
        }
        HashMap taxUnitGroups = new HashMap();
        try {
            while (rowSet.next()) {
                String taxUnitId = rowSet.getString("fTaxUnitId");
                ArrayList<TaxCalBasicVO> calcList = (ArrayList<TaxCalBasicVO>)taxUnitGroups.get(taxUnitId);
                if (null == calcList) {
                    calcList = new ArrayList<TaxCalBasicVO>();
                    taxUnitGroups.put(taxUnitId, calcList);
                }
                TaxCalBasicVO vo = new TaxCalBasicVO();
                vo.setPeriodBegin(rowSet.getDate("fPeriodBegin"));
                vo.setTaxUnitId(rowSet.getString("fTaxUnitId"));
                vo.setIncomeItemId(rowSet.getString("fIncomeItemId"));
                vo.setAcceptId(rowSet.getString("initId"));
                vo.setSubmitStatus(rowSet.getString("FSubmitStatus"));
                vo.setEntryId(rowSet.getString("entryId"));
                calcList.add(vo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        Iterator iterator = taxUnitGroups.entrySet().iterator();
        ObjectMapper objectMapper = new ObjectMapper();
        Iterator i$ = iterator;
        while (i$.hasNext()) {
            Map.Entry group = i$.next();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String taxUnitId = (String)group.getKey();
            List list = (List)group.getValue();
            String yearMonth = CmpDateUtil.getDateStr((Date)((TaxCalBasicVO)list.get(0)).getPeriodBegin(), (String)"yyyy-MM");
            paramMap.put("TAXUNITID", taxUnitId);
            paramMap.put("PERIOD", yearMonth);
            paramMap.put("initIds", initIds);
            paramMap.put("creator", this.userId);
            String notReportedPersonIds = this.getNotReportedPersonIds(list);
            if (StringUtils.isEmpty((String)notReportedPersonIds)) {
                paramMap.put("accept_id", ((TaxCalBasicVO)list.get(0)).getAcceptId());
            } else if (!this.isFbSubmit) {
                try {
                    List relayTaskIDList = TaxPersonReportExFacadeFactory.getLocalInstance(ctx).report(paramMap);
                    if (null != relayTaskIDList && relayTaskIDList.size() > 0) {
                        String relayTaskID = (String)relayTaskIDList.get(0);
                        paramMap.put("RELAYTASK", relayTaskID);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BOSException("\u4eba\u5458\u62a5\u7a0e\u4fe1\u606f\u62a5\u9001_\u4eba\u5458\u4fe1\u606f\u62a5\u9001\u62a5\u9519: " + e.getMessage());
                }
            }
            String taxSpeAddDedEntryIds = this.getTaxSpeAddDedEntryIds(list);
            String reportTaskId = null;
            if (TaxCalTaskCatalogEnum.CAL == catalog && taxSpeAddDedEntryIds.length() > 0) {
                paramMap.put("TaxPersonRecordEntryIDS", taxSpeAddDedEntryIds);
                try {
                    String jsonString = objectMapper.writeValueAsString(paramMap);
                    logger.info((Object)("\u4e13\u9879\u9644\u52a0\u6263\u9664\u7533\u62a5_\u7533\u62a5 \u53c2\u6570: " + jsonString));
                    List relayTaskIDList = TaxSpeAddDedReportExFacadeFactory.getLocalInstance(ctx).report(paramMap);
                    if (null != relayTaskIDList && relayTaskIDList.size() > 0) {
                        reportTaskId = (String)relayTaskIDList.get(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BOSException("\u4e13\u9879\u9644\u52a0\u6263\u9664\u7533\u62a5_\u7533\u62a5\u63d0\u4ea4\u4efb\u52a1\u62a5\u9519: " + e.getMessage());
                }
            }
            String calTaxTaskId = null;
            try {
                String jsonString = objectMapper.writeValueAsString(paramMap);
                logger.info((Object)("\u7a0e\u6b3e\u8ba1\u7b97 \u53c2\u6570: " + jsonString));
                calTaxTaskId = SYUtilsFacadeFactory.getLocalInstance(ctx).addTask("submitAsynTaxCalRequestService", jsonString, TaskCatalogEnum.CAL, reportTaskId);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                throw new BOSException("\u7a0e\u6b3e\u8ba1\u7b97\u63d0\u4ea4\u4efb\u52a1\u62a5\u9519: " + e.getMessage());
            }
        }
        return null;
    }

    private String getTaxSpeAddDedEntryIds(List<TaxCalBasicVO> list) {
        StringBuilder entryIds = new StringBuilder();
        for (TaxCalBasicVO vo : list) {
            if (!"8r0AAABCg2PDiOoP".equals(vo.getIncomeItemId())) continue;
            if (entryIds.length() > 0) {
                entryIds.append(",");
            }
            entryIds.append("'").append(vo.getEntryId()).append("'");
        }
        return entryIds.toString();
    }

    private void initTaxItem(Context ctx) {
        this.allTaxItemList = new ArrayList<String>();
        this.sumTaxList = new ArrayList<String>();
        TaxItemCollection itemColl = TaxItemUtil.getAllTaxItem((Context)ctx, (boolean)false);
        for (int i = 0; i < itemColl.size(); ++i) {
            TaxItemInfo info = itemColl.get(i);
            this.allTaxItemList.add("T" + info.getFieldSn());
            boolean isSum = info.isIsSum();
            if (!isSum) continue;
            this.sumTaxList.add("T" + info.getFieldSn());
        }
    }

    private void updateLastTaskDetail(Context ctx, String initIds) throws BOSException {
        String str = " UPDATE T_HR_STAXCALTASKDETAIL A01 SET FDATASTATE = 30 WHERE EXISTS (SELECT 1 FROM T_HR_STAXCALINITDETAIL A02  WHERE FID IN (" + initIds + ") AND A01.FCMPCALTABLEID = A02.FCMPCALTABLEID AND A01.fIncomeItemId = A02.fIncomeItemId)    AND A01.FDATASTATE = " + 10;
        DbUtil.execute((Context)ctx, (String)str);
    }

    private String getInsertTaskDetailSql() {
        StringBuilder str = new StringBuilder();
        StringBuilder itemStr = new StringBuilder();
        for (String s : this.allTaxItemList) {
            str.append(s).append(",");
            itemStr.append(",?");
        }
        String taxItems = str.substring(0, str.length() - 1);
        str = new StringBuilder();
        str.append(" INSERT INTO T_HR_STAXCALTASKDETAIL(FID, FCALTASKID, FRELAYID, FCMPCALTABLEID, FPERSONID, ");
        str.append(" FTAXUNITID, FPERIODBEGIN, FPERIODEND, FINCOMEITEMID, FACCEPTID, ");
        str.append(" FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME,FDataState, ").append(taxItems);
        str.append(" )");
        str.append(" values(?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ? ");
        str.append((CharSequence)itemStr);
        str.append(")");
        return str.toString();
    }

    private List<Object[]> getParamListData(Context ctx, String initIds) throws BOSException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        StringBuilder str = new StringBuilder();
        for (String s : this.allTaxItemList) {
            str.append(",").append(s);
        }
        String taxItem = str.toString();
        if (!this.isDelete) {
            this.getSubmittedData(ctx, initIds);
        }
        HashSet<String> personSet = new HashSet<String>();
        str = new StringBuilder();
        str.append(" SELECT FCMPCALTABLEID, FPERSONID, FTAXUNITID, FPERIODBEGIN, FPERIODEND, ");
        str.append(" FINCOMEITEMID,FID,fAcceptId ").append(taxItem);
        str.append(" FROM T_HR_STAXCALINITDETAIL ");
        str.append(" WHERE FID IN (").append(initIds).append(")");
        str.append(" ORDER BY FTAXUNITID, FINCOMEITEMID, FPERSONID, FCREATETIME ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                String personId;
                String incomeItemId;
                String taxUnitId = rowSet.getString("FTAXUNITID");
                String personKey = this.getPersonKey(taxUnitId, incomeItemId = rowSet.getString("FINCOMEITEMID"), personId = rowSet.getString("FPERSONID"));
                if (personSet.contains(personKey)) continue;
                personSet.add(personKey);
                String taskId = this.taskMap.get(taxUnitId);
                Object[] param = this.sumLastData(rowSet, personKey, taskId);
                paramsList.add(param);
            }
        }
        catch (SQLException var14) {
            logger.error((Object)var14);
        }
        return paramsList;
    }

    private void updateTaxCalInitData(Context ctx, String initIds) throws BOSException {
        String sql = "UPDATE T_HR_STAXCALINITDETAIL SET FSTATE = 30 WHERE FID IN (" + initIds + ")  ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private Object[] sumLastData(IRowSet rowSet, String personKey, String taskId) throws SQLException {
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        Map<Object, Object> rowMap = new HashMap();
        if (this.dataMap.containsKey(personKey)) {
            rowMap = this.dataMap.get(personKey);
            for (String taxItem : this.sumTaxList) {
                BigDecimal detail = null == rowSet.getBigDecimal(taxItem) ? BigDecimal.ZERO : rowSet.getBigDecimal(taxItem);
                BigDecimal sum = null == rowMap.get(taxItem) ? BigDecimal.ZERO : (BigDecimal)rowMap.get(taxItem);
                rowMap.put(taxItem, detail.add(sum));
            }
        }
        Object[] param = new Object[15 + this.allTaxItemList.size()];
        param[0] = BOSUuid.create((String)"01CB8082").toString();
        param[1] = taskId;
        param[2] = rowMap.get("FCMPCALTABLEID");
        param[3] = rowSet.getString("FCMPCALTABLEID");
        param[4] = rowSet.getString("FPERSONID");
        param[5] = rowSet.getString("FTAXUNITID");
        param[6] = rowSet.getDate("FPERIODBEGIN");
        param[7] = rowSet.getDate("FPERIODEND");
        param[8] = rowSet.getString("FINCOMEITEMID");
        param[9] = rowSet.getString("fAcceptId");
        param[10] = this.userId;
        param[11] = createTime;
        param[12] = this.userId;
        param[13] = createTime;
        param[14] = this.isDelete ? 20 : 10;
        for (String item : this.allTaxItemList) {
            int index = this.allTaxItemList.indexOf(item);
            param[15 + index] = rowMap.containsKey(item) ? rowMap.get(item) : rowSet.getObject(item);
        }
        return param;
    }

    private void getSubmittedData(Context ctx, String initIds) throws BOSException {
        if (null != this.sumTaxList && !this.sumTaxList.isEmpty()) {
            StringBuilder str = new StringBuilder();
            for (String taxItem : this.sumTaxList) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append("SUMDATA.").append(taxItem);
            }
            String sumItems = str.toString();
            str = new StringBuilder();
            str.append(" SELECT SUMDATA.FPERSONID, SUMDATA.FTAXUNITID, SUMDATA.FINCOMEITEMID,SUMDATA.FCMPCALTABLEID, ").append(sumItems);
            str.append(" FROM T_HR_STAXCALTASKDETAIL SUMDATA ");
            str.append(" INNER JOIN T_HR_STAXCALINITDETAIL INIT ON SUMDATA.FCMPCALTABLEID = INIT.FCMPCALTABLEID and SUMDATA.fIncomeItemId = INIT.fIncomeItemId AND INIT.FSTATE = ");
            str.append(40);
            str.append(" INNER JOIN T_HR_STAXINCOMEITEM INCOMEITEM ON SUMDATA.FINCOMEITEMID =  INCOMEITEM.FID ");
            str.append(" WHERE EXISTS( ");
            str.append(" SELECT 1 FROM T_HR_STAXCALINITDETAIL DETAIL ");
            str.append(" WHERE DETAIL.FID IN (").append(initIds).append(") ");
            str.append(" AND INIT.FPERSONID = DETAIL.FPERSONID AND INIT.FTAXUNITID = DETAIL.FTAXUNITID ");
            str.append(" AND INIT.FINCOMEITEMID = DETAIL.FINCOMEITEMID AND INIT.FPERIODBEGIN = DETAIL.FPERIODBEGIN) ");
            str.append(" AND SUMDATA.FDATASTATE = ").append(10);
            str.append(" AND INCOMEITEM.FTAXCALMETHOD = ").append(10);
            str.append(" ORDER BY SUMDATA.FPERSONID, SUMDATA.FTAXUNITID, SUMDATA.FINCOMEITEMID, SUMDATA.FCREATETIME DESC ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            try {
                while (rowSet.next()) {
                    this.combineRowData(rowSet);
                }
            }
            catch (SQLException var7) {
                var7.printStackTrace();
            }
        }
    }

    private String getNotReportedPersonIds(List<TaxCalBasicVO> list) {
        StringBuilder notReported = new StringBuilder();
        for (TaxCalBasicVO vo : list) {
            String submitStatus = vo.getSubmitStatus();
            if (!"0".equals(submitStatus) && !"3".equals(submitStatus)) continue;
            if (notReported.length() > 0) {
                notReported.append(",");
            }
            notReported.append("'").append(vo.getEntryId()).append("'");
        }
        return notReported.toString();
    }

    private String getPersonKey(String taxUnitId, String incomeItemId, String personId) {
        return taxUnitId + "_" + incomeItemId + "_" + personId;
    }

    private void combineRowData(IRowSet rowSet) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        String key = null;
        try {
            key = this.getPersonKey(rowSet.getString("FTAXUNITID"), rowSet.getString("FINCOMEITEMID"), rowSet.getString("FPERSONID"));
            if (this.dataMap.containsKey(key)) {
                return;
            }
            for (String taxItem : this.sumTaxList) {
                rowMap.put(taxItem, rowSet.getBigDecimal(taxItem));
            }
            rowMap.put("FCMPCALTABLEID", rowSet.getString("FCMPCALTABLEID"));
        }
        catch (SQLException var6) {
            var6.printStackTrace();
        }
        this.dataMap.put(key, rowMap);
    }
}

