/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.beisen.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.interfacelog.businessoperationlog.OperateLogCollection;
import com.kingdee.eas.custom.interfacelog.businessoperationlog.OperateLogEntryCollection;
import com.kingdee.eas.custom.interfacelog.businessoperationlog.OperateLogEntryInfo;
import com.kingdee.eas.custom.interfacelog.businessoperationlog.OperateLogFactory;
import com.kingdee.eas.custom.interfacelog.businessoperationlog.OperateLogInfo;
import com.kingdee.eas.custom.interfacelog.enumdata.RequestStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class Helper {
    public Context context;

    public Helper(Context context) {
        this.context = context;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getURL(String url, Map<String, String> header, JSONObject requestBody, String method, String businessId, String operate, String businessName) throws URISyntaxException, JSONException, ClientProtocolException, IOException {
        void var17_27;
        CloseableHttpResponse response;
        OperateLogInfo operateLogInfo = this.getOperateLogInfoByBusinessId(businessId, businessName);
        OperateLogEntryCollection entrys = operateLogInfo.getEntrys();
        if (entrys == null) {
            entrys = new OperateLogEntryCollection();
        }
        OperateLogEntryInfo operateLogEntryInfo = new OperateLogEntryInfo();
        operateLogEntryInfo.setUrl(url);
        String requestBodyString = requestBody.toString();
        if (requestBodyString.length() > 1500) {
            requestBodyString = requestBodyString.substring(0, 1500);
        }
        operateLogEntryInfo.setRequestBody(requestBodyString);
        String jsonString = JSONObject.toJSONString(header);
        if (jsonString.length() > 1500) {
            jsonString = jsonString.substring(0, 1500);
        }
        operateLogEntryInfo.setHeaded(jsonString);
        operateLogEntryInfo.setOperate(operate);
        operateLogEntryInfo.setMethod(method);
        JSONObject responseJson = new JSONObject();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        if ("GET".equals(method)) {
            URIBuilder uriBuilder = new URIBuilder(url);
            Set set = requestBody.keySet();
            for (String string2 : set) {
                String key = string2;
                String value = requestBody.getString(key);
                uriBuilder.addParameter(key, value);
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            for (Map.Entry entry : header.entrySet()) {
                httpGet.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
        } else if ("POST".equals(method)) {
            HttpPost httpPost = new HttpPost(url);
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
            StringEntity stringEntity = new StringEntity(requestBody.toString(), "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
        } else if ("PUT".equals(method)) {
            HttpPut httpPut = new HttpPut(url);
            for (Map.Entry entry : header.entrySet()) {
                httpPut.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            StringEntity stringEntity = new StringEntity(requestBody.toString(), "UTF-8");
            httpPut.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPut);
        } else {
            operateLogEntryInfo.setErrorInfo("Unsupported HTTP method: " + method);
            operateLogEntryInfo.setRequestStatus(RequestStatusEnum.ABNORMAL);
            entrys.add(operateLogEntryInfo);
            try {
                OperateLogFactory.getLocalInstance(this.context).save((CoreBaseInfo)operateLogInfo);
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
            catch (EASBizException e) {
                throw new RuntimeException(e);
            }
            throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        responseJson = JSONObject.parseObject((String)responseBody);
        System.out.println(responseBody);
        String string = "";
        String string2 = responseJson.toString();
        if (string2.length() > 1500) {
            String string3 = string2.substring(0, 1500);
        } else {
            String string4 = string2.toString();
        }
        operateLogEntryInfo.setReturnValue((String)var17_27);
        String string5 = responseJson.getString("code");
        if (string5 == null || !string5.equals("200")) {
            operateLogEntryInfo.setRequestStatus(RequestStatusEnum.ABNORMAL);
        } else {
            operateLogEntryInfo.setRequestStatus(RequestStatusEnum.NORMAL);
        }
        try {
            entrys.add(operateLogEntryInfo);
            OperateLogFactory.getLocalInstance(this.context).save((CoreBaseInfo)operateLogInfo);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        httpClient.close();
        return responseJson;
    }

    public OperateLogInfo getOperateLogInfoByBusinessId(String businessId, String businessName) {
        if (businessId != null && !businessId.equals("")) {
            OperateLogCollection operateLogCollection = null;
            try {
                operateLogCollection = OperateLogFactory.getLocalInstance(this.context).getOperateLogCollection("where businessId='" + businessId + "' ");
                if (operateLogCollection.size() > 0) {
                    return operateLogCollection.get(0);
                }
                OperateLogInfo operateLogInfo = new OperateLogInfo();
                operateLogInfo.setBusinessId(businessId);
                operateLogInfo.setBusinessName(businessName);
                return operateLogInfo;
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }
        OperateLogInfo operateLogInfo = new OperateLogInfo();
        operateLogInfo.setBusinessName(businessName);
        return operateLogInfo;
    }

    public JSONObject getURL(String url, Map<String, String> header, JSONArray requestBody, String method) throws URISyntaxException, JSONException, ClientProtocolException, IOException {
        CloseableHttpResponse response;
        JSONObject responseJson = new JSONObject();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        if ("GET".equals(method)) {
            URIBuilder uriBuilder = new URIBuilder(url);
            ArrayList<Object> paramList = new ArrayList<Object>();
            int i = 0;
            while (i < requestBody.size()) {
                paramList.add(requestBody.get(i));
                ++i;
            }
            uriBuilder.addParameters(paramList);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
        } else if ("POST".equals(method)) {
            HttpPost httpPost = new HttpPost(url);
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
            StringEntity requestEntity = new StringEntity(requestBody.toString(), "UTF-8");
            httpPost.setEntity((HttpEntity)requestEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
        } else if ("PUT".equals(method)) {
            HttpPut httpPut = new HttpPut(url);
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPut.addHeader(entry.getKey(), entry.getValue());
            }
            StringEntity requestEntity = new StringEntity(requestBody.toString(), "UTF-8");
            httpPut.setEntity((HttpEntity)requestEntity);
            response = httpClient.execute((HttpUriRequest)httpPut);
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        responseJson = JSONObject.parseObject((String)responseBody);
        httpClient.close();
        return responseJson;
    }

    public JSONObject getURLEncoded(String url, Map<String, String> header, JSONObject requestBody, String method) throws URISyntaxException, JSONException, ClientProtocolException, IOException {
        CloseableHttpResponse response;
        JSONObject responseJson = new JSONObject();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        if ("GET".equals(method)) {
            URIBuilder uriBuilder = new URIBuilder(url);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
            Set strings = requestBody.keySet();
            Iterator iterator = strings.iterator();
            while (iterator.hasNext()) {
                String string;
                String key = string = (String)iterator.next();
                String value = requestBody.getString(key);
                uriBuilder.addParameter(key, value);
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
        } else if ("POST".equals(method)) {
            HttpPost httpPost = new HttpPost(url);
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            Set strings = requestBody.keySet();
            Iterator iterator = strings.iterator();
            while (iterator.hasNext()) {
                String string;
                String key = string = (String)iterator.next();
                String value = requestBody.getString(key);
                list.add(new BasicNameValuePair(key, value));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            response = httpClient.execute((HttpUriRequest)httpPost);
        } else if ("PUT".equals(method)) {
            HttpPut httpPut = new HttpPut(url);
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPut.addHeader(entry.getKey(), entry.getValue());
            }
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            Set strings = requestBody.keySet();
            Iterator iterator = strings.iterator();
            while (iterator.hasNext()) {
                String string;
                String key = string = (String)iterator.next();
                String value = requestBody.getString(key);
                list.add(new BasicNameValuePair(key, value));
            }
            httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            response = httpClient.execute((HttpUriRequest)httpPut);
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        responseJson = JSONObject.parseObject((String)responseBody);
        httpClient.close();
        return responseJson;
    }

    public byte[] getBytesByNetURL(String urlStr) throws IOException {
        int len;
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        in.close();
        return outputStream.toByteArray();
    }
}

