/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.beisen.synchronouspos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.custom.beisen.synchronouspos.AbstractSynchronousPosFacadeControllerBean;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SynchronousPosFacadeControllerBean
extends AbstractSynchronousPosFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.beisen.synchronouspos.SynchronousPosFacadeControllerBean");

    @Override
    protected String _syncPosToBeiSen(Context ctx, String posId, String syncStartTimeStr, String syncEndTimeStr) throws BOSException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        super._syncPosToBeiSen(ctx, posId, syncStartTimeStr, syncEndTimeStr);
        Object obj = null;
        try {
            HashMap map = Maps.newHashMap();
            map.put("posId", posId);
            if (!StringUtils.isNotBlank((CharSequence)posId)) {
                if (StringUtils.isNotBlank((CharSequence)syncStartTimeStr)) {
                    map.put("syncStartTimeStr", syncStartTimeStr);
                } else if (StringUtils.isNotBlank((CharSequence)syncEndTimeStr)) {
                    map.put("syncEndTimeStr", syncEndTimeStr);
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, 1);
                    syncEndTimeStr = sf.format(calendar.getTime());
                    calendar.add(5, -2);
                    syncStartTimeStr = sf.format(calendar.getTime());
                    map.put("syncStartTimeStr", syncStartTimeStr);
                    map.put("syncEndTimeStr", syncEndTimeStr);
                }
            }
            obj = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("synchronousPosOSF", (Map)map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null == obj ? "" : obj.toString();
    }

    @Override
    protected String _sendAddNewPosToBeisen(Context ctx, String jsonStr) throws BOSException {
        super._sendAddNewPosToBeisen(ctx, jsonStr);
        Object obj = null;
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            HashMap map = Maps.newHashMap();
            map.putAll(jsonObject);
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String syncStartTimeStr = (String)map.get("syncStartTimeStr");
            String syncEndTimeStr = (String)map.get("syncEndTimeStr");
            if (StringUtils.isNotBlank((CharSequence)syncStartTimeStr)) {
                map.put("syncStartTimeStr", syncStartTimeStr);
            } else if (StringUtils.isNotBlank((CharSequence)syncEndTimeStr)) {
                map.put("syncEndTimeStr", syncEndTimeStr);
            } else {
                Calendar calendar = Calendar.getInstance();
                syncEndTimeStr = sf.format(calendar.getTime());
                calendar.add(5, -1);
                syncStartTimeStr = sf.format(calendar.getTime());
                map.put("syncStartTimeStr", syncStartTimeStr);
                map.put("syncEndTimeStr", syncEndTimeStr);
            }
            obj = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("synchronousPosOSF", (Map)map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null == obj ? "" : obj.toString();
    }

    @Override
    protected void _sendEditPosToBeisen(Context ctx, String jsonStr) throws BOSException {
        super._sendEditPosToBeisen(ctx, jsonStr);
        Object obj = null;
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            HashMap map = Maps.newHashMap();
            map.putAll(jsonObject);
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String syncStartTimeStr = (String)map.get("syncStartTimeStr");
            String syncEndTimeStr = (String)map.get("syncEndTimeStr");
            if (StringUtils.isNotBlank((CharSequence)syncStartTimeStr)) {
                map.put("syncStartTimeStr", syncStartTimeStr);
            } else if (StringUtils.isNotBlank((CharSequence)syncEndTimeStr)) {
                map.put("syncEndTimeStr", syncEndTimeStr);
            } else {
                Calendar calendar = Calendar.getInstance();
                syncEndTimeStr = sf.format(calendar.getTime());
                calendar.add(5, -1);
                syncStartTimeStr = sf.format(calendar.getTime());
                map.put("syncStartTimeStr", syncStartTimeStr);
                map.put("syncEndTimeStr", syncEndTimeStr);
            }
            obj = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("synchronousPosOSF", (Map)map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

