/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.beisen.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.custom.beisen.utils.Helper;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Properties;

public class BeiSenUtils {
    public String APP_KEY = null;
    public String APP_SECRET = null;
    public Properties propt = new Properties();
    public Context context = null;
    public Helper helper = null;

    public BeiSenUtils(String app_key, String app_secret, Context context) {
        this.context = context;
        this.helper = new Helper(context);
        try {
            this.propt.load(new FileInputStream(String.valueOf(System.getProperty("EAS_HOME")) + "/server/properties/beiSen/BeiSenConfig.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.APP_KEY = app_key;
        this.APP_SECRET = app_secret;
    }

    public BeiSenUtils(Context context) {
        this.context = context;
        this.helper = new Helper(context);
        try {
            this.propt.load(new FileInputStream(String.valueOf(System.getProperty("EAS_HOME")) + "/server/properties/beiSen/BeiSenConfig.properties"));
            this.APP_KEY = this.propt.getProperty("APP_KEY");
            this.APP_SECRET = this.propt.getProperty("APP_SECRET");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAccessToken() throws FileNotFoundException, IOException, URISyntaxException {
        String tenantAccessToken = null;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject requestBody = new JSONObject();
        requestBody.put("grant_type", (Object)"client_credentials");
        requestBody.put("app_key", (Object)this.APP_KEY);
        requestBody.put("app_secret", (Object)this.APP_SECRET);
        JSONObject responseJson = this.helper.getURLEncoded(this.propt.getProperty("ACCESSTOKEN_URL"), header, requestBody, "POST");
        tenantAccessToken = responseJson.getString("access_token");
        return tenantAccessToken;
    }

    public JSONObject createOrUpdateByOrg(JSONObject requestBody, AdminOrgUnitInfo adminOrgUnitInfo) throws FileNotFoundException, IOException, URISyntaxException {
        String originalId = adminOrgUnitInfo.getReserveFieldFirst();
        String orgid = adminOrgUnitInfo.getNumber();
        JSONArray responseData = new JSONArray();
        JSONObject responseJson = null;
        String token = this.getAccessToken();
        if (!StringUtils.isEmpty((String)token)) {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            header.put("Authorization", "Bearer " + token);
            if (originalId != null && !originalId.equals("")) {
                header.put("originalId", orgid);
                String departmentsput = this.propt.getProperty("DEPARTMENTSPUT");
                departmentsput = String.valueOf(departmentsput) + "?originalId=" + URLEncoder.encode(orgid, "UTF-8");
                responseJson = this.helper.getURL(departmentsput, header, requestBody, "PUT", adminOrgUnitInfo.getId().toString(), "\u66f4\u65b0", "\u5317\u68ee");
                System.out.println("url\uff1a" + departmentsput);
                System.out.println("requestBody\uff1a" + requestBody);
            } else {
                String departmentspost = this.propt.getProperty("DEPARTMENTSPOST");
                responseJson = this.helper.getURL(departmentspost, header, requestBody, "POST", adminOrgUnitInfo.getId().toString(), "\u521b\u5efa", "\u5317\u68ee");
                System.out.println("url\uff1a" + this.propt.getProperty("DEPARTMENTSPOST"));
                System.out.println("requestBody\uff1a" + requestBody);
            }
        }
        return responseJson;
    }

    public JSONObject setDisableAndEnable(String businessId, String url, String method) throws IOException, URISyntaxException {
        String token = this.getAccessToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Authorization", "Bearer " + token);
        JSONObject responseJson = this.helper.getURL(url, header, new JSONObject(), method, businessId, "\u542f\u7528/\u7981\u7528/\u5220\u9664", "\u5317\u68ee");
        return responseJson;
    }

    public static void main(String[] args) {
        MetaDataUtil.getEntityObjectByBosType((BOSObjectType)BOSUuid.read((String)"/1aEqNuoTWaCOnKAj1sSTHSuYS4=").getType()).getAlias();
    }
}

