/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.beisen.synchronousorg;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.custom.beisen.synchronousorg.AbstractsynchronousOrgControllerBean;
import com.kingdee.eas.custom.beisen.utils.BeiSenUtils;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.hr.base.EmpPostExperienceHisCollection;
import com.kingdee.eas.hr.base.EmpPostExperienceHisFactory;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class synchronousOrgControllerBean
extends AbstractsynchronousOrgControllerBean {
    private static final Logger logger = Logger.getLogger(synchronousOrgControllerBean.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    protected String _createOrUpdateOrg(Context ctx, int day, String orgId, boolean isDelete) throws BOSException {
        BeiSenUtils beiSenUtils = new BeiSenUtils(ctx);
        Date now = new Date();
        Date dayBefore = this.getDayBefore(now, day);
        EntityViewInfo entityViewInfo = this.createEntityViewInfo(orgId, dayBefore, now);
        String ids = "";
        try {
            IAdminOrgUnit localInstance = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminOrgUnitCollection = localInstance.getAdminOrgUnitCollection(entityViewInfo);
            int i = 0;
            while (i < adminOrgUnitCollection.size()) {
                AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnitCollection.get(i);
                String originalId = adminOrgUnitInfo.getReserveFieldFirst();
                System.out.println("===========originalId" + originalId);
                try {
                    JSONObject requestBody = this.getRequestBody(ctx, adminOrgUnitInfo, null);
                    JSONObject orUpdateByOrg = beiSenUtils.createOrUpdateByOrg(requestBody, adminOrgUnitInfo);
                    System.out.println("orUpdateByOrg\uff1a" + orUpdateByOrg);
                    String code = orUpdateByOrg.getString("code");
                    if ("200".equals(code)) {
                        if (originalId == null) {
                            String data = orUpdateByOrg.getString("data");
                            String id = adminOrgUnitInfo.getId().toString();
                            if (data != null && !data.equals("")) {
                                String sql = "update T_ORG_Admin set FreserveFieldFirst = '" + data + "' where FID = '" + id + "'";
                                DBUtil.execute((Context)ctx, (String)sql);
                            }
                        }
                        ids = String.valueOf(ids) + adminOrgUnitInfo.getId().toString();
                    } else {
                        this.logError(adminOrgUnitInfo.getName(), orUpdateByOrg.getString("message"));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.logError(adminOrgUnitInfo.getName(), e.getMessage());
                    logger.error((Object)"\u5904\u7406\u7ec4\u7ec7\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    this.logError(adminOrgUnitInfo.getName(), e.getMessage());
                    logger.error((Object)"\u5904\u7406\u7ec4\u7ec7\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                ++i;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u96c6\u5408\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        return ids;
    }

    public JSONObject getRequestBody(Context context, AdminOrgUnitInfo adminOrgUnitInfo, JSONObject requestBody) throws BOSException {
        if (requestBody == null) {
            requestBody = new JSONObject();
        }
        requestBody.put("name", (Object)adminOrgUnitInfo.getName());
        requestBody.put("code", (Object)adminOrgUnitInfo.getNumber());
        AdminOrgUnitInfo parent = adminOrgUnitInfo.getParent();
        if (parent != null) {
            requestBody.put("parentOriginalId", (Object)parent.getId().toString());
        }
        requestBody.put("originalId", (Object)adminOrgUnitInfo.getId().toString());
        JSONArray originalIds = new JSONArray();
        PositionInfo responPosition = adminOrgUnitInfo.getResponPosition();
        if (responPosition != null) {
            BOSUuid id = responPosition.getId();
            EntityViewInfo entityViewInfo = this.createPersonPositionViewInfo(id);
            try {
                EmpPostExperienceHisCollection empPostExperienceHisCollection = EmpPostExperienceHisFactory.getLocalInstance((Context)context).getEmpPostExperienceHisCollection(entityViewInfo);
                int i = 0;
                while (i < empPostExperienceHisCollection.size()) {
                    EmpPostExperienceHisInfo empPostExperienceHisInfo = empPostExperienceHisCollection.get(i);
                    PersonInfo person = empPostExperienceHisInfo.getPerson();
                    originalIds.add((Object)person.getId().toString());
                    ++i;
                }
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u4eba\u5458\u5c97\u4f4d\u4fe1\u606f\u96c6\u5408\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw e;
            }
            JSONObject customFieldList = new JSONObject();
            customFieldList.put("extbumenfuzerengangweibianma_433107_1704083012", (Object)responPosition.getNumber());
            customFieldList.put("extbumenfuzerengangweimingcheng_433107_501692677", (Object)responPosition.getName());
            requestBody.put("customFieldList", (Object)customFieldList);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("originalIds", (Object)originalIds);
        jsonObject.put("leaderType", (Object)1);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        requestBody.put("departmentLeaders", (Object)jsonArray);
        requestBody.put("modifiedTime", (Object)this.formatDate(adminOrgUnitInfo.getLastUpdateTime()));
        requestBody.put("createTime", (Object)this.formatDate(adminOrgUnitInfo.getCreateTime()));
        return requestBody;
    }

    public Date getDayBefore(Date specifiedDay, int x) {
        Calendar c = Calendar.getInstance();
        c.setTime(specifiedDay);
        c.add(5, -x);
        return c.getTime();
    }

    private EntityViewInfo createEntityViewInfo(String orgId, Date dayBefore, Date date) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (orgId != null && !orgId.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgId, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("lastUpdateTime", (Object)dayBefore, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("lastUpdateTime", (Object)date, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false, CompareType.EQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("longNumber");
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemCollection.add(sorterItemInfo);
        entityViewInfo.setSorter(sorterItemCollection);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("parent.*");
        selectorItemCollection.add("responPosition.*");
        entityViewInfo.setSelector(selectorItemCollection);
        return entityViewInfo;
    }

    private EntityViewInfo createPersonPositionViewInfo(BOSUuid positionId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Position", (Object)positionId.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.bsUserId is not null"));
        filterInfo.getFilterItems().add(new FilterItemInfo("Leffdt", (Object)new Date(), CompareType.GREATER_EQUALS));
        HashSet<String> stringSet = new HashSet<String>();
        stringSet.add("1");
        stringSet.add("4");
        filterInfo.getFilterItems().add(new FilterItemInfo("person.employeeType.inService", stringSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("person.*");
        entityViewInfo.setSelector(selectorItemCollection);
        System.out.println("=============entityViewInfo" + entityViewInfo);
        return entityViewInfo;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT.format(date);
    }

    private void logError(String orgName, String message) {
        String errorMsg = String.valueOf(orgName) + " \u540c\u6b65\u5931\u8d25\uff1a" + message;
        System.out.println(errorMsg);
        logger.error((Object)errorMsg);
    }
}

