/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.DomainFilterFacadeFactory;
import com.kingdee.shr.base.syssetting.IDomainFilterFacade;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.model.VirtualDataFetcher;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingUIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ListUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.IFragmentUIViewConverter;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.IUIViewConverter;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.UIViewConverterFactory;
import com.kingdee.shr.ml.MLServiceFactory;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class ViewGetDataUtils {
    private UIViewInfo viewInfo = null;
    private Context context = null;

    public UIViewInfo getViewInfo() {
        return this.viewInfo;
    }

    public void setViewInfo(UIViewInfo viewInfo) {
        this.viewInfo = viewInfo;
    }

    public ViewGetDataUtils(Context context, String uipk) {
        this.context = context;
        try {
            this.viewInfo = this.getUIViewInfoByUIPK(uipk);
        }
        catch (SHRWebException e) {
            throw new RuntimeException(e);
        }
    }

    public FilterInfo getDomainFilter(Context context) throws SHRWebException {
        ListUIViewInfo uiViewInfo = (ListUIViewInfo)this.viewInfo;
        String domain = uiViewInfo.getDomain();
        if (StringUtils.isEmpty((String)domain)) {
            domain = uiViewInfo.getDomain();
        }
        if (!StringUtils.isEmpty((String)domain)) {
            try {
                IDomainFilterFacade localInstance = DomainFilterFacadeFactory.getLocalInstance((Context)context);
                FilterInfo domainFilter = localInstance.getDomainFilter(uiViewInfo.getEntityName(), domain, null);
                return domainFilter;
            }
            catch (Exception var5) {
                throw new SHRWebException(var5.getMessage(), (Throwable)var5);
            }
        }
        return null;
    }

    public List<CoreBaseInfo> getCoreBaseInfo(String uipk, String where) throws SHRWebException {
        CoreBaseCollection collection = this.initCollection(this.context, uipk, where);
        ArrayList<CoreBaseInfo> list = new ArrayList<CoreBaseInfo>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            list.add(collection.get(i));
        }
        return list;
    }

    public CoreBaseCollection initCollection(Context context, String uipk, String where) throws SHRWebException {
        EntityViewInfo entityViewInfo = this.getEntityViewInfo(uipk, where);
        try {
            CoreBaseCollection collection = this.getBizInterface().getCollection(entityViewInfo);
            return collection;
        }
        catch (BOSException var8) {
            throw new SHRWebException(var8.getMessage(), (Throwable)var8);
        }
    }

    public ICoreBase getBizInterface() throws SHRWebException {
        if (this.viewInfo == null) {
            return null;
        }
        try {
            return MetaDataUtil.getBizInterface((Context)SHRContext.getInstance().getContext(), (String)this.viewInfo.getEntityName());
        }
        catch (BOSException var4) {
            throw new SHRWebException((Throwable)var4);
        }
    }

    public EntityViewInfo getEntityViewInfo(String uipk, String where) throws SHRWebException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        try {
            FilterInfo filterInfo1 = new FilterInfo();
            if (!where.equals("")) {
                FilterInfo filterInfo = new FilterInfo(where);
                filterInfo1.mergeFilter(filterInfo, "AND");
            }
            FilterInfo domainFilter = this.getDomainFilter(this.context);
            filterInfo1.mergeFilter(domainFilter, "AND");
            entityViewInfo.setFilter(filterInfo1);
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        entityViewInfo.setSelector(this.getSelectors(uipk));
        UIViewInfo uiViewInfo = this.viewInfo;
        if (uiViewInfo.getOrderBy() != null) {
            SorterItemCollection sorter = new SorterItemCollection();
            try {
                sorter.getSorter().decode("order by " + uiViewInfo.getOrderBy());
            }
            catch (ParserException var9) {
                throw new SHRWebException(var9.getMessage(), (Throwable)var9);
            }
            entityViewInfo.setSorter(sorter);
        }
        return entityViewInfo;
    }

    public SelectorItemCollection getSelectors(String uipk) throws SHRWebException {
        UIViewInfo viewInfo = this.getUIViewInfoByUIPK(uipk);
        SelectorItemCollection sic = null;
        if (viewInfo != null && (sic = viewInfo.getSelectors()) == null) {
            sic = UIViewUtil.assembleSelector((UIViewInfo)viewInfo);
            viewInfo.setSelectors(sic);
        }
        return sic;
    }

    public boolean isRequestFragment(String uipk) {
        return uipk.indexOf("$") != -1;
    }

    public UIViewInfo getUIViewInfoByUIPK(String uipk) throws SHRWebException {
        if (this.viewInfo == null) {
            if (this.isRequestFragment(uipk)) {
                String[] str = uipk.split("\\$");
                String str1 = str[1];
                if (!StringUtils.isEmpty((String)str1)) {
                    str1 = str1.replaceAll("'", "").replaceAll("\\|", "").replaceAll("location", "").replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("=", "").replaceAll("\\\\", "").replaceAll("\\+", "").replaceAll("window", "");
                }
                this.viewInfo = this.generateUIViewFragment(str[0], str1);
            } else {
                this.viewInfo = this.generateUIView(uipk);
            }
            this.addUIViewInfo(uipk, this.viewInfo);
        }
        return this.viewInfo;
    }

    public void addUIViewInfo(String key, UIViewInfo uiViewInfo) {
        CacheService.getInstance().put("shr.uiView", this.getKey(key, this.context.getLocale().toString()), (Object)uiViewInfo);
    }

    public UIViewInfo generateUIView(String uipk) throws SHRWebException {
        com.kingdee.shr.base.syssetting.UIViewInfo dbUIViewInfo = this.getUIViewFromDB(uipk);
        if (dbUIViewInfo == null) {
            if (uipk.contains(" ")) {
                throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"view_contain_blank"), uipk));
            }
            throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"view_not_found"));
        }
        this.dealTreeNavigationElement(dbUIViewInfo);
        IUIViewConverter converter = UIViewConverterFactory.getUIViewConverter((com.kingdee.shr.base.syssetting.UIViewInfo)dbUIViewInfo, (Context)this.context);
        return converter.exec();
    }

    public com.kingdee.shr.base.syssetting.UIViewInfo getUIViewFromDB(String uipk) throws SHRWebException {
        try {
            if (LocaleUtils.locale_zh_CN.toString().equals(LocaleUtils.getLocaleString((Locale)LocaleUtils.getFirstOriginLocale((Locale)this.context.getLocale())))) {
                return UIViewFactory.getLocalInstance((Context)this.context).getValueByUipk(uipk, SysSettingUIViewUtil.getUIViewSelector());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("uipks", uipk);
            params.put("isConvert", true);
            Object obj = MLServiceFactory.getLocalInstance((Context)this.context).convert(ResourceType.UIView, params);
            return null == obj ? null : (com.kingdee.shr.base.syssetting.UIViewInfo)obj;
        }
        catch (BOSException var4) {
            throw new ShrWebBizException(var4.getMessage(), (Throwable)var4);
        }
        catch (EASBizException var5) {
            throw new ShrWebBizException(var5.getMessage(), (Throwable)var5);
        }
    }

    public void dealTreeNavigationElement(com.kingdee.shr.base.syssetting.UIViewInfo dbUIViewInfo) {
        String content = this.dealConfig(dbUIViewInfo.getContent());
        String extend = this.dealConfig(dbUIViewInfo.getExtend());
        if (!StringUtils.isEmpty((String)content)) {
            dbUIViewInfo.setContent(content);
        }
        if (!StringUtils.isEmpty((String)extend)) {
            dbUIViewInfo.setExtend(extend);
        }
    }

    public String dealConfig(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        try {
            XMLOutputter output = XMLUtil.getXMLOutputter();
            Document doc = XMLUtil.parseXML((String)text);
            XPathFactory xpathFac = XPathFactory.instance();
            XPathExpression xPathTreeNavigation = xpathFac.compile("//treeNavigation", Filters.element());
            XPathExpression xPathFilterItem = xpathFac.compile("//filterItem[@isAdminOrg='true']", Filters.element());
            List treeNavigations = xPathTreeNavigation.evaluate((Object)doc);
            List filterItems = xPathFilterItem.evaluate((Object)doc);
            if (null != treeNavigations && !treeNavigations.isEmpty()) {
                if (null != filterItems && !filterItems.isEmpty()) {
                    for (Element e : treeNavigations) {
                        Element parent = e.getParentElement();
                        parent.removeContent((Content)e);
                    }
                    return output.outputString(doc);
                }
                return null;
            }
            return null;
        }
        catch (Exception var11) {
            return null;
        }
    }

    public UIViewInfo generateUIViewFragment(String parentkey, String subType) throws SHRWebException {
        UIViewInfo parentUIViewInfo = this.getUIViewInfoByUIPK(parentkey);
        if (parentUIViewInfo == null) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"view_not_exist"), parentkey));
        }
        IFragmentUIViewConverter converter = UIViewConverterFactory.getFragmentUIViewConverter((UIViewInfo)parentUIViewInfo, (Context)this.context);
        converter.setSubType(subType);
        return converter.exec();
    }

    public UIViewInfo getUIViewInfoFromCache(String uipk) {
        return (UIViewInfo)CacheService.getInstance().get("shr.uiView", this.getKey(uipk, this.context.getLocale().toString()));
    }

    public String getKey(String key, String locale) {
        return MessageFormat.format("{0}_{1}", key, locale);
    }

    public List<Map<String, Object>> getGridDataEntity(String uipk, String where) throws SHRWebException, ShrWebBizException, ParserException, BOSException {
        ListUIViewInfo uiViewInfo = (ListUIViewInfo)this.viewInfo;
        String query = uiViewInfo.getQuery();
        IQueryExecutor queryExecutor = this.getQueryExecutor(uipk, where, query);
        Uuid uuid = queryExecutor.openQuery();
        VirtualDataFetcher vdf = VirtualDataFetcher.createInstance((IQueryExecutor)queryExecutor, (Uuid)uuid, (int)0, (int)1000);
        List data = vdf.getData();
        return data;
    }

    public IQueryExecutor getQueryExecutor(String uipk, String where, String query) throws SHRWebException, ShrWebBizException, BOSException, ParserException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.context, (IMetaDataPK)MetaDataPK.create((String)query));
        EntityViewInfo entityViewInfo = this.getEntityViewInfo(uipk, where);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }
}

