/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kd.isc.connector.eas.EasContext;
import kd.isc.iscb.util.misc.FileUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EASConfig {
    private List<Member> members = new ArrayList<Member>();
    public static EASConfig INSTANCE = new EASConfig();

    private EASConfig() {
        FileReader in;
        String path = String.valueOf(System.getProperty("EAS_HOME")) + File.separator + "admin" + File.separator + "config" + File.separator + "domain.xml";
        FileUtil.checkFilePath((String)path);
        try {
            in = new FileReader(path);
        }
        catch (Throwable e) {
            EasContext.getErrLogger().warn((Object)("\u8bfb\u53d6domain.xml\u65f6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage()), e);
            return;
        }
        BufferedReader reader = new BufferedReader(in);
        try {
            try {
                String tempStr;
                StringBuilder content = new StringBuilder();
                while ((tempStr = reader.readLine()) != null) {
                    content.append(tempStr);
                }
                this.initMembers(content);
            }
            catch (Throwable e) {
                EasContext.getErrLogger().warn((Object)("\u52a0\u8f7d\u89e3\u6790domain.xml\u65f6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage()), e);
                try {
                    reader.close();
                }
                catch (Exception e2) {
                    EasContext.getErrLogger().warn((Object)("\u5173\u95edBufferedReader\u65f6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                EasContext.getErrLogger().warn((Object)("\u5173\u95edBufferedReader\u65f6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void initMembers(StringBuilder content) throws DocumentException {
        SAXReader reader = new SAXReader();
        reader.setIncludeExternalDTDDeclarations(false);
        Document doc = reader.read((Reader)new StringReader(content.toString()));
        List list = doc.selectNodes("domain/clustermanager/eascluster/members");
        if (list != null && list.size() > 0) {
            Element el = (Element)list.get(0);
            List members = el.elements();
            for (Element member : members) {
                String node = member.attribute("node").getValue();
                if (StringUtils.isEmpty((String)node)) continue;
                String ip = node.substring(0, node.indexOf(":"));
                String appServerHttpPort = member.attribute("appServerHttpPort").getValue();
                this.members.add(new Member(String.valueOf(ip) + ":" + appServerHttpPort));
            }
        }
    }

    public List<Member> getEasMembers() {
        return this.members;
    }

    public static class Member {
        private String httpUrl;

        public Member(String httpUrl) {
            this.httpUrl = httpUrl;
        }

        public String getHttpUrl() {
            return this.httpUrl;
        }
    }
}

