/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.DbConnector;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.TimeWaitUtil;
import kd.isc.connector.eas.notify.NotifyUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class PushDataJobHandler
implements IJobHandler {
    private static final long serialVersionUID = 1L;
    private String dataCenter;
    private Context ctx;
    private int interval;
    private static final Map<String, AtomicInteger> intervals = new ReadLockFreeMap();

    public PushDataJobHandler(String dataCenter) {
        this.dataCenter = dataCenter;
        this.ctx = Ctx.getShadowContext((String)dataCenter);
        this.interval = 0;
    }

    public Object execute(Job job) {
        block5: {
            try {
                if (!this.timeout()) break block5;
                Connection cn = DbConnector.getConnection((Context)this.ctx);
                try {
                    EventBindingUtil.pushAll((Connection)cn, (String)this.dataCenter);
                }
                finally {
                    DbUtil.close((Connection)cn, (boolean)false);
                }
            }
            catch (Throwable e) {
                EasContext.getErrLogger().warn((Object)StringUtil.toString((Throwable)e));
                intervals.get(this.dataCenter).set(512);
            }
        }
        return new Delay(TimeWaitUtil.getDelay());
    }

    private boolean timeout() {
        AtomicInteger top = intervals.get(this.dataCenter);
        if (++this.interval < top.get()) {
            return false;
        }
        this.interval = 0;
        int current = top.get();
        if (current >= 512) {
            return true;
        }
        while (!top.compareAndSet(current, current + current)) {
            current = top.get();
        }
        return true;
    }

    static void dataArrived(String dataCenter) {
        PushDataJobHandler.loadRightRow(dataCenter);
        if (!Configuration.isEnable()) {
            NotifyUtil.sendMsg(dataCenter, "NOTIFY_PUSH_DATA_JOB");
        }
    }

    public static void loadRightRow(String dataCenter) {
        AtomicInteger i = intervals.get(dataCenter);
        if (i == null) {
            PushDataJobHandler.init(dataCenter);
            i = intervals.get(dataCenter);
        }
        i.set(1);
    }

    public static synchronized void init(String dataCenter) {
        if (!intervals.containsKey(dataCenter)) {
            intervals.put(dataCenter, new AtomicInteger(64));
            Job job = new Job(null, (IJobHandler)new PushDataJobHandler(dataCenter), null, false);
            NotifyUtil.submitJob(job);
        }
    }
}

