/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.flow.core.Transition;
import kd.isc.iscb.util.flow.core.i.adapter.Begin;
import kd.isc.iscb.util.flow.core.i.adapter.Complete;
import kd.isc.iscb.util.flow.core.i.adapter.Fail;
import kd.isc.iscb.util.flow.core.i.adapter.LeapOver;
import kd.isc.iscb.util.flow.core.i.adapter.Ready;
import kd.isc.iscb.util.flow.core.i.adapter.Resume;
import kd.isc.iscb.util.flow.core.i.adapter.Started;
import kd.isc.iscb.util.flow.core.i.adapter.Suspend;
import kd.isc.iscb.util.flow.core.i.adapter.Terminate;
import kd.isc.iscb.util.flow.core.i.arithmetic.Graph;
import kd.isc.iscb.util.flow.core.i.c.common.End;
import kd.isc.iscb.util.flow.core.i.c.common.GotoDisposing;
import kd.isc.iscb.util.flow.core.i.c.common.Pause;
import kd.isc.iscb.util.flow.core.i.c.common.RestoreRecovery;
import kd.isc.iscb.util.flow.core.i.c.common.ResumeChildren;
import kd.isc.iscb.util.flow.core.i.c.common.SuspendChildren;
import kd.isc.iscb.util.flow.core.i.c.common.TerminateChildren;
import kd.isc.iscb.util.flow.core.i.c.common.ThrowError;
import kd.isc.iscb.util.flow.core.i.c.composite.StartSubNodes;
import kd.isc.iscb.util.flow.core.i.c.composite.SubFlowIsPartiallyDone;
import kd.isc.iscb.util.flow.core.i.c.composite.WaitingForChildren;
import kd.isc.iscb.util.flow.core.i.c.trans.CheckCompensation;
import kd.isc.iscb.util.flow.core.i.c.trans.ErrorHandle;
import kd.isc.iscb.util.flow.core.i.c.trans.RegisterCompensation;
import kd.isc.iscb.util.flow.core.i.c.trans.Sequence;
import kd.isc.iscb.util.flow.core.i.c.trans.StartupCompensation;
import kd.isc.iscb.util.flow.core.i.c.trans.XorChoice;
import kd.isc.iscb.util.flow.core.i.model.AbstractExecutable;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.GroupImpl;
import kd.isc.iscb.util.flow.core.i.model.Output;
import kd.isc.iscb.util.flow.core.i.model.Pattern;
import kd.isc.iscb.util.flow.core.i.model.TransitionImpl;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.flow.core.plugin.Callback;
import kd.isc.iscb.util.flow.core.plugin.SubFlowLoader;
import kd.isc.iscb.util.flow.core.plugin.Synchronizer;
import kd.isc.iscb.util.script.misc.Consts;

public final class NodeImpl
extends AbstractExecutable
implements Node {
    public static final String ROOT_ID = "$";
    private NodeImpl parent;
    private List<NodeImpl> children;
    private List<TransitionImpl> inComing = new ArrayList<TransitionImpl>();
    private List<TransitionImpl> outGoing = new ArrayList<TransitionImpl>();
    private Map<GroupImpl, Integer> groups;
    private Map<String, Pattern> pattern_map = new HashMap<String, Pattern>();
    private ArrayList<Pattern> patterns = new ArrayList();
    private Synchronizer synchronizer;
    private SubFlowLoader subFlowLoader;
    private boolean is_start;
    private boolean is_end;
    private boolean is_composite;
    private Output output;
    private Application application;
    private Callback callback;
    private Graph graph;
    private boolean has_compensation;
    private boolean is_compensation;

    public NodeImpl(NodeImpl parent, String id, String title) {
        super(parent.getFlow(), id, title);
        this.parent = parent;
        parent.addChildren(this);
    }

    NodeImpl(FlowImpl flow) {
        super(flow, ROOT_ID, ROOT_ID);
    }

    private void addChildren(NodeImpl child) {
        if (this.children == null) {
            this.children = new ArrayList<NodeImpl>();
        }
        this.children.add(child);
        this.setComposite();
    }

    @Override
    public boolean isComposite() {
        return this.is_composite;
    }

    @Override
    public boolean isCompensation() {
        return this.is_compensation;
    }

    public boolean hasCompensation() {
        return this.has_compensation;
    }

    public void setComposite() {
        this.is_composite = true;
    }

    @Override
    public NodeImpl getParent() {
        return this.parent;
    }

    public List<NodeImpl> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public int getChildrenCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    @Override
    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void join(GroupImpl group) {
        this.join(group, 0);
    }

    private void join(GroupImpl group, int depth) {
        if (this.groups == null) {
            this.groups = new HashMap<GroupImpl, Integer>();
        }
        this.groups.put(group, depth);
    }

    public List<TransitionImpl> getOutGoing() {
        return Collections.unmodifiableList(this.outGoing);
    }

    public List<TransitionImpl> getInComing() {
        return Collections.unmodifiableList(this.inComing);
    }

    @Override
    public boolean isStart() {
        return this.is_start;
    }

    @Override
    public boolean isEnd() {
        return this.is_end;
    }

    void addInComing(TransitionImpl in) {
        this.inComing.add(in);
    }

    void addOutGoing(TransitionImpl out) {
        this.outGoing.add(out);
        this.insertCompensationCommand(out);
    }

    public boolean exists(Pattern pattern) {
        return this.patterns.contains(pattern);
    }

    public void addPattern(Pattern p) {
        String[] keys = p.getMutex();
        boolean added = keys.length == 0;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Pattern c = this.pattern_map.get(key);
            if (c == null) {
                this.pattern_map.put(key, p);
                added = true;
            } else if (c != p) {
                throw new IscBizException("'" + p + "' conflicted with '" + c + "' in node '" + this + "'!");
            }
            ++n2;
        }
        if (added) {
            this.patterns.add(p);
        }
    }

    @Override
    public Pattern getPattern(String mutex) {
        return this.pattern_map.get(mutex);
    }

    @Override
    public String[] getFeatures() {
        String[] features = new String[this.patterns.size()];
        int i = 0;
        while (i < features.length) {
            features[i] = this.patterns.get(i).getName();
            ++i;
        }
        return features;
    }

    private void setStart() {
        if (this.is_start) {
            return;
        }
        int count = 0;
        for (TransitionImpl t : this.getInComing()) {
            if (t.getSource() == this) continue;
            ++count;
        }
        this.is_start = count == 0;
    }

    public void setStart(boolean start) {
        this.is_start = start;
    }

    public void setSubFlowLoader(SubFlowLoader subFlowLoader) {
        this.subFlowLoader = subFlowLoader;
    }

    public SubFlowLoader getSubFlowLoader() {
        return this.subFlowLoader;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        if (synchronizer == null) {
            return;
        }
        this.synchronizer = synchronizer;
        this.insert(Begin.CMD);
        this.insert(Complete.CMD);
        this.insert(Fail.CMD);
        this.insert(Terminate.CMD);
        this.insert(Suspend.CMD);
        this.insert(Resume.CMD);
        if (this.getParent() != null) {
            this.insert(LeapOver.CMD);
            this.insert(Ready.CMD);
            this.insert(Started.CMD);
        }
    }

    @Override
    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setEnd(boolean end) {
        this.is_end = end;
    }

    private void setEnd() {
        if (this.is_end) {
            return;
        }
        int count = 0;
        for (TransitionImpl t : this.getOutGoing()) {
            if (t.getTarget() == this) continue;
            ++count;
        }
        this.is_end = count == 0;
    }

    @Override
    Map<String, VariableImpl> getOtherAvailableVariables() {
        HashMap<String, VariableImpl> map = new HashMap<String, VariableImpl>();
        this.getVarsFromParent(map);
        this.getVarsFromGroups(map);
        return map;
    }

    private void getVarsFromGroups(Map<String, VariableImpl> map) {
        if (this.groups == null) {
            return;
        }
        HashMap<String, VariableImpl> scopes_vars = new HashMap<String, VariableImpl>();
        for (Map.Entry<GroupImpl, Integer> entry : this.groups.entrySet()) {
            if (entry.getValue() > 0) continue;
            this.getVarsFromGroup(scopes_vars, entry);
        }
        map.putAll(scopes_vars);
    }

    private GroupImpl getVarsFromGroup(Map<String, VariableImpl> scopes_vars, Map.Entry<GroupImpl, Integer> entry) {
        GroupImpl scope = entry.getKey();
        for (VariableImpl v : scope.getVariables().values()) {
            VariableImpl exists = scopes_vars.get(v.getName());
            if (exists == null) {
                scopes_vars.put(v.getName(), v);
                continue;
            }
            throw new IscBizException("Variable '" + v.getName() + "' conflicted in node '" + this + "'!");
        }
        return scope;
    }

    private void getVarsFromParent(Map<String, VariableImpl> map) {
        NodeImpl parent = this.getParent();
        if (parent != null) {
            map.putAll(parent.getAvailableVariables());
        } else {
            map.putAll(this.getFlow().getAvailableVariables());
        }
    }

    @Override
    void compile() {
        super.compile();
        this.setStart();
        this.setEnd();
        this.propagateGroups2Children();
        this.insertDefaultCommands();
        this.applyPatterns();
        this.compileChildren();
        this.checkChildren();
        this.insertCompositeCommands();
        this.handle4SubFlow();
        this.solidifyChildren();
        this.solidifyScopes();
        this.solidifyInComing();
        this.solidifyOutGoing();
    }

    private void handle4SubFlow() {
        if (this.getFlow().isSubFlow() && this.callback != null) {
            this.insert(SubFlowIsPartiallyDone.CMD);
        }
    }

    private void insertCompositeCommands() {
        if (this.is_composite) {
            this.insert(SuspendChildren.CMD);
            this.insert(ResumeChildren.CMD);
            this.insert(TerminateChildren.CMD);
            this.insert(WaitingForChildren.CMD_BEFORE_TERMINATED);
        }
    }

    private void insertDefaultCommands() {
        this.insertDefaultCommands4BlockNode();
        this.insertDefaultTransitCommand();
        this.insertErrorDeliverCommand();
        this.insert(ThrowError.CMD);
        this.insert(Pause.CMD_AFTER_SUSPENDED);
        this.insert(RestoreRecovery.CMD);
        this.insert(GotoDisposing.CMD);
        this.insert(End.CMD);
    }

    private void insertDefaultCommands4BlockNode() {
        if (this.children != null) {
            this.insert(StartSubNodes.CMD);
        }
        if (this.is_composite) {
            this.insert(WaitingForChildren.CMD_AFTER_STARTED);
        }
    }

    private void insertDefaultTransitCommand() {
        int count = 0;
        for (TransitionImpl t : this.outGoing) {
            if (t.getType() != Transition.Type.NORMAL) continue;
            ++count;
        }
        if (count == 1) {
            this.insert(new Sequence(this));
        } else if (count > 1) {
            this.insert(new XorChoice(this));
        }
    }

    private void insertErrorDeliverCommand() {
        int error = 0;
        for (TransitionImpl t : this.outGoing) {
            if (t.getType() != Transition.Type.ERROR) continue;
            ++error;
        }
        if (error > 0) {
            this.insert(new ErrorHandle(this));
        }
    }

    private void insertCompensationCommand(TransitionImpl out) {
        if (out.getType() == Transition.Type.COMPENSATION) {
            this.parent.insert(StartupCompensation.CMD);
            NodeImpl tar = out.getTarget();
            tar.is_compensation = true;
            this.insert(CheckCompensation.CMD);
            this.insert(RegisterCompensation.CMD);
            this.has_compensation = true;
        }
    }

    private void compileChildren() {
        if (this.children == null) {
            return;
        }
        for (NodeImpl c : this.children) {
            c.setStart();
            c.setEnd();
        }
        for (NodeImpl c : this.children) {
            c.compile();
        }
    }

    private void propagateGroups2Children() {
        if (this.children == null || this.groups == null) {
            return;
        }
        for (NodeImpl c : this.children) {
            for (Map.Entry<GroupImpl, Integer> e : this.groups.entrySet()) {
                GroupImpl group = e.getKey();
                int depth = e.getValue() + 1;
                c.join(group, depth);
            }
        }
    }

    private void checkChildren() {
        if (this.children == null) {
            return;
        }
        boolean hasStart = false;
        boolean hasEnd = false;
        for (NodeImpl c : this.children) {
            if (c.is_start) {
                hasStart = true;
            }
            if (!c.is_end) continue;
            hasEnd = true;
        }
        if (!hasStart) {
            throw new IscBizException("Can't find start node for '" + this + "'!");
        }
        if (!hasEnd) {
            throw new IscBizException("Can't find end node for '" + this + "'!");
        }
    }

    private void applyPatterns() {
        if (this.patterns.size() > 0) {
            Object[] features = this.patterns.toArray(new Pattern[this.patterns.size()]);
            Arrays.sort(features);
            Object[] objectArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                ((Pattern)f).apply(this);
                ++n2;
            }
        }
        if (this.pattern_map.size() == 0) {
            this.pattern_map = Consts.EMPTY_MAP;
        }
    }

    private void solidifyChildren() {
        this.children = this.children == null ? Consts.EMPTY_LIST : Collections.unmodifiableList(this.children);
    }

    private void solidifyScopes() {
        this.groups = this.groups == null ? Consts.EMPTY_MAP : Collections.unmodifiableMap(this.groups);
    }

    private void solidifyInComing() {
        this.inComing = this.inComing.size() == 0 ? Consts.EMPTY_LIST : Collections.unmodifiableList(this.inComing);
    }

    private void solidifyOutGoing() {
        this.outGoing = this.outGoing.size() == 0 ? Consts.EMPTY_LIST : Collections.unmodifiableList(this.outGoing);
    }

    void dumpMicroProgram(StringBuilder sb, int depth) {
        sb.append("\r\n");
        int i = 0;
        while (i <= depth) {
            sb.append("    ");
            ++i;
        }
        sb.append(this).append('(').append(this.getId()).append(')').append(": ");
        super.dumpMicroProgram(sb);
        for (NodeImpl child : this.getChildren()) {
            child.dumpMicroProgram(sb, depth + 1);
        }
    }

    void dumpDiagram(StringBuilder sb) {
        if (this.children.size() > 0) {
            sb.append("\r\n").append(this).append(":\r\n");
            for (NodeImpl c : this.children) {
                sb.append("    ").append(c);
                if (c.isStart()) {
                    sb.append('^');
                } else if (c.isEnd()) {
                    sb.append('~');
                }
                sb.append("\t=>");
                for (TransitionImpl out : c.getOutGoing()) {
                    sb.append(' ').append(out.getTarget());
                    if (out.isBackward()) {
                        sb.append("(*)");
                    }
                    sb.append(';');
                }
                sb.append("\r\n");
            }
        }
        for (NodeImpl child : this.getChildren()) {
            child.dumpDiagram(sb);
        }
    }

    @Override
    public Graph getGraph() {
        if (this.graph == null) {
            this.graph = new Graph(this);
        }
        return this.graph;
    }
}

