/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.CharBuffer;
import kd.isc.iscb.util.misc.CharReader;
import kd.isc.iscb.util.misc.StringUtil;

public class Json {
    public static final String BASE64_PREFIX = "data::base64encoded://";
    public static final int MAX_LEVEL = 64;
    public static final String JSON_PREFIX = "json:";
    public static final Object NULL = new Object();
    private static ReadLockFreeMap<Class<?>, Serializer> serializers = new ReadLockFreeMap();

    public static void escape(String s, StringBuilder sb) {
        if (s == null) {
            sb.append("null");
            return;
        }
        sb.append('\"');
        if (s.startsWith(BASE64_PREFIX)) {
            sb.append(s);
        } else {
            Json.appendNormalString(s, sb);
        }
        sb.append('\"');
    }

    private static void appendNormalString(String s, StringBuilder sb) {
        int i = 0;
        int j = s.length();
        while (i < j) {
            char c = s.charAt(i);
            if (c > '\\') {
                sb.append(c);
            } else {
                switch (c) {
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
    }

    public static String toString(Object o) {
        return Json.toString(o, false);
    }

    public static String escapeHTML(Object o) {
        String s = Json.toString(o);
        if (s.indexOf(60) < 0) {
            return s;
        }
        int i = 0;
        int j = s.indexOf(60);
        StringBuilder sb = new StringBuilder();
        while (j > 0) {
            sb.append(s.substring(i, j));
            sb.append("<\"+\"");
            i = j + 1;
            j = s.indexOf(60, i);
        }
        if (i < s.length()) {
            sb.append(s.substring(i, s.length()));
        }
        return sb.toString();
    }

    public static String toString(Object o, boolean withoutBrackets) {
        String s;
        if (o instanceof String && (s = (String)o).startsWith(JSON_PREFIX)) {
            return s.substring(JSON_PREFIX.length());
        }
        StringBuilder sb = new StringBuilder();
        if (!withoutBrackets) {
            sb.append('(');
        }
        Json.toString(o, sb, 0);
        if (!withoutBrackets) {
            sb.append(')');
        }
        return sb.toString();
    }

    public static StringBuilder toString(Object o, StringBuilder buffer, int level) {
        if (level >= 64) {
            throw new IscBizException("Collection or Map nested level is too deep, and there may be exist a recursive reference.");
        }
        if (o == null || o == NULL) {
            return buffer.append("null");
        }
        if (o instanceof Boolean) {
            return buffer.append(o);
        }
        if (o instanceof Number) {
            return Json.numberToString(o, buffer);
        }
        if (o instanceof CharSequence) {
            Json.escape(o.toString(), buffer);
            return buffer;
        }
        if (o instanceof byte[]) {
            String s = Hex.encode((byte[])o);
            buffer.append('\"').append(s).append('\"');
            return buffer;
        }
        if (o instanceof Object[]) {
            return Json.toString((Object[])o, buffer, level + 1);
        }
        if (o instanceof Collection) {
            return Json.toString((Collection)((Object)o), buffer, level + 1);
        }
        if (o.getClass().isArray()) {
            return Json.toString2(o, buffer, level + 1);
        }
        if (o instanceof Throwable) {
            o = Json.wrap((Throwable)((Object)o));
        }
        if (o instanceof Map) {
            return Json.toString(o, buffer, level + 1);
        }
        if (o instanceof Date) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof Time) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof Timestamp) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof java.util.Date) {
            return Json.dateToString((java.util.Date)((Object)o), buffer);
        }
        if (o instanceof Map.Entry) {
            return Json.entryToString((Map.Entry)((Object)o), buffer, level);
        }
        if (o instanceof ObjectReader) {
            ObjectReader reader = (ObjectReader)((Object)o);
            return Json.readerToString(reader, buffer, level);
        }
        Serializer s = serializers.get(o.getClass());
        if (s != null) {
            buffer.append(s.toJson(o));
        } else {
            Json.escape(o.toString(), buffer);
        }
        return buffer;
    }

    private static StringBuilder readerToString(ObjectReader<?> reader, StringBuilder buffer, int level) {
        try {
            buffer.append('[');
            boolean first = true;
            Object item = reader.read();
            while (item != null) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                Json.toString(item, buffer, level + 1);
                item = reader.read();
            }
            buffer.append(']');
            StringBuilder stringBuilder = buffer;
            return stringBuilder;
        }
        catch (Exception e) {
            throw D.e(e);
        }
        finally {
            DbUtil.close(reader);
        }
    }

    private static StringBuilder entryToString(Map.Entry<?, ?> p, StringBuilder buffer, int level) {
        buffer.append('{');
        buffer.append("\"key\":");
        Json.toString(p.getKey(), buffer, level + 1);
        buffer.append(",\"value\":");
        Json.toString(p.getValue(), buffer, level + 1);
        buffer.append('}');
        return buffer;
    }

    private static StringBuilder dateToString(java.util.Date d, StringBuilder buffer) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return buffer.append('\"').append(df.format(d)).append('\"');
    }

    private static StringBuilder numberToString(Object o, StringBuilder buffer) {
        if (o instanceof BigDecimal) {
            return buffer.append('\"').append(((BigDecimal)o).toPlainString()).append('\"');
        }
        if (o instanceof Integer || o instanceof Byte || o instanceof Short || o instanceof Double || o instanceof Float) {
            return buffer.append(o).append(' ');
        }
        return buffer.append('\"').append(o).append('\"');
    }

    private static StringBuilder toString(Collection<?> l, StringBuilder buffer, int level) {
        buffer.append('[');
        boolean first = true;
        Iterator<?> it = l.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            Json.toString(it.next(), buffer, level + 1);
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString2(Object array, StringBuilder buffer, int level) {
        buffer.append('[');
        int len = Array.getLength(array);
        int i = 0;
        while (i < len) {
            if (i > 0) {
                buffer.append(',');
            }
            Object value = Array.get(array, i);
            Json.toString(value, buffer, level + 1);
            ++i;
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString(Object[] a, StringBuilder buffer, int level) {
        buffer.append('[');
        int i = 0;
        while (i < a.length) {
            if (i > 0) {
                buffer.append(',');
            }
            Json.toString(a[i], buffer, level + 1);
            ++i;
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString(Map<?, ?> m, StringBuilder buffer, int level) {
        buffer.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object value = entry.getValue();
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            Object key = entry.getKey();
            Json.toString(key, buffer, level + 1);
            buffer.append(':');
            Json.toString(value, buffer, level + 1);
        }
        buffer.append('}');
        return buffer;
    }

    public static Object toObject(String json) {
        if (json == null || json.length() == 0) {
            return null;
        }
        StringReader sr = new StringReader(json);
        try {
            if (json.startsWith(JSON_PREFIX)) {
                while (sr.read() != 58) {
                }
            }
            return Json.toObject(sr);
        }
        catch (IOException e) {
            throw new IscBizException(e);
        }
    }

    public static Object toObject(Reader sr) throws IOException {
        int i = sr.read();
        if (i == 65279) {
            i = sr.read();
        }
        if (i == 40) {
            i = sr.read();
        }
        switch (i) {
            case 34: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 91: 
            case 102: 
            case 110: 
            case 116: 
            case 123: {
                CharBuffer cb = new CharBuffer();
                return Json.asObject(new CharReader(sr), i, cb);
            }
        }
        throw new IscBizException("Invalid json format, unexpected char : " + (char)i + "(" + i + ")");
    }

    private static Object asObject(CharReader sr, int priorChar, CharBuffer cb) throws IOException {
        if (priorChar == 40) {
            priorChar = sr.read();
        }
        switch (priorChar) {
            case 110: {
                return Json.asNull(sr);
            }
            case 102: 
            case 116: {
                return Json.asBoolean(sr);
            }
            case 34: {
                return Json.asString(sr, cb);
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return Json.asNumber(sr, priorChar, cb);
            }
            case 91: {
                return Json.asList(sr, cb);
            }
            case 123: {
                return Json.asMap(sr, cb);
            }
            case 42: {
                return null;
            }
        }
        throw new IscBizException("invalid json format");
    }

    private static Object asNumber(CharReader sr, int priorChar, CharBuffer cb) throws IOException {
        String t;
        cb.clear();
        cb.append((char)priorChar);
        int c = sr.read();
        while (c >= 0 && c != 32) {
            if (c == 44 || c == 41 || c == 93 || c == 125 || c == 58) {
                sr.back(c);
                break;
            }
            cb.append((char)c);
            c = sr.read();
        }
        if ((t = cb.toString()).indexOf(46) >= 0) {
            if (t.indexOf(69) > 0 || t.indexOf(101) > 0) {
                return Double.valueOf(t);
            }
            return new BigDecimal(t);
        }
        if (t.startsWith("0E") || t.startsWith("0e")) {
            return Double.valueOf(t);
        }
        if (t.length() > 18) {
            return new BigInteger(t);
        }
        if (t.length() >= 9) {
            return Long.valueOf(t);
        }
        return Integer.valueOf(t);
    }

    private static Object asString(CharReader s, CharBuffer cb) throws IOException {
        cb.clear();
        int c = s.read();
        while (c >= 0) {
            block0 : switch (c) {
                case 34: {
                    return cb.toString();
                }
                case 92: {
                    c = s.read();
                    switch (c) {
                        case 114: {
                            cb.append('\r');
                            break block0;
                        }
                        case 110: {
                            cb.append('\n');
                            break block0;
                        }
                        case 39: {
                            cb.append('\'');
                            break block0;
                        }
                        case 34: {
                            cb.append('\"');
                            break block0;
                        }
                        case 116: {
                            cb.append('\t');
                            break block0;
                        }
                        case 92: {
                            cb.append('\\');
                            break block0;
                        }
                        case 47: {
                            cb.append('/');
                            break block0;
                        }
                    }
                    throw new IscBizException("\\" + (char)c + " is not valid char.");
                }
                default: {
                    cb.append((char)c);
                }
            }
            c = s.read();
        }
        return cb.length() > 0 ? cb.toString() : null;
    }

    private static Object asNull(CharReader s) throws IOException {
        s.read();
        s.read();
        s.read();
        return null;
    }

    private static Object asBoolean(CharReader s) throws IOException {
        s.read();
        s.read();
        int i = s.read();
        if (i == 101) {
            return Boolean.TRUE;
        }
        s.read();
        return Boolean.FALSE;
    }

    private static ArrayList<Object> asList(CharReader s, CharBuffer cb) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int c = s.read();
        while (c >= 0) {
            switch (c) {
                case 93: {
                    return list;
                }
                case 34: 
                case 42: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 91: 
                case 102: 
                case 110: 
                case 116: 
                case 123: {
                    list.add(Json.asObject(s, c, cb));
                    c = s.read();
                    break;
                }
                case 40: 
                case 41: 
                case 44: {
                    c = s.read();
                    break;
                }
                default: {
                    throw new IscBizException("char {" + (char)c + "} is an invalid char.");
                }
            }
        }
        return list;
    }

    private static LinkedHashMap<Object, Object> asMap(CharReader s, CharBuffer cb) throws IOException {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int c = s.read();
        while (c >= 0) {
            switch (c) {
                case 125: {
                    return map;
                }
                case 34: 
                case 42: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 91: 
                case 102: 
                case 110: 
                case 116: 
                case 123: {
                    Object key = Json.asObject(s, c, cb);
                    s.read();
                    Object value = Json.asObject(s, s.read(), cb);
                    map.put(key, value);
                    c = s.read();
                    break;
                }
                case 40: 
                case 41: 
                case 44: {
                    c = s.read();
                    break;
                }
                default: {
                    throw new IscBizException("char {" + (char)c + "} is an invalid char.");
                }
            }
        }
        return map;
    }

    public static boolean isQName(String name) {
        if (!Json.isLetter(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Json.isLetterOrDigital(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInteger(String name) {
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Json.isDigital(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSpace(char c) {
        return c <= ' ';
    }

    public static boolean isLetterOrDigital(char c) {
        return Json.isLetter(c) || Json.isDigital(c);
    }

    public static boolean isLetter(char c) {
        return c == '_' || c == '$' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isDigital(char c) {
        return c >= '0' && c <= '9';
    }

    public static Map<String, Object> wrap(Throwable e) {
        String code;
        HashMap<String, Object> data = new HashMap<String, Object>();
        String message = e.getMessage();
        if (message == null) {
            message = e.getClass().getName();
        }
        data.put("#message", message);
        if (e instanceof IscBizException && (code = ((IscBizException)e).getCode()) != null) {
            data.put("#code", code);
        }
        data.put("#stack_trace", StringUtil.toString(e));
        return data;
    }

    public static <T> T copy(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (T)Json.copyList((List)value);
        }
        if (value instanceof Set) {
            return (T)Json.copySet((Set)value);
        }
        if (value instanceof Map) {
            return (T)Json.copyMap((Map)value);
        }
        if (value instanceof Object[]) {
            return (T)Json.copyArray((Object[])value);
        }
        return value;
    }

    private static Object[] copyArray(Object[] value) {
        return Arrays.copyOf(value, value.length);
    }

    private static Map<?, ?> copyMap(Map<?, ?> value) {
        LinkedHashMap map = new LinkedHashMap(value.size());
        for (Map.Entry<?, ?> e : value.entrySet()) {
            map.put(e.getKey(), Json.copy(e.getValue()));
        }
        return map;
    }

    private static Set<?> copySet(Set<?> value) {
        HashSet set = new HashSet(value.size());
        set.addAll(value);
        return set;
    }

    private static List<?> copyList(List<?> value) {
        ArrayList list = new ArrayList(value.size());
        for (Object item : value) {
            list.add(Json.copy(item));
        }
        return list;
    }

    public static void register(Serializer s) {
        serializers.put(s.getTargetClass(), s);
    }

    public static interface Serializer {
        public Class<?> getTargetClass();

        public String toJson(Object var1);
    }
}

