/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WFNoticeAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFNoticeAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum MESSAGEMODEL = null;

    public boolean isNeedSendXT() {
        String content;
        boolean blackMode = true;
        String dbCode = this.ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String mode = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "scope.text.pattern.mode", "");
        if ("0".equals(mode)) {
            blackMode = false;
        }
        if ((content = this.parseContent()) == null) {
            return false;
        }
        String list = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "scope.text.pattern.list", "");
        if (list == null || list.length() == 0) {
            return true;
        }
        String[] patternList = list.split(";");
        boolean findStr = false;
        int i = 0;
        while (i < patternList.length) {
            String patternStr = "^((?!" + patternList[i] + ").)+$";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(content.toString());
            if (!matcher.find()) {
                findStr = true;
                break;
            }
            ++i;
        }
        if (blackMode) {
            return !findStr;
        }
        return findStr;
    }

    public WFNoticeAdapter(Message message) {
        logger.debug((Object)"WfNoticeAdapter init");
        this.message = message;
        this.ctx = WFNoticeAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.TEXT;
    }

    public MessageModelEnum getModel() {
        return this.MESSAGEMODEL;
    }

    public Map<String, Object> getContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        Locale locale = this.getConfigLocale(eid);
        contents.put("appid", appId);
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.MESSAGEMODEL)) {
            MsgBizType bizType = MsgBizType.getEnum((int)this.message.getIntHeader("bizType"));
            String tagId = MsgBizType.FORWARN == bizType ? "alarm" : "notify";
            contents.put("tagId", tagId);
            contents.put("itemtitle", this.message.getLocaleStringHeader("title", locale));
            contents.put("text", this.message.getLocaleStringHeader("body", locale));
            contents.put("assignId", UUID.randomUUID() + "LCZSITEM");
        } else {
            contents.put("text", this.parseContent());
        }
        String wxtitle = "l1".equalsIgnoreCase(locale.getDisplayName()) ? "notice" : "\u6d88\u606f\u901a\u77e5";
        contents.put("wxtitle", wxtitle);
        contents.put("sendId", this.message.getStringHeader("initiatorId"));
        contents.put("procinstid", this.message.getStringHeader("ProcessInstId"));
        contents.put("receiver", this.message.getStringHeader("receiver"));
        return contents;
    }

    private String parseContent() {
        String msgContent;
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        Locale locale = this.getConfigLocale(eid);
        String msgTitle = this.message.getLocaleStringHeader("title", locale);
        String msgBody = this.message.getLocaleStringHeader("body", locale);
        msgTitle = StringUtils.isEmpty((String)msgTitle) ? msgBody : msgTitle;
        String string = msgContent = !StringUtils.isEmpty((String)msgBody) && msgBody.startsWith(msgTitle) ? "" : msgTitle;
        msgContent = StringUtils.isEmpty((String)msgContent) ? msgBody : String.valueOf(msgContent) + (StringUtils.isEmpty((String)msgBody) ? "" : "\n" + msgBody);
        logger.info((Object)("XT Notices parseContext() body=" + this.message.getLocaleStringHeader("body", locale) + ",title=" + this.message.getLocaleStringHeader("title", locale)));
        return msgContent;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private Locale getConfigLocale(String eid) {
        String localeStr = XTServiceConfig.getInstance().getLocale(eid);
        localeStr = StringUtils.isEmpty((String)localeStr) ? "L2" : localeStr;
        return LocaleUtils.getLocale((String)localeStr);
    }

    private void initMessageModel() {
        String api = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        this.MESSAGEMODEL = "flowcenter".equalsIgnoreCase(api) ? MessageModelEnum.FLOWCENTERNOTICE : null;
    }
}

