/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class WFProcessinstAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFProcessinstAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum messageModel = null;
    private Map<String, Map<String, Object>> eidContentMap = null;

    public boolean isNeedSendXT() {
        return true;
    }

    public WFProcessinstAdapter(Message message) {
        logger.debug((Object)"WFProcessinstAdapter init");
        this.message = message;
        this.ctx = WFProcessinstAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public MessageModelEnum getModel() {
        return this.messageModel;
    }

    public Map<String, Object> getContent() {
        String mbosUrl;
        this.eidContentMap = this.eidContentMap == null ? new HashMap() : this.eidContentMap;
        String dbCode = this.ctx.getAIS();
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(dbCode);
        if (this.eidContentMap.get(eid) != null) {
            return this.eidContentMap.get(eid);
        }
        HashMap<String, Object> contents = new HashMap<String, Object>();
        Map<String, Object> content = this.parseContent();
        Locale locale = this.getConfigLocale(eid);
        String wxtitle = "l1".equalsIgnoreCase(locale.getDisplayName()) ? "notice" : "\u6d88\u606f\u901a\u77e5";
        contents.put("wxtitle", wxtitle);
        contents.putAll(content);
        String assignid = this.message.getStringHeader("assignid");
        String fproinstid = this.message.getStringHeader("ProcessInstId");
        String initiatorId = URLEncoder.encode(this.message.getStringHeader("initiatorId"));
        String host = instance.getPubAcctProperty(eid, "WFMessage", "host", "");
        String appId = instance.getPubAcctProperty(eid, "WFMessage", "appId", "");
        String newEid = instance.getPubAcctProperty(eid, "WFMessage", "eid", "");
        String procid = this.message.getStringHeader("ProcessDefId");
        String actDefId = this.message.getStringHeader("activityDefId");
        String url = host;
        if (!(StringUtils.isEmpty((String)procid) || StringUtils.isEmpty((String)actDefId) || StringUtils.isEmpty((String)(mbosUrl = this.getMbosUrl(procid, actDefId, fproinstid, eid))))) {
            url = mbosUrl.replace("page/loadPage", "mbosw/getWorkflowUrl");
            url = String.valueOf(url) + (host.contains("&") ? host.substring(host.indexOf("&"), host.length()) : "");
        }
        if (url.indexOf("?") > -1) {
            if (url.indexOf("name") == -1) {
                url = String.valueOf(url) + "&storeEid=21231&name=approveui.navui";
            }
            url = String.valueOf(url) + "&viewtype=message&eid=" + newEid + "&type=message&fpersonuserid=" + initiatorId + "&appid=" + appId + "&fprocinstid=" + fproinstid + "&actDefId=" + actDefId;
        } else {
            url = String.valueOf(url) + "/otherDetails.html?viewtype=message&eid=" + newEid + "&type=message&fpersonuserid=" + initiatorId + "&appid=" + appId + "&fprocinstid=" + fproinstid;
        }
        contents.put("url", url);
        contents.put("appid", appId);
        contents.put("procinstid", fproinstid);
        contents.put("sendId", this.message.getStringHeader("initiatorId"));
        contents.put("receiver", this.message.getStringHeader("receiver"));
        contents.put("todo", "0");
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.messageModel)) {
            contents.put("itemtitle", this.message.getLocaleStringHeader("title", locale));
            contents.put("text", this.message.getLocaleStringHeader("body", locale));
            contents.put("tagId", "notify");
            contents.put("assignId", UUID.randomUUID() + "LCZSITEM");
        }
        return contents;
    }

    private String getMbosUrl(String procid, String actDefId, String procinstId, String eid) {
        String url = "";
        try {
            IRowSet rowSet;
            StringBuffer sql = new StringBuffer("SELECT url FROM T_WFR_MBOS_WORKFLOW WHERE url like '%eid=" + eid + "%'");
            if (!StringUtils.isEmpty((String)actDefId)) {
                sql.append(" and actDefId in ('" + actDefId + "')");
            }
            if (!StringUtils.isEmpty((String)procid)) {
                sql.append(" and procdefid in ('" + procid + "')");
            }
            if ((rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString())).next()) {
                url = rowSet.getString("url");
            }
            if (!StringUtils.isEmpty((String)url)) {
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String billid = service.getBizObjIdByProcessInstanceId(procinstId);
                url = String.valueOf(url) + "&billID=" + URLEncoder.encode(billid);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url;
    }

    private Map<String, Object> parseContent() {
        String msgContent;
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        Locale locale = this.getConfigLocale(eid);
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String msgTitle = this.message.getLocaleStringHeader("title", locale);
        String msgBody = this.message.getLocaleStringHeader("body", locale);
        msgTitle = StringUtils.isEmpty((String)msgTitle) ? msgBody : msgTitle;
        String string = msgContent = !StringUtils.isEmpty((String)msgBody) && msgBody.startsWith(msgTitle) ? "" : msgTitle;
        msgContent = StringUtils.isEmpty((String)msgContent) ? msgBody : String.valueOf(msgContent) + (StringUtils.isEmpty((String)msgBody) ? "" : "\n" + msgBody);
        contents.put("text", msgContent);
        logger.info((Object)("XT Message parseContext() body=" + this.message.getLocaleStringHeader("body", locale) + ",title=" + this.message.getLocaleStringHeader("title", locale)));
        return contents;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private Locale getConfigLocale(String eid) {
        String localeStr = XTServiceConfig.getInstance().getLocale(eid);
        localeStr = StringUtils.isEmpty((String)localeStr) ? "L2" : localeStr;
        return LocaleUtils.getLocale((String)localeStr);
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            String initiatorId;
            String quarySql;
            IRowSet rowSet;
            String procinstid = this.message.getStringHeader("ProcessInstId");
            if ("flowcenter".equalsIgnoreCase(apiVersion) && !StringUtils.isEmpty((String)procinstid) && (rowSet = DbUtil.executeQuery((Context)this.ctx, (String)(quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? "), (Object[])new Object[]{initiatorId = this.message.getStringHeader("initiatorId"), initiatorId})).next()) {
                ifInit = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.messageModel = MessageModelEnum.FLOWCENTERNOTICE;
        }
    }
}

