/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.permission.ActiveStateEnum;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLicenseGroupCollection;
import com.kingdee.eas.base.permission.UserLicenseGroupFactory;
import com.kingdee.eas.base.permission.UserLicenseGroupInfo;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.GroupLicenseUseInfo;
import com.kingdee.eas.base.permission.app.SyncUserResultInfo;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.app.util.PermThreadPool;
import com.kingdee.eas.base.permission.app.util.UserLogUtil;
import com.kingdee.eas.base.permission.app.util.interior.ILicenseUseSrv;
import com.kingdee.eas.base.permission.app.util.interior.IUserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseManager;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseConstantHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper4User;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.DBUserBean;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.cloud.activiation.UserNoActiviationHelper;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class UserLicenseGroupHelper1 {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper1");
    LicenseUseManager licenseUserManager = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    static UserLicenseGroupHelper1 instance = null;

    private UserLicenseGroupHelper1(Context ctx) {
    }

    public static UserLicenseGroupHelper1 getInstance(Context ctx) {
        if (instance == null) {
            instance = new UserLicenseGroupHelper1(ctx);
        }
        return instance;
    }

    private ILicenseUseSrv getLicenseUseSev(Context ctx) throws BOSException {
        return LicenseUseSrvFactory.getLocalInstance((Context)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealLicGroupHelperbyLicense(Context ctx) {
        if (ctx == null) {
            return;
        }
        Map licenseUsersInfo = null;
        try {
            licenseUsersInfo = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getRegistUserMapGroup();
        }
        catch (LicenseException e) {
            logger.error((Object)"LicenseUseManager.loadDataFromLicense():getRegistUserMapGroup error.");
        }
        HashMap<String, String> mpNumberUserId = new HashMap<String, String>();
        String selSql = "select fid,fnumber from t_pm_user";
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e2) {
            logger.error((Object)e2);
        }
        Statement state = null;
        try {
            state = conn.createStatement();
            ResultSet rs = state.executeQuery(selSql);
            while (rs.next()) {
                mpNumberUserId.put(rs.getString("fnumber").toLowerCase(), rs.getString("fid"));
            }
            rs.close();
            String delSql = "delete from T_PM_UserLicenseGroup where fuserId=? and fgroupNumber=?";
            String insSql = "insert into T_PM_UserLicenseGroup(FuserId,FGroupNumber,FSynUser,fid,fisactive) values(?,?,?,?,?)";
            PreparedStatement ps = conn.prepareStatement(insSql);
            PreparedStatement ps1 = conn.prepareStatement(delSql);
            if (licenseUsersInfo != null) {
                for (CloudRegistUserInfo cui : licenseUsersInfo.values()) {
                    String fid = (String)mpNumberUserId.get(cui.getErpNumber().toLowerCase());
                    if (fid == null || fid.trim().length() == 0 || UserLicenseConstantHelper.IGNORE_SYNTOCLOUD_USERS.contains(fid.trim()) || cui == null || cui.getGroup() == null) continue;
                    for (String group : cui.getGroup()) {
                        if (group == null || group.trim().length() == 0) continue;
                        ps.setString(1, fid);
                        ps.setString(2, group);
                        ps.setInt(3, SynStateEnum.SYN_YES.getValue());
                        ps.setString(4, BOSUuid.create((String)"94716EDD").toString());
                        ps.setInt(5, 1);
                        ps.addBatch();
                        ps1.setString(1, fid);
                        ps1.setString(2, group);
                        ps1.addBatch();
                    }
                }
                ps1.executeBatch();
                ps1.close();
                ps.executeBatch();
                ps.close();
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)state, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String synResultUpdate2ERP(Context ctx, Map<String, UserInfo> synUserMap) throws BOSException, EASBizException {
        this.dealLicGroupbyLicense4synCloud2ERP(ctx);
        String sqlLicenseGroupDiff = "delete from t_pm_userLicGroupDiff where FuserId = ?";
        String sqlUser = "update t_pm_user set fuid=?,fisSynToCloud=? where fid=?";
        Connection conn = null;
        int modNumber = 0;
        Boolean flag = false;
        Boolean deleteFlag = false;
        PreparedStatement updateUserStmt = null;
        Statement deleteUserStmt = null;
        ArrayList<String> synUpdateUserIDs = new ArrayList<String>();
        String result = "{'success':'true'}";
        try {
            int i;
            conn = EJBFactory.getConnection((Context)ctx);
            updateUserStmt = conn.prepareStatement(sqlUser);
            UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where isSynToCloud <> 1");
            for (i = 0; i < users.size(); ++i) {
                UserInfo user = synUserMap.get(users.get(i).getNumber());
                if (user == null) continue;
                String userID = users.get(i).getId().toString();
                updateUserStmt.setString(1, user.getUid());
                updateUserStmt.setInt(2, 1);
                updateUserStmt.setString(3, userID);
                synUpdateUserIDs.add(userID);
                updateUserStmt.addBatch();
                if (++modNumber % 1000 == 0) {
                    updateUserStmt.executeBatch();
                    updateUserStmt.clearBatch();
                    flag = true;
                    continue;
                }
                flag = false;
            }
            if (!flag.booleanValue()) {
                updateUserStmt.executeBatch();
            }
            modNumber = 0;
            deleteUserStmt = conn.prepareStatement(sqlLicenseGroupDiff);
            for (i = 0; i < synUpdateUserIDs.size(); ++i) {
                deleteUserStmt.setString(1, (String)synUpdateUserIDs.get(i));
                if (++modNumber % 1000 == 0) {
                    deleteUserStmt.executeBatch();
                    deleteUserStmt.clearBatch();
                    deleteFlag = true;
                    continue;
                }
                deleteFlag = false;
            }
            if (!deleteFlag.booleanValue()) {
                deleteUserStmt.executeBatch();
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            logger.error((Object)"synResultUpdate2ERP error {}", (Throwable)e);
            String string = result = "{'success':'false';'error':'" + e + "'}";
            return string;
        }
        finally {
            try {
                if (updateUserStmt != null) {
                    updateUserStmt.close();
                }
                if (deleteUserStmt != null) {
                    deleteUserStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                ILicenseUseSrv ilus = this.getLicenseUseSev(ctx);
                ilus.dealLicenseGroupUsageInfo(ctx);
            }
            catch (SQLException e) {
                logger.error((Object)"synResultUpdate2ERP-rollback error {}", (Throwable)e);
            }
            catch (LicenseException e1) {
                logger.error((Object)"UserLicenseGroupHelper1.synCloudUser2ERP-1{}", (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synCloudUser2ERP(Context ctx, List<UserInfo> userList) throws BOSException, EASBizException {
        logger.error((Object)"enter tj test-error: test1.");
        this.dealLicGroupbyLicense4synCloud2ERP(ctx);
        if (userList == null || userList.size() == 0) {
            return;
        }
        ArrayList<UserInfo> userListPri = new ArrayList<UserInfo>();
        userListPri.addAll(userList);
        String sqlLicenseGroupDiff = "delete from t_pm_userLicGroupDiff where FuserId = ?";
        String sqlUser = "update t_pm_user set fuid=?,fisSynToCloud=? where fid=?";
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            PreparedStatement ps2 = conn.prepareStatement(sqlUser);
            UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where isSynToCloud <> 1");
            for (int i = 0; i < userList.size(); ++i) {
            }
            ps2.executeBatch();
            ps2.close();
            PreparedStatement ps1 = conn.prepareStatement(sqlLicenseGroupDiff);
            int size = userListPri.size();
            for (int i = 0; i < size; ++i) {
                if (userListPri.get(i) == null || ((UserInfo)userListPri.get(i)).getId() == null) continue;
                ps1.setString(1, ((UserInfo)userListPri.get(i)).getId().toString());
                ps1.addBatch();
            }
            ps1.executeBatch();
            ps1.close();
        }
        catch (SQLException e) {
            logger.error((Object)"UserLicenseGroupHelper1.synCloudUser2ERP-1");
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup(null, null, (Connection)conn);
            try {
                ILicenseUseSrv ilus = this.getLicenseUseSev(ctx);
                ilus.dealLicenseGroupUsageInfo(ctx);
            }
            catch (LicenseException e1) {
                logger.error((Object)"UserLicenseGroupHelper1.synCloudUser2ERP-1");
                logger.error((Object)e1);
            }
        }
    }

    private boolean checkIsSynSuccessByKeyInfo(Context ctx, UserInfo erpUserInfo, Map<String, Set> ulicMap, SyncUserResultInfo cloudUserInfo) {
        if (cloudUserInfo == null) {
            return erpUserInfo.isIsForbidden() || erpUserInfo.isIsDelete();
        }
        if (erpUserInfo.isIsForbidden() || erpUserInfo.isIsDelete()) {
            return false;
        }
        if (!(erpUserInfo.getNumber() == null && cloudUserInfo.getNumber() == null || erpUserInfo.getNumber() == null || erpUserInfo.getNumber().equalsIgnoreCase(cloudUserInfo.getNumber()))) {
            return false;
        }
        if (!(erpUserInfo.getCell() == null && cloudUserInfo.getCell() == null || erpUserInfo.getCell() == null || erpUserInfo.getCell().equalsIgnoreCase(cloudUserInfo.getCell()))) {
            return false;
        }
        try {
            long t1 = System.currentTimeMillis();
            CloudRegistUserInfo cloudRegistUserInfo = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getCloudRegistUserInfo(erpUserInfo.getNumber());
            Set groupSet1 = ulicMap.get(erpUserInfo.getNumber());
            if (cloudRegistUserInfo == null || cloudRegistUserInfo != null && cloudRegistUserInfo.getGroup() != null && groupSet1 != null && !cloudRegistUserInfo.getGroup().containsAll(groupSet1)) {
                return false;
            }
            long t2 = System.currentTimeMillis();
            logger.error((Object)("===========================checkIsSynSuccessByKeyInfo cost time:" + (t2 - t1)));
        }
        catch (LicenseException e) {
            logger.error((Object)"UserLicenseGroupHelper1.checkIsSynSuccessByKeyInfo.LicenseException", (Throwable)e);
        }
        return true;
    }

    private boolean checkIsSynSuccessByKeyInfo2(Context ctx, CloudUserInfo synCloudUser, CloudRegistUserInfo cloudUserInfo) {
        List noActiviationUsers = UserNoActiviationHelper.getNoActiviationUsersIgnoreCase((Context)ctx);
        if (cloudUserInfo == null) {
            return synCloudUser.getStatus() == 0 || synCloudUser.getIs_delete() == 1;
        }
        if (synCloudUser.getStatus() == 0 || synCloudUser.getIs_delete() == 1) {
            return false;
        }
        if (!(synCloudUser.getErp_account() == null && cloudUserInfo.getErpNumber() == null || synCloudUser.getErp_account() == null || synCloudUser.getErp_account().equalsIgnoreCase(cloudUserInfo.getErpNumber()))) {
            return false;
        }
        if (StringUtils.isEmpty((String)synCloudUser.getPhone()) && StringUtils.isEmpty((String)synCloudUser.getEmail())) {
            if (!noActiviationUsers.contains(synCloudUser.getErp_account())) {
                return false;
            }
            if (!StringUtils.isEmpty((String)cloudUserInfo.getPhone())) {
                return false;
            }
            String string = "\u6ce8\u518c\u7528\u6237\u540c\u6b65\u90ae\u7bb1\u652f\u6301";
        } else if (cloudUserInfo.getPhone() != null || cloudUserInfo.getEmail() != null) {
            if (synCloudUser.getPhone() != null && cloudUserInfo.getPhone() != null) {
                if (!cloudUserInfo.getPhone().trim().replaceFirst("\\+", "").equalsIgnoreCase(synCloudUser.getPhone().trim().replaceFirst("\\+", ""))) {
                    return false;
                }
            } else if (synCloudUser.getEmail() != null && cloudUserInfo.getEmail() != null) {
                if (!cloudUserInfo.getEmail().trim().equals(synCloudUser.getEmail().toLowerCase().trim())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return cloudUserInfo != null && (cloudUserInfo == null || cloudUserInfo.getGroup() == null || synCloudUser == null || synCloudUser.getMpGroups().keySet() == null || cloudUserInfo.getGroup().containsAll(synCloudUser.getMpGroups().keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String synResultUpdateToERP2(Context ctx, List<CloudUserInfo> assembleCloudUserInfo) throws BOSException, EASBizException {
        String string;
        long t1 = System.currentTimeMillis();
        long t2 = System.currentTimeMillis();
        String sqlUser = "update t_pm_user set fuid=?,fisSynToCloud=? where fid=?";
        Connection conn = null;
        int modNumber = 0;
        Boolean flag = false;
        PreparedStatement updateUserStmt = null;
        Object dataStmt = null;
        ArrayList<String> synUpdateUserIDs = new ArrayList<String>();
        HashMap<String, String> userMap = new HashMap<String, String>();
        String result = "{'success':'true'}";
        if (assembleCloudUserInfo.size() < 0) {
            result = "{'success':false}";
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateUserStmt = conn.prepareStatement(sqlUser);
            ICloudRegistSrv cloudRegistSrv = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            UserCollection userCol = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id,number where issyntocloud =0");
            for (UserInfo user : userCol) {
                userMap.put(user.getNumber().toLowerCase(), user.getId().toString());
            }
            for (int i = 0; i < assembleCloudUserInfo.size(); ++i) {
                CloudRegistUserInfo syncUserResultInfo;
                CloudUserInfo cloudUserInfo = assembleCloudUserInfo.get(i);
                boolean isSynSuccess = this.checkIsSynSuccessByKeyInfo2(ctx, cloudUserInfo, syncUserResultInfo = cloudRegistSrv.getCloudRegistUserInfo(cloudUserInfo.getErp_account().toLowerCase()));
                if (!isSynSuccess) continue;
                String userID = (String)userMap.get(cloudUserInfo.getErp_account());
                updateUserStmt.setString(1, syncUserResultInfo == null ? cloudUserInfo.getUid() + "" : syncUserResultInfo.getCloudUuId());
                updateUserStmt.setInt(2, 1);
                updateUserStmt.setString(3, userID);
                synUpdateUserIDs.add(userID);
                updateUserStmt.addBatch();
                if (++modNumber % 1000 == 0) {
                    updateUserStmt.executeBatch();
                    updateUserStmt.clearBatch();
                    flag = true;
                    continue;
                }
                flag = false;
            }
            if (!flag.booleanValue()) {
                updateUserStmt.executeBatch();
            }
            modNumber = 0;
            long t3 = System.currentTimeMillis();
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>dealLicGroupbyLicense4synCloud2ERP-cost>>>>>>>>>>>>>>>>>>>>>>>>>" + (t2 - t1)));
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>synResultUpdateToERP-cost>>>>>>>>>>>>>>>>>>>>>>>>>" + (t3 - t2)));
            string = result;
        }
        catch (Exception e) {
            String string2;
            try {
                logger.error((Object)"synResultUpdate2ERP error {}", (Throwable)e);
                string2 = result = "{'success':false,'error':'" + e + "'}";
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateUserStmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)updateUserStmt);
            SQLUtils.cleanup((Connection)conn);
            return string2;
        }
        SQLUtils.cleanup((Statement)updateUserStmt);
        SQLUtils.cleanup((Connection)conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String synResultUpdateToERP3(Context ctx, List<CloudUserInfo> assembleCloudUserInfo) throws BOSException, EASBizException {
        String string;
        String sqlUser = "update t_pm_user set fuid=?,fisSynToCloud=? where fid=?";
        Connection conn = null;
        int modNumber = 0;
        Boolean flag = false;
        PreparedStatement updateUserStmt = null;
        ArrayList<String> synUpdateUserIDs = new ArrayList<String>();
        HashMap<String, String> userMap = new HashMap<String, String>();
        String result = "{'success':'true'}";
        if (assembleCloudUserInfo.size() < 0) {
            result = "{'success':false}";
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateUserStmt = conn.prepareStatement(sqlUser);
            ICloudRegistSrv cloudRegistSrv = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            UserCollection userCol = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id,number where issyntocloud =0");
            for (UserInfo user : userCol) {
                userMap.put(user.getNumber().toLowerCase(), user.getId().toString());
            }
            for (int i = 0; i < assembleCloudUserInfo.size(); ++i) {
                CloudRegistUserInfo syncUserResultInfo;
                CloudUserInfo cloudUserInfo = assembleCloudUserInfo.get(i);
                boolean isSynSuccess = this.checkIsSynSuccessByKeyInfo2(ctx, cloudUserInfo, syncUserResultInfo = cloudRegistSrv.getCloudRegistUserInfo(cloudUserInfo.getErp_account().toLowerCase()));
                if (!isSynSuccess) continue;
                String userID = (String)userMap.get(cloudUserInfo.getErp_account());
                updateUserStmt.setString(1, syncUserResultInfo == null ? cloudUserInfo.getUid() + "" : syncUserResultInfo.getCloudUuId());
                updateUserStmt.setInt(2, 1);
                updateUserStmt.setString(3, userID);
                synUpdateUserIDs.add(userID);
                updateUserStmt.addBatch();
                if (++modNumber % 1000 == 0) {
                    updateUserStmt.executeBatch();
                    updateUserStmt.clearBatch();
                    flag = true;
                    continue;
                }
                flag = false;
            }
            if (!flag.booleanValue()) {
                updateUserStmt.executeBatch();
            }
            string = result;
        }
        catch (Exception e) {
            String string2;
            try {
                logger.error((Object)"synResultUpdate2ERP error {}", (Throwable)e);
                string2 = result = "{'success':false,'error':'" + e + "'}";
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateUserStmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)updateUserStmt);
            SQLUtils.cleanup((Connection)conn);
            return string2;
        }
        SQLUtils.cleanup((Statement)updateUserStmt);
        SQLUtils.cleanup((Connection)conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String synResultUpdateToERP(Context ctx, Map<String, SyncUserResultInfo> synUserResults) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        this.dealLicGroupbyLicense4synCloud2ERP(ctx);
        long t2 = System.currentTimeMillis();
        String sqlLicenseGroupDiff = "delete from t_pm_userLicGroupDiff where FuserId = ?";
        String sqlUser = "update t_pm_user set fuid=?,fisSynToCloud=? where fid=?";
        Connection conn = null;
        int modNumber = 0;
        Boolean flag = false;
        Boolean deleteFlag = false;
        PreparedStatement updateUserStmt = null;
        Statement deleteUserStmt = null;
        PreparedStatement dataStmt = null;
        ArrayList<String> synUpdateUserIDs = new ArrayList<String>();
        String result = "{'success':'true'}";
        try {
            UserInfo user;
            conn = EJBFactory.getConnection((Context)ctx);
            updateUserStmt = conn.prepareStatement(sqlUser);
            HashMap<String, UserInfo> userMap = new HashMap<String, UserInfo>();
            HashMap<String, Set> userGroupMap = new HashMap<String, Set>();
            String dataSql = "select u.fid id, u.fnumber  number,u.fforbidden forbidden,u.fisDelete isDelete,u.fcell cell,u.fuid uuid ,up.fgroupNumber groupNumber  from t_pm_user u left outer join  t_pm_userlicensegroup up on u.fid = up.fuserid where u.fisSynToCloud=0 and (up.fisActive = 1 or up.fisActive is null)";
            dataStmt = conn.prepareStatement(dataSql);
            ResultSet rs = dataStmt.executeQuery();
            while (rs.next()) {
                String userNumber = rs.getString("number");
                String groupNumber = rs.getString("groupNumber");
                if (!userMap.containsKey(userNumber)) {
                    user = new UserInfo();
                    user.setNumber(userNumber);
                    user.setId(BOSUuid.read((String)rs.getString("id")));
                    user.setUid(rs.getString("uuid"));
                    user.setIsForbidden(rs.getInt("forbidden") == 1);
                    user.setIsDelete(rs.getInt("isDelete") == 1);
                    user.setCell(rs.getString("cell"));
                    userMap.put(user.getNumber(), user);
                }
                if (userGroupMap.containsKey(userNumber)) {
                    ((Set)userGroupMap.get(userNumber)).add(groupNumber);
                    continue;
                }
                if (groupNumber == null) continue;
                HashSet<String> groupSet = new HashSet<String>();
                groupSet.add(groupNumber);
                userGroupMap.put(userNumber, groupSet);
            }
            for (Map.Entry userEntry : userMap.entrySet()) {
                SyncUserResultInfo syncUserResultInfo;
                user = (UserInfo)userEntry.getValue();
                boolean isSynSuccess = this.checkIsSynSuccessByKeyInfo(ctx, user, userGroupMap, syncUserResultInfo = synUserResults.get(user.getNumber().toLowerCase()));
                if (!isSynSuccess) continue;
                String userID = user.getId().toString();
                updateUserStmt.setString(1, syncUserResultInfo == null ? user.getUid() : syncUserResultInfo.getUid());
                updateUserStmt.setInt(2, 1);
                updateUserStmt.setString(3, userID);
                synUpdateUserIDs.add(userID);
                updateUserStmt.addBatch();
                if (++modNumber % 1000 == 0) {
                    updateUserStmt.executeBatch();
                    updateUserStmt.clearBatch();
                    flag = true;
                    continue;
                }
                flag = false;
            }
            if (!flag.booleanValue()) {
                updateUserStmt.executeBatch();
            }
            modNumber = 0;
            deleteUserStmt = conn.prepareStatement(sqlLicenseGroupDiff);
            for (int i = 0; i < synUpdateUserIDs.size(); ++i) {
                deleteUserStmt.setString(1, (String)synUpdateUserIDs.get(i));
                if (++modNumber % 1000 == 0) {
                    deleteUserStmt.executeBatch();
                    deleteUserStmt.clearBatch();
                    deleteFlag = true;
                    continue;
                }
                deleteFlag = false;
            }
            if (!deleteFlag.booleanValue()) {
                deleteUserStmt.executeBatch();
            }
            long t3 = System.currentTimeMillis();
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>dealLicGroupbyLicense4synCloud2ERP-cost>>>>>>>>>>>>>>>>>>>>>>>>>" + (t2 - t1)));
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>synResultUpdateToERP-cost>>>>>>>>>>>>>>>>>>>>>>>>>" + (t3 - t2)));
            String string = result;
            return string;
        }
        catch (Exception e) {
            logger.error((Object)"synResultUpdate2ERP error {}", (Throwable)e);
            String string = result = "{'success':false,'error':'" + e + "'}";
            return string;
        }
        finally {
            try {
                if (updateUserStmt != null) {
                    updateUserStmt.close();
                }
                if (deleteUserStmt != null) {
                    deleteUserStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"synResultUpdateToERP-rollback error {}", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealLicGroupbyLicense4synCloud2ERP(Context ctx) {
        if (ctx == null) {
            return;
        }
        Map licenseUsersInfo = null;
        try {
            licenseUsersInfo = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getRegistUserMapGroup();
        }
        catch (LicenseException e) {
            logger.error((Object)"UserLicenseGroupHelper.dealLicGroupbyLicense4synCloud2ERP:getRegistUserMapGroup error.");
        }
        HashMap<String, String> mpNumberUserId = new HashMap<String, String>();
        String selSql = "select fid,fnumber from t_pm_user where fisSynToCloud = 0";
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e2) {
            logger.error((Object)e2);
        }
        Statement state = null;
        try {
            state = conn.createStatement();
            ResultSet rs = state.executeQuery(selSql);
            while (rs.next()) {
                mpNumberUserId.put(rs.getString("fnumber").toLowerCase(), rs.getString("fid"));
            }
            rs.close();
            String updSql = "update T_PM_UserLicenseGroup set FSynUser=? where fuserId=? and fgroupNumber=? and fisactive=?";
            PreparedStatement ps1 = conn.prepareStatement(updSql);
            if (licenseUsersInfo != null) {
                for (CloudRegistUserInfo cui : licenseUsersInfo.values()) {
                    String fid = (String)mpNumberUserId.get(cui.getErpNumber().toLowerCase());
                    if (fid == null || fid.trim().length() == 0 || UserLicenseConstantHelper.IGNORE_SYNTOCLOUD_USERS.contains(fid.trim()) || cui == null || cui.getGroup() == null) continue;
                    for (String group : cui.getGroup()) {
                        if (group == null || group.trim().length() == 0) continue;
                        ps1.setInt(1, SynStateEnum.SYN_YES.getValue());
                        ps1.setString(2, fid);
                        ps1.setString(3, group);
                        ps1.setInt(4, 1);
                        ps1.addBatch();
                    }
                }
                ps1.executeBatch();
                ps1.close();
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)state, (Connection)conn);
        }
    }

    private UserInfo findUserfromLicenseUsers(UserInfo user, List<UserInfo> userList) {
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            UserInfo userNew = userList.get(i);
            if (user.getId().equals((Object)userNew.getId())) {
                user.setUid(userNew.getUid());
                return userNew;
            }
            if (!user.getNumber().equalsIgnoreCase(userNew.getNumber())) continue;
            user.setUid(userNew.getUid());
            return userNew;
        }
        return null;
    }

    private boolean existUser(UserInfo user, List<UserInfo> userList) {
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            UserInfo userNew = userList.get(i);
            if (user.getId().equals((Object)userNew.getId())) {
                user.setUid(userNew.getUid());
                return true;
            }
            if (!user.getNumber().equals(userNew.getNumber())) continue;
            user.setUid(userNew.getUid());
            return true;
        }
        return false;
    }

    public List<String> getUserLicenseGroupByUser(Context ctx, String userId) throws BOSException, EASBizException {
        int len2;
        List<String> lsUserGroup1 = this.getUserGroupListByUserorgperm(ctx, userId);
        List<String> lsUserGroup2 = this.getUserGroupListByUserroleorg(ctx, userId);
        int len1 = lsUserGroup1.size();
        if (len1 >= (len2 = lsUserGroup2.size())) {
            for (int i = 0; i < len2; ++i) {
                if (lsUserGroup1.contains(lsUserGroup2.get(i))) continue;
                lsUserGroup1.add(lsUserGroup2.get(i));
            }
            return lsUserGroup1;
        }
        for (int i = 0; i < len1; ++i) {
            if (lsUserGroup2.contains(lsUserGroup1.get(i))) continue;
            lsUserGroup2.add(lsUserGroup1.get(i));
        }
        return lsUserGroup2;
    }

    public List<String> getUserGroupListByUserorgperm(Context ctx, String userId) throws BOSException, EASBizException {
        ArrayList<String> lsUserGroup = new ArrayList<String>();
        try {
            String sql = "SELECT top 1 1 FROM t_pm_orgrange ORGRANGE INNER JOIN t_org_baseunit UNIT   ON orgrange.FORGID = unit.FID WHERE (orgrange.FUSERID = '" + userId + "' AND unit.FISUNION = 1)";
            IRowSet hasUnionOrgRange = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean flag = false;
            if (hasUnionOrgRange.next()) {
                flag = true;
            }
            StringBuilder sqlUserorgperm = new StringBuilder();
            sqlUserorgperm.append("select distinct pi.fid from  T_PM_PermItem pi  ").append(" inner join t_pm_userorgperm up on pi.fid = up.fpermitemid ").append(" where up.fowner = '").append(userId).append("' and ((pi.forgrelation = -1 and up.forgid='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("') or (pi.forgrelation <>-1 and up.forgid <>'").append("11111111-1111-1111-1111-111111111111CCE7AED4'))");
            if (!flag) {
                Set cslrptPermItemNames = ConfigurationLoader.getInstance().getConfigurationInfo().getCslrptPermItemNames();
                sqlUserorgperm.append(" and pi.fnumber not in (").append(ToolUtils.aryToStr((Collection)cslrptPermItemNames, (boolean)true)).append(")");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlUserorgperm.toString());
            while (rs.next()) {
                String group = rs.getString(1);
                lsUserGroup.add(group);
            }
        }
        catch (Exception e) {
            logger.error((Object)"UserLicenseGroupHelper1.getUserGroupListByUserorgperm-1");
            throw new BOSException((Throwable)e);
        }
        return lsUserGroup;
    }

    public List<String> getUserGroupListByRoles(Context ctx, List<String> roleIds) throws BOSException, EASBizException {
        ArrayList<String> lsUserGroup = new ArrayList<String>();
        StringBuilder sqluserroleorg = new StringBuilder();
        sqluserroleorg.append("select distinct pi.fid from t_pm_role urole").append(" inner join t_pm_roleperm rp on rp.FRoleID = urole.fid  ").append(" inner join T_PM_PermItem pi on pi.fid = rp.fpermitemid  ").append(" where urole.fid in (").append(ToolUtils.aryToStr(roleIds)).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqluserroleorg.toString());
        try {
            while (rs.next()) {
                String group = rs.getString(1);
                lsUserGroup.add(group);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"UserLicenseGroupHelper1.getUserGroupListByRoles-1");
        }
        return lsUserGroup;
    }

    public List<String> getUserGroupListByRole(Context ctx, String roleId) throws BOSException, EASBizException {
        ArrayList<String> lsUserGroup = new ArrayList<String>();
        String sqluserroleorg = "select distinct pgm.fgroupnumber,pgm.fgroupName_l2 from t_pm_role urole inner join t_pm_roleperm rp on rp.FRoleID = urole.fid   inner join T_PM_PermItem pi on pi.fid = rp.fpermitemid   inner join " + UserLicenseGroupTool.getPermUIGroupTableName((Context)ctx) + " pgm on pgm.FPERMITEMID= pi.fid  where urole.fid ='" + roleId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqluserroleorg);
        try {
            while (rs.next()) {
                String group = rs.getString(1) + ";" + rs.getString(2);
                lsUserGroup.add(group);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"UserLicenseGroupHelper1.getUserGroupListByRole-1");
        }
        return lsUserGroup;
    }

    public List<String> getUserGroupsByRole(Context ctx, String roleId) throws BOSException, EASBizException {
        ArrayList<String> lsUserGroup = new ArrayList<String>();
        String sqluserroleorg = "select distinct pi.fid from t_pm_role urole inner join t_pm_roleperm rp on rp.FRoleID = urole.fid   inner join T_PM_PermItem pi on pi.fid = rp.fpermitemid   where urole.fid ='" + roleId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqluserroleorg);
        try {
            while (rs.next()) {
                String permItemID = rs.getString(1);
                lsUserGroup.add(permItemID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"UserLicenseGroupHelper1.getUserGroupListByRole-1");
        }
        return lsUserGroup;
    }

    public List<String> getUserGroupListByUserroleorg(Context ctx, String userId) throws BOSException, EASBizException {
        ArrayList<String> lsUserGroup = new ArrayList<String>();
        StringBuilder sqluserroleorg = new StringBuilder();
        sqluserroleorg.append("select distinct pi.fid from  t_pm_role urole ").append(" inner join t_pm_roleperm rp on rp.FRoleID = urole.fid  ").append(" inner join T_PM_PermItem pi on pi.fid = rp.fpermitemid  ").append(" inner join t_pm_userroleorg uroleorg on urole.fid = uroleorg.FRoleID  ").append(" where uroleorg.fuserId ='" + userId + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqluserroleorg.toString());
        try {
            while (rs.next()) {
                String group = rs.getString(1);
                lsUserGroup.add(group);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"UserLicenseGroupHelper1.getUserGroupListByUserroleorg-1");
        }
        return lsUserGroup;
    }

    public boolean rebuildUserLicenseGroupInfo(Context ctx, String userId) throws BOSException, EASBizException {
        List<String> lsUserGroup = this.getPermitemsGroupStr(ctx, this.getUserLicenseGroupByUser(ctx, userId));
        List lsUserGroupInTBLicenseGroup = LicenseUseManager.getInstance((Context)ctx).getUserGroupStr(ctx, userId);
        ArrayList lsDeleteGroup = new ArrayList();
        lsDeleteGroup.addAll(lsUserGroupInTBLicenseGroup);
        lsDeleteGroup.removeAll(lsUserGroup);
        lsUserGroup.removeAll(lsUserGroupInTBLicenseGroup);
        UserLicenseGroupsInfo userLicenseGroups = UserLicenseGroupTool.getUserLicenseGroups((Context)ctx, (String)userId);
        IUserLicenseGroupHelper ihelper = LicenseUseManager.getInstance((Context)ctx).getUserLicenseGroupHelper4Add(ctx, userLicenseGroups, lsUserGroup);
        ihelper.exec();
        return true;
    }

    private List<String> getPermitemsGroupStr(Context ctx, List<String> permitemIds) throws BOSException {
        return UserLicenseGroupTool.getPermitemsGroupStr((Context)ctx, permitemIds);
    }

    private void updateLicGroupDiffbyUserId(Context ctx, String userId, List<String> lsUserGroup) throws BOSException, EASBizException {
        ArrayList<String> fids = new ArrayList<String>();
        fids.add(userId);
        this.delUserLicGroupDiffbyUserIds(ctx, fids);
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        UserLicenseGroupTool.insUserLicGroupDiff((Context)ctx, (UserInfo)userInfo, lsUserGroup);
    }

    private void delUserLicGroupDiffbyUserIds(Context ctx, List<String> fids) throws BOSException, EASBizException {
        String sql = "delete from t_pm_userLicGroupDiff where FuserId = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String fid : fids) {
            Object[] params = new Object[]{fid};
            paramsList.add(params);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"DELETE_FAIL"));
        }
    }

    private List<String> convertLsNumberName2LsNumber(List<String> lsNumberName) {
        ArrayList<String> lsNumber = new ArrayList<String>();
        if (lsNumberName == null) {
            return lsNumber;
        }
        for (String strNumberName : lsNumberName) {
            String[] sa = strNumberName.split(";");
            lsNumber.add(sa[0]);
        }
        return lsNumber;
    }

    public List<String> getUserGroupName(Context ctx, String useId) throws BOSException, EASBizException {
        List userGroupStr = UserLicenseGroupTool.getUserGroupStr((Context)ctx, (String)useId);
        if (userGroupStr == null) {
            return null;
        }
        Map mpLicenseUseInfo = null;
        try {
            mpLicenseUseInfo = this.getLicenseUseSev(ctx).getGroupsUseInfo(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        ArrayList<String> userGroupName = new ArrayList<String>();
        for (String group : userGroupStr) {
            userGroupName.add(group);
            if (mpLicenseUseInfo == null) {
                group = EASResource.getString((String)RESOURCE, (String)"GROUP1") + group + EASResource.getString((String)RESOURCE, (String)"ERROR");
                continue;
            }
            GroupLicenseUseInfo glui = (GroupLicenseUseInfo)mpLicenseUseInfo.get(group);
            if (glui != null) {
                group = glui.getAlias();
                continue;
            }
            group = EASResource.getString((String)RESOURCE, (String)"GROUP1") + group + EASResource.getString((String)RESOURCE, (String)"ERROR");
        }
        return userGroupName;
    }

    public void changeUserInfo(Context ctx, UserInfo newUserInfo, UserInfo oldUserInfo) throws BOSException, EASBizException {
        if (UserLicenseGroupTool.isChangeKeyInfoIgnoreCloudCommunicationStategy((UserInfo)newUserInfo, (UserInfo)oldUserInfo)) {
            newUserInfo.setIsSynToCloud(SynStateEnum.SYN_NO);
            this.updateUserToNotSyn(ctx, newUserInfo);
            UserLogUtil.logChangeUser((Context)ctx, (UserInfo)newUserInfo, (UserInfo)oldUserInfo);
        }
    }

    private boolean isChangeKeyInfo(UserInfo newUserInfo, UserInfo oldUserInfo) {
        return UserLicenseGroupTool.isChangeKeyInfo((UserInfo)newUserInfo, (UserInfo)oldUserInfo);
    }

    private void updUserLicGroupDiffwithoutGroup(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        int updNums = UserLicenseGroupTool.updateUserLicGroupDiff((Context)ctx, (UserInfo)userInfo);
        if (updNums <= 0) {
            this.insUserLicGroupDiff(ctx, userInfo);
        }
        this.updateUserToNotSyn(ctx, userInfo);
    }

    private void insUserLicGroupDiff(Context ctx, UserInfo newUserInfo) throws BOSException {
        UserLicenseGroupTool.insUserLicGroupDiff((Context)ctx, (UserInfo)newUserInfo, null);
    }

    private void updateUserToNotSyn(Context ctx, UserInfo userInfo) throws BOSException {
        if (userInfo == null || userInfo.getId() == null) {
            return;
        }
        ArrayList<String> lsUserId = new ArrayList<String>();
        lsUserId.add(userInfo.getId().toString());
        UserLicenseGroupTool.updateUserToNotSyn((Context)ctx, lsUserId);
    }

    public void callBackUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (usersId == null) {
            return;
        }
        HashMap<String, Map<String, Boolean>> userGroupMap = new HashMap<String, Map<String, Boolean>>();
        DBUserBean dbUserBean = new DBUserBean();
        UserInfo userInfo = null;
        Map<String, UserInfo> mpUser = this.getUserMapByFids(ctx, usersId);
        Map<String, Boolean> groupMap = null;
        ArrayList<String> userNumbers = new ArrayList<String>();
        for (String userId : usersId) {
            userInfo = mpUser.get(userId);
            userInfo.setIsDelete(false);
            groupMap = this.deleteUser(ctx, userInfo);
            if (groupMap != null) {
                userGroupMap.put(userInfo.getNumber(), groupMap);
            }
            userNumbers.add(userInfo.getNumber());
        }
        dbUserBean.setState(false);
        dbUserBean.setUserNumbers(userNumbers);
    }

    Map<String, UserInfo> getUserMapByFids(Context ctx, List<String> usersId) {
        HashMap<String, UserInfo> mpUser = new HashMap<String, UserInfo>();
        String userSql = "select fid,fnumber,fname_l2,fisdelete,fislocked,FForbidden,FCell,FEMail,FUid from t_pm_user  where fid in (" + ToolUtils.aryToStr(usersId) + ")";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)userSql);
            while (rs.next()) {
                String format;
                Pattern p;
                Matcher m;
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString("fid")));
                user.setNumber(rs.getString("fnumber"));
                user.setName(rs.getString("fname_l2"));
                user.setIsDelete(rs.getInt("fisdelete") != 0);
                user.setIsLocked(rs.getInt("fislocked") != 0);
                user.setIsForbidden(rs.getInt("fforbidden") != 0);
                user.setCell(rs.getString("FCell"));
                user.setEmail(rs.getString("FEmail"));
                String fuid = rs.getString("FUid");
                mpUser.put(user.getId().toString(), user);
                if (fuid == null || !(m = (p = Pattern.compile(format = "^[0-9]*$")).matcher(fuid)).matches()) continue;
                user.setUid(fuid);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"LicenseUseManager.getUserMapByFids error1. ");
        }
        catch (BOSException e) {
            logger.error((Object)"LicenseUseManager.getUserMapByFids error2. ");
        }
        return mpUser;
    }

    public void unForbidUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (usersId == null) {
            return;
        }
        UserInfo userInfo = null;
        Map<String, UserInfo> mpUser = this.getUserMapByFids(ctx, usersId);
        for (String userId : usersId) {
            userInfo = mpUser.get(userId);
            userInfo.setIsForbidden(false);
            this.forbidUser(ctx, userInfo);
        }
    }

    private boolean checkAssignGroupsNums(Context ctx, Map<String, Integer> mpGroupNumCount) throws BOSException, EASBizException {
        if (mpGroupNumCount == null) {
            return true;
        }
        for (String group : mpGroupNumCount.keySet()) {
            if (this.checkAssignUsersGroup(ctx, group, mpGroupNumCount.get(group))) continue;
            throw new UserException(UserException.GOURP_NOT_ENOUGH, new Object[]{group});
        }
        return true;
    }

    private boolean checkAssignUsersGroup(Context ctx, String groupNumber, int nums) throws EASBizException {
        if (ctx == null) {
            ctx = ContextUtils.getContextFromSession();
        }
        int remainNum = 0;
        try {
            remainNum = this.getLicenseUseSev(ctx).getGroupRemainNum(ctx, groupNumber);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return remainNum >= nums;
    }

    public void forbidUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (usersId == null) {
            return;
        }
        UserInfo userInfo = null;
        Map<String, UserInfo> mpUser = this.getUserMapByFids(ctx, usersId);
        for (String userId : usersId) {
            userInfo = mpUser.get(userId);
            userInfo.setIsForbidden(true);
            this.forbidUser(ctx, userInfo);
        }
    }

    public Map<String, Boolean> forbidUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (userInfo == null) {
            return null;
        }
        UserLicenseGroupsInfo userLicenseGroups = UserLicenseGroupTool.getUserLicenseGroups((Context)ctx, (UserInfo)userInfo);
        List lsGroupEx = userLicenseGroups.getLsLicGroups();
        Map moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap((Context)ctx);
        HashMap<String, Boolean> groupMap = new HashMap<String, Boolean>();
        if (lsGroupEx != null) {
            UserLicenseGroupHelper userlicHelper = new UserLicenseGroupHelper(ctx);
            int size = lsGroupEx.size();
            for (int i = 0; i < size; ++i) {
                UserLicenseGroupInfo userLicenseGroupInfo;
                UserLicenseGroupInfoEx groupEx = (UserLicenseGroupInfoEx)lsGroupEx.get(i);
                userlicHelper.addDelUserLicenseGroupInfo(groupEx);
                UserLicenseGroupInfoEx groupExClone4Add = new UserLicenseGroupInfoEx();
                groupExClone4Add.setGroupNumber(groupEx.getGroupNumber());
                groupExClone4Add.setName((String)moduleAliasMap.get(groupEx.getGroupNumber()));
                groupExClone4Add.setIsActive(!userInfo.isIsForbidden());
                if (userInfo.isIsForbidden()) {
                    userLicenseGroupInfo = groupEx.getUserLicenseGroupInfo();
                    if (userLicenseGroupInfo != null && userLicenseGroupInfo.getIsActive() != null && userLicenseGroupInfo.getId() != null && userLicenseGroupInfo.getIsActive() == ActiveStateEnum.Active_NO) {
                        continue;
                    }
                } else {
                    userLicenseGroupInfo = groupEx.getUserLicenseGroupInfo();
                    boolean checkAssignUsersGroup = this.checkAssignUsersGroup(ctx, userLicenseGroupInfo.getGroupNumber(), 1);
                    if (!checkAssignUsersGroup) {
                        groupExClone4Add.setIsActive(false);
                        UserLogUtil.activeGroupFailByOpt((Context)ctx, (UserInfo)userInfo, (String)userLicenseGroupInfo.getGroupNumber(), (String)EASResource.getString((String)RESOURCE, (String)"ENABLE_USER"));
                    }
                }
                groupExClone4Add.setSynUser(SynStateEnum.SYN_NO);
                groupExClone4Add.setUser(groupEx.getUser());
                userlicHelper.addAddUserLicenseGroupInfo(groupExClone4Add);
                groupMap.put(groupEx.getGroupNumber(), !userInfo.isIsForbidden());
            }
            userlicHelper.exec();
        }
        this.updateUserToNotSyn(ctx, userInfo);
        UserLogUtil.logForbidUser((Context)ctx, (UserInfo)userInfo);
        return groupMap;
    }

    public void addUser(Context ctx, UserInfo userInfo) throws BOSException {
        if (ctx == null || userInfo == null) {
            return;
        }
        UserLicenseGroupHelper helper = new UserLicenseGroupHelper(ctx, new UserLicenseGroupHelper4User(ctx, userInfo));
        try {
            helper.exec();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        UserLogUtil.logAddUser((Context)ctx, (UserInfo)userInfo);
    }

    public void deleteUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (usersId == null) {
            return;
        }
        UserInfo userInfo = null;
        Map<String, UserInfo> mpUser = this.getUserMapByFids(ctx, usersId);
        for (String userId : usersId) {
            userInfo = mpUser.get(userId);
            userInfo.setIsDelete(true);
            this.deleteUser(ctx, userInfo);
        }
    }

    public Map<String, Boolean> deleteUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (userInfo == null) {
            return null;
        }
        UserLicenseGroupsInfo userLicenseGroups = UserLicenseGroupTool.getUserLicenseGroups((Context)ctx, (UserInfo)userInfo);
        List lsGroupEx = userLicenseGroups.getLsLicGroups();
        Map moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap((Context)ctx);
        HashMap<String, Boolean> groupMap = new HashMap<String, Boolean>();
        if (lsGroupEx != null) {
            UserLicenseGroupHelper userlicHelper = new UserLicenseGroupHelper(ctx);
            int size = lsGroupEx.size();
            for (int i = 0; i < size; ++i) {
                UserLicenseGroupInfo userLicenseGroupInfo;
                UserLicenseGroupInfoEx groupEx = (UserLicenseGroupInfoEx)lsGroupEx.get(i);
                userlicHelper.addDelUserLicenseGroupInfo(groupEx);
                UserLicenseGroupInfoEx groupExClone4Add = new UserLicenseGroupInfoEx();
                groupExClone4Add.setGroupNumber(groupEx.getGroupNumber());
                groupExClone4Add.setName((String)moduleAliasMap.get(groupEx.getGroupNumber()));
                groupExClone4Add.setIsActive(!userInfo.isIsDelete() && !userInfo.isIsForbidden());
                if (userInfo.isIsDelete() || userInfo.isIsForbidden()) {
                    userLicenseGroupInfo = groupEx.getUserLicenseGroupInfo();
                    if (userLicenseGroupInfo != null && userLicenseGroupInfo.getIsActive() != null && userLicenseGroupInfo.getId() != null && userLicenseGroupInfo.getIsActive() == ActiveStateEnum.Active_NO) {
                        continue;
                    }
                } else {
                    userLicenseGroupInfo = groupEx.getUserLicenseGroupInfo();
                    boolean checkAssignUsersGroup = this.checkAssignUsersGroup(ctx, userLicenseGroupInfo.getGroupNumber(), 1);
                    if (!checkAssignUsersGroup) {
                        groupExClone4Add.setIsActive(false);
                        UserLogUtil.activeGroupFailByOpt((Context)ctx, (UserInfo)userInfo, (String)userLicenseGroupInfo.getGroupNumber(), (String)EASResource.getString((String)RESOURCE, (String)"RECYCLE_USER"));
                    }
                }
                groupExClone4Add.setSynUser(SynStateEnum.SYN_NO);
                groupExClone4Add.setUser(groupEx.getUser());
                userlicHelper.addAddUserLicenseGroupInfo(groupExClone4Add);
                groupMap.put(groupEx.getGroupNumber(), !userInfo.isIsDelete());
            }
            userlicHelper.exec();
        }
        this.updateUserToNotSyn(ctx, userInfo);
        if (userInfo.isIsDelete()) {
            UserLogUtil.logDeleteUser((Context)ctx, (UserInfo)userInfo);
        } else {
            UserLogUtil.callBackUser((Context)ctx, (UserInfo)userInfo);
        }
        return groupMap;
    }

    public List<CloudUserInfo> getCloudUserInfoFromLicense(Context ctx) {
        Map<String, CloudRegistUserInfo> licenseUsersInfo = this.getRegistUserMapFromLicense(ctx);
        if (licenseUsersInfo == null || licenseUsersInfo.size() == 0) {
            return null;
        }
        ArrayList<CloudUserInfo> cloudUsers = new ArrayList<CloudUserInfo>();
        for (String key : licenseUsersInfo.keySet()) {
            CloudRegistUserInfo crui = licenseUsersInfo.get(key);
            if (crui == null) continue;
            CloudUserInfo cloudUserInfo = this.castRegistUser2CloudUser(crui);
            cloudUsers.add(cloudUserInfo);
        }
        return cloudUsers;
    }

    public Map<String, CloudRegistUserInfo> getRegistUserMapFromLicense(Context ctx) {
        Map licenseUsersInfo = null;
        try {
            licenseUsersInfo = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getRegistUserMapGroup();
        }
        catch (LicenseException e) {
            logger.error((Object)"LicenseUseManager.getRegistUserMapFromLicense():getRegistUserMapGroup error.");
        }
        return licenseUsersInfo;
    }

    private CloudUserInfo castRegistUser2CloudUser(CloudRegistUserInfo crui) {
        return UserLicenseGroupTool.castRegistUser2CloudUser((CloudRegistUserInfo)crui);
    }

    public boolean changeRolePermitem(Context ctx, RoleInfo role, RolePermCollection addPerms, RolePermCollection delPerms) throws EASBizException, BOSException {
        if (role == null || role.getId() == null || role.getId().toString().trim().length() == 0) {
            return true;
        }
        if (!(addPerms != null && addPerms.size() != 0 || delPerms != null && delPerms.size() != 0)) {
            return true;
        }
        List<String> roleOldGroups = this.getPermitemsGroupStr(ctx, GroupLicenseUseInfoUtil.getUserGroupsByRole((Context)ctx, (String)role.getId().toString()));
        List roleNewGroups = UserLicenseGroupTool.getPermitemsGroupStr((Context)ctx, this.getRoleFinalGroupStr(ctx, role, addPerms, delPerms));
        ArrayList<String> addGroups = new ArrayList<String>();
        addGroups.addAll(roleNewGroups);
        addGroups.removeAll(roleOldGroups);
        HashMap<String, AtomicInteger> mpGroupRemainnum = new HashMap<String, AtomicInteger>();
        for (String addGroup : addGroups) {
            try {
                mpGroupRemainnum.put(addGroup, new AtomicInteger(this.getLicenseUseSev(ctx).getGroupRemainNum(ctx, addGroup)));
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        ArrayList<String> delGroups = new ArrayList<String>();
        delGroups.addAll(roleOldGroups);
        delGroups.removeAll(roleNewGroups);
        if (addGroups.size() == 0 && delGroups.size() == 0) {
            return true;
        }
        List userIds = UserLicenseGroupTool.getRoleOwnerUsers((Context)ctx, (String)role.getId().toString());
        UserLicenseGroupCollection userGroups = null;
        userGroups = userIds.size() > 100 ? UserLicenseGroupFactory.getLocalInstance((Context)ctx).getUserLicenseGroupCollection() : UserLicenseGroupFactory.getLocalInstance((Context)ctx).getUserLicenseGroupCollection("where user in (" + ToolUtils.aryToStr((List)userIds) + ")");
        UserLicenseGroupHelper userlicHelper = new UserLicenseGroupHelper(ctx);
        this.dealLicenseGroupHelper(ctx, role.getId().toString(), userlicHelper, userIds, userGroups, addGroups, delGroups, mpGroupRemainnum, addPerms, delPerms);
        return userlicHelper.exec();
    }

    public void dealLicenseGroupHelper(Context ctx, String roleId, UserLicenseGroupHelper userlicHelper, List<String> userIds, UserLicenseGroupCollection userGroups, List<String> addGroups, List<String> delGroups, Map<String, AtomicInteger> mpGroupRemainnum, RolePermCollection addPerms, RolePermCollection delPerms) throws BOSException {
        Map moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap((Context)ctx);
        Map<Object, Object> userPermitems = new HashMap();
        if (delGroups.size() > 0) {
            userPermitems = this.getUsersPermItemsWithoutRole(ctx, roleId, userIds, addPerms, delPerms);
        }
        for (String userId : userIds) {
            List permitems;
            List userNewGroups;
            UserLicenseGroupsInfo userLicGroup = new UserLicenseGroupsInfo(ctx, userId);
            if (userLicGroup.getUser() == null || userLicGroup.getUser().getId() == null) continue;
            int size = userGroups.size();
            for (int i = 0; i < size; ++i) {
                UserLicenseGroupInfo uginfo = userGroups.get(i);
                if (uginfo == null || uginfo.getUser() == null || uginfo.getUser().getId() == null || !userId.equalsIgnoreCase(uginfo.getUser().getId().toString())) continue;
                userLicGroup.addLicGroups(uginfo);
            }
            if (addGroups.size() > 0 && !userLicGroup.getGroupsNumberSet().containsAll(addGroups)) {
                if (userLicGroup.getUser() == null || userLicGroup.getUser().getId() == null) {
                    logger.error((Object)("com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper1.dealLicenseGroupHelper.user is null: " + userLicGroup.getFuserId() + " ;userid:" + userId + " ;user:" + userLicGroup.getUser()));
                    continue;
                }
                UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicGroup.getUser(), userLicGroup);
                for (String addGroup : addGroups) {
                    if (userLicGroup.getLicGroup(addGroup) != null) continue;
                    UserLicenseGroupInfoEx userNewGroup = new UserLicenseGroupInfoEx();
                    userNewGroup.setUser(ulgh4user.getUser());
                    userNewGroup.setGroupNumber(addGroup);
                    userNewGroup.setSynUser(SynStateEnum.SYN_NO);
                    userNewGroup.setName((String)moduleAliasMap.get(addGroup));
                    AtomicInteger remainNum = mpGroupRemainnum.get(addGroup);
                    if (remainNum.decrementAndGet() >= 0) {
                        userNewGroup.setIsActive(true);
                    } else {
                        userNewGroup.setIsActive(false);
                    }
                    mpGroupRemainnum.put(addGroup, remainNum);
                    ulgh4user.addAddUserLicenseGroupInfo(userNewGroup);
                }
                userlicHelper.addUserLicenseGroupHelper4User(ulgh4user);
            }
            if (delGroups.size() <= 0 || (userNewGroups = UserLicenseGroupTool.getPermitemsGroupStr((Context)ctx, (List)(permitems = (List)userPermitems.get(userId)))).containsAll(delGroups)) continue;
            UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicGroup.getUser(), userLicGroup);
            for (String delGroup : delGroups) {
                if (userNewGroups.contains(delGroup)) continue;
                UserLicenseGroupInfoEx ulgiEx = ulgh4user.getUserLicenseGroups().getLicGroup(delGroup);
                userlicHelper.addDelUserLicenseGroupInfo(ulgiEx);
            }
        }
    }

    private List<String> getUserPermItems(Context ctx, UserInfo user, RolePermCollection addPerms, RolePermCollection delPerms) throws BOSException {
        PermItemInfo pi;
        RolePermInfo rolePerm;
        PermItemInfo pi2;
        int i;
        ArrayList<String> permitemNormalIds = new ArrayList<String>();
        if (user == null || user.getId() == null) {
            return permitemNormalIds;
        }
        List rolePerms = UserLicenseGroupTool.getPermitemsByUserViaRole((Context)ctx, (String)user.getId().toString());
        List userPerms = UserLicenseGroupTool.getPermitemsByUserViaPerm((Context)ctx, (String)user.getId().toString());
        ArrayList<String> permitemForbiddenIds = new ArrayList<String>();
        int size = rolePerms.size();
        for (i = 0; i < size; ++i) {
            if (rolePerms.get(i) == null || ((RolePermInfo)rolePerms.get(i)).getPermItem() == null || ((RolePermInfo)rolePerms.get(i)).getPermItem().getId() == null) continue;
            pi2 = ((RolePermInfo)rolePerms.get(i)).getPermItem();
            if (PermType.NORMAL.equals((Object)((RolePermInfo)rolePerms.get(i)).getPermType())) {
                permitemNormalIds.add(pi2.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)pi2.getType())) continue;
            permitemForbiddenIds.add(pi2.getId().toString());
        }
        size = userPerms.size();
        for (i = 0; i < size; ++i) {
            if (userPerms.get(i) == null || ((UserOrgPermInfo)userPerms.get(i)).getPermItem() == null || ((UserOrgPermInfo)userPerms.get(i)).getPermItem().getId() == null) continue;
            pi2 = ((UserOrgPermInfo)userPerms.get(i)).getPermItem();
            if (PermType.NORMAL.equals((Object)((UserOrgPermInfo)userPerms.get(i)).getPermType())) {
                permitemNormalIds.add(pi2.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)pi2.getType())) continue;
            permitemForbiddenIds.add(pi2.getId().toString());
        }
        size = addPerms.size();
        for (i = 0; i < size; ++i) {
            rolePerm = addPerms.get(i);
            if (rolePerm == null || (pi = rolePerm.getPermItem()) == null || pi.getId() == null) continue;
            if (PermType.NORMAL.equals((Object)rolePerm.getPermType())) {
                permitemNormalIds.add(pi.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)rolePerm.getPermType())) continue;
            permitemForbiddenIds.add(pi.getId().toString());
        }
        size = delPerms.size();
        for (i = 0; i < size; ++i) {
            rolePerm = delPerms.get(i);
            if (rolePerm == null || (pi = rolePerm.getPermItem()) == null || pi.getId() == null) continue;
            if (PermType.NORMAL.equals((Object)rolePerm.getPermType())) {
                permitemNormalIds.remove(pi.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)rolePerm.getPermType())) continue;
            permitemForbiddenIds.remove(pi.getId().toString());
        }
        permitemNormalIds.removeAll(permitemForbiddenIds);
        return permitemNormalIds;
    }

    private Map<String, List<String>> getUsersPermItemsWithoutRole(Context ctx, String roleId, List<String> userIds, RolePermCollection addPerms, RolePermCollection delPerms) throws BOSException {
        long curtime = System.currentTimeMillis();
        final Context ctx1 = ctx;
        final String roleId1 = roleId;
        final RolePermCollection addPerms1 = addPerms;
        final RolePermCollection delPerms1 = delPerms;
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        ExecutorService executorService = PermThreadPool.getExecutorService();
        HashMap<String, Future<List<String>>> futures = new HashMap<String, Future<List<String>>>();
        Iterator<String> iterator = userIds.iterator();
        while (iterator.hasNext()) {
            String userId;
            final String userId1 = userId = iterator.next();
            Future<List<String>> future = executorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    List perms = null;
                    try {
                        UserInfo userInfo1 = UserFactory.getLocalInstance((Context)ctx1).getUserInfo((IObjectPK)new ObjectUuidPK(userId1));
                        if (userInfo1 == null || userInfo1.getId() == null) {
                            return perms;
                        }
                        long start = System.currentTimeMillis();
                        perms = UserLicenseGroupHelper1.this.getUserPermItemsWithoutRole(ctx1, roleId1, userInfo1, addPerms1, delPerms1);
                        long cost = System.currentTimeMillis() - start;
                        if (cost > 1000L) {
                            logger.error((Object)("getUsersPermItemsWithoutRole\u672c\u6b21\u5355\u7528\u6237\u6267\u884c\u65f6\u95f4\u8f83\u957f,\u6bd4\u8f83\u5f71\u54cd\u6027\u80fd\uff01cost" + cost + "ms\uff0cuserId =" + userInfo1.getId().toString()));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"getUsersPermItemsWithoutRole call \u6267\u884c\u5931\u8d25\uff01", (Throwable)e);
                    }
                    return perms;
                }
            });
            futures.put(userId1, future);
        }
        for (String userkey : futures.keySet()) {
            Future future = (Future)futures.get(userkey);
            try {
                List list = (List)future.get(600000L, TimeUnit.MILLISECONDS);
                data.put(userkey, list);
            }
            catch (InterruptedException e) {
                throw new BOSException("getUsersPermItemsWithoutRole\u6267\u884c\u4e2d\u65ad:" + e.getMessage());
            }
            catch (ExecutionException e) {
                throw new BOSException("getUsersPermItemsWithoutRole\u6267\u884c\u9519\u8bef:" + e.getMessage());
            }
            catch (TimeoutException e) {
                throw new BOSException("getUsersPermItemsWithoutRole\u6267\u884c\u8d85\u65f6:" + e.getMessage());
            }
        }
        long cost = System.currentTimeMillis() - curtime;
        if (cost > 5000L) {
            logger.error((Object)("getUsersPermItemsWithoutRole\u672c\u6b21\u591a\u7528\u6237\u5e76\u53d1\u6267\u884c\u65f6\u95f4\u8f83\u957f,\u6bd4\u8f83\u5f71\u54cd\u6027\u80fd\uff01cost" + cost + "ms\uff0croleId =" + roleId));
        }
        return data;
    }

    private List<String> getUserPermItemsWithoutRole(Context ctx, String roleId, UserInfo user, RolePermCollection addPerms, RolePermCollection delPerms) throws BOSException {
        int i;
        ArrayList<String> permitemNormalIds = new ArrayList<String>();
        if (user == null || user.getId() == null) {
            return permitemNormalIds;
        }
        List rolePerms = UserLicenseGroupTool.getPermitemsByUserWithoutRole((Context)ctx, (String)roleId, (String)user.getId().toString());
        ArrayList<String> permitemForbiddenIds = new ArrayList<String>();
        int size = rolePerms.size();
        for (i = 0; i < size; ++i) {
            if (rolePerms.get(i) == null || ((RolePermInfo)rolePerms.get(i)).getPermItem() == null || ((RolePermInfo)rolePerms.get(i)).getPermItem().getId() == null) continue;
            PermItemInfo pi = ((RolePermInfo)rolePerms.get(i)).getPermItem();
            if (PermType.NORMAL.equals((Object)((RolePermInfo)rolePerms.get(i)).getPermType())) {
                permitemNormalIds.add(pi.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)pi.getType())) continue;
            permitemForbiddenIds.add(pi.getId().toString());
        }
        size = addPerms.size();
        for (i = 0; i < size; ++i) {
            PermItemInfo pi;
            RolePermInfo rolePerm = addPerms.get(i);
            if (rolePerm == null || (pi = rolePerm.getPermItem()) == null || pi.getId() == null) continue;
            if (PermType.NORMAL.equals((Object)rolePerm.getPermType())) {
                permitemNormalIds.add(pi.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)rolePerm.getPermType())) continue;
            permitemForbiddenIds.add(pi.getId().toString());
        }
        permitemNormalIds.removeAll(permitemForbiddenIds);
        return permitemNormalIds;
    }

    private List<String> getRoleFinalGroupStr(Context ctx, RoleInfo role, RolePermCollection addPerms, RolePermCollection delPerms) throws EASBizException, BOSException {
        PermItemInfo pi;
        RolePermInfo rolePerm;
        int i;
        ArrayList<String> permitemNormalIds = new ArrayList<String>();
        if (role == null || role.getId() == null || role.getId().toString().trim().length() == 0) {
            return permitemNormalIds;
        }
        RolePermCollection rolePerms = UserLicenseGroupTool.getRolePerms((Context)ctx, (String)role.getId().toString());
        ArrayList<String> permitemForbiddenIds = new ArrayList<String>();
        int size = rolePerms.size();
        for (i = 0; i < size; ++i) {
            rolePerm = rolePerms.get(i);
            if (rolePerm == null || (pi = rolePerm.getPermItem()) == null || pi.getId() == null) continue;
            if (PermType.NORMAL.equals((Object)rolePerm.getPermType())) {
                permitemNormalIds.add(pi.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)rolePerm.getPermType())) continue;
            permitemForbiddenIds.add(pi.getId().toString());
        }
        size = addPerms.size();
        for (i = 0; i < size; ++i) {
            rolePerm = addPerms.get(i);
            if (rolePerm == null || (pi = rolePerm.getPermItem()) == null || pi.getId() == null) continue;
            if (PermType.NORMAL.equals((Object)rolePerm.getPermType())) {
                permitemNormalIds.add(pi.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)rolePerm.getPermType())) continue;
            permitemForbiddenIds.add(pi.getId().toString());
        }
        size = delPerms.size();
        for (i = 0; i < size; ++i) {
            rolePerm = delPerms.get(i);
            if (rolePerm == null || (pi = rolePerm.getPermItem()) == null || pi.getId() == null) continue;
            if (PermType.NORMAL.equals((Object)rolePerm.getPermType())) {
                permitemNormalIds.remove(pi.getId().toString());
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)rolePerm.getPermType())) continue;
            permitemForbiddenIds.remove(pi.getId().toString());
        }
        permitemNormalIds.removeAll(permitemForbiddenIds);
        return permitemNormalIds;
    }

    private List<String> getPermitemIdsFromRolePermCollection(RolePermCollection perms, PermType permType) {
        ArrayList<String> permitems = new ArrayList<String>();
        if (perms == null || perms.size() == 0 || permType == null) {
            return permitems;
        }
        int size = perms.size();
        for (int i = 0; i < size; ++i) {
            PermItemInfo pi;
            RolePermInfo rolePerm = perms.get(i);
            if (rolePerm == null || (pi = rolePerm.getPermItem()) == null || pi.getId() == null || !permType.equals((Object)rolePerm.getPermType())) continue;
            permitems.remove(pi.getId().toString());
        }
        return permitems;
    }

    private boolean dealRoleChangeViaForkJoin(Context ctx, List<String> userIds, UserLicenseGroupCollection userGroups, List<String> addGroups, List<String> delGroups, Map<String, AtomicInteger> mpGroupRemainnum, RolePermCollection addPerms, RolePermCollection delPerms) throws BOSException, EASBizException {
        return true;
    }
}

