package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.ats.*;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsPrepareDataHelper;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;


public class AtsLeaveBillSplitHelper {

	private AtsLeaveBillInfo billInfo;
	private AtsLeaveBillEntryInfo atsLeaveBillEntryInfo;
	private Context ctx;
	private String personId ;
	private Boolean isIncludeLegal;
	private Boolean isIncludeRest;
	private HolidayPolicyInfo holidayPolicyInfo;
	private BigDecimal sourceLen = new BigDecimal(0);
	//ĬϹʱ
	private BigDecimal defaultStandardHour = BigDecimal.valueOf(24);
	private int decimalPlaceValue=2;
	private static Logger logger = Logger.getLogger("com.kingdee.eas.hr.ats.util.AtsLeaveBillSplitHelper");

	public AtsLeaveBillSplitHelper(Context ctx,BOSUuid billId) throws EASBizException, BOSException {
		this.billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(new ObjectUuidPK(billId.toString()));
		AtsLeaveBillEntryCollection billEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where bill='"+billInfo.getId().toString()+"'");
		this.atsLeaveBillEntryInfo = billEntryColl.get(0);
		this.ctx = ctx;
		this.personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
		this.holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id='"+atsLeaveBillEntryInfo.getPolicy().getId().toString()+"'");
		this.isIncludeLegal = holidayPolicyInfo.isIsIncludeLegal();
		this.isIncludeRest = holidayPolicyInfo.isIsIncludeRest();
		this.decimalPlaceValue = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);

	}

	public AtsLeaveBillSplitHelper(Context ctx,AtsLeaveBillInfo billInfo,AtsLeaveBillEntryInfo atsLeaveBillEntryInfo) throws EASBizException, BOSException {
		this.billInfo = billInfo ;
		//AtsLeaveBillEntryCollection billEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where bill='"+billInfo.getId().toString()+"'");
		this.atsLeaveBillEntryInfo = atsLeaveBillEntryInfo;
		this.ctx = ctx;
		this.personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
		this.holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id='"+atsLeaveBillEntryInfo.getPolicy().getId().toString()+"'");
		this.isIncludeLegal = holidayPolicyInfo.isIsIncludeLegal();
		this.isIncludeRest = holidayPolicyInfo.isIsIncludeRest();

	}

	// 
	@SuppressWarnings("unchecked")
	public void splitLeaveBill() throws EASBizException, BOSException{
		logger.info(MLUtile.getRes(AtsLeaveBillResEnum.StartSplitLeaveBill,ctx) + "...");
		Timestamp beginTime = atsLeaveBillEntryInfo.getRealBeginTime();
		Timestamp endTime = atsLeaveBillEntryInfo.getRealEndTime();
		//ȡʼʱ֮
		List<Date> dateList = getLeaveDateColl(beginTime, endTime);
		// ڼȥü
		List<Date> dateListAfter = dealDateNew(dateList);

		String oql = " select holidayPolicySet.isHalfDayOff,holidayPolicySet.isHalfDayOff" //atsShift,
				+ ",holidayPolicySet.amStartWorkTime,holidayPolicySet.amEndWorkTime"
				+ ",holidayPolicySet.pmStartWorkTime,holidayPolicySet.pmEndWorkTime"
				+ " where proposer.id='"+personId+"' and attendFileState='1' ";
		//AttendanceFileInfo attendanceFileInfo = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileInfo(oql);
		AtsHolidayFileInfo holidayFileInfo = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileInfo(oql);

		Map<String,Object> dateLenMap = null ;
		HolidayPolicySetInfo holidayPolicySetInfo = holidayFileInfo.getHolidayPolicySet();
		if(null != holidayPolicyInfo && null != holidayPolicyInfo.getHolidayType()
				&& holidayPolicyInfo.getHolidayType().getId().toString().equals(AtsServerUtils.ATS_HOLIDAYTYPE_BREASTFEED_ID)
				&& null != atsLeaveBillEntryInfo.getBfType() &&  !atsLeaveBillEntryInfo.getBfType().getId().toString().equals(AtsServerUtils.ATS_HOLIDAYTYPE_BFTYPE_ID) ){
			dateLenMap = calRealLeaveLengthOfBF(dateListAfter,beginTime,endTime,atsLeaveBillEntryInfo.getRealUnit(),holidayFileInfo,holidayPolicySetInfo,holidayPolicyInfo);
		}else if(null != holidayPolicyInfo && holidayPolicyInfo.isIsHalfDayOff() ) {
			//

			dateLenMap = calRealLeaveLengthOfDay(dateListAfter,beginTime,endTime,atsLeaveBillEntryInfo.getRealUnit(),holidayFileInfo,holidayPolicySetInfo,holidayPolicyInfo);
		} else {
			dateLenMap = calRealLeaveLengthInfo(dateListAfter,beginTime,endTime,atsLeaveBillEntryInfo.getRealUnit(),holidayFileInfo,holidayPolicyInfo);
		}

		insertleaveBillDetail(dateLenMap);
		/*
		if(atsLeaveBillEntryInfo.getRealUnit().getValue()==HolidayTypeUnitEnum.DAY_VALUE){
			insertleaveBillDetailDay(dateListAfter);
		}else if(atsLeaveBillEntryInfo.getRealUnit().getValue()==HolidayTypeUnitEnum.HOUR_VALUE){
			insertleaveBillDetailHour(dateListAfter);
		}
		*/
		logger.info(MLUtile.getRes(AtsLeaveBillResEnum.EndSplitLeaveBill,ctx) + "...");
	}


	/*
	 * author : bing_chen
	 * date : 2015-05-14
	 * param: dateListAfterlist
	 * function :¼ٵϸСʱ
	 */
	private void insertleaveBillDetailHour(List<Date> dateListAfter) throws BOSException, EASBizException{

		Double leaveLengthDouble = atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();

		PersonInfo  personInfo = SHRBillServerUtil.getPersonDetailInfo(ctx,personId);

		PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx,personInfo.getId().toString());

		CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();

		if(dateListAfter.size()==0){
			return;
		}
		BigDecimal standardHour = getStandardHour(personId, dateListAfter.get(0));
		Double standardHourDouble = standardHour.doubleValue();
		Double tempDouble = leaveLengthDouble % standardHourDouble;
		//
		tempDouble = BigDecimal.valueOf(tempDouble).setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
		AtsLeaveBillDetailInfo leaveBillDetailInfofirst = new AtsLeaveBillDetailInfo();
		for(int i = 0;i<dateListAfter.size();i++){
			if(leaveLengthDouble>0){
				AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
				leaveBillDetailInfo.setLeavebill(billInfo);
				leaveBillDetailInfo.setProposer(personInfo);
				leaveBillDetailInfo.setLeaveDate(dateListAfter.get(i));
				leaveBillDetailInfo.setLeaveUnit(atsLeaveBillEntryInfo.getRealUnit());
				leaveBillDetailInfo.setPolicy(holidayPolicyInfo);
				leaveBillDetailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());//֯
				if(i==0){
					if(tempDouble!=0){
						leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(tempDouble));
						leaveBillDetailInfofirst = leaveBillDetailInfo;
						leaveLengthDouble -= tempDouble;
					}else{
						leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(standardHourDouble));
						leaveBillDetailInfofirst = leaveBillDetailInfo;
						leaveLengthDouble -= standardHourDouble;
					}
				}else{
					leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(standardHourDouble));
					leaveBillDetailColl.add(leaveBillDetailInfo);
					leaveLengthDouble -= standardHourDouble;
				}
			}
		}
		// ٳȻʣ  ȫӵһ
		if(leaveLengthDouble>0){
			leaveBillDetailInfofirst.setLeaveLength(leaveBillDetailInfofirst.getLeaveLength().add(BigDecimal.valueOf(leaveLengthDouble)));
		}

		leaveBillDetailColl.add(leaveBillDetailInfofirst);
		IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance(ctx);
		leaveBillDetail.addnewBatchData(leaveBillDetailColl);

	}
	/*
	 * author : bing_chen
	 * date : 2015-05-14
	 * param: dateListAfterlist
	 * function :¼ٵϸ
	 */
	private void insertleaveBillDetailDay(List<Date> dateListAfter) throws BOSException, EASBizException{

		Double leaveLengthDouble = atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();

		PersonInfo  personInfo = SHRBillServerUtil.getPersonDetailInfo(ctx,personId);
		PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx,personInfo.getId().toString());

		CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();
		Double leaveLength = leaveLengthDouble;
		for(int i = 0;i<dateListAfter.size();i++){
			if(leaveLengthDouble>0){
				AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
				leaveBillDetailInfo.setLeavebill(billInfo);
				leaveBillDetailInfo.setProposer(personInfo);
				leaveBillDetailInfo.setLeaveDate(dateListAfter.get(i));
				leaveBillDetailInfo.setLeaveUnit(atsLeaveBillEntryInfo.getRealUnit());
				leaveBillDetailInfo.setPolicy(holidayPolicyInfo);
				leaveBillDetailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());//֯
				Double tempDouble = leaveLengthDouble%1;
				if(i==0&&tempDouble!=0){
					leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(tempDouble));
					leaveBillDetailColl.add(leaveBillDetailInfo);
					leaveLengthDouble -= tempDouble;
				}else{
					leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(1));
					leaveBillDetailColl.add(leaveBillDetailInfo);
					leaveLengthDouble -= 1;
				}
			}
		}
		IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance(ctx);
		leaveBillDetail.addnewBatchData(leaveBillDetailColl);

	}

	/*
	 * author : bing_chen
	 * date : 2015-05-14
	 * param: dateListAfterlist
	 * function :¼ٵϸ
	 */
	private void insertleaveBillDetail(Map<String,Object> dateLenMap) throws BOSException, EASBizException{

		Double leaveLengthDouble = atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();

		PersonInfo  personInfo = SHRBillServerUtil.getPersonDetailInfo(ctx,personId);

		CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();

		HolidayTypeUnitEnum holidayTypeUnit = atsLeaveBillEntryInfo.getRealUnit();

		Object[] key = dateLenMap.keySet().toArray();
		Arrays.sort(key);
		BigDecimal leavelen = atsLeaveBillEntryInfo.getRealLeaveLength();
		//ȡԱĿڵ߼ڵϵĹ
		Map<String,WorkCalendarItemInfo> map = new HashMap<String, WorkCalendarItemInfo>();
		try {
			AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, HRTimeWebUtils.stringShortToTimestamp(key[0].toString()), HRTimeWebUtils.stringShortToTimestamp(key[key.length-1].toString()), personId, null);
			AtsHolidayFileHisCollection atsHolidayFileHisCollection =null;
			AtsHolidayFileHisInfo atsHolidayFileHisInfo = null;
			atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx)
					.getAtsHolidayFileHisCollection("where proposer.id='" + personId + "'  order by effdt asc");
			if (null!=atsHolidayFileHisCollection && atsHolidayFileHisCollection.size() > 0) {
				for (int i = 0; i < atsHolidayFileHisCollection.size(); i++) {
					AtsHolidayFileHisInfo atsHolidayFileHis = atsHolidayFileHisCollection.get(i);
					if (HRTimeWebUtils.stringShortToTimestamp(key[0].toString()).getTime() >= atsHolidayFileHis.getEFFDT().getTime()
							&& HRTimeWebUtils.stringShortToTimestamp(key[key.length-1].toString()).getTime() <= atsHolidayFileHis.getLEFFDT().getTime()) {
						atsHolidayFileHisInfo=atsHolidayFileHisCollection.get(i);
					}
				}
			}
			map =AtsServerCalUtils.getWorkCalendarItemInfoByDate (ctx,key[0].toString(),key[key.length-1].toString(),attendanceFileHisInfo,atsHolidayFileHisInfo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		int len = key.length ;
		for (int i = 0; i < len; i++)
		{
			ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, new Date(HRTimeWebUtils.stringToTimestamp(key[i]+" 00:00:00").getTime()));
			if (scheduleShiftInfo==null) {
				String keyStr = key[i].toString().substring(0,10);
				WorkCalendarItemInfo workCalendarItemInfo = map.get(keyStr);
				if(workCalendarItemInfo == null || workCalendarItemInfo.getDayType() == null){
					//ûйòϸ
					continue;
				}
				//аϢջ߷ڣɲϸ
				if (!holidayPolicyInfo.isIsIncludeRest()) {
					//ûйòϸ
					if(null == workCalendarItemInfo){
						continue;
					}
					//գȥҹڣȥϢպͷڼ
					if (workCalendarItemInfo.getDayType()==DayTypeEnum.restDay ||workCalendarItemInfo.getDayType()==DayTypeEnum.legalHoliday) {
						continue;
					}
				}
			}
			Map<String,Double> dateMap = (Map<String, Double>) dateLenMap.get(key[i]);
			BigDecimal tempLen = new BigDecimal(0);
			if(holidayTypeUnit == HolidayTypeUnitEnum.day){
				tempLen = BigDecimal.valueOf(dateMap.get("calDay"));
				if (holidayPolicyInfo.isIsRoundSum()) {
					//ȡڻܣôڲֵʱݼƶõĽд
					tempLen = BigDecimal.valueOf(this.getValueByMinLeaveLength(holidayPolicyInfo, tempLen));
				}
				if (leavelen.compareTo(tempLen)>0 && i!=len-1){
					leavelen = leavelen.subtract(tempLen);
				}else{
					tempLen=leavelen;
				}

			}else{
				tempLen=BigDecimal.valueOf(dateMap.get("calHour"));
				if (holidayPolicyInfo.isIsRoundSum()) {
					//ȡڻܣôڲֵʱݼƶõĽд
					tempLen = BigDecimal.valueOf(this.getValueByMinLeaveLength(holidayPolicyInfo, tempLen));
				}
				if (leavelen.compareTo(tempLen)>0 && i!=len-1){
					leavelen = leavelen.subtract(tempLen);
				}else{
					tempLen=leavelen;
				}
			}
			List<Map<String,Object>> dateList = getLeaveSuchScheduleDetal(HRTimeWebUtils.stringToTimestamp(key[i].toString().substring(0,10)+" 00:00:00"),personId,tempLen);
			for (int j = 0; j < dateList.size(); j++) {
				Map<String,Object> mapSplit = dateList.get(j);
				AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
				Date currDate = AtsDateUtils.stringToShortDate((String)key[i]);
				leaveBillDetailInfo.setLeavebill(billInfo);
				leaveBillDetailInfo.setProposer(personInfo);
				leaveBillDetailInfo.setLeaveDate(currDate);
				leaveBillDetailInfo.setLeaveUnit(holidayTypeUnit);
				leaveBillDetailInfo.setPolicy(holidayPolicyInfo);
				leaveBillDetailInfo.setAdminOrgUnit(atsLeaveBillEntryInfo.getAdminOrgUnit());//֯
				leaveBillDetailInfo.setLeavebillEntry(atsLeaveBillEntryInfo);
				leaveBillDetailInfo.setLeaveLength((BigDecimal) mapSplit.get("leaveLength"));
				leaveBillDetailInfo.setPreTime((String) mapSplit.get("beginTime"));
				leaveBillDetailInfo.setNextTime((String) mapSplit.get("endTime"));
				String attAdminOrgUnitid = (String) mapSplit.get("attAdminOrgUnit");
				AdminOrgUnitInfo info = AdminOrgUnitFactory.getLocalInstance(ctx).getAdminOrgUnitInfo(new ObjectUuidPK(attAdminOrgUnitid));
				leaveBillDetailInfo.setAttAdminOrgUnit(info);
				leaveBillDetailColl.add(leaveBillDetailInfo);

			}
//			 AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
//
//			 Date currDate = AtsDateUtils.stringToShortDate((String)key[i]);
//			 leaveBillDetailInfo.setLeavebill(billInfo);
//			 leaveBillDetailInfo.setProposer(personInfo);
//			 leaveBillDetailInfo.setLeaveDate(currDate);
//			 leaveBillDetailInfo.setLeaveUnit(holidayTypeUnit);
//			 leaveBillDetailInfo.setPolicy(holidayPolicyInfo);
//			 leaveBillDetailInfo.setAdminOrgUnit(atsLeaveBillEntryInfo.getAdminOrgUnit());//֯
//			 leaveBillDetailInfo.setLeavebillEntry(atsLeaveBillEntryInfo);
//			 if(holidayTypeUnit == HolidayTypeUnitEnum.day)
//			 {
//				 BigDecimal tempLen = BigDecimal.valueOf(dateMap.get("calDay"));
//				 if(leavelen.compareTo(tempLen) >= 0 && i != (len - 1))//ȡ
//				 {
//					 double saveTempLen = tempLen.doubleValue();
//					 if (holidayPolicyInfo.isIsRoundSum()) {
//						 //ȡڻܣôڲֵʱݼƶõĽд
//						 saveTempLen = this.getValueByMinLeaveLength(holidayPolicyInfo, tempLen);
//					}
//					 leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(saveTempLen));
//					 leavelen = leavelen.subtract(BigDecimal.valueOf(saveTempLen));
//				 }else{
//					 leaveBillDetailInfo.setLeaveLength(leavelen);
//					 leavelen =  BigDecimal.valueOf(0);
//
//				 }
//			 }
//			 else
//			 {
//				 BigDecimal tempLen =new BigDecimal(-1);
//				 if(dateMap!= null && dateMap.get("calHour") != null){
//					tempLen = BigDecimal.valueOf(dateMap.get("calHour"));
//				 }
//				 if(leavelen.compareTo(tempLen) >= 0 && i != (len-1))//ȡ
//				 {
//					 double saveTempLen = tempLen.doubleValue();
//					 if (holidayPolicyInfo.isIsRoundSum()) {
//						 //ȡڻܣôڲֵʱݼƶõĽд
//						 saveTempLen = this.getValueByMinLeaveLength(holidayPolicyInfo, tempLen);
//					}
//					 leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(saveTempLen));
//					 leavelen = leavelen.subtract(BigDecimal.valueOf(saveTempLen));
//				 }
//				 else{
//					 leaveBillDetailInfo.setLeaveLength(leavelen);
//					 leavelen =  BigDecimal.valueOf(0);
//
//				 }
//			 }

//		     leaveBillDetailColl.add(leaveBillDetailInfo);
			if(leavelen.compareTo(BigDecimal.valueOf(0)) == 0)
			{
				break ;
			}
		}

		IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance(ctx);
		leaveBillDetail.addnewBatchData(leaveBillDetailColl);
	}

	/**
	 * صŰַ
	 * @param date
	 * @param personId
	 * @param dataLen
	 * @return
	 * @throws BOSException
	 */
	private List<Map<String,Object>> getLeaveSuchScheduleDetal(Timestamp date,String personId, BigDecimal dataLen ) throws BOSException {
		List<Map<String,Object>> list = new ArrayList<>();
		AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, date, date, personId, null);
		HashMap<String, Object> dateMap;

		ScheduleShiftItemCollection scheduleShiftItemColl;
		ScheduleShiftInfo scheduleShiftInfo = null;
		HashMap<String,Object> defaultItemMap = new HashMap<String,Object>();
		AtsShiftItemCollection shiftItemColl = new AtsShiftItemCollection();
		try {
			dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate(ctx,personId,date,holidayPolicyInfo.isIsFixOTAllowLeave());
			scheduleShiftItemColl=(ScheduleShiftItemCollection)dateMap.get("scheduleShiftItemColl");

			if (null == scheduleShiftItemColl || scheduleShiftItemColl.size()==0){
				defaultItemMap=AtsLeaveBillUtils.getdefaultShiftItemByHis(ctx,attendanceFileHisInfo,holidayPolicyInfo);
				shiftItemColl= (AtsShiftItemCollection)defaultItemMap.get("scheduleShiftItemColl");
				//ðεĿڵص
				for (int i = 0; i < shiftItemColl.size(); i++) {
					AtsShiftItemInfo info = shiftItemColl.get(i);
					info.setString("adminOrgUnit",attendanceFileHisInfo.getAttAdminOrgUnit().getId().toString());
				}
			}else{
				defaultStandardHour = (BigDecimal) dateMap.get("standardHour");
				for (int i = 0; i < scheduleShiftItemColl.size(); i++) {
					ScheduleShiftItemInfo info = scheduleShiftItemColl.get(i);
					AtsShiftItemInfo shiftItemInfo = createScheduleShiftItemToAtsShiftItem(ctx,info);
					shiftItemInfo.setString("adminOrgUnit",attendanceFileHisInfo.getAttAdminOrgUnit().getId().toString());
					shiftItemInfo.getGroup().setIsElastic(info.getGroup().isIsElastic());
					shiftItemInfo.getGroup().setId(info.getGroup().getId());
					shiftItemColl.add(shiftItemInfo);
				}
			}
			Timestamp beginTime = atsLeaveBillEntryInfo.getRealBeginTime();
			Timestamp endTime = atsLeaveBillEntryInfo.getEndTime();
			if (shiftItemColl.size()<=0 && scheduleShiftItemColl.size()<=0){
				Map<String, Object> dataSpiltMap = new HashMap<>();
				dataSpiltMap.put("beginTime", "00:00");
				dataSpiltMap.put("endTime", "23:59");
				dataSpiltMap.put("leaveLength", dataLen);
				dataSpiltMap.put("attAdminOrgUnit", billInfo.getAdminOrg().getId().toString());
				list.add(dataSpiltMap);
				return list;
			}
			shiftItemColl.sort("segment");
			String curDate = HRTimeWebUtils.timestampToString(date);
			String dateBeginTime = HRTimeWebUtils.timestampToString(beginTime);
			String dateEndTime = HRTimeWebUtils.timestampToString(endTime);
			Map<String,Object> res = getIsCtrlHalfDayOff(ctx);
			boolean isHalfDayOff = (boolean) res.get("isHalfDayOff");

			//жٵʼʱͽʱǷһ죬ǵһѰνʱ滻ɵٽʱ䡣һ죬Ѱϰʱ滻ɵٿʼʱ
			if (curDate.equals(dateBeginTime.substring(0,10)+" 00:00:00")){
				//ʱ⴦
				if (isHalfDayOff){
					beginTime = atsLeaveBillEntryInfo.getRealBeginTime();
					endTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0,10)+" "+res.get("pmEndTime")+":00");
				}else {
					AtsShiftItemInfo shiftItemInfo = shiftItemColl.get(0);
					String preDate = getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate);
					Timestamp shiftItemStarTime = HRTimeWebUtils.stringToTimestamp(preDate + " " + shiftItemInfo.getPreTime() + ":00");
					if (shiftItemStarTime.getTime() > beginTime.getTime()) {
						beginTime = shiftItemStarTime;
					}
					shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
					if (!dateBeginTime.substring(0, 10).equals(dateEndTime.substring(0, 10))) {
						String nextTime = getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), curDate);
						endTime = HRTimeWebUtils.stringToTimestamp(nextTime + " " + shiftItemInfo.getNextTime() + ":00");
					}
				}
			}
			if (curDate.equals(dateEndTime.substring(0,10)+" 00:00:00")){
				if (isHalfDayOff){
					if(!curDate.equals(dateBeginTime.substring(0,10)+" 00:00:00")){
						beginTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0,10)+" "+res.get("amBeginTime")+":00");
					}
					endTime = atsLeaveBillEntryInfo.getRealEndTime();
				}else {
					AtsShiftItemInfo shiftItemInfo = shiftItemColl.get(0);
					if (!dateBeginTime.substring(0, 10).equals(dateEndTime.substring(0, 10))) {
						//beginTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0, 10) + " " + shiftItemInfo.getPreTime() + ":00");
						String curBeginTime = getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate.substring(0, 10));
						beginTime = HRTimeWebUtils.stringToTimestamp(curBeginTime + " " + shiftItemInfo.getPreTime() + ":00");
					}
					shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
					String dateEndTime1 = getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), dateEndTime.substring(0, 10));
					Timestamp shiftItemEndTime = HRTimeWebUtils.stringToTimestamp(dateEndTime1.substring(0, 10) + " " + shiftItemInfo.getNextTime() + ":00");
					boolean elasticCalLen = shiftItemInfo.getGroup() != null && shiftItemInfo.getGroup().isIsElastic() && atsLeaveBillEntryInfo.isIsElasticCalLen();
					if (shiftItemEndTime.getTime() < endTime.getTime() && !elasticCalLen) {
						endTime = shiftItemEndTime;
					}
				}
			}
			if (!curDate.substring(0,10).equals(dateEndTime.substring(0,10)) && !curDate.substring(0,10).equals(dateBeginTime.substring(0,10))) {
				if (isHalfDayOff) {
					beginTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0,10)+" "+res.get("amBeginTime")+":00");
					endTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0,10)+" "+res.get("pmEndTime")+":00");
				} else {
					AtsShiftItemInfo shiftItemInfo = shiftItemColl.get(0);
					//beginTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0, 10) + " " + shiftItemInfo.getPreTime() + ":00");
					String curBeginTime = getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate.substring(0, 10));
					beginTime = HRTimeWebUtils.stringToTimestamp(curBeginTime + " " + shiftItemInfo.getPreTime() + ":00");
					//Կദ
					if (beginTime.getTime() <= atsLeaveBillEntryInfo.getRealBeginTime().getTime()) {
						beginTime = atsLeaveBillEntryInfo.getRealBeginTime();
					}
					shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
					String curEndTime = getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), curDate.substring(0, 10));
					endTime = HRTimeWebUtils.stringToTimestamp(curEndTime.substring(0, 10) + " " + shiftItemInfo.getNextTime() + ":00");
				}
			}
			list = getSpiltDate(beginTime,endTime,shiftItemColl,dataLen,curDate.substring(0,10));
		}catch (EASBizException e){
			e.printStackTrace();
		}
		return list;
	}

	private List<Map<String,Object>> getSpiltDate(Timestamp beginDate,Timestamp endDate,AtsShiftItemCollection shiftItemColl,BigDecimal dataLen,String curDate){
		List<Map<String,Object>> dataList = new ArrayList<>();
		AtsShiftItemCollection collection = new AtsShiftItemCollection();
		AtsShiftItemCollection overTimecoll = new AtsShiftItemCollection();
		for (int i = 0; i < shiftItemColl.size(); i++) {
			AtsShiftItemInfo info = shiftItemColl.get(i);
			String preDay = getCurDate(info.getPreTimeDayType().getValue(),curDate);
			Timestamp perTime = HRTimeWebUtils.stringToTimestamp(preDay+" "+info.getPreTime()+":00");
			String nextDay = getCurDate(info.getNextTimeDayType().getValue(),curDate);
			Timestamp nextTime = HRTimeWebUtils.stringToTimestamp(nextDay+" "+info.getNextTime()+":00");
			if (beginDate.getTime()<=nextTime.getTime() && perTime.getTime() <= endDate.getTime() || (info.getGroup().isIsElastic() && atsLeaveBillEntryInfo.isIsElasticCalLen())){
				if(!holidayPolicyInfo.isIsFixOTAllowLeave()){
					if (info.getAttendanceType() == AttendanceTypeEnum.normalAttance || info.getAttendanceType() == AttendanceTypeEnum.normalAttanceExcludExcep){
						collection.add(info);
					}
				}else{
					if (info.getAttendanceType() == AttendanceTypeEnum.normalAttance || info.getAttendanceType() == AttendanceTypeEnum.normalAttanceExcludExcep){
						collection.add(info);
					}else{
						overTimecoll.add(info);
					}
				}
			}
		}
		BigDecimal billTime = defaultStandardHour.multiply(new BigDecimal(60*60*1000)) ;
		sourceLen = dataLen.setScale(decimalPlaceValue, RoundingMode.HALF_UP);
		Map<String,Object> res = getIsCtrlHalfDayOff(ctx);
		boolean isHalfDayOff = (boolean) res.get("isHalfDayOff");
		if (isHalfDayOff){
			if (beginDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate+" "+res.get("amBeginTime")+":00").getTime() && endDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate+" "+res.get("pmEndTime")+":00").getTime()){
				Map<String,Object> dayMap = new HashMap<String,Object>();
				dayMap.put("leaveLength",new BigDecimal(1));
				dayMap.put("beginTime",res.get("amBeginTime"));
				dayMap.put("endTime", res.get("pmEndTime"));
				dayMap.put("attAdminOrgUnit",billInfo.getAdminOrg().getId().toString());
				dataList.add(dayMap);
			}else if (beginDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate+" "+res.get("amBeginTime")+":00").getTime() && (endDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate+" "+res.get("amEndTime")+":00").getTime())|| endDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate+" "+res.get("pmBeginTime")+":00").getTime()){
				Map<String,Object> amMap = new HashMap<String,Object>();
				amMap.put("leaveLength",sourceLen);
				amMap.put("beginTime",res.get("amBeginTime"));
				amMap.put("endTime", res.get("amEndTime"));
				amMap.put("attAdminOrgUnit",billInfo.getAdminOrg().getId().toString());
				dataList.add(amMap);
			}else {
				Map<String,Object> pmMap = new HashMap<String,Object>();
				pmMap.put("leaveLength",sourceLen);
				pmMap.put("beginTime",res.get("pmBeginTime"));
				pmMap.put("endTime", res.get("pmEndTime"));
				pmMap.put("attAdminOrgUnit",billInfo.getAdminOrg().getId().toString());
				dataList.add(pmMap);
			}
		}else{
			dataList = getDataSpiltMap(dataList,collection,curDate,beginDate,endDate,billTime,defaultStandardHour);
			if (overTimecoll.size()>0){
				dataList = getDataSpiltMap(dataList,overTimecoll,curDate,beginDate,endDate,billTime,defaultStandardHour);
			}
			if (sourceLen.compareTo(new BigDecimal(0)) == 1){
				Map<String,Object> dataSpiltMap = dataList.get(dataList.size()-1);
				BigDecimal  leaveLength = sourceLen.add((BigDecimal) dataSpiltMap.get("leaveLength"));
				dataList.get(dataList.size()-1).put("leaveLength", leaveLength);
			}
		}
		return dataList;
	}

	private List<Map<String,Object>> getDataSpiltMap(List<Map<String,Object>> dataList,AtsShiftItemCollection collection,String curDate,Timestamp beginDate,Timestamp endDate,BigDecimal billTime,BigDecimal defaultHour){
		Map<String,Object> shiftMap = new HashMap<String,Object>();
		for (int i = 0; i < collection.size() ; i++) {
			if (sourceLen.compareTo(new BigDecimal(0)) == 1) {
				Map<String, Object> dataSpiltMap = new HashMap<>();
				AtsShiftItemInfo info = collection.get(i);
				String groupId = info.getGroup().getId().toString();
				ScheduleShiftInfo shiftInfo = null;
				if(shiftMap.get(groupId) == null){
					try {
						shiftInfo = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection("select isElastic,elasticType,elasticValue,elasticDirection where id ='" + groupId + "'").get(0);
					} catch (BOSException e) {
						e.printStackTrace();
					}
				}
				String beginTime = getCurDate(info.getPreTimeDayType().getValue(),curDate);
				Timestamp perTime = HRTimeWebUtils.stringToTimestamp(beginTime + " " + info.getPreTime() + ":00");
				String endTime = getCurDate(info.getNextTimeDayType().getValue(),curDate);
				Timestamp nextTime = HRTimeWebUtils.stringToTimestamp(endTime + " " + info.getNextTime() + ":00");
				if(atsLeaveBillEntryInfo.isIsElasticCalLen() && shiftInfo.isIsElastic() && shiftInfo.getElasticType() == AtsShiftElasticType.commuteElastic){
					//ʱ԰
					if(AtsShiftElasticDirection.next == shiftInfo.getElasticDirection()){
						if(i == collection.size() - 1){
							////ʱ
							Date nextTimed = new Date((nextTime.getTime() + shiftInfo.getElasticValue().multiply(new BigDecimal(60 * 60 * 1000)).longValue()));
							nextTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateLongToString(nextTimed));
						}
					}else if(AtsShiftElasticDirection.pre == shiftInfo.getElasticDirection()){
						if(i == 0){
							//ǰ//ʼʱǰ
							Date perTimed = new Date((perTime.getTime() - shiftInfo.getElasticValue().multiply(new BigDecimal(60 * 60 * 1000)).longValue()));
							perTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateLongToString(perTimed));
						}
					}
				}

				if (i == 0) {
					BigDecimal time = new BigDecimal(0);
					if (nextTime.getTime() >= endDate.getTime()) {
						if (beginDate.getTime() <= perTime.getTime()){
							beginDate = perTime;
						}
						BigDecimal item = new BigDecimal(endDate.getTime() - beginDate.getTime());
						if (item.compareTo(BigDecimal.ZERO)>0){
							time = item.divide(billTime, decimalPlaceValue, BigDecimal.ROUND_HALF_UP);
							dataSpiltMap.put("beginTime", HRTimeWebUtils.timestampToString(beginDate).substring(11, 16));
							dataSpiltMap.put("endTime", HRTimeWebUtils.timestampToString(endDate).substring(11, 16));
						}else{
							continue;
						}
					} else {
						BigDecimal item = new BigDecimal(nextTime.getTime() - beginDate.getTime());
						if (item.compareTo(BigDecimal.ZERO)>0) {
							time = item.divide(billTime, decimalPlaceValue, BigDecimal.ROUND_HALF_UP);
							dataSpiltMap.put("beginTime", HRTimeWebUtils.timestampToString(beginDate).substring(11, 16));
							dataSpiltMap.put("endTime", info.getNextTime());
						}else{
							continue;
						}
					}
					sourceLen = getBigDecimal(defaultHour, dataSpiltMap, time);

				} else if (i == collection.size() - 1 || endDate.getTime() <= nextTime.getTime()) {
					if (endDate.getTime() >= nextTime.getTime()){
						endDate = nextTime;
					}
					BigDecimal item = new BigDecimal(endDate.getTime() - perTime.getTime());
					if (item.compareTo(BigDecimal.ZERO)>0) {
						BigDecimal time = item.divide(billTime, decimalPlaceValue, BigDecimal.ROUND_HALF_UP);
						dataSpiltMap.put("beginTime", info.getPreTime());
						dataSpiltMap.put("endTime", HRTimeWebUtils.timestampToString(endDate).substring(11, 16));
						sourceLen = getBigDecimal(defaultHour, dataSpiltMap, time);
					}else {
						continue;
					}

				} else {
					BigDecimal item = new BigDecimal(nextTime.getTime() - perTime.getTime());
					if (item.compareTo(BigDecimal.ZERO)>0) {
						BigDecimal time = item.divide(billTime, decimalPlaceValue, BigDecimal.ROUND_HALF_UP);
						dataSpiltMap.put("beginTime", info.getPreTime());
						dataSpiltMap.put("endTime", info.getNextTime());
						sourceLen = getBigDecimal(defaultHour, dataSpiltMap, time);
					}else{
						continue;
					}
				}
				dataSpiltMap.put("attAdminOrgUnit", info.getString("adminOrgUnit"));
				dataList.add(dataSpiltMap);
			}
		}
		return dataList;
	}
	private String getCurDate(int dateType,String curDate){
		Date date = HRTimeWebUtils.stringToShortDate(curDate);
		Calendar calendar=Calendar.getInstance();
		calendar.setTime(date);
		SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
		if (dateType ==0){
			//õǰһ
			calendar.add(Calendar.DAY_OF_MONTH,-1);
		} else if (dateType == 2) {
			//ȡһ
			calendar.add(Calendar.DAY_OF_MONTH, 1);
		}
		return simpleDateFormat.format(calendar.getTime());
	}
	private BigDecimal getBigDecimal(BigDecimal defaultHour, Map<String, Object> dataSpiltMap, BigDecimal time) {
		BigDecimal value = new BigDecimal(0);
		if (holidayPolicyInfo.getUnit().getValue()==1){
			value = time;
		}else{
			value = defaultHour.multiply(time).setScale(decimalPlaceValue,BigDecimal.ROUND_HALF_UP);
		}
		if (sourceLen.compareTo(value) == 1) {
			dataSpiltMap.put("leaveLength", value);
			sourceLen = sourceLen.subtract(value);
		} else {
			dataSpiltMap.put("leaveLength", sourceLen);
			sourceLen = new BigDecimal(0);
		}
		return sourceLen;
	}

	/**
	 * ͨƿٵλʱ
	 * ᵥR20180925-2433
	 */
	private double getValueByMinLeaveLength(HolidayPolicyInfo holidayPolicyInfo, BigDecimal realLengthBigDecimal ){
		int saveLength=getSaveLength(ctx,holidayPolicyInfo);
		double length = realLengthBigDecimal.setScale(saveLength, java.math.BigDecimal.ROUND_HALF_UP).doubleValue();
		if(holidayPolicyInfo!=null){
			if(holidayPolicyInfo.isEnableLeaveLength()){
				double M = holidayPolicyInfo.getMinLeaveLength().doubleValue();
				int minLeaveLengthMtd = holidayPolicyInfo.getMinLeaveLengthVMtd().getValue();
				int ZNum = (int)(length/M);//
				double XSNum = length%M;//С
				if(minLeaveLengthMtd == 1){//ȡ
					length = (ZNum + Math.floor(XSNum/M))*M;
				}else if(minLeaveLengthMtd == 2){//ȡ
					length = (ZNum + Math.ceil(XSNum/M))*M;
				}else if(minLeaveLengthMtd == 3){//
					length = (ZNum + Math.round(XSNum/M))*M;
				}
			}
		}
		return length;
	}
	public int getSaveLength(Context ctx,HolidayPolicyInfo holidayPolicyInfo){
		int saveLength=0;
		if(holidayPolicyInfo != null && holidayPolicyInfo.isEnableLeaveLength()){
			Double MinLeaveLength=holidayPolicyInfo.getMinLeaveLength().stripTrailingZeros().doubleValue();
			saveLength=getNumberDecimalDigits(MinLeaveLength);
		}else{
			saveLength=DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
		}
		return saveLength;
	}
	public static int getNumberDecimalDigits(double number) {
		if (number == (long)number) {
			return 0;
		}
		int i = 0;
		while (true){
			i++;
			if (number * Math.pow(10, i) % 1 == 0) {
				return i;
			}
		}
	}
	/*
	 * author : bing_chen
	 * date : 2015-05-14
	 * param: personId:Աid
	 * param: date:
	 * function :ȡ    ڼ 
	 */
	private int getDayType(String personId,Date date) throws BOSException, EASBizException{

		java.sql.Date dateSql = new java.sql.Date(date.getTime());
//		ScheduleShiftCollection scheduleShiftColl  
//		= ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(" where proposer ='"+personId+"' and attendDate='"+dateSql.toString()+"'");
		//ȼȡŰ
		ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, date);
		if(null != scheduleShiftInfo){
			return scheduleShiftInfo.getDayType().getValue();
		}else{
			AttendanceFileCollection attendanceFileColl =  AtsServerUtils.getAttendanceFileByPersonId(ctx,personId);
			if(attendanceFileColl != null && attendanceFileColl.get(0)!= null && attendanceFileColl.get(0).getAttencePolicy()!=null){
				AttencePolicyInfo attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx)
						.getAttencePolicyInfo(" where id='"+attendanceFileColl.get(0).getAttencePolicy().getId().toString()+"'");
				WorkCalendarInfo workCalendarInfo = WorkCalendarFactory.getLocalInstance(ctx)
						.getWorkCalendarInfo(" where id='"+attencePolicyInfo.getWorkCalendar().getId().toString()+"'");
				WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(ctx)
						.getWorkCalendarItemCollection(" where calendarGroup='"+workCalendarInfo.getId().toString()+"' and date='"+dateSql+"'");
				if(workCalendarItemColl.size()>0){
					return workCalendarItemColl.get(0).getDayType().getValue();
				}
			}else{//ûпģ飬ûпڵ
				if(holidayPolicyInfo.getHolidayPolicySet() != null){
					HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx)
							.getHolidayPolicySetInfo("where id = '"+holidayPolicyInfo.getHolidayPolicySet().getId().toString()+"'");
					WorkCalendarInfo workCalendarInfo = WorkCalendarFactory.getLocalInstance(ctx)
							.getWorkCalendarInfo(" where id='"+holidayPolicySetInfo.getWorkCalendar().getId().toString()+"'");
					WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(ctx)
							.getWorkCalendarItemCollection(" where calendarGroup='"+workCalendarInfo.getId().toString()+"' and date='"+dateSql+"'");
					if(workCalendarItemColl.size()>0){
						return workCalendarItemColl.get(0).getDayType().getValue();
					}
				}
			}
		}
		return DayTypeEnum.WORKDAY_VALUE;

	}
	/*
	 * author : bing_chen
	 * date : 2015-05-14
	 * param: personId:Աid
	 * param: date:
	 * function :ñ׼ʱ
	 */
	private BigDecimal getStandardHour(String personId,Date date) throws BOSException, EASBizException{

//		java.sql.Date dateSql = new java.sql.Date(date.getTime());
//		ScheduleShiftCollection scheduleShiftColl  
//		= ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(" where proposer ='"+personId+"' and attendDate='"+dateSql.toString()+"'");
		ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, date);
		if(null != scheduleShiftInfo){
//			AtsShiftInfo atsShiftInfo = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo(" where id='"+scheduleShiftColl.get(0).getDefaultShift().getId()+"'");
			return scheduleShiftInfo.getDefaultShift().getStandardHour();
		}else{
			AttendanceFileCollection attendanceFileColl =  AtsServerUtils.getAttendanceFileByPersonId(ctx,personId);
			AtsShiftCollection atsShiftColl = new AtsShiftCollection();
			if(attendanceFileColl.get(0).getAtsShift()!=null){
				atsShiftColl = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(" where id='"+attendanceFileColl.get(0).getAtsShift().getId()+"'");
			}
			if(atsShiftColl.size()>0){
				return atsShiftColl.get(0).getStandardHour();
			}
		}

		// modefiy 2014/12/04 ûŰ ûе 24 Сʱ㡣    ټʱʱһ
		//  8 Сʱ㣬ָʱһ£Ӱ ڼ㡣


		return defaultStandardHour;

	}
	/*
	 * author : xiaofei_zhao
	 * date : 2020-05-21
	 * param: dateList:ԭʼlist
	 * function :Ҫ󽲷ǹյƳ
	 */
	private List dealDateNew(List<Date> dateList) throws EASBizException, BOSException{
		int length = dateList.size();
		String beginDate = AtsDateUtils.dateShortToString(dateList.get(0));
		String endDate = AtsDateUtils.dateShortToString(dateList.get(length - 1));
		String personIds = "'" + this.personId +  "'";
		Map<String,ScheduleShiftInfo>  scheduleShiftMap = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personIds, beginDate, endDate);
		Map<String,AttendanceFileInfo> attendanceFileMap = AtsServerUtils.getAttendanceFileInfoByPersonId(ctx, personIds, beginDate, endDate);
		if(AtsCollectionUtile.isEmpty(attendanceFileMap)){
			//ûпģ
			HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx)
					.getHolidayPolicySetInfo("select workCalendar.id where id = '"+holidayPolicyInfo.getHolidayPolicySet().getId().toString()+"'");
			WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(ctx)
					.getWorkCalendarItemCollection(" where calendarGroup='"+holidayPolicySetInfo.getWorkCalendar().getId().toString()+"' and date>={ts'"+ beginDate+"'} and date <={ts'" + endDate + "'} order by date asc " );
			if(holidayPolicyInfo.getHolidayPolicySet() != null){
				for(int i= 0;i<dateList.size(); i++) {
					if(workCalendarItemColl.get(i) != null && workCalendarItemColl.get(i).getDayType() != null) {
						int dayType = workCalendarItemColl.get(i).getDayType().getValue();
						if(!isIncludeLegal&&dayType==DayTypeEnum.LEGALHOLIDAY_VALUE){
							dateList.remove(i);
							workCalendarItemColl.remove(workCalendarItemColl.get(i));
							i--;
						}else if(!isIncludeRest&&dayType==DayTypeEnum.RESTDAY_VALUE){
							dateList.remove(i);
							workCalendarItemColl.remove(workCalendarItemColl.get(i));
							i--;
						}
					}
				}
			}
		}else {
			//ƴδŰ
			Set<String> unScheduleDateSet = new HashSet<String>();
			for (Date date : dateList) {
				String scheduleShiftKey = personId + AtsDateUtils.UNDERLINE + AtsDateUtils.dateShortToString(date);
				if (scheduleShiftMap == null || scheduleShiftMap.size() == 0 || scheduleShiftMap.get(scheduleShiftKey) == null) {
					unScheduleDateSet.add(AtsDateUtils.dateShortToString(date));
				}
			}

			Map<String,Map> workCalendarItemMap = null;
			if(unScheduleDateSet.size()>0) {
				workCalendarItemMap = getWorkCalendarItembyID(attendanceFileMap,unScheduleDateSet);
			}
			//List remove  size仯
			for(int i = 0;i<dateList.size();i++){
				Date currentDate = dateList.get(i);
				int dayType = DayTypeEnum.WORKDAY_VALUE;
				String scheduleShiftKey =  personId + AtsDateUtils.UNDERLINE +  AtsDateUtils.dateShortToString(currentDate);
				if(scheduleShiftMap != null && scheduleShiftMap.get(scheduleShiftKey) != null) {
					ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)scheduleShiftMap.get(scheduleShiftKey);
					if(scheduleShiftInfo.getDayType() != null){
						dayType = scheduleShiftInfo.getDayType().getValue();
					}
				}else {
					AttendanceFileInfo attendanceFileInfo = attendanceFileMap.get(scheduleShiftKey);
					if (attendanceFileInfo != null && attendanceFileInfo.getAttencePolicy() != null
							&& attendanceFileInfo.getAttencePolicy().getWorkCalendar() != null) {
						String workCalendarId = attendanceFileMap.get(scheduleShiftKey).getAttencePolicy()
								.getWorkCalendar().getId().toString();
						if (workCalendarItemMap!=null) {
							Map<String, WorkCalendarItemInfo> infoMap = workCalendarItemMap.get(workCalendarId);
							if (infoMap != null) {
								WorkCalendarItemInfo info = (WorkCalendarItemInfo) infoMap
										.get(AtsDateUtils.dateShortToString(currentDate));
								if (info != null && info.getDayType() != null) {
									dayType = info.getDayType().getValue();
								}
							}
						}

					}
				}
				if(!isIncludeLegal&&dayType==DayTypeEnum.LEGALHOLIDAY_VALUE){
					dateList.remove(i);
					i--;
				}else if(!isIncludeRest&&dayType==DayTypeEnum.RESTDAY_VALUE){
					dateList.remove(i);
					i--;
				}
			}
		}
		return dateList;
	}

	private Map<String,Map> getWorkCalendarItembyID(Map<String,AttendanceFileInfo> attendanceFileMap,Set<String> unScheduleDateSet) throws BOSException{
		Map<String,Map> result = new HashMap<String, Map>();
		Set<String> workCalendarIds = new HashSet<String>();
		for (Entry<String, AttendanceFileInfo> entry : attendanceFileMap.entrySet()) {
			if (entry.getValue() != null && entry.getValue().getCalendar() != null) {
				workCalendarIds.add(entry.getValue().getCalendar().getId().toString());
			}
		}

		String workCalendarIdStr = AtsCollectionUtile.joinForSql(workCalendarIds);
//		WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(ctx)
//				.getWorkCalendarItemCollection(" where calendarGroup in("+workCalendarIdStr+") and date in(" + convertSetToString(unScheduleDateSet) +")" );
		System.out.println("splitHelperError:"+convertSetToString(unScheduleDateSet));
		StringBuffer buffer=new StringBuffer();
		buffer.append("select FDayType,fid,FDate,FCalendarGroupID ")
				.append(" from T_HR_ATS_WorkCalendarItem ")
				.append(" where FCalendarGroupID in (").append(workCalendarIdStr).append(") ")
				.append(" and FDate in(").append(convertSetToString(unScheduleDateSet)).append(") ");
		WorkCalendarItemCollection workCalendarItemColl=new WorkCalendarItemCollection();
		try {
			IRowSet row = DbUtil.executeQuery(ctx, buffer.toString());
			while(row.next()){
				WorkCalendarItemInfo info=new WorkCalendarItemInfo();
				WorkCalendarInfo dar=new WorkCalendarInfo();
				info.setDayType(DayTypeEnum.getEnum(row.getInt("FDayType")));
				info.setId(BOSUuid.read(row.getString("fid")));
				dar.setId(BOSUuid.read(row.getString("FCalendarGroupID")));
				info.setCalendarGroup(dar);
				info.setDate(row.getDate("FDate"));
				workCalendarItemColl.add(info);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		for (String workCalendarId : workCalendarIds) {
			Map<String,WorkCalendarItemInfo> workCalendarMap = new HashMap<String, WorkCalendarItemInfo>();
			for (String dateStr : unScheduleDateSet) {
				for (int j = 0; j < workCalendarItemColl.size(); j++) {
					if (workCalendarItemColl.get(j).getCalendarGroup().getId().toString().equals(workCalendarId) && workCalendarItemColl.get(j).getDate().toString().equals(dateStr)) {
						workCalendarMap.put(dateStr, workCalendarItemColl.get(j));
					}
				}
			}
			result.put(workCalendarId, workCalendarMap);
		}
		return result;
	}
	public static String convertSetToString(Set set) {
		if (!(set != null && set.size() > 0)) {
			//Ӧ÷һԤΪʱsqlinΪձ⣬yongxiang_yang 2011-10-28
			return "''";
		}

		Iterator iter = set.iterator();
		StringBuffer sql = new StringBuffer();
		while (iter.hasNext()) {
			String date=iter.next().toString();
			if(date.length()>0){
				date=date.substring(0,10);
			}
			sql.append("{ts'");
			sql.append(date);
			sql.append("'},");
		}

		sql.deleteCharAt(sql.length()-1);

		return sql.toString();
	}
	/*
	 * author : bing_chen
	 * date : 2015-05-14
	 * param: beginTime:ʼʱ
	 * param: endTime:ʱ
	 * function :ȡʱ֮
	 */
	private List getLeaveDateColl(Timestamp beginTime,Timestamp endTime) throws EASBizException, BOSException{

		List<Date> dateList = new ArrayList<Date>();

		Date beginDate =  AtsDateUtils.stringToShortDate(AtsDateUtils.dateLongToString((beginTime))) ;
		Date endDate = AtsDateUtils.stringToShortDate(AtsDateUtils.dateLongToString(endTime)) ;
		Calendar beginCal = Calendar.getInstance();
		beginCal.setTime(beginDate);

		Calendar endCal = Calendar.getInstance();
		endCal.setTime(endDate);

		int temp = (int) ((endDate.getTime() - beginDate.getTime())/(24*60*60*1000) +1);

		for(int i = 0 ;i<temp ; i++){
			int year = beginCal.get(Calendar.YEAR);//ȡ
			int month=beginCal.get(Calendar.MONTH);//ȡ·
			int day=beginCal.get(Calendar.DATE);//ȡ
			Date tempDate = new Date(year - 1900,month,day);
			dateList.add(tempDate);
			beginCal.add(Calendar.DATE, 1);
		}

		return dateList;
	}


	public Map<String,Object> calRealLeaveLengthInfo(List<Date>  afterDealDateList,Date beginTimeCount
			,Date endTimeCount,HolidayTypeUnitEnum holidayTypeUnit,AtsHolidayFileInfo holidayFileInfo,HolidayPolicyInfo holidayPolicyInfo)//AttendanceFileInfo attendanceFileInfo
	{

		int tempAfterDealDateListSize = afterDealDateList.size();

		AtsShiftItemCollection defaultAtsShiftItemCollection = new AtsShiftItemCollection();
		// ȡĬϵİκĬϵı׼ʱ
		Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp(beginTimeCount);
		Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp(endTimeCount);
		HashMap<String,Object> defaultItemMap = new HashMap<String,Object>();
		try {
			AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, beginTimeCountTs, endTimeCountTs, personId, null);
			defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis(ctx,attendanceFileHisInfo,holidayPolicyInfo);
		} catch (BOSException e) {
			e.printStackTrace();
		}
//		HashMap<String,Object> defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemV2(ctx,holidayFileInfo);
		defaultAtsShiftItemCollection = (AtsShiftItemCollection)defaultItemMap.get("scheduleShiftItemColl");
		defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");

		String beginDate = AtsDateUtils.dateLongToString(beginTimeCount).substring(0, 10);
		String endDate = AtsDateUtils.dateLongToString(endTimeCount).substring(0, 10);

		//2021-03-29 ԱŰ࣬޿ڵÿ׼ʱȡԱڵ--->ƶ--->Ϣ--->һ㼸Сʱõֵ
		AtsHolidayFileHisCollection atsHolidayFileHisCollection =null;
		BigDecimal standardHour = new BigDecimal(0);
		try {
			atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx)
					.getAtsHolidayFileHisCollection("where proposer.id='" + personId + "'  order by effdt asc");
			if (null!=atsHolidayFileHisCollection && atsHolidayFileHisCollection.size() > 0) {
				for (int i = 0; i < atsHolidayFileHisCollection.size(); i++) {
					AtsHolidayFileHisInfo atsHolidayFileHisInfo = atsHolidayFileHisCollection.get(i);
					if (beginTimeCount.getTime() >= atsHolidayFileHisInfo.getEFFDT().getTime()
							&& endTimeCount.getTime() <= atsHolidayFileHisInfo.getLEFFDT().getTime()) {
						String id = atsHolidayFileHisInfo.getHolidayPolicySet().getId().toString();
						HolidayPolicySetInfo holidayPolicyInfo_1 = HolidayPolicySetFactory.getLocalInstance(ctx)
								.getHolidayPolicySetInfo(" where id = '" + id + "'");
						standardHour = holidayPolicyInfo_1.getDefaultStandardHour();
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		Map<String,Object> paramMap = new HashMap<String,Object>();

		paramMap.put("personId",personId);
		paramMap.put("beginDate",beginDate);
		paramMap.put("endDate",endDate);
		//paramMap.put("curDate",beginDate); // ڻǿʼ  ʼʱ 
		paramMap.put("endTimeCount",endTimeCount);
		paramMap.put("beginTimeCount",beginTimeCount);
		paramMap.put("defaultStandardHour",defaultStandardHour);
		paramMap.put("holidayTypeUnit",holidayTypeUnit);
		paramMap.put("isFixOTAllowLeave",holidayPolicyInfo.isIsFixOTAllowLeave());
		paramMap.put("afterDealDateList",afterDealDateList);
		paramMap.put("defaultAtsShiftItemCollection",defaultAtsShiftItemCollection);
		paramMap.put("dayStandardHour",standardHour);

		Map<String,Object> DateLeaveLenMap = new HashMap<String,Object>();

		//ȫϢ  ٶϢ  0
		if(tempAfterDealDateListSize != 0)
		{
			/*
			 * ȡٿʼ   ⴦мó
			 *
			 * */
			//ٿʼʱ⴦   Ű ȡʱ
			//ٿʼͬһ
			if(afterDealDateList.size()==1
					&&afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate+" 00:00:00").getTime()))
					&&afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate+" 00:00:00").getTime()))){
				paramMap.put("curDate",beginDate); // ڻǿʼ  ʼʱ 
				paramMap.put("index","index"); // ڻǿʼ  ʼʱ
				getBeginDateOrEndDateLength(ctx,paramMap,DateLeaveLenMap);
			}else{
				// 㿪ʼ ʱ
				boolean isContainBeginDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate+" 00:00:00").getTime())) ;
				boolean isContainEndDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate+" 00:00:00").getTime())) ;

				if(isContainBeginDate)
				{
					//ȥİ
					paramMap.put("curDate",beginDate); // ڻǿʼ  ʼʱ 
					afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(beginDate+" 00:00:00").getTime()));
					getBeginDateOrEndDateLength(ctx,paramMap,DateLeaveLenMap);
				}
				//  ʱ
				if(isContainEndDate)
				{
					//ȥİ
					paramMap.put("curDate",endDate); // ڻǿʼ   ʱ
					afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(endDate+" 00:00:00").getTime()));
					getBeginDateOrEndDateLength(ctx,paramMap,DateLeaveLenMap);
				}

				//ڶΪ ⴦ֳ 
				//һζļڶ   ʱ ӦǲٵĽʱȽϿǲʱûнеĻͲȥ
				//ûҪȥ 
				if(tempAfterDealDateListSize >=3 ){

					Date nowDate = AtsDateUtils.getPreDay(AtsDateUtils.stringToShortDate(endDate));

					String nowDateStr = AtsDateUtils.dateShortToString(nowDate);
					boolean isPreEndDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(nowDateStr+" 00:00:00").getTime())) ;
					if(isPreEndDate)
					{
						paramMap.put("curDate",nowDateStr); // ǰһ 
						paramMap.put("nowDate",nowDate); //
						paramMap.put("index","calPreEndDate");
						afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(nowDateStr+" 00:00:00").getTime()));
						getBeginDateOrEndDateLength(ctx,paramMap,DateLeaveLenMap);
					}

				}
				// ʱ мڵļ
//				paramMap.put("dayStandardHour",new BigDecimal(24)); 
				getMidleDateLength(ctx,paramMap,DateLeaveLenMap);
			}
		}
		// ǰһǿ =================================
		Date nowDate = AtsDateUtils.getPreDay(AtsDateUtils.stringToShortDate(beginDate));
		String nowDateStr = AtsDateUtils.dateShortToString(nowDate);

		paramMap.put("curDate",nowDateStr); // ǰһ 
		paramMap.put("nowDate",nowDate);
		paramMap.put("index","calPrebeginDate");
		getBeginDateOrEndDateLength(ctx,paramMap,DateLeaveLenMap);// ǰһǿ


		// һǿǰ =================================
		Date nextNowDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(endDate));
		String nextNowDateStr = AtsDateUtils.dateShortToString(nextNowDate);

		paramMap.put("curDate",nextNowDateStr); // ǰһ 
		paramMap.put("nowDate",nextNowDate);
		paramMap.put("index","calNextendDate");
		getBeginDateOrEndDateLength(ctx,paramMap,DateLeaveLenMap);// һǿǰ

		return DateLeaveLenMap;
	}

	/**
	 * ʱ мڵļ
	 * @param ctx
	 * @param paramMap
	 */
	public void getMidleDateLength(Context ctx,Map<String,Object> paramMap,Map<String,Object> DateLeaveLenMap)
	{
		HolidayTypeUnitEnum holidayTypeUnit = (HolidayTypeUnitEnum)paramMap.get("holidayTypeUnit");
		List<Date> afterDealDateList = (List<Date>)paramMap.get("afterDealDateList");
		AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)paramMap.get("defaultAtsShiftItemCollection");

		String personId     = (String)paramMap.get("personId");
		String beginDate    = (String)paramMap.get("beginDate");
		String endDate      = (String)paramMap.get("endDate");

		Boolean isFixOTAllowLeave = (Boolean)paramMap.get("isFixOTAllowLeave");

		BigDecimal defaultStandardHour = (BigDecimal)paramMap.get("defaultStandardHour");
		BigDecimal dayStandardHour = (BigDecimal)paramMap.get("dayStandardHour");
		BigDecimal standardHour = new BigDecimal(0);

		if(afterDealDateList.size() > 0)
		{
			//мʱ
			if(holidayTypeUnit==HolidayTypeUnitEnum.day)
			{


				for(int i = 0; i < afterDealDateList.size(); i++)
				{
					boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, personId, afterDealDateList.get(i));

					String curDate = AtsDateUtils.dateShortToString(afterDealDateList.get(i));
					Map<String,Double> curDateMap  = new HashMap<String,Double>();
					if(isHalfDay){
						curDateMap.put("calDay",0.5d);
					}else{
						curDateMap.put("calDay",1d);
					}
					curDateMap.put("calHour",0d);
					DateLeaveLenMap.put(curDate, curDateMap);
				}

			}else if(holidayTypeUnit==HolidayTypeUnitEnum.hour){
				//ʣ мʱ
				// ȡϷ map Ϊ key  Ż
//				String oql = " where proposer = '"+personId+"' and attendDate >={ts '"+beginDate+"'} and attendDate<={ts '"+endDate+"'}";
//				ScheduleShiftCollection scheduleShiftColl;
				try {
//					scheduleShiftColl = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(oql);

					Map<String,ScheduleShiftInfo>  scheduleShiftInfoMap= AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, beginDate, endDate);

					ScheduleShiftInfo scheduleShiftInfo = null;
					for(int i = 0; i < afterDealDateList.size(); i++)
					{
						Map<String,Double> curDateMap  = new HashMap<String,Double>();

						Date currentDate = afterDealDateList.get(i);
						String curDate = AtsDateUtils.dateShortToString(currentDate);
						curDateMap.put("calDay",0d);
						String key = personId + "_" + AtsDateUtils.dateShortToString(currentDate);
						DateLeaveLenMap.put(curDate, curDateMap);
						if(null != scheduleShiftInfoMap){
							scheduleShiftInfo = scheduleShiftInfoMap.get(key);
						}
						if(scheduleShiftInfo!=null){

							standardHour = scheduleShiftInfo.getStandardHour();
							curDateMap.put("calHour",standardHour.doubleValue());
							if(isFixOTAllowLeave){//̶Ӱ٣׼ʱҪϹ̶Ӱʱ
								curDateMap.put("calHour",standardHour.doubleValue()+ getFixOTSegHour(scheduleShiftInfo.getItems()));
							}
						}else{
							//Ĭϰ
							if(defaultAtsShiftItemCollection.size() != 0)
							{
								curDateMap.put("calHour",defaultStandardHour.doubleValue());
								//leaveLengthHour = leaveLengthHour + defaultStandardHour.doubleValue();

								if(isFixOTAllowLeave){//̶Ӱ٣׼ʱҪϹ̶Ӱʱ
									curDateMap.put("calHour",defaultStandardHour.doubleValue() + getFixOTSegHour(defaultAtsShiftItemCollection));
								}
							}else{
								//
								//standardHour = new BigDecimal(24); ûʱʱ24Сʱ㣬磬ǰ8Сʱ
								curDateMap.put("calHour",dayStandardHour.doubleValue());
							}
						}
					}

//					Map<Date, BigDecimal> scheduleShiftMap = new HashMap<Date, BigDecimal>();
//					Map<Date, ScheduleShiftItemCollection> scheduleShiftItemMap = new HashMap<Date, ScheduleShiftItemCollection>();
//					for(int i = 0 ; i < scheduleShiftColl.size() ; i ++)
//					{
//						scheduleShiftMap.put(scheduleShiftColl.get(i).getAttendDate(), scheduleShiftColl.get(i).getStandardHour());
//						scheduleShiftItemMap.put(scheduleShiftColl.get(i).getAttendDate(), scheduleShiftColl.get(i).getItems());
//					}
//					
//					for(int i = 0; i < afterDealDateList.size(); i++)
//					{
//						
//						Map<String,Double> curDateMap  = new HashMap<String,Double>();
//						
//						Date currentDate = afterDealDateList.get(i);
//						String curDate = AtsDateUtils.dateLongToString(currentDate);
//						curDateMap.put("calDay",0d);
//						
//						DateLeaveLenMap.put(curDate, curDateMap);
//						if(scheduleShiftMap.get(currentDate)!=null){
//							
//							standardHour = scheduleShiftMap.get(currentDate);
//							curDateMap.put("calHour",standardHour.doubleValue());
//							if(isFixOTAllowLeave){//̶Ӱ٣׼ʱҪϹ̶Ӱʱ
//								curDateMap.put("calHour",standardHour.doubleValue()+ getFixOTSegHour(scheduleShiftItemMap.get(afterDealDateList.get(i))));
//							}
//						}else{
//							//Ĭϰ
//							if(defaultAtsShiftItemCollection.size() != 0)
//							{
//								curDateMap.put("calHour",defaultStandardHour.doubleValue());
//								//leaveLengthHour = leaveLengthHour + defaultStandardHour.doubleValue();
//								
//								if(isFixOTAllowLeave){//̶Ӱ٣׼ʱҪϹ̶Ӱʱ
//									curDateMap.put("calHour",defaultStandardHour.doubleValue() + getFixOTSegHour(defaultAtsShiftItemCollection));
//								}
//							}else{
//								//
//								//standardHour = new BigDecimal(24); ûʱʱ24Сʱ㣬磬ǰ8Сʱ
//								curDateMap.put("calHour",dayStandardHour.doubleValue());
//							}
//						}
//					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	public double getFixOTSegHour(ScheduleShiftItemCollection item){
		double otSegHour = 0;
		ScheduleShiftItemInfo info = null;
		for(int i = 0,len = item.size();i<len;i++){
			info = item.get(i);
			if(info.getAttendanceType().equals(AttendanceTypeEnum.fixedOverTime)){
				otSegHour += (info.getNextDateTime().getTime()-info.getPreDateTime().getTime())/(1000*60*60);
			}
		}
		return otSegHour;
	}
	public double getFixOTSegHour(AtsShiftItemCollection item){
		double otSegHour = 0;
		AtsShiftItemInfo info = null;
		for(int i = 0,len = item.size();i<len;i++){
			info = item.get(i);
			if(info.getAttendanceType().equals(AttendanceTypeEnum.fixedOverTime)){
				String preTime = info.getPreTime()+":00";
				String nextTime = info.getNextTime()+":00";
				if(preTime.compareTo(nextTime)>0){
					preTime = "1900-01-01 "+preTime;
					nextTime = "1900-01-02 "+nextTime;
				}else{
					preTime = "1900-01-01 "+preTime;
					nextTime = "1900-01-01 "+nextTime;
				}
				otSegHour += (HRTimeWebUtils.stringToTimestamp(nextTime).getTime()-HRTimeWebUtils.stringToTimestamp(preTime).getTime())/(1000*60*60);
			}
		}
		return otSegHour;
	}

	public void getBeginDateOrEndDateLength(Context ctx,Map<String,Object> paramMap,Map<String,Object> DateLeaveLenMap)
	{
		HolidayTypeUnitEnum holidayTypeUnit = (HolidayTypeUnitEnum)paramMap.get("holidayTypeUnit");

		AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)paramMap.get("defaultAtsShiftItemCollection");

		String personId     = (String)paramMap.get("personId");
		String beginDate    = (String)paramMap.get("beginDate");
		String endDate      = (String)paramMap.get("endDate");
		String curDate      = (String)paramMap.get("curDate");

		Boolean isFixOTAllowLeave = (Boolean)paramMap.get("isFixOTAllowLeave");

		Timestamp beginTimeCount      = (Timestamp)paramMap.get("beginTimeCount");
		Timestamp endTimeCount      = (Timestamp)paramMap.get("endTimeCount");

		BigDecimal defaultStandardHour = (BigDecimal)paramMap.get("defaultStandardHour");
		BigDecimal standardHour = (BigDecimal)paramMap.get("dayStandardHour");

		long leaveLength = 0L;
		HashMap<String, Object> dateMap;
		try {
			dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate(ctx,personId,new Date(AtsDateUtils.stringToTimestamp(curDate+" 00:00:00").getTime()),isFixOTAllowLeave);
			ScheduleShiftItemCollection scheduleShiftItemColl=(ScheduleShiftItemCollection)dateMap.get("scheduleShiftItemColl");

			if(scheduleShiftItemColl.size()!=0 || defaultAtsShiftItemCollection.size()!=0){

				List<HashMap<String,Object>> shift = null ;
				if(scheduleShiftItemColl.size()!=0)
				{ // Űȡ
					standardHour = (BigDecimal) dateMap.get("standardHour");
					shift=AtsLeaveBillUtils.getShiftItemInfos(scheduleShiftItemColl,curDate,atsLeaveBillEntryInfo == null ? null : atsLeaveBillEntryInfo.isIsElasticCalLen());
				}
				else
				{ // Ĭϰ
					standardHour = defaultStandardHour ;
					shift=AtsLeaveBillUtils.getShiftItemInfos(defaultAtsShiftItemCollection,curDate,atsLeaveBillEntryInfo == null ? null : atsLeaveBillEntryInfo.isIsElasticCalLen());
				}
//				leaveLength = AtsLeaveBillUtils.calSegmentLength(shift,beginTimeCount,endTimeCount,leaveLength) ;
				Map<String,Object> res = AtsLeaveBillUtils.calSegmentLength(ctx,shift,beginTimeCount,endTimeCount,leaveLength,holidayPolicyInfo,standardHour);
				leaveLength = (Long)res.get("realLen"); //۳Ϣʱʱ
//				segmentInRest = (Long)res.get("segRest")!= null ? (Long)res.get("segRest"):0l ;  //Ϣʱ
			}else {
				standardHour = new BigDecimal(24);
				String index = (String)paramMap.get("index");
				if(!StringUtils.isEmpty(index) && index.equals("index"))
				{  // ʼͽʱ䶼ͬһ   ûŰ
					leaveLength = endTimeCount.getTime() -  beginTimeCount.getTime();
				}
				else if(curDate.equals(endDate))
				{ // 죬ûŰ 
					leaveLength = leaveLength + endTimeCount.getTime() - AtsDateUtils.stringToTimestamp(endDate+" 00:00:00").getTime();
				}
				else if(curDate.equals(beginDate)){ // ʼ ûŰ

					leaveLength = leaveLength + AtsDateUtils.stringToTimestamp(beginDate+" 23:59:59").getTime() -  beginTimeCount.getTime();
				}else if(!StringUtils.isEmpty(index) && index.equals("calPreEndDate")){
					// м  ڶ
					leaveLength = (long) (standardHour.longValue() * 60.0*60*1000) ;
				}
			}
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		Map<String,Double> curDateMap  = new HashMap<String,Double>();
		if(leaveLength > 0)
		{
			if(holidayTypeUnit==HolidayTypeUnitEnum.day)
			{
				boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, personId, HRTimeWebUtils.stringToShortDate(curDate));
				if(isHalfDay){
					curDateMap.put("calDay",(leaveLength/(standardHour.doubleValue()*60.0*60*1000*2))>0.5 ? 0.5:leaveLength/(standardHour.doubleValue()*60.0*60*1000*2));
				}else{
					curDateMap.put("calDay",(leaveLength/(standardHour.doubleValue()*60.0*60*1000))>1 ? 1:leaveLength/(standardHour.doubleValue()*60.0*60*1000));
				}
			}
			else if(holidayTypeUnit==HolidayTypeUnitEnum.hour)
			{
				//leaveLengthHour = leaveLengthHour + ;
				curDateMap.put("calHour",(leaveLength/(60.0*60*1000))>standardHour.doubleValue() ? standardHour.doubleValue() : leaveLength/(60.0*60*1000));
			}
			DateLeaveLenMap.put(curDate, curDateMap);
		}

	}



	//ȡ ʽʱʱ 2014-12-17  ,AttendanceFileInfo attendanceFileInfo 
	public Map<String,Object> calRealLeaveLengthOfDay(List<Date>  afterDealDateList,Date beginTimeCount
			,Date endTimeCount,HolidayTypeUnitEnum holidayTypeUnit
			,AtsHolidayFileInfo holidayFileInfo,HolidayPolicySetInfo holidayPolicySetInfo,HolidayPolicyInfo holidayPolicyInfo)
			throws BOSException, EASBizException
	{
		Map<String,Object> retMap = new HashMap<String,Object>();
		if (afterDealDateList.size() == 0) {
			return retMap;
		}

		// ȡĬϵİκĬϵı׼ʱ
		Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp(beginTimeCount);
		Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp(endTimeCount);
		AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, beginTimeCountTs, endTimeCountTs, personId, null);
		HashMap<String,Object> defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis(ctx,attendanceFileHisInfo,holidayPolicyInfo);
		AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)defaultItemMap.get("scheduleShiftItemColl");

		BigDecimal defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");

		BigDecimal standardHour = new BigDecimal(8);

		String beginDate = AtsDateUtils.dateLongToString(beginTimeCount).substring(0, 10);
		String endDate = AtsDateUtils.dateLongToString(endTimeCount).substring(0, 10);

		String amStartTime = holidayPolicySetInfo.getAmStartWorkTime();
		String amEndTime = holidayPolicySetInfo.getAmEndWorkTime();
		String pmStartTime = holidayPolicySetInfo.getPmStartWorkTime();
		String pmEndTime = holidayPolicySetInfo.getPmEndWorkTime();

		HolidayTypeUnitEnum holidayUnit = holidayPolicyInfo.getUnit();
		Boolean isFixOTAllowLeave= holidayPolicyInfo.isIsFixOTAllowLeave();


		double realLength = 0.0 ;
		double leaveLengthDay = 0.0;
		double leaveLengthHour= 0.0;


		if(afterDealDateList.size()==1
				&& afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate+" 00:00:00").getTime()))
				&& afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate+" 00:00:00").getTime())))
		{
			boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, personId, HRTimeWebUtils.stringToShortDate(beginDate));

			String startTimeTemp = AtsDateUtils.dateLongToString(beginTimeCount).substring(11, 16);
			String endTimeTemp = AtsDateUtils.dateLongToString(endTimeCount).substring(11, 16);

			if(startTimeTemp.equals(amStartTime) && endTimeTemp.equals(amEndTime) ||
					startTimeTemp.equals(pmStartTime) && endTimeTemp.equals(pmEndTime) ||
					startTimeTemp.equals(amStartTime) && endTimeTemp.equals(pmStartTime) ||
					startTimeTemp.equals(amEndTime) && endTimeTemp.equals(pmEndTime)

			)
			{
				realLength = 0.5;
			}else if(startTimeTemp.equals(amStartTime) && endTimeTemp.equals(pmEndTime)){
				realLength = 1;
			}else {
				realLength = 0;
			}

			if(realLength > 0)
			{
				Map<String,Double> curDateMap  = new HashMap<String,Double>();
				if(holidayTypeUnit==HolidayTypeUnitEnum.day) {
					if(isHalfDay){
						leaveLengthDay = 0.5;
					}else{
						leaveLengthDay = realLength;
					}
					curDateMap.put("calDay",leaveLengthDay);
					curDateMap.put("calHour",0d);
				} else if(holidayTypeUnit==HolidayTypeUnitEnum.hour) {
					//leaveLengthHour = leaveLengthHour + ;
					standardHour = getStandardHourOfDay(ctx,personId,beginDate,defaultAtsShiftItemCollection,defaultStandardHour,holidayPolicyInfo.isIsFixOTAllowLeave());
					leaveLengthHour = realLength * standardHour.doubleValue();
					curDateMap.put("calDay",0d);
					curDateMap.put("calHour",leaveLengthHour);
				}

				retMap.put(beginDate, curDateMap);
			}
		}else{
			if(afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate+" 00:00:00").getTime())))
			{
				boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, personId, HRTimeWebUtils.stringToShortDate(beginDate));
				String amStartTimeTemp = AtsDateUtils.dateLongToString(beginTimeCount).substring(11, 16);

				//ȥİ
				afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(beginDate+" 00:00:00").getTime()));

				if(amStartTimeTemp.equals(amStartTime)) {
					realLength = 1;
				} else if(amStartTimeTemp.equals(pmStartTime)) {
					realLength = 0.5;
				}else{
					realLength = 0;
				}

				if(realLength > 0)
				{
					Map<String,Double> curDateMap  = new HashMap<String,Double>();
					if(holidayTypeUnit==HolidayTypeUnitEnum.day)
					{
						if(isHalfDay){
							leaveLengthDay = 0.5;
						}else{
							leaveLengthDay = realLength;
						}
						curDateMap.put("calDay",leaveLengthDay);
						curDateMap.put("calHour",0d);
					}
					else if(holidayTypeUnit==HolidayTypeUnitEnum.hour)
					{
						standardHour = getStandardHourOfDay(ctx,personId,beginDate,defaultAtsShiftItemCollection,defaultStandardHour,holidayPolicyInfo.isIsFixOTAllowLeave());
						leaveLengthHour = realLength * standardHour.doubleValue();
						curDateMap.put("calDay",0d);
						curDateMap.put("calHour",leaveLengthHour);
					}
					retMap.put(beginDate, curDateMap);
				}
			}
			//  ʱ
			if(afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate+" 00:00:00").getTime())))
			{
				boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, personId, HRTimeWebUtils.stringToShortDate(endDate));

				//ȥİ
				afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(endDate+" 00:00:00").getTime()));

				String amEndTimeTemp = AtsDateUtils.dateLongToString(endTimeCount).substring(11, 16);
				realLength = 0 ;
				if(amEndTimeTemp.equals(amEndTime) || amEndTimeTemp.equals(pmStartTime))
				{
					realLength = 0.5;
				}else if(amEndTimeTemp.equals(pmEndTime)){
					realLength = 1;
				}else{
					realLength = 0 ;
				}
				if(realLength > 0 )
				{
					Map<String,Double> curDateMap  = new HashMap<String,Double>();
					if(holidayTypeUnit==HolidayTypeUnitEnum.day)
					{
						if(isHalfDay){
							leaveLengthDay = 0.5;
						}else{
							leaveLengthDay = realLength;
						}
						curDateMap.put("calDay",leaveLengthDay);
						curDateMap.put("calHour",0d);
					}
					else if(holidayTypeUnit==HolidayTypeUnitEnum.hour)
					{
						standardHour = getStandardHourOfDay(ctx,personId,endDate,defaultAtsShiftItemCollection,defaultStandardHour,holidayPolicyInfo.isIsFixOTAllowLeave());
						leaveLengthHour = realLength * standardHour.doubleValue();
						curDateMap.put("calDay",0d);
						curDateMap.put("calHour",leaveLengthHour);
					}
					retMap.put(endDate, curDateMap);
				}
			}

			if(afterDealDateList.size()>0)
			{
				Map<String,Object> paramMap = new HashMap<String,Object>();
				paramMap.put("leaveLengthDay",leaveLengthDay);
				paramMap.put("leaveLengthHour",leaveLengthHour);
				paramMap.put("personId",personId);
				paramMap.put("beginDate",beginDate);
				paramMap.put("endDate",endDate);
				paramMap.put("defaultStandardHour",defaultStandardHour);
				paramMap.put("holidayTypeUnit",holidayUnit);
				paramMap.put("isFixOTAllowLeave",isFixOTAllowLeave);
				paramMap.put("afterDealDateList",afterDealDateList);
				paramMap.put("defaultAtsShiftItemCollection",defaultAtsShiftItemCollection);
				paramMap.put("dayStandardHour",new BigDecimal(8)); //ûŰҲûĬϰ ֱ Сʱ
				getMidleDateLength(ctx,paramMap,retMap);
			}

		}

		return retMap;
	}


	/**
	 * <p>ȡʱı׼ʱ</p>
	 * @param ctx
	 * @param personId
	 * @param curDate
	 * @param defaultAtsShiftItemCollection
	 * @param defaultStandardHour
	 * @return ׼ʱ
	 */
	public BigDecimal getStandardHourOfDay(Context ctx,String personId,String curDate,AtsShiftItemCollection defaultAtsShiftItemCollection,BigDecimal defaultStandardHour,Boolean isFixOTAllowLeave)
	{
		BigDecimal standardHour = new BigDecimal(8);
		try {
			HashMap<String, Object> dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate(ctx,personId,new Date(AtsDateUtils.stringToShortDate(curDate).getTime()),isFixOTAllowLeave);
			ScheduleShiftItemCollection scheduleShiftItemColl =(ScheduleShiftItemCollection)dateMap.get("scheduleShiftItemColl");

			if(scheduleShiftItemColl.size()!=0 || defaultAtsShiftItemCollection.size()!=0)
			{
				if(scheduleShiftItemColl.size()!=0)
				{ // Űȡ
					standardHour = (BigDecimal) dateMap.get("standardHour");
				}
				else
				{ // Ĭϰ
					standardHour = defaultStandardHour ;
				}
			}

		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}

		return standardHour;
	}

	// ٲ߼
	public Map<String, Object> calRealLeaveLengthOfBF(List<Date> afterDealDateList, Date beginTimeCount,
													  Date endTimeCount, HolidayTypeUnitEnum holidayTypeUnit, AtsHolidayFileInfo holidayFileInfo,
													  HolidayPolicySetInfo holidayPolicySetInfo, HolidayPolicyInfo holidayPolicyInfo) throws BOSException, EASBizException {

		Map<String, Object> DateLeaveLenMap = new HashMap<String, Object>();
		if (atsLeaveBillEntryInfo.getBfType() == null) {
			return DateLeaveLenMap;
		}

		String bfTypeId = atsLeaveBillEntryInfo.getBfType().getId().toString();
		BreastFeedingTypeCollection bfTypeColl = BreastFeedingTypeFactory.getLocalInstance(ctx).getBreastFeedingTypeCollection("where id = '" + bfTypeId + "'");

		double leaveLengthOfSplit = 1d; // ÿһĲʱ
		if (bfTypeColl.size() > 0) {
			BreastFeedingTypeInfo bfTypeInfo = bfTypeColl.get(0);
			// ֳ=  ٵλ * ̥
			leaveLengthOfSplit = bfTypeInfo.getLeaveLength().multiply(new BigDecimal(bfTypeInfo.getFetusNum())).doubleValue();
		}

		Map<String, List<ScheduleShiftInfo>> scheduleShiftMap = null;
		if (holidayTypeUnit.getValue() == HolidayTypeUnitEnum.DAY_VALUE) {
			// ȡĬϵİκĬϵı׼ʱ
			Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp(beginTimeCount);
			Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp(endTimeCount);
			HashMap<String, Object> defaultItemMap = new HashMap<String, Object>();
			try {
				AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, beginTimeCountTs, endTimeCountTs, personId, null);
				defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis(ctx, attendanceFileHisInfo, holidayPolicyInfo);
			} catch (BOSException e) {
				e.printStackTrace();
			}

			defaultStandardHour = (BigDecimal) defaultItemMap.get("standardHour");
			String beginDate = AtsDateUtils.dateLongToString(beginTimeCount).substring(0, 10);
			String endDate = AtsDateUtils.dateLongToString(endTimeCount).substring(0, 10);
			Map<String, Object> fileInfoRenturn = AtsPrepareDataHelper.getAttendanceFileInfoByPersonId(ctx, "'" + personId + "'", beginDate, endDate, null);
			Map<String, AttendanceFileInfo> fileInfoObject = (Map<String, AttendanceFileInfo>) fileInfoRenturn.get("fileInfoMap");
			scheduleShiftMap = AtsScheduleShiftUtil.getScheduleShiftMapByPriority(ctx, fileInfoObject, personId, beginDate, endDate);
		}

		if (afterDealDateList.size() == 0) {
			return DateLeaveLenMap;
		}

		for (Date date : afterDealDateList) {
			Map<String, Double> curDateMap = new HashMap<String, Double>();
			if (holidayTypeUnit.getValue() == HolidayTypeUnitEnum.DAY_VALUE) {// 
				BigDecimal standardhour = new BigDecimal(0);
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				// ÷
				String ds = sdf.format(date);
				String key = personId + "_" + ds;
				List<ScheduleShiftInfo> scheduleShiftList = null == scheduleShiftMap ? null : scheduleShiftMap.get(key);
				if (scheduleShiftList != null && scheduleShiftList.size() > 0) {
					standardhour = (BigDecimal) scheduleShiftList.get(0).get("standardhour");
				} else {
					standardhour = defaultStandardHour;
				}
				BigDecimal dayRealLength = (BigDecimal.valueOf(leaveLengthOfSplit)).divide(standardhour, 8, RoundingMode.HALF_UP);
				curDateMap.put("calDay", dayRealLength.doubleValue());
				curDateMap.put("calHour", 0d);
			} else {// Сʱ
				curDateMap.put("calDay", 0d);
				curDateMap.put("calHour", leaveLengthOfSplit);
			}

			String curDate = AtsDateUtils.dateLongToString(date);
			DateLeaveLenMap.put(curDate, curDateMap);
		}

		return DateLeaveLenMap;
	}

	/**
	 * ٲ
	 * @param ctx
	 * @return
	 */
	public Map<String, Object> getIsCtrlHalfDayOff(Context ctx){
		Map<String, Object> res = new HashMap<String, Object>();
		try {
			HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + holidayPolicyInfo.getHolidayPolicySet().getId().toString()+ "' ");
			res.put("amBeginTime", holidayPolicySetInfo.getAmStartWorkTime());
			res.put("amEndTime", holidayPolicySetInfo.getAmEndWorkTime());
			res.put("pmBeginTime", holidayPolicySetInfo.getPmStartWorkTime());
			res.put("pmEndTime", holidayPolicySetInfo.getPmEndWorkTime());
			res.put("isHalfDayOff", holidayPolicyInfo.isIsHalfDayOff());
		}catch (Exception e){

		}
		return res;
	}

	private AtsShiftItemInfo createScheduleShiftItemToAtsShiftItem(Context ctx,ScheduleShiftItemInfo scheduleShiftItemInfo){
		AtsShiftItemInfo info =new AtsShiftItemInfo();
		info.setPreTime(scheduleShiftItemInfo.getPreTime());
		info.setNextTime(scheduleShiftItemInfo.getNextTime());
		info.setPreIsPunchCard(scheduleShiftItemInfo.getPreIsPunchCard());
		info.setNextIsPunchCard(scheduleShiftItemInfo.getNextIsPunchCard());
		info.setPreTimeDayType(scheduleShiftItemInfo.getPreTimeDayType());
		info.setNextTimeDayType(scheduleShiftItemInfo.getNextTimeDayType());
		info.setSegment(scheduleShiftItemInfo.getSegment());
		info.setPreFloatAdjusted(scheduleShiftItemInfo.getPreFloatAdjusted());
		info.setNextFloatAdjusted(scheduleShiftItemInfo.getNextFloatAdjusted());
		info.setRestPreTime(scheduleShiftItemInfo.getRestPreTime());
		info.setRestNextTime(scheduleShiftItemInfo.getRestNextTime());
		info.setSegmentInRest(scheduleShiftItemInfo.getSegmentInRest());
		info.setAttendanceType(scheduleShiftItemInfo.getAttendanceType());
		info.setGroup(new AtsShiftInfo());
		return info;
	}
}
