/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.model;

import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.model.AbstractVariableScope;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.QueueMode;
import kd.isc.iscb.util.flow.core.plugin.Synchronizer;

public abstract class AbstractExecutable
extends AbstractVariableScope {
    private QueueMode queueMode = QueueMode.LAST;
    private List<Command> commands = new ArrayList<Command>();

    AbstractExecutable(FlowImpl flow, String id, String title) {
        super(flow, id, title);
    }

    AbstractExecutable(String id, String title) {
        super(id, title);
    }

    public QueueMode getQueueMode() {
        return this.queueMode;
    }

    public void setQueueMode(QueueMode queueMode) {
        if (queueMode == null) {
            throw new NullPointerException();
        }
        this.queueMode = queueMode;
    }

    public Synchronizer getSynchronizer() {
        return null;
    }

    public final void insert(Command cmd) {
        int p = 0;
        int i = this.commands.size() - 1;
        while (i >= 0) {
            int index = this.commands.get(i).getLabel();
            if (index == cmd.getLabel()) {
                this.commands.set(i, cmd);
                return;
            }
            if (index < cmd.getLabel()) {
                p = i + 1;
                break;
            }
            --i;
        }
        this.commands.add(p, cmd);
    }

    public final void remove(Command cmd) {
        int i = this.commands.size() - 1;
        while (i >= 0) {
            int index = this.commands.get(i).getLabel();
            if (index == cmd.getLabel()) {
                this.commands.remove(i);
                break;
            }
            --i;
        }
    }

    public final int getCommandCount() {
        return this.commands.size();
    }

    public final boolean contains(Command cmd) {
        return this.commands.contains(cmd);
    }

    public final Command getCommand(int index) {
        if (index >= this.commands.size()) {
            throw new IscBizException("Command '" + index + "' doesn't exist!");
        }
        return this.commands.get(index);
    }

    public final int seekCommand(int label) {
        int i = 0;
        int j = this.commands.size();
        while (i < j) {
            Command x = this.getCommand(i);
            if (x.getLabel() >= label) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void dumpMicroProgram(StringBuilder sb) {
        for (Command i : this.commands) {
            sb.append(i).append('[').append(i.getLabel()).append("]; ");
        }
    }

    final void updateCRC(CRC32 crc) {
        for (Command i : this.commands) {
            String s = i.toString();
            int j = 0;
            while (j < s.length()) {
                crc.update(s.charAt(j));
                ++j;
            }
        }
    }
}

